/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Optional;
import org.lockss.laaws.crawler.api.WsApi;
import org.lockss.laaws.crawler.model.CrawlWsResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;

public interface WsApiDelegate {
    public static final Logger log = LoggerFactory.getLogger(WsApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    default public ResponseEntity<CrawlWsResult> getWsCrawls(String crawlQuery) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((CrawlWsResult)this.getObjectMapper().get().readValue("{\n  \"auId\" : \"auId\",\n  \"auName\" : \"auName\",\n  \"pagesFetchedCount\" : 5,\n  \"sources\" : [ \"sources\", \"sources\" ],\n  \"linkDepth\" : 1,\n  \"pagesFetched\" : [ \"pagesFetched\", \"pagesFetched\" ],\n  \"pagesNotModifiedCount\" : 2,\n  \"pagesParsed\" : [ \"pagesParsed\", \"pagesParsed\" ],\n  \"refetchDepth\" : 1,\n  \"duration\" : 1,\n  \"mimeTypes\" : [ \"mimeTypes\", \"mimeTypes\" ],\n  \"pagesWithErrorsCount\" : 4,\n  \"pagesWithErrors\" : [ {\n    \"severity\" : \"severity\",\n    \"message\" : \"message\",\n    \"url\" : \"url\"\n  }, {\n    \"severity\" : \"severity\",\n    \"message\" : \"message\",\n    \"url\" : \"url\"\n  } ],\n  \"startTime\" : 6,\n  \"crawlType\" : \"crawlType\",\n  \"pagesParsedCount\" : 2,\n  \"bytesFetchedCount\" : 5,\n  \"crawlKey\" : \"crawlKey\",\n  \"crawlStatus\" : \"crawlStatus\",\n  \"priority\" : 0,\n  \"pagesPendingCount\" : 7,\n  \"pagesPending\" : [ \"pagesPending\", \"pagesPending\" ],\n  \"pagesExcludedCount\" : 9,\n  \"offSiteUrlsExcludedCount\" : 3,\n  \"pagesNotModified\" : [ \"pagesNotModified\", \"pagesNotModified\" ],\n  \"mimeTypeCount\" : 7,\n  \"pagesExcluded\" : [ \"pagesExcluded\", \"pagesExcluded\" ],\n  \"startingUrls\" : [ \"startingUrls\", \"startingUrls\" ]\n}", CrawlWsResult.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default WsApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }
}

