/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.lockss.laaws.crawler.model.PageInfo;
import org.lockss.util.rest.crawler.CrawlJob;
import org.springframework.validation.annotation.Validated;

@Schema(description="A display page of jobs")
@Validated
public class JobPager {
    @JsonProperty(value="jobs")
    @Valid
    private List<CrawlJob> jobs = new ArrayList<CrawlJob>();
    @JsonProperty(value="pageInfo")
    private PageInfo pageInfo = null;

    public JobPager jobs(List<CrawlJob> jobs) {
        this.jobs = jobs;
        return this;
    }

    public JobPager addJobsItem(CrawlJob jobsItem) {
        this.jobs.add(jobsItem);
        return this;
    }

    @Schema(required=true, description="The jobs displayed in the page")
    @NotNull
    @Valid
    public List<CrawlJob> getJobs() {
        return this.jobs;
    }

    public void setJobs(List<CrawlJob> jobs) {
        this.jobs = jobs;
    }

    public JobPager pageInfo(PageInfo pageInfo) {
        this.pageInfo = pageInfo;
        return this;
    }

    @Schema(required=true, description="")
    @NotNull
    @Valid
    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public void setPageInfo(PageInfo pageInfo) {
        this.pageInfo = pageInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobPager jobPager = (JobPager)o;
        return Objects.equals(this.jobs, jobPager.jobs) && Objects.equals(this.pageInfo, jobPager.pageInfo);
    }

    public int hashCode() {
        return Objects.hash(this.jobs, this.pageInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobPager {\n");
        sb.append("    jobs: ").append(this.toIndentedString(this.jobs)).append("\n");
        sb.append("    pageInfo: ").append(this.toIndentedString(this.pageInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

