/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Schema(description="The information related to pagination of content")
@Validated
public class PageInfo {
    @JsonProperty(value="totalCount")
    private Integer totalCount = null;
    @JsonProperty(value="resultsPerPage")
    private Integer resultsPerPage = null;
    @JsonProperty(value="continuationToken")
    private String continuationToken = null;
    @JsonProperty(value="curLink")
    private String curLink = null;
    @JsonProperty(value="nextLink")
    private String nextLink = null;

    public PageInfo totalCount(Integer totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    @Schema(required=true, description="The total number of elements to be paginated")
    @NotNull
    public Integer getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public PageInfo resultsPerPage(Integer resultsPerPage) {
        this.resultsPerPage = resultsPerPage;
        return this;
    }

    @Schema(required=true, description="The number of results per page.")
    @NotNull
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    public void setResultsPerPage(Integer resultsPerPage) {
        this.resultsPerPage = resultsPerPage;
    }

    public PageInfo continuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
        return this;
    }

    @Schema(required=true, description="The continuation token.")
    @NotNull
    public String getContinuationToken() {
        return this.continuationToken;
    }

    public void setContinuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
    }

    public PageInfo curLink(String curLink) {
        this.curLink = curLink;
        return this;
    }

    @Schema(required=true, description="The link to the current page.")
    @NotNull
    public String getCurLink() {
        return this.curLink;
    }

    public void setCurLink(String curLink) {
        this.curLink = curLink;
    }

    public PageInfo nextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    @Schema(description="The link to the next page.")
    public String getNextLink() {
        return this.nextLink;
    }

    public void setNextLink(String nextLink) {
        this.nextLink = nextLink;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageInfo pageInfo = (PageInfo)o;
        return Objects.equals(this.totalCount, pageInfo.totalCount) && Objects.equals(this.resultsPerPage, pageInfo.resultsPerPage) && Objects.equals(this.continuationToken, pageInfo.continuationToken) && Objects.equals(this.curLink, pageInfo.curLink) && Objects.equals(this.nextLink, pageInfo.nextLink);
    }

    public int hashCode() {
        return Objects.hash(this.totalCount, this.resultsPerPage, this.continuationToken, this.curLink, this.nextLink);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PageInfo {\n");
        sb.append("    totalCount: ").append(this.toIndentedString(this.totalCount)).append("\n");
        sb.append("    resultsPerPage: ").append(this.toIndentedString(this.resultsPerPage)).append("\n");
        sb.append("    continuationToken: ").append(this.toIndentedString(this.continuationToken)).append("\n");
        sb.append("    curLink: ").append(this.toIndentedString(this.curLink)).append("\n");
        sb.append("    nextLink: ").append(this.toIndentedString(this.nextLink)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

