/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.crawler.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Schema(description="information related to an error for a url.")
@Validated
public class UrlError {
    @JsonProperty(value="message")
    private String message = null;
    @JsonProperty(value="severity")
    private SeverityEnum severity = null;

    public UrlError message(String message) {
        this.message = message;
        return this;
    }

    @Schema(required=true, description="The error message")
    @NotNull
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public UrlError severity(SeverityEnum severity) {
        this.severity = severity;
        return this;
    }

    @Schema(required=true, description="the severity of the error.")
    @NotNull
    public SeverityEnum getSeverity() {
        return this.severity;
    }

    public void setSeverity(SeverityEnum severity) {
        this.severity = severity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlError urlError = (UrlError)o;
        return Objects.equals(this.message, urlError.message) && Objects.equals((Object)this.severity, (Object)urlError.severity);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.message, this.severity});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UrlError {\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    severity: ").append(this.toIndentedString((Object)this.severity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SeverityEnum {
        WARNING("Warning"),
        ERROR("Error"),
        FATAL("Fatal");

        private String value;

        private SeverityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SeverityEnum fromValue(String text) {
            for (SeverityEnum b : SeverityEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

