/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.mdx.api;

import io.swagger.annotations.ApiParam;
import java.lang.reflect.MalformedParametersException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.lockss.app.LockssApp;
import org.lockss.app.LockssDaemon;
import org.lockss.job.JobAuStatus;
import org.lockss.job.JobManager;
import org.lockss.laaws.mdx.api.ErrorResponse;
import org.lockss.laaws.mdx.api.MdupdatesApi;
import org.lockss.laaws.mdx.model.Job;
import org.lockss.laaws.mdx.model.JobPageInfo;
import org.lockss.laaws.mdx.model.MetadataUpdateSpec;
import org.lockss.laaws.mdx.model.PageInfo;
import org.lockss.laaws.mdx.model.Status;
import org.lockss.rs.auth.SpringAuthenticationFilter;
import org.lockss.rs.status.ApiStatus;
import org.lockss.rs.status.SpringLockssBaseApiController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MdupdatesApiController
extends SpringLockssBaseApiController
implements MdupdatesApi {
    private static Logger log = Logger.getLogger(MdupdatesApiController.class);
    @Autowired
    private HttpServletRequest request;
    private static final String API_VERSION = "1.0.0";

    @RequestMapping(value={"/mdupdates"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Integer> deleteMdupdates() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Invoked");
        }
        SpringAuthenticationFilter.checkAuthorization((String[])new String[]{"contentAdminRole"});
        try {
            int removedCount = this.getJobManager().removeAllJobs();
            if (log.isDebugEnabled()) {
                log.debug((Object)("removedCount = " + removedCount));
            }
            return new ResponseEntity((Object)removedCount, HttpStatus.OK);
        }
        catch (Exception e) {
            String message = "Cannot deleteMdupdates()";
            log.error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
    }

    @RequestMapping(value={"/mdupdates/{jobid}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Job> deleteMdupdatesJobid(@PathVariable(value="jobid") String jobid) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("jobid = " + jobid));
        }
        SpringAuthenticationFilter.checkAuthorization((String[])new String[]{"contentAdminRole"});
        try {
            JobAuStatus jobAuStatus = this.getJobManager().removeJob(jobid);
            if (log.isDebugEnabled()) {
                log.debug((Object)("jobAuStatus = " + jobAuStatus));
            }
            Job result = new Job(jobAuStatus);
            if (log.isDebugEnabled()) {
                log.debug((Object)("result = " + result));
            }
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (IllegalArgumentException iae) {
            String message = "No job found for jobid = '" + jobid + "'";
            log.error((Object)message);
            throw new IllegalArgumentException(message);
        }
        catch (Exception e) {
            String message = "Cannot deleteMdupdatesJobid() for jobid = '" + jobid + "'";
            log.error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
    }

    public ResponseEntity<JobPageInfo> getMdupdates(@RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="limit", required=false, defaultValue="50") Integer limit) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("page = " + page));
            log.debug((Object)("limit = " + limit));
        }
        try {
            String curLink;
            PageInfo pi = new PageInfo();
            String nextLink = curLink = this.request.getRequestURL().toString();
            if (page != null) {
                curLink = curLink + "?page=" + page;
                nextLink = nextLink + "?page=" + (page + 1);
                if (limit != null) {
                    curLink = curLink + "&limit=" + limit;
                    nextLink = nextLink + "&limit=" + limit;
                }
            } else if (limit != null) {
                curLink = curLink + "?limit=" + limit;
                nextLink = nextLink + "?limit=" + limit;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("curLink = " + curLink));
                log.debug((Object)("nextLink = " + nextLink));
            }
            pi.setCurLink(curLink);
            pi.setNextLink(nextLink);
            pi.setCurrentPage(page);
            pi.setResultsPerPage(limit);
            JobPageInfo result = new JobPageInfo();
            result.setPageInfo(pi);
            List jobAuStatuses = this.getJobManager().getJobs(page, limit);
            if (log.isDebugEnabled()) {
                log.debug((Object)("jobAuStatuses = " + jobAuStatuses));
            }
            ArrayList<Job> jobs = new ArrayList<Job>();
            for (JobAuStatus jobAuStatus : jobAuStatuses) {
                jobs.add(new Job(jobAuStatus));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("jobs = " + jobs));
            }
            result.setJobs(jobs);
            if (log.isDebugEnabled()) {
                log.debug((Object)("result = " + result));
            }
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (Exception e) {
            String message = "Cannot getMdupdates() for page = " + page + ", limit = " + limit;
            log.error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
    }

    @RequestMapping(value={"/mdupdates/{jobid}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<Status> getMdupdatesJobid(@PathVariable(value="jobid") String jobid) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("jobid = " + jobid));
        }
        try {
            JobAuStatus jobAuStatus = this.getJobManager().getJobStatus(jobid);
            if (log.isDebugEnabled()) {
                log.debug((Object)("jobAuStatus = " + jobAuStatus));
            }
            Status result = new Status(jobAuStatus);
            if (log.isDebugEnabled()) {
                log.debug((Object)("result = " + result));
            }
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (IllegalArgumentException iae) {
            String message = "No job found for jobid = '" + jobid + "'";
            log.error((Object)message);
            throw new IllegalArgumentException(message);
        }
        catch (Exception e) {
            String message = "Cannot getMdupdatesJobid() for jobid = '" + jobid + "'";
            log.error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
    }

    @RequestMapping(value={"/mdupdates"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Job> postMdupdates(@ApiParam(required=true) @RequestBody MetadataUpdateSpec metadataUpdateSpec) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("metadataUpdateSpec = " + metadataUpdateSpec));
        }
        SpringAuthenticationFilter.checkAuthorization((String[])new String[]{"contentAdminRole"});
        String auid = null;
        try {
            if (metadataUpdateSpec == null) {
                String message = "Invalid metadata update specification: null";
                log.error((Object)message);
                throw new MalformedParametersException(message);
            }
            auid = metadataUpdateSpec.getAuid();
            if (log.isDebugEnabled()) {
                log.debug((Object)("auid = " + auid));
            }
            if (auid == null || auid.isEmpty()) {
                String message = "Invalid auid = '" + auid + "'";
                log.error((Object)message);
                throw new MalformedParametersException(message);
            }
            String updateType = metadataUpdateSpec.getUpdateType();
            if (log.isDebugEnabled()) {
                log.debug((Object)("updateType = " + updateType));
            }
            if (updateType == null || updateType.isEmpty()) {
                String message = "Invalid updateType = '" + updateType + "'";
                log.error((Object)message);
                throw new MalformedParametersException(message);
            }
            String canonicalUpdateType = updateType.toLowerCase();
            if (log.isDebugEnabled()) {
                log.debug((Object)("canonicalUpdateType = " + canonicalUpdateType));
            }
            JobAuStatus jobAuStatus = null;
            if (canonicalUpdateType.equals("full_extraction")) {
                jobAuStatus = this.getJobManager().scheduleMetadataExtraction(auid, true);
            } else if (canonicalUpdateType.equals("incremental_extraction")) {
                jobAuStatus = this.getJobManager().scheduleMetadataExtraction(auid, false);
            } else if (canonicalUpdateType.equals("delete")) {
                jobAuStatus = this.getJobManager().scheduleMetadataRemoval(auid);
            } else {
                String message = "Invalid updateType = '" + updateType + "'";
                log.error((Object)message);
                throw new MalformedParametersException(message);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("jobAuStatus = " + jobAuStatus));
            }
            Job result = new Job(jobAuStatus);
            if (log.isDebugEnabled()) {
                log.debug((Object)("result = " + result));
            }
            return new ResponseEntity((Object)result, HttpStatus.ACCEPTED);
        }
        catch (IllegalArgumentException iae) {
            String message = "No Archival Unit found for auid = '" + auid + "'";
            log.error((Object)message);
            throw new IllegalArgumentException(message);
        }
        catch (Exception e) {
            String message = "Cannot postMdupdates() for metadataUpdateSpec = '" + metadataUpdateSpec + "'";
            log.error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
    }

    @ExceptionHandler(value={AccessControlException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public ErrorResponse authorizationExceptionHandler(AccessControlException e) {
        return new ErrorResponse(e.getMessage());
    }

    @ExceptionHandler(value={MalformedParametersException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ErrorResponse authorizationExceptionHandler(MalformedParametersException e) {
        return new ErrorResponse(e.getMessage());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ErrorResponse notFoundExceptionHandler(IllegalArgumentException e) {
        return new ErrorResponse(e.getMessage());
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ErrorResponse internalExceptionHandler(RuntimeException e) {
        return new ErrorResponse(e.getMessage());
    }

    public ApiStatus getApiStatus() {
        return new ApiStatus().setVersion(API_VERSION).setReady(Boolean.valueOf(LockssApp.getLockssApp().isAppRunning()));
    }

    private JobManager getJobManager() {
        return LockssDaemon.getLockssDaemon().getJobManager();
    }
}

