/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.mdx.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Objects;
import org.lockss.job.JobAuStatus;
import org.lockss.laaws.mdx.model.Au;
import org.lockss.laaws.mdx.model.Status;

@ApiModel(description="An asynchronous task to be performed")
public class Job {
    private Au au = null;
    private String id = null;
    private String description = null;
    private Date creationDate = null;
    private Date startDate = null;
    private Date endDate = null;
    private Status status = null;

    public Job() {
    }

    public Job(JobAuStatus jobAuStatus) {
        if (jobAuStatus != null) {
            this.au = new Au(jobAuStatus);
            this.id = jobAuStatus.getId();
            this.description = jobAuStatus.getDescription();
            this.creationDate = jobAuStatus.getCreationDate();
            this.startDate = jobAuStatus.getStartDate();
            this.endDate = jobAuStatus.getEndDate();
            this.status = new Status(jobAuStatus);
        }
    }

    public Au getAu() {
        return this.au;
    }

    public void setAu(Au au) {
        this.au = au;
    }

    @ApiModelProperty(required=true, value="The identifier of this job")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(value="A description of the task being performed by this job")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(required=true, value="The timestamp when this job was created")
    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @ApiModelProperty(value="The timestamp when this job processing started")
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @ApiModelProperty(value="The timestamp when this job processing ended")
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Job job = (Job)o;
        return Objects.equals(this.au, job.au) && Objects.equals(this.id, job.id) && Objects.equals(this.description, job.description) && Objects.equals(this.creationDate, job.creationDate) && Objects.equals(this.startDate, job.startDate) && Objects.equals(this.endDate, job.endDate) && Objects.equals(this.status, job.status);
    }

    public int hashCode() {
        return Objects.hash(this.au, this.id, this.description, this.creationDate, this.startDate, this.endDate, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Job {\n");
        sb.append("    au: ").append(this.toIndentedString((Object)this.au)).append("\n");
        sb.append("    id: ").append(this.toIndentedString((Object)this.id)).append("\n");
        sb.append("    description: ").append(this.toIndentedString((Object)this.description)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString((Object)this.creationDate)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString((Object)this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString((Object)this.endDate)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

