/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.mdx;

import org.lockss.app.LockssApp;
import org.lockss.app.LockssDaemon;
import org.lockss.app.ManagerDescs;
import org.lockss.app.ServiceDescr;
import org.lockss.metadata.extractor.MetadataExtractorManager;
import org.lockss.metadata.extractor.job.JobDbManager;
import org.lockss.metadata.extractor.job.JobManager;
import org.lockss.spring.base.BaseSpringBootApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@SpringBootApplication
@EnableSwagger2
public class MdxApplication
extends BaseSpringBootApplication
implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(MdxApplication.class);
    protected static final LockssApp.ManagerDesc[] myManagerDescs = new LockssApp.ManagerDesc[]{ManagerDescs.ACCOUNT_MANAGER_DESC, ManagerDescs.CONFIG_DB_MANAGER_DESC, ManagerDescs.PLUGIN_MANAGER_DESC, ManagerDescs.STATE_MANAGER_DESC, ManagerDescs.CRAWL_MANAGER_DESC, ManagerDescs.REPOSITORY_MANAGER_DESC, ManagerDescs.METADATA_DB_MANAGER_DESC, ManagerDescs.METADATA_MANAGER_DESC, new LockssApp.ManagerDesc(LockssDaemon.managerKey(MetadataExtractorManager.class), "org.lockss.metadata.extractor.MetadataExtractorManager"), new LockssApp.ManagerDesc(LockssDaemon.managerKey(JobDbManager.class), "org.lockss.metadata.extractor.job.JobDbManager"), new LockssApp.ManagerDesc(LockssDaemon.managerKey(JobManager.class), "org.lockss.metadata.extractor.job.JobManager"), ManagerDescs.SERVLET_MANAGER_DESC, ManagerDescs.PLATFORM_CONFIG_STATUS_DESC, ManagerDescs.CONFIG_STATUS_DESC, ManagerDescs.ARCHIVAL_UNIT_STATUS_DESC, ManagerDescs.OVERVIEW_STATUS_DESC};

    public static void main(String[] args) {
        logger.info("Starting the application");
        MdxApplication.configure();
        SpringApplication.run(MdxApplication.class, (String[])args);
    }

    public void run(String ... args) {
        if (args != null && args.length > 0) {
            logger.info("Starting the LOCKSS Metadata Extractor Service");
            LockssApp.AppSpec spec = new LockssApp.AppSpec().setService(ServiceDescr.SVC_MDX).setArgs(args).addAppConfig("org.lockss.startPlugins", "true").addAppConfig("org.lockss.plugin.startAllAus", "false").setAppManagers(myManagerDescs);
            LockssApp.startStatic(LockssDaemon.class, (LockssApp.AppSpec)spec);
        }
    }
}

