/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.mdx.impl;

import java.security.AccessControlException;
import java.util.ConcurrentModificationException;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.util.Supplier;
import org.lockss.app.LockssApp;
import org.lockss.laaws.mdx.api.MdupdatesApiDelegate;
import org.lockss.laaws.mdx.model.JobPageInfo;
import org.lockss.laaws.mdx.model.MetadataUpdateSpec;
import org.lockss.laaws.mdx.model.PageInfo;
import org.lockss.laaws.status.model.ApiStatus;
import org.lockss.log.L4JLogger;
import org.lockss.metadata.extractor.job.Job;
import org.lockss.metadata.extractor.job.JobAuStatus;
import org.lockss.metadata.extractor.job.JobContinuationToken;
import org.lockss.metadata.extractor.job.JobManager;
import org.lockss.metadata.extractor.job.JobPage;
import org.lockss.metadata.extractor.job.Status;
import org.lockss.spring.auth.SpringAuthenticationFilter;
import org.lockss.spring.status.SpringLockssBaseApiController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class MdupdatesApiServiceImpl
extends SpringLockssBaseApiController
implements MdupdatesApiDelegate {
    public static final String MD_UPDATE_DELETE = "delete";
    public static final String MD_UPDATE_FULL_EXTRACTION = "full_extraction";
    public static final String MD_UPDATE_INCREMENTAL_EXTRACTION = "incremental_extraction";
    private static final L4JLogger log = L4JLogger.getLogger();
    @Autowired
    private HttpServletRequest request;

    @Override
    public ResponseEntity<Integer> deleteMdupdates() {
        log.debug2("Invoked");
        try {
            SpringAuthenticationFilter.checkAuthorization((String[])new String[]{"contentAdminRole"});
        }
        catch (AccessControlException ace) {
            log.warn(ace.getMessage());
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        try {
            int removedCount = this.getJobManager().removeAllJobs();
            log.trace("removedCount = {}", (Object)removedCount);
            return new ResponseEntity((Object)removedCount, HttpStatus.OK);
        }
        catch (Exception e) {
            String message = "Cannot deleteMdupdates()";
            log.error(message, (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public ResponseEntity<Job> deleteMdupdatesJobid(String jobid) {
        log.debug2("jobid = {}", (Object)jobid);
        try {
            SpringAuthenticationFilter.checkAuthorization((String[])new String[]{"contentAdminRole"});
        }
        catch (AccessControlException ace) {
            log.warn(ace.getMessage());
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        try {
            JobAuStatus jobAuStatus = this.getJobManager().removeJob(jobid);
            log.trace("jobAuStatus = {}", new Supplier[]{() -> jobAuStatus});
            Job result = new Job(jobAuStatus);
            log.trace("result = {}", new Supplier[]{() -> result});
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (IllegalArgumentException iae) {
            String message = "No job found for jobid = '" + jobid + "'";
            log.warn(message, (Throwable)iae);
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            String message = "Cannot deleteMdupdatesJobid() for jobid = '" + jobid + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public ResponseEntity<JobPageInfo> getMdupdates(Integer limit, String continuationToken) {
        log.debug2("limit = {}", (Object)limit);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        if (limit == null || limit < 0) {
            String message = "Limit of requested items must be a non-negative integer; it was '" + limit + "'";
            log.warn(message);
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        JobContinuationToken jct = null;
        try {
            jct = new JobContinuationToken(continuationToken);
        }
        catch (IllegalArgumentException iae) {
            String message = "Invalid continuation token '" + continuationToken + "'";
            log.warn(message, (Throwable)iae);
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        try {
            JobPage jobPage = this.getJobManager().getJobs(limit, jct);
            log.trace("jobPage = {}", new Supplier[]{() -> jobPage});
            JobPageInfo result = new JobPageInfo();
            PageInfo pi = new PageInfo();
            result.setPageInfo(pi);
            StringBuffer curLinkBuffer = new StringBuffer(this.request.getRequestURL().toString()).append("?limit=").append(limit);
            if (continuationToken != null) {
                curLinkBuffer.append("&continuationToken=").append(continuationToken);
            }
            if (log.isTraceEnabled()) {
                log.trace("curLink = {}", (Object)curLinkBuffer.toString());
            }
            pi.setCurLink(curLinkBuffer.toString());
            pi.setResultsPerPage(jobPage.getJobs().size());
            if (jobPage.getContinuationToken() != null) {
                pi.setContinuationToken(jobPage.getContinuationToken().toWebResponseContinuationToken());
                String nextLink = this.request.getRequestURL().toString() + "?limit=" + limit + "&continuationToken=" + pi.getContinuationToken();
                log.trace("nextLink = {}", (Object)nextLink);
                pi.setNextLink(nextLink);
            }
            result.setJobs(jobPage.getJobs());
            log.debug2("result = {}", new Supplier[]{() -> result});
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (ConcurrentModificationException cme) {
            String message = "Pagination conflict for jobs: " + cme.getMessage();
            log.warn(message, (Throwable)cme);
            return new ResponseEntity(HttpStatus.CONFLICT);
        }
        catch (Exception e) {
            String message = "Cannot getMdupdates() for limit = " + limit + ", continuationToken = " + continuationToken;
            log.error(message, (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public ResponseEntity<Status> getMdupdatesJobid(String jobid) {
        log.debug2("jobid = {}", (Object)jobid);
        try {
            JobAuStatus jobAuStatus = this.getJobManager().getJobStatus(jobid);
            log.trace("jobAuStatus = {}", new Supplier[]{() -> jobAuStatus});
            Status result = new Status(jobAuStatus);
            log.trace("result = {}", new Supplier[]{() -> result});
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (IllegalArgumentException iae) {
            String message = "No job found for jobid = '" + jobid + "'";
            log.warn(message, (Throwable)iae);
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            String message = "Cannot getMdupdatesJobid() for jobid = '" + jobid + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public ResponseEntity<Job> postMdupdates(MetadataUpdateSpec metadataUpdateSpec) {
        log.debug2("metadataUpdateSpec = {}", new Supplier[]{() -> metadataUpdateSpec});
        try {
            SpringAuthenticationFilter.checkAuthorization((String[])new String[]{"contentAdminRole"});
        }
        catch (AccessControlException ace) {
            log.warn(ace.getMessage());
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        String auid = null;
        try {
            if (metadataUpdateSpec == null) {
                String message = "Invalid metadata update specification: null";
                log.warn(message);
                return new ResponseEntity(HttpStatus.BAD_REQUEST);
            }
            auid = metadataUpdateSpec.getAuid();
            log.trace("auid = {}", (Object)auid);
            if (auid == null || auid.isEmpty()) {
                String message = "Invalid auid = '" + auid + "'";
                log.warn(message);
                return new ResponseEntity(HttpStatus.BAD_REQUEST);
            }
            String updateType = metadataUpdateSpec.getUpdateType();
            log.trace("updateType = {}", (Object)updateType);
            if (updateType == null || updateType.isEmpty()) {
                String message = "Invalid updateType = '" + updateType + "'";
                log.warn(message);
                return new ResponseEntity(HttpStatus.BAD_REQUEST);
            }
            String canonicalUpdateType = updateType.toLowerCase();
            log.trace("canonicalUpdateType = {}", (Object)canonicalUpdateType);
            JobAuStatus jobAuStatus = null;
            if (canonicalUpdateType.equals(MD_UPDATE_FULL_EXTRACTION)) {
                jobAuStatus = this.getJobManager().scheduleMetadataExtraction(auid, true);
            } else if (canonicalUpdateType.equals(MD_UPDATE_INCREMENTAL_EXTRACTION)) {
                jobAuStatus = this.getJobManager().scheduleMetadataExtraction(auid, false);
            } else if (canonicalUpdateType.equals(MD_UPDATE_DELETE)) {
                jobAuStatus = this.getJobManager().scheduleMetadataRemoval(auid);
            } else {
                String message = "Invalid updateType = '" + updateType + "'";
                log.warn(message);
                return new ResponseEntity(HttpStatus.BAD_REQUEST);
            }
            if (log.isTraceEnabled()) {
                log.trace("jobAuStatus = {}", (Object)jobAuStatus);
            }
            Job result = new Job(jobAuStatus);
            log.trace("result = {}", new Supplier[]{() -> result});
            return new ResponseEntity((Object)result, HttpStatus.ACCEPTED);
        }
        catch (IllegalArgumentException iae) {
            String message = "No Archival Unit found for auid = '" + auid + "'";
            log.warn(message, (Throwable)iae);
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            String message = "Cannot postMdupdates() for metadataUpdateSpec = '" + metadataUpdateSpec + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ApiStatus getApiStatus() {
        return new ApiStatus("swagger/swagger.yaml").setReady(Boolean.valueOf(LockssApp.getLockssApp().isAppRunning()));
    }

    private JobManager getJobManager() {
        return (JobManager)LockssApp.getManagerByTypeStatic(JobManager.class);
    }
}

