/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.mdx.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import org.lockss.laaws.mdx.api.MdupdatesApiDelegate;
import org.lockss.laaws.mdx.model.JobPageInfo;
import org.lockss.laaws.mdx.model.MetadataUpdateSpec;
import org.lockss.metadata.extractor.job.Job;
import org.lockss.metadata.extractor.job.Status;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="mdupdates", description="the mdupdates API")
public interface MdupdatesApi {
    public MdupdatesApiDelegate getDelegate();

    @ApiOperation(value="Delete all of the currently queued and active jobs", nickname="deleteMdupdates", notes="Delete all of the currently queued and active jobs", response=Integer.class, authorizations={@Authorization(value="basicAuth")}, tags={"mdupdates"})
    @ApiResponses(value={@ApiResponse(code=200, message="Count of jobs successfully deleted", response=Integer.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/mdupdates"}, produces={"application/json"}, method={RequestMethod.DELETE})
    default public ResponseEntity<Integer> deleteMdupdates() {
        return this.getDelegate().deleteMdupdates();
    }

    @ApiOperation(value="Delete a job", nickname="deleteMdupdatesJobid", notes="Delete a job given the job identifier, stopping any current processing, if necessary", response=Job.class, authorizations={@Authorization(value="basicAuth")}, tags={"mdupdates"})
    @ApiResponses(value={@ApiResponse(code=200, message="The deleted job", response=Job.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/mdupdates/{jobid}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    default public ResponseEntity<Job> deleteMdupdatesJobid(@ApiParam(value="The identifier of the job to be deleted", required=true) @PathVariable(value="jobid") String jobid) {
        return this.getDelegate().deleteMdupdatesJobid(jobid);
    }

    @ApiOperation(value="Get a list of currently active jobs", nickname="getMdupdates", notes="Get a list of all currently active jobs or a pageful of the list defined by the continuation token and size", response=JobPageInfo.class, authorizations={@Authorization(value="basicAuth")}, tags={"mdupdates"})
    @ApiResponses(value={@ApiResponse(code=200, message="The requested jobs", response=JobPageInfo.class), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=409, message="Conflict"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/mdupdates"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<JobPageInfo> getMdupdates(@ApiParam(value="The number of jobs per page", defaultValue="50") @Valid @RequestParam(value="limit", required=false, defaultValue="50") Integer limit, @ApiParam(value="The continuation token of the next page of jobs to be returned") @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().getMdupdates(limit, continuationToken);
    }

    @ApiOperation(value="Get a job", nickname="getMdupdatesJobid", notes="Get a job given the job identifier", response=Status.class, authorizations={@Authorization(value="basicAuth")}, tags={"mdupdates"})
    @ApiResponses(value={@ApiResponse(code=200, message="The status of the requested job", response=Status.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Not Found"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/mdupdates/{jobid}"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<Status> getMdupdatesJobid(@ApiParam(value="The identifier of the requested job", required=true) @PathVariable(value="jobid") String jobid) {
        return this.getDelegate().getMdupdatesJobid(jobid);
    }

    @ApiOperation(value="Perform an AU metadata update operation", nickname="postMdupdates", notes="Perform an AU metadata update operation given the update specification", response=Job.class, authorizations={@Authorization(value="basicAuth")}, tags={"mdupdates"})
    @ApiResponses(value={@ApiResponse(code=202, message="The job created to perform the AU metadata update operation", response=Job.class), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden"), @ApiResponse(code=404, message="Not Found"), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/mdupdates"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    default public ResponseEntity<Job> postMdupdates(@ApiParam(value="The information defining the AU metadata update operation", required=true) @Valid @RequestBody MetadataUpdateSpec metadataUpdateSpec) {
        return this.getDelegate().postMdupdates(metadataUpdateSpec);
    }
}

