/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.mdx.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="The information defining an AU metadata update operation")
@Validated
public class MetadataUpdateSpec {
    @JsonProperty(value="auid")
    private String auid = null;
    @JsonProperty(value="updateType")
    private String updateType = null;

    public MetadataUpdateSpec auid(String auid) {
        this.auid = auid;
        return this;
    }

    @ApiModelProperty(required=true, value="The identifier of the AU for which the metadata update is to be performed")
    @NotNull
    public String getAuid() {
        return this.auid;
    }

    public void setAuid(String auid) {
        this.auid = auid;
    }

    public MetadataUpdateSpec updateType(String updateType) {
        this.updateType = updateType;
        return this;
    }

    @ApiModelProperty(example="full_extraction | incremental_extraction | delete", required=true, value="The type of metadata update to be performed")
    @NotNull
    public String getUpdateType() {
        return this.updateType;
    }

    public void setUpdateType(String updateType) {
        this.updateType = updateType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataUpdateSpec metadataUpdateSpec = (MetadataUpdateSpec)o;
        return Objects.equals(this.auid, metadataUpdateSpec.auid) && Objects.equals(this.updateType, metadataUpdateSpec.updateType);
    }

    public int hashCode() {
        return Objects.hash(this.auid, this.updateType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataUpdateSpec {\n");
        sb.append("    auid: ").append(this.toIndentedString(this.auid)).append("\n");
        sb.append("    updateType: ").append(this.toIndentedString(this.updateType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

