/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.mdx.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.validation.Valid;
import org.lockss.laaws.mdx.api.MdupdatesApiDelegate;
import org.lockss.laaws.mdx.model.ErrorResult;
import org.lockss.laaws.mdx.model.JobPageInfo;
import org.lockss.metadata.extractor.job.Job;
import org.lockss.metadata.extractor.job.Status;
import org.lockss.util.rest.mdx.MetadataUpdateSpec;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
public interface MdupdatesApi {
    public MdupdatesApiDelegate getDelegate();

    @Operation(summary="Delete all of the currently queued and active jobs", description="Delete all of the currently queued and active jobs", security={@SecurityRequirement(name="basicAuth")}, tags={"mdupdates"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Count of jobs successfully deleted", content={@Content(mediaType="application/json", schema=@Schema(implementation=Integer.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/mdupdates"}, produces={"application/json"}, method={RequestMethod.DELETE})
    default public ResponseEntity<Integer> deleteMdupdates() {
        return this.getDelegate().deleteMdupdates();
    }

    @Operation(summary="Delete a job", description="Delete a job given the job identifier, stopping any current processing, if necessary", security={@SecurityRequirement(name="basicAuth")}, tags={"mdupdates"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The deleted job", content={@Content(mediaType="application/json", schema=@Schema(implementation=Job.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/mdupdates/{jobid}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    default public ResponseEntity<Job> deleteMdupdatesJobid(@Parameter(in=ParameterIn.PATH, description="The identifier of the job to be deleted", required=true, schema=@Schema) @PathVariable(value="jobid") String jobid) {
        return this.getDelegate().deleteMdupdatesJobid(jobid);
    }

    @Operation(summary="Get a list of currently active jobs", description="Get a list of all currently active jobs or a pageful of the list defined by the continuation token and size", security={@SecurityRequirement(name="basicAuth")}, tags={"mdupdates"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The requested jobs", content={@Content(mediaType="application/json", schema=@Schema(implementation=JobPageInfo.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/mdupdates"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<JobPageInfo> getMdupdates(@Parameter(in=ParameterIn.QUERY, description="The number of jobs per page", schema=@Schema(defaultValue="50")) @Valid @RequestParam(value="limit", required=false, defaultValue="50") Integer limit, @Parameter(in=ParameterIn.QUERY, description="The continuation token of the next page of jobs to be returned", schema=@Schema) @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().getMdupdates(limit, continuationToken);
    }

    @Operation(summary="Get a job", description="Get a job given the job identifier", security={@SecurityRequirement(name="basicAuth")}, tags={"mdupdates"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The status of the requested job", content={@Content(mediaType="application/json", schema=@Schema(implementation=Status.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/mdupdates/{jobid}"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<Status> getMdupdatesJobid(@Parameter(in=ParameterIn.PATH, description="The identifier of the requested job", required=true, schema=@Schema) @PathVariable(value="jobid") String jobid) {
        return this.getDelegate().getMdupdatesJobid(jobid);
    }

    @Operation(summary="Perform an AU metadata update operation", description="Perform an AU metadata update operation given the update specification", security={@SecurityRequirement(name="basicAuth")}, tags={"mdupdates"})
    @ApiResponses(value={@ApiResponse(responseCode="202", description="The job created to perform the AU metadata update operation", content={@Content(mediaType="application/json", schema=@Schema(implementation=Job.class))}), @ApiResponse(responseCode="200", description="The resulting error payload.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResult.class))})})
    @RequestMapping(value={"/mdupdates"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    default public ResponseEntity<Job> postMdupdates(@Parameter(in=ParameterIn.DEFAULT, description="The information defining the AU metadata update operation", required=true, schema=@Schema) @Valid @RequestBody MetadataUpdateSpec body, @Parameter(in=ParameterIn.QUERY, description="An indication of whether to force the operation regardless of the current state of the AU", schema=@Schema(defaultValue="true")) @Valid @RequestParam(value="force", required=false, defaultValue="true") Boolean force) {
        return this.getDelegate().postMdupdates(body, force);
    }
}

