/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.mdx.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Optional;
import org.lockss.laaws.mdx.api.MdupdatesApi;
import org.lockss.laaws.mdx.model.JobPageInfo;
import org.lockss.metadata.extractor.job.Job;
import org.lockss.metadata.extractor.job.Status;
import org.lockss.util.rest.mdx.MetadataUpdateSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;

public interface MdupdatesApiDelegate {
    public static final Logger log = LoggerFactory.getLogger(MdupdatesApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    default public ResponseEntity<Integer> deleteMdupdates() {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((Integer)this.getObjectMapper().get().readValue("0", Integer.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default MdupdatesApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<Job> deleteMdupdatesJobid(String jobid) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((Job)this.getObjectMapper().get().readValue("{\n  \"au\" : {\n    \"name\" : \"name\",\n    \"id\" : \"id\",\n    \"job\" : \"job\"\n  },\n  \"endDate\" : \"2000-01-23\",\n  \"description\" : \"description\",\n  \"id\" : \"id\",\n  \"creationDate\" : \"2000-01-23\",\n  \"startDate\" : \"2000-01-23\",\n  \"status\" : {\n    \"msg\" : \"msg\",\n    \"code\" : 0\n  }\n}", Job.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default MdupdatesApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<JobPageInfo> getMdupdates(Integer limit, String continuationToken) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((JobPageInfo)this.getObjectMapper().get().readValue("{\n  \"jobs\" : [ {\n    \"au\" : {\n      \"name\" : \"name\",\n      \"id\" : \"id\",\n      \"job\" : \"job\"\n    },\n    \"endDate\" : \"2000-01-23\",\n    \"description\" : \"description\",\n    \"id\" : \"id\",\n    \"creationDate\" : \"2000-01-23\",\n    \"startDate\" : \"2000-01-23\",\n    \"status\" : {\n      \"msg\" : \"msg\",\n      \"code\" : 0\n    }\n  }, {\n    \"au\" : {\n      \"name\" : \"name\",\n      \"id\" : \"id\",\n      \"job\" : \"job\"\n    },\n    \"endDate\" : \"2000-01-23\",\n    \"description\" : \"description\",\n    \"id\" : \"id\",\n    \"creationDate\" : \"2000-01-23\",\n    \"startDate\" : \"2000-01-23\",\n    \"status\" : {\n      \"msg\" : \"msg\",\n      \"code\" : 0\n    }\n  } ],\n  \"pageInfo\" : {\n    \"curLink\" : \"curLink\",\n    \"resultsPerPage\" : 1,\n    \"totalCount\" : 6,\n    \"continuationToken\" : \"continuationToken\",\n    \"nextLink\" : \"nextLink\"\n  }\n}", JobPageInfo.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default MdupdatesApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<Status> getMdupdatesJobid(String jobid) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((Status)this.getObjectMapper().get().readValue("{\n  \"msg\" : \"msg\",\n  \"code\" : 0\n}", Status.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default MdupdatesApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<Job> postMdupdates(MetadataUpdateSpec body, Boolean force) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((Job)this.getObjectMapper().get().readValue("{\n  \"au\" : {\n    \"name\" : \"name\",\n    \"id\" : \"id\",\n    \"job\" : \"job\"\n  },\n  \"endDate\" : \"2000-01-23\",\n  \"description\" : \"description\",\n  \"id\" : \"id\",\n  \"creationDate\" : \"2000-01-23\",\n  \"startDate\" : \"2000-01-23\",\n  \"status\" : {\n    \"msg\" : \"msg\",\n    \"code\" : 0\n  }\n}", Job.class)), (HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default MdupdatesApi interface so no example is generated");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }
}

