/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.mdx.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.security.AccessControlException;
import java.util.ConcurrentModificationException;
import org.apache.logging.log4j.util.Supplier;
import org.lockss.account.UserAccount;
import org.lockss.app.LockssApp;
import org.lockss.app.LockssDaemon;
import org.lockss.laaws.mdx.api.MdupdatesApiDelegate;
import org.lockss.laaws.mdx.model.JobPageInfo;
import org.lockss.laaws.mdx.model.PageInfo;
import org.lockss.log.L4JLogger;
import org.lockss.metadata.extractor.MetadataExtractorManager;
import org.lockss.metadata.extractor.job.Job;
import org.lockss.metadata.extractor.job.JobAuStatus;
import org.lockss.metadata.extractor.job.JobContinuationToken;
import org.lockss.metadata.extractor.job.JobManager;
import org.lockss.metadata.extractor.job.JobPage;
import org.lockss.metadata.extractor.job.Status;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.plugin.AuUtil;
import org.lockss.servlet.DebugPanel;
import org.lockss.spring.auth.AuthUtil;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.state.AuState;
import org.lockss.util.rest.mdx.MetadataUpdateSpec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class MdupdatesApiServiceImpl
extends BaseSpringApiServiceImpl
implements MdupdatesApiDelegate {
    private static final L4JLogger log = L4JLogger.getLogger();
    static final String USE_FORCE_MESSAGE = "Use the 'force=true' query parameter to override.";
    @Autowired
    private HttpServletRequest request;

    @Override
    public ResponseEntity<Integer> deleteMdupdates() {
        log.debug2("Invoked");
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        try {
            AuthUtil.checkHasRole((String[])new String[]{"contentAdminRole"});
        }
        catch (AccessControlException ace) {
            log.warn(ace.getMessage());
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        try {
            int removedCount = this.getJobManager().removeAllJobs();
            log.trace("removedCount = {}", (Object)removedCount);
            return new ResponseEntity((Object)removedCount, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            String message = "Cannot deleteMdupdates()";
            log.error(message, (Throwable)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public ResponseEntity<Job> deleteMdupdatesJobid(String jobid) {
        log.debug2("jobid = {}", (Object)jobid);
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        try {
            AuthUtil.checkHasRole((String[])new String[]{"contentAdminRole"});
        }
        catch (AccessControlException ace) {
            log.warn(ace.getMessage());
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        try {
            JobAuStatus jobAuStatus = this.getJobManager().removeJob(jobid);
            log.trace("jobAuStatus = {}", new Supplier[]{() -> jobAuStatus});
            Job result = new Job(jobAuStatus);
            log.trace("result = {}", new Supplier[]{() -> result});
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IllegalArgumentException iae) {
            String message = "No job found for jobid = '" + jobid + "'";
            log.warn(message, (Throwable)iae);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            String message = "Cannot deleteMdupdatesJobid() for jobid = '" + jobid + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public ResponseEntity<JobPageInfo> getMdupdates(Integer limit, String continuationToken) {
        log.debug2("limit = {}", (Object)limit);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        if (limit == null || limit < 0) {
            String message = "Limit of requested items must be a non-negative integer; it was '" + limit + "'";
            log.warn(message);
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        JobContinuationToken jct = null;
        try {
            jct = new JobContinuationToken(continuationToken);
        }
        catch (IllegalArgumentException iae) {
            String message = "Invalid continuation token '" + continuationToken + "'";
            log.warn(message, (Throwable)iae);
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        try {
            JobPage jobPage = this.getJobManager().getJobs(limit, jct);
            log.trace("jobPage = {}", new Supplier[]{() -> jobPage});
            JobPageInfo result = new JobPageInfo();
            PageInfo pi = new PageInfo();
            result.setPageInfo(pi);
            StringBuffer curLinkBuffer = new StringBuffer(this.request.getRequestURL().toString()).append("?limit=").append(limit);
            if (continuationToken != null) {
                curLinkBuffer.append("&continuationToken=").append(continuationToken);
            }
            if (log.isTraceEnabled()) {
                log.trace("curLink = {}", (Object)curLinkBuffer.toString());
            }
            pi.setCurLink(curLinkBuffer.toString());
            pi.setResultsPerPage(jobPage.getJobs().size());
            if (jobPage.getContinuationToken() != null) {
                pi.setContinuationToken(jobPage.getContinuationToken().toWebResponseContinuationToken());
                String nextLink = this.request.getRequestURL().toString() + "?limit=" + limit + "&continuationToken=" + pi.getContinuationToken();
                log.trace("nextLink = {}", (Object)nextLink);
                pi.setNextLink(nextLink);
            }
            result.setJobs(jobPage.getJobs());
            log.debug2("result = {}", new Supplier[]{() -> result});
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (ConcurrentModificationException cme) {
            String message = "Pagination conflict for jobs: " + cme.getMessage();
            log.warn(message, (Throwable)cme);
            return new ResponseEntity((HttpStatusCode)HttpStatus.CONFLICT);
        }
        catch (Exception e) {
            String message = "Cannot getMdupdates() for limit = " + limit + ", continuationToken = " + continuationToken;
            log.error(message, (Throwable)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public ResponseEntity<Status> getMdupdatesJobid(String jobid) {
        log.debug2("jobid = {}", (Object)jobid);
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        try {
            JobAuStatus jobAuStatus = this.getJobManager().getJobStatus(jobid);
            log.trace("jobAuStatus = {}", new Supplier[]{() -> jobAuStatus});
            Status result = new Status(jobAuStatus);
            log.trace("result = {}", new Supplier[]{() -> result});
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IllegalArgumentException iae) {
            String message = "No job found for jobid = '" + jobid + "'";
            log.warn(message, (Throwable)iae);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            String message = "Cannot getMdupdatesJobid() for jobid = '" + jobid + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public ResponseEntity<Job> postMdupdates(MetadataUpdateSpec metadataUpdateSpec, Boolean force) {
        log.debug2("metadataUpdateSpec = {}", (Object)metadataUpdateSpec);
        log.debug2("force = {}", (Object)force);
        if (!this.waitReady()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE);
        }
        try {
            AuthUtil.checkHasRole((String[])new String[]{"contentAdminRole"});
        }
        catch (AccessControlException ace) {
            log.warn(ace.getMessage());
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        if (!((MetadataExtractorManager)LockssApp.getManagerByTypeStatic(MetadataExtractorManager.class)).isIndexingEnabled()) {
            try {
                if (force.booleanValue()) {
                    this.audit("Force Reindex Metadata", null);
                } else {
                    this.audit("Reindex Metadata", null);
                }
            }
            catch (AccessControlException ace) {
                log.warn(ace.getMessage());
                return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
            }
            String message = "Metadata extraction is disabled";
            log.warn(message);
            return new ResponseEntity((HttpStatusCode)HttpStatus.CONFLICT);
        }
        String auid = null;
        try {
            if (metadataUpdateSpec == null) {
                try {
                    if (force.booleanValue()) {
                        this.audit("Force Reindex Metadata", null);
                    } else {
                        this.audit("Reindex Metadata", null);
                    }
                }
                catch (AccessControlException ace) {
                    log.warn(ace.getMessage());
                    return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
                }
                String message = "Invalid metadata update specification: null";
                log.warn(message);
                return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            auid = metadataUpdateSpec.getAuid();
            log.trace("auid = {}", (Object)auid);
            try {
                if (force.booleanValue()) {
                    this.audit("Force Reindex Metadata", auid);
                } else {
                    this.audit("Reindex Metadata", auid);
                }
            }
            catch (AccessControlException ace) {
                log.warn(ace.getMessage());
                return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
            }
            if (auid == null || auid.isEmpty()) {
                String message = "Invalid auid = '" + auid + "'";
                log.warn(message);
                return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            String updateType = metadataUpdateSpec.getUpdateType();
            log.trace("updateType = {}", (Object)updateType);
            if (updateType == null || updateType.isEmpty()) {
                String message = "Invalid updateType = '" + updateType + "'";
                log.warn(message);
                return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            if (!force.booleanValue()) {
                ArchivalUnit au = LockssDaemon.getLockssDaemon().getPluginManager().getAuFromId(auid);
                log.trace("au = {}", (Object)au);
                if (au == null) {
                    throw new IllegalArgumentException();
                }
                String message = null;
                if (!AuUtil.hasCrawled((ArchivalUnit)au)) {
                    message = "AU has never been crawled. Use the 'force=true' query parameter to override.";
                    log.warn(message);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.CONFLICT);
                }
                AuState auState = AuUtil.getAuState((ArchivalUnit)au);
                log.trace("auState = {}", (Object)auState);
                switch (auState.getSubstanceState()) {
                    case No: {
                        message = "AU has no substance. Use the 'force=true' query parameter to override.";
                        log.warn(message);
                        return new ResponseEntity((HttpStatusCode)HttpStatus.CONFLICT);
                    }
                    case Unknown: {
                        message = "Unknown substance for AU. Use the 'force=true' query parameter to override.";
                        log.warn(message);
                        return new ResponseEntity((HttpStatusCode)HttpStatus.CONFLICT);
                    }
                }
                if (!auState.isMetadataExtractionEnabled()) {
                    message = "Metadata extraction for this AU has been disabled";
                    log.warn(message);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.CONFLICT);
                }
            }
            String canonicalUpdateType = updateType.toLowerCase();
            log.trace("canonicalUpdateType = {}", (Object)canonicalUpdateType);
            JobAuStatus jobAuStatus = null;
            if (canonicalUpdateType.equals("full_extraction")) {
                jobAuStatus = this.getJobManager().scheduleMetadataExtraction(auid, true);
            } else if (canonicalUpdateType.equals("incremental_extraction")) {
                jobAuStatus = this.getJobManager().scheduleMetadataExtraction(auid, false);
            } else if (canonicalUpdateType.equals("delete")) {
                jobAuStatus = this.getJobManager().scheduleMetadataRemoval(auid);
            } else {
                String message = "Invalid updateType = '" + updateType + "'";
                log.warn(message);
                return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            if (log.isTraceEnabled()) {
                log.trace("jobAuStatus = {}", (Object)jobAuStatus);
            }
            Job result = new Job(jobAuStatus);
            log.trace("result = {}", new Supplier[]{() -> result});
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.ACCEPTED);
        }
        catch (IllegalArgumentException iae) {
            String message = "No Archival Unit found for auid = '" + auid + "'";
            log.warn(message, (Throwable)iae);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            String message = "Cannot postMdupdates() for metadataUpdateSpec = '" + String.valueOf(metadataUpdateSpec) + "', force = " + force;
            log.error(message, (Throwable)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private JobManager getJobManager() {
        return (JobManager)LockssApp.getManagerByTypeStatic(JobManager.class);
    }

    private void audit(String action, String auId) throws AccessControlException {
        log.debug2("action = {}", (Object)action);
        log.debug2("auId = {}", (Object)auId);
        String userName = SecurityContextHolder.getContext().getAuthentication().getName();
        log.trace("userName = {}", (Object)userName);
        UserAccount userAccount = null;
        try {
            userAccount = LockssDaemon.getLockssDaemon().getAccountManager().getUser(userName);
            log.trace("userAccount = {}", (Object)userAccount);
        }
        catch (Exception e) {
            log.error("userName = {}", (Object)userName);
            log.error("LockssDaemon.getLockssDaemon().getAccountManager().getUser(" + userName + ")", (Throwable)e);
            throw new AccessControlException("Unable to get user '" + userName + "'");
        }
        if (userAccount != null && !DebugPanel.noAuditActions.contains(action)) {
            userAccount.auditableEvent("Called AusApi web service operation '" + action + "' AU ID: " + auId);
        }
    }
}

