/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.metadata.extractor;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lockss.db.DbException;
import org.lockss.db.DbManager;
import org.lockss.db.JdbcContext;
import org.lockss.laaws.mdq.model.ItemMetadata;
import org.lockss.metadata.extractor.MetadataExtractorManager;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.plugin.PluginManager;
import org.lockss.util.Logger;

public class MetadataExtractorManagerSql {
    private static final Logger log = Logger.getLogger(MetadataExtractorManagerSql.class);
    private static final int UNKNOWN_VERSION = -1;
    private static final String COUNT_ENABLED_PENDING_AUS_QUERY = "select count(*) from pending_au where priority >= 0";
    private static final String COUNT_BIB_ITEM_QUERY = "select count(*) from bib_item";
    private static final String COUNT_PUBLISHER_QUERY = "select count(distinct publisher.publisher_seq) from publisher,publication,md_item where publisher.publisher_seq=publication.publisher_seq and publication.md_item_seq=md_item.md_item_seq";
    private static final String COUNT_PROVIDER_QUERY = "select count(distinct provider.provider_seq) from provider,au_md,md_item where provider.provider_seq=au_md.provider_seq and au_md.au_md_seq=md_item.au_md_seq";
    private static final String FIND_PRIORITIZED_ENABLED_PENDING_AUS_QUERY = "select pending_au.plugin_id,pending_au.au_key,pending_au.priority,(au_md.au_seq is null) as is_new,pending_au.fully_reindex from pending_au   left join plugin     on plugin.plugin_id        = pending_au.plugin_id   left join au     on au.au_key        = pending_au.au_key    and au.plugin_seq        = plugin.plugin_seq   left join au_md     on au_md.au_seq        = au.au_seq where priority >= 0 order by (pending_au.priority > 0),(true = ? and au_md.au_seq is not null),pending_au.priority";
    private static final String DELETE_PENDING_AU_QUERY = "delete from pending_au where plugin_id = ? and au_key = ?";
    private static final String DELETE_AU_MD_ITEM_QUERY = "delete from md_item where au_md_seq = ?";
    private static final String FIND_AU_MD_BY_AU_ID_QUERY = "select m.au_md_seq from au_md m,au a,plugin p where m.au_seq = a.au_seq and a.plugin_seq = p.plugin_seq and p.plugin_id = ? and a.au_key = ?";
    private static final String DELETE_AU_QUERY = "delete from au where au_seq = ?";
    private static final String FIND_AU_BY_AU_ID_QUERY = "select a.au_seq from au a,plugin p where a.plugin_seq = p.plugin_seq and p.plugin_id = ? and a.au_key = ?";
    private static final String UPDATE_AU_MD_EXTRACT_TIME_QUERY = "update au_md set extract_time = ? where au_md_seq = ?";
    private static final String DELETE_DISABLED_PENDING_AU_QUERY = "delete from pending_au where plugin_id = ? and au_key = ? and priority < 0";
    private static final String INSERT_ENABLED_PENDING_AU_QUERY = "insert into pending_au(plugin_id,au_key,priority,fully_reindex) values (?,?,(select coalesce(max(priority), 0) + 1 from pending_au where priority >= 0),?)";
    private static final String INSERT_ENABLED_PENDING_AU_MYSQL_QUERY = "insert into pending_au(plugin_id,au_key,priority,fully_reindex) values (?,?,(select next_priority from (select coalesce(max(priority), 0) + 1 as next_priority from pending_au where priority >= 0) as temp_pau_table),?)";
    private static final String INSERT_HIGHEST_PRIORITY_PENDING_AU_QUERY = "insert into pending_au(plugin_id,au_key,priority,fully_reindex) values (?,?,0,?)";
    private static final String FIND_PENDING_AU_QUERY = "select plugin_id,au_key from pending_au where plugin_id = ? and au_key = ?";
    private static final String FIND_AU_METADATA_VERSION_QUERY = "select m.md_version from au_md m,au a,plugin p where m.au_seq =  a.au_seq and a.plugin_seq =  p.plugin_seq and p.plugin_id = ? and a.au_key = ?";
    private static final String FIND_AU_FULL_REINDEXING_BY_AU_QUERY = "select fully_reindex from pending_au where plugin_id = ? and au_key = ?";
    private static final String UPDATE_AU_FULL_REINDEXING_QUERY = "update pending_au set fully_reindex = ? where plugin_id = ? and au_key = ?";
    private static final String FIND_AU_MD_EXTRACT_TIME_BY_AUSEQ_QUERY = "select extract_time from au_md where au_seq = ?";
    private static final String FIND_AU_MD_EXTRACT_TIME_BY_AU_QUERY = "select m.extract_time from au_md m,au a,plugin p where m.au_seq =  a.au_seq and a.plugin_seq =  p.plugin_seq and p.plugin_id = ? and a.au_key = ?";
    private static final String INSERT_PLATFORM_QUERY = "insert into platform(platform_seq,platform_name) values (default,?)";
    private static final String INSERT_DISABLED_PENDING_AU_QUERY = "insert into pending_au(plugin_id,au_key,priority) values (?,?,-10000)";
    private static final String INSERT_FAILED_INDEXING_PENDING_AU_QUERY = "insert into pending_au(plugin_id,au_key,priority) values (?,?,-1000)";
    private static final String FIND_PENDING_AUS_WITH_PRIORITY_QUERY = "select plugin_id,au_key from pending_au where priority = ?";
    private static final String FIND_AU_PUBLISHER_QUERY = "select distinct pr.publisher_seq from publisher pr,publication p,md_item m,au_md am where pr.publisher_seq = p.publisher_seq and p.md_item_seq = m.parent_seq and m.au_md_seq = am.au_md_seq and am.au_seq = ?";
    private static final String FIND_MD_ITEM_AUTHOR_QUERY = "select author_name from author where md_item_seq = ?";
    private static final String FIND_MD_ITEM_KEYWORD_QUERY = "select keyword from keyword where md_item_seq = ?";
    private static final String INSERT_AUTHOR_QUERY = "insert into author(md_item_seq,author_name,author_idx) values (?,?,(select coalesce(max(author_idx), 0) + 1 from author where md_item_seq = ?))";
    private static final String INSERT_AUTHOR_MYSQL_QUERY = "insert into author(md_item_seq,author_name,author_idx) values (?,?,(select next_idx from (select coalesce(max(author_idx), 0) + 1 as next_idx from author where md_item_seq = ?) as temp_author_table))";
    private static final String INSERT_KEYWORD_QUERY = "insert into keyword(md_item_seq,keyword) values (?,?)";
    private static final String DELETE_UNCONFIGURED_AU_QUERY = "delete from unconfigured_au where plugin_id = ? and au_key = ?";
    private static final String DELETE_AU_CHILD_MD_ITEM_QUERY = "delete from md_item where au_md_seq = ? and md_item_seq = ? and parent_seq is not null";
    private static final String UPDATE_AU_MD_UNKNOWN_PROVIDER_QUERY = "update au_md set provider_seq = ? where au_md_seq IN (select am.au_md_seq from au_md am,provider p where am.provider_seq = p.provider_seq and p.provider_name = 'UNKNOWN PROVIDER' and am.au_md_seq = ?)";
    private static final String FIND_OFFSET_AU_MD_ITEM_QUERY = "select distinct pr.publisher_name, min1.name as publication_name, mi2.md_item_seq, min2.name as item_title, mi2.date, mi2.coverage, mi2.fetch_time, b.volume, b.issue, b.start_page, b.end_page, b.item_no, d.doi, pv.provider_name from publisher pr,plugin pl,publication pn,md_item_name min1,au_md am,au,provider pv,md_item mi2 left outer join md_item_name min2 on mi2.md_item_seq = min2.md_item_seq and min2.name_type = 'primary' left outer join doi d on mi2.md_item_seq = d.md_item_seq left outer join bib_item b on mi2.md_item_seq = b.md_item_seq where pr.publisher_seq = pn.publisher_seq and pn.md_item_seq = min1.md_item_seq and min1.name_type = 'primary' and pn.md_item_seq = mi2.parent_seq and mi2.au_md_seq = am.au_md_seq and am.au_seq = au.au_seq and au.plugin_seq = pl.plugin_seq and am.provider_seq = pv.provider_seq and pl.plugin_id = ? and au.au_key = ? order by mi2.md_item_seq offset ?";
    private static final String GET_MULTIPLE_MD_DETAIL_QUERY = "select distinct mi2.md_item_seq, u.feature, u.url, a.author_name, k.keyword, issn.issn, issn.issn_type, isbn.isbn, isbn.isbn_type, pi.proprietary_id from md_item mi2 left outer join md_item_name min2 on mi2.md_item_seq = min2.md_item_seq and min2.name_type = 'primary' left outer join issn on mi2.parent_seq = issn.md_item_seq left outer join isbn on mi2.parent_seq = isbn.md_item_seq left outer join proprietary_id pi on mi2.parent_seq = pi.md_item_seq left outer join url u on mi2.md_item_seq = u.md_item_seq left outer join author a on mi2.md_item_seq = a.md_item_seq left outer join keyword k on mi2.md_item_seq = k.md_item_seq where mi2.md_item_seq in () order by mi2.md_item_seq";
    private DbManager dbManager;
    private MetadataExtractorManager mdxManager;

    MetadataExtractorManagerSql(DbManager dbManager, MetadataExtractorManager mdxManager) throws DbException {
        this.dbManager = dbManager;
        this.mdxManager = mdxManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getEnabledPendingAusCount() throws DbException {
        String DEBUG_HEADER = "getEnabledPendingAusCount(): ";
        if (log.isDebug2()) {
            log.debug2("getEnabledPendingAusCount(): Starting...");
        }
        long rowCount = -1L;
        Connection conn = this.dbManager.getConnection();
        try {
            rowCount = this.getEnabledPendingAusCount(conn);
        }
        finally {
            DbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("getEnabledPendingAusCount(): rowCount = " + rowCount);
        }
        return rowCount;
    }

    long getEnabledPendingAusCount(Connection conn) throws DbException {
        String DEBUG_HEADER = "getEnabledPendingAusCount(): ";
        if (log.isDebug2()) {
            log.debug2("getEnabledPendingAusCount(): Starting...");
        }
        long rowCount = -1L;
        PreparedStatement stmt = this.dbManager.prepareStatement(conn, COUNT_ENABLED_PENDING_AUS_QUERY);
        ResultSet resultSet = null;
        try {
            resultSet = this.dbManager.executeQuery(stmt);
            resultSet.next();
            rowCount = resultSet.getLong(1);
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot get the count of enabled pending AUs";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'select count(*) from pending_au where priority >= 0'.");
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseResultSet(resultSet);
                DbManager.safeCloseStatement((Statement)stmt);
                throw throwable;
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)stmt);
        if (log.isDebug2()) {
            log.debug2("getEnabledPendingAusCount(): rowCount = " + rowCount);
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getArticleCount() throws DbException {
        String DEBUG_HEADER = "getArticleCount(): ";
        if (log.isDebug2()) {
            log.debug2("getArticleCount(): Starting...");
        }
        long rowCount = -1L;
        Connection conn = this.dbManager.getConnection();
        try {
            rowCount = this.getArticleCount(conn);
        }
        finally {
            DbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("getArticleCount(): rowCount = " + rowCount);
        }
        return rowCount;
    }

    long getArticleCount(Connection conn) throws DbException {
        String DEBUG_HEADER = "getArticleCount(): ";
        if (log.isDebug2()) {
            log.debug2("getArticleCount(): Starting...");
        }
        long rowCount = -1L;
        PreparedStatement stmt = this.dbManager.prepareStatement(conn, COUNT_BIB_ITEM_QUERY);
        ResultSet resultSet = null;
        try {
            resultSet = this.dbManager.executeQuery(stmt);
            resultSet.next();
            rowCount = resultSet.getLong(1);
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot get the count of articles";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'select count(*) from bib_item'.");
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseResultSet(resultSet);
                DbManager.safeCloseStatement((Statement)stmt);
                throw throwable;
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)stmt);
        if (log.isDebug2()) {
            log.debug2("getArticleCount(): rowCount = " + rowCount);
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getPublisherCount() throws DbException {
        String DEBUG_HEADER = "getPublisherCount(): ";
        if (log.isDebug2()) {
            log.debug2("getPublisherCount(): Starting...");
        }
        long rowCount = -1L;
        Connection conn = this.dbManager.getConnection();
        try {
            rowCount = this.getPublisherCount(conn);
        }
        finally {
            DbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("getPublisherCount(): rowCount = " + rowCount);
        }
        return rowCount;
    }

    long getPublisherCount(Connection conn) throws DbException {
        String DEBUG_HEADER = "getPublisherCount(): ";
        if (log.isDebug2()) {
            log.debug2("getPublisherCount(): Starting...");
        }
        long rowCount = -1L;
        PreparedStatement stmt = this.dbManager.prepareStatement(conn, COUNT_PUBLISHER_QUERY);
        ResultSet resultSet = null;
        try {
            resultSet = this.dbManager.executeQuery(stmt);
            resultSet.next();
            rowCount = resultSet.getLong(1);
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot get the count of publishers";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'select count(distinct publisher.publisher_seq) from publisher,publication,md_item where publisher.publisher_seq=publication.publisher_seq and publication.md_item_seq=md_item.md_item_seq'.");
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseResultSet(resultSet);
                DbManager.safeCloseStatement((Statement)stmt);
                throw throwable;
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)stmt);
        if (log.isDebug2()) {
            log.debug2("getPublisherCount(): rowCount = " + rowCount);
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getProviderCount() throws DbException {
        String DEBUG_HEADER = "getProviderCount(): ";
        if (log.isDebug2()) {
            log.debug2("getProviderCount(): Starting...");
        }
        long rowCount = -1L;
        Connection conn = this.dbManager.getConnection();
        try {
            rowCount = this.getProviderCount(conn);
        }
        finally {
            DbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("getProviderCount(): rowCount = " + rowCount);
        }
        return rowCount;
    }

    long getProviderCount(Connection conn) throws DbException {
        String DEBUG_HEADER = "getProviderCount(): ";
        if (log.isDebug2()) {
            log.debug2("getProviderCount(): Starting...");
        }
        long rowCount = -1L;
        PreparedStatement stmt = this.dbManager.prepareStatement(conn, COUNT_PROVIDER_QUERY);
        ResultSet resultSet = null;
        try {
            resultSet = this.dbManager.executeQuery(stmt);
            resultSet.next();
            rowCount = resultSet.getLong(1);
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot get the count of providers";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'select count(distinct provider.provider_seq) from provider,au_md,md_item where provider.provider_seq=au_md.provider_seq and au_md.au_md_seq=md_item.au_md_seq'.");
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseResultSet(resultSet);
                DbManager.safeCloseStatement((Statement)stmt);
                throw throwable;
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)stmt);
        if (log.isDebug2()) {
            log.debug2("getProviderCount(): rowCount = " + rowCount);
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    List<MetadataExtractorManager.PrioritizedAuId> getPrioritizedAuIdsToReindex(Connection conn, int maxAuIds, boolean prioritizeIndexingNewAus) {
        String DEBUG_HEADER = "getPrioritizedAuIdsToReindex(): ";
        if (log.isDebug2()) {
            log.debug2("getPrioritizedAuIdsToReindex(): maxAuIds = " + maxAuIds);
            log.debug2("getPrioritizedAuIdsToReindex(): prioritizeIndexingNewAus = " + prioritizeIndexingNewAus);
        }
        ArrayList<MetadataExtractorManager.PrioritizedAuId> auIds = new ArrayList<MetadataExtractorManager.PrioritizedAuId>();
        PreparedStatement selectPendingAus = null;
        ResultSet results = null;
        String sql = FIND_PRIORITIZED_ENABLED_PENDING_AUS_QUERY;
        try {
            selectPendingAus = this.dbManager.prepareStatement(conn, sql);
            selectPendingAus.setBoolean(1, prioritizeIndexingNewAus);
            results = this.dbManager.executeQuery(selectPendingAus);
            while (auIds.size() < maxAuIds && results.next()) {
                String pluginId = results.getString("plugin_id");
                if (log.isDebug3()) {
                    log.debug3("getPrioritizedAuIdsToReindex(): pluginId = " + pluginId);
                }
                String auKey = results.getString("au_key");
                if (log.isDebug3()) {
                    log.debug3("getPrioritizedAuIdsToReindex(): auKey = " + auKey);
                }
                String auId = PluginManager.generateAuId((String)pluginId, (String)auKey);
                if (log.isDebug3()) {
                    log.debug3("getPrioritizedAuIdsToReindex(): auId = " + auId);
                }
                if (!this.mdxManager.isEligibleForReindexing(auId) || this.mdxManager.activeReindexingTasks.containsKey(auId)) continue;
                MetadataExtractorManager.PrioritizedAuId auToReindex = new MetadataExtractorManager.PrioritizedAuId();
                auToReindex.auId = auId;
                long priority = results.getLong("priority");
                if (log.isDebug3()) {
                    log.debug3("getPrioritizedAuIdsToReindex(): priority = " + priority);
                }
                auToReindex.priority = priority;
                boolean isNew = results.getBoolean("is_new");
                if (log.isDebug3()) {
                    log.debug3("getPrioritizedAuIdsToReindex(): isNew = " + isNew);
                }
                auToReindex.isNew = isNew;
                boolean needFullReindex = results.getBoolean("fully_reindex");
                if (log.isDebug3()) {
                    log.debug3("getPrioritizedAuIdsToReindex(): needFullReindex = " + needFullReindex);
                }
                auToReindex.needFullReindex = needFullReindex;
                auIds.add(auToReindex);
                if (!log.isDebug3()) continue;
                log.debug3("getPrioritizedAuIdsToReindex(): Added auId = " + auId + " to reindex list");
            }
        }
        catch (SQLException sqle) {
            String message = "Cannot identify the enabled pending AUs";
            log.error(message, (Throwable)sqle);
            log.error("maxAuIds = " + maxAuIds);
            log.error("SQL = '" + sql + "'.");
            log.error("prioritizeIndexingNewAus = " + prioritizeIndexingNewAus);
            DbManager.safeCloseResultSet((ResultSet)results);
            DbManager.safeCloseStatement((Statement)selectPendingAus);
        }
        catch (DbException dbe) {
            String message = "Cannot identify the enabled pending AUs";
            log.error(message, (Throwable)dbe);
            log.error("SQL = '" + sql + "'.");
            log.error("prioritizeIndexingNewAus = " + prioritizeIndexingNewAus);
            {
                catch (Throwable throwable) {
                    DbManager.safeCloseResultSet(results);
                    DbManager.safeCloseStatement((Statement)selectPendingAus);
                    throw throwable;
                }
            }
            DbManager.safeCloseResultSet((ResultSet)results);
            DbManager.safeCloseStatement((Statement)selectPendingAus);
        }
        DbManager.safeCloseResultSet((ResultSet)results);
        DbManager.safeCloseStatement((Statement)selectPendingAus);
        auIds.trimToSize();
        if (log.isDebug2()) {
            log.debug2("getPrioritizedAuIdsToReindex(): auIds.size() = " + auIds.size());
        }
        return auIds;
    }

    long removeFromPendingAus(Connection conn, String auId) throws DbException {
        String DEBUG_HEADER = "removeFromPendingAus(): ";
        if (log.isDebug2()) {
            log.debug2("removeFromPendingAus(): auId = " + auId);
        }
        String pluginId = null;
        String auKey = null;
        PreparedStatement deletePendingAu = this.dbManager.prepareStatement(conn, DELETE_PENDING_AU_QUERY);
        try {
            pluginId = PluginManager.pluginIdFromAuId((String)auId);
            auKey = PluginManager.auKeyFromAuId((String)auId);
            deletePendingAu.setString(1, pluginId);
            deletePendingAu.setString(2, auKey);
            int deletedCount = this.dbManager.executeUpdate(deletePendingAu);
            if (log.isDebug3()) {
                log.debug3("removeFromPendingAus(): deletedCount = " + deletedCount);
            }
        }
        catch (SQLException sqle) {
            String message = "Cannot remove AU from pending table";
            log.error(message, (Throwable)sqle);
            log.error("auId = '" + auId + "'.");
            log.error("SQL = 'delete from pending_au where plugin_id = ? and au_key = ?'.");
            log.error("pluginId = '" + pluginId + "'.");
            log.error("auKey = '" + auKey + "'.");
            throw new DbException(message, (Throwable)sqle);
        }
        finally {
            DbManager.safeCloseStatement((Statement)deletePendingAu);
        }
        long enabledPendingAusCount = this.getEnabledPendingAusCount(conn);
        if (log.isDebug2()) {
            log.debug2("removeFromPendingAus(): enabledPendingAusCount = " + enabledPendingAusCount);
        }
        return enabledPendingAusCount;
    }

    int removeAuMetadataItems(Connection conn, String auId) throws DbException {
        String DEBUG_HEADER = "removeAuMetadataItems(): ";
        if (log.isDebug2()) {
            log.debug2("removeAuMetadataItems(): auId = " + auId);
        }
        int count = 0;
        Long auMdSeq = this.findAuMdByAuId(conn, auId);
        if (log.isDebug3()) {
            log.debug3("removeAuMetadataItems(): auMdSeq = " + auMdSeq);
        }
        if (auMdSeq != null) {
            PreparedStatement deleteMetadataItems = this.dbManager.prepareStatement(conn, DELETE_AU_MD_ITEM_QUERY);
            try {
                deleteMetadataItems.setLong(1, auMdSeq);
                count = this.dbManager.executeUpdate(deleteMetadataItems);
            }
            catch (SQLException sqle) {
                String message = "Cannot delete AU metadata items";
                log.error(message, (Throwable)sqle);
                log.error("auId = " + auId);
                log.error("SQL = 'delete from md_item where au_md_seq = ?'.");
                log.error("auMdSeq = " + auMdSeq);
                throw new DbException(message, (Throwable)sqle);
            }
            finally {
                DbManager.safeCloseStatement((Statement)deleteMetadataItems);
            }
        }
        if (log.isDebug2()) {
            log.debug2("removeAuMetadataItems(): count = " + count);
        }
        return count;
    }

    private Long findAuMdByAuId(Connection conn, String auId) throws DbException {
        ResultSet resultSet;
        PreparedStatement findAuMd;
        Long auMdSeq;
        block9: {
            String DEBUG_HEADER = "findAuMdByAuId(): ";
            if (log.isDebug2()) {
                log.debug2("findAuMdByAuId(): auId = " + auId);
            }
            String pluginId = null;
            String auKey = null;
            auMdSeq = null;
            findAuMd = this.dbManager.prepareStatement(conn, FIND_AU_MD_BY_AU_ID_QUERY);
            resultSet = null;
            try {
                pluginId = PluginManager.pluginIdFromAuId((String)auId);
                if (log.isDebug3()) {
                    log.debug3("findAuMdByAuId(): pluginId() = " + pluginId);
                }
                auKey = PluginManager.auKeyFromAuId((String)auId);
                if (log.isDebug3()) {
                    log.debug3("findAuMdByAuId(): auKey = " + auKey);
                }
                findAuMd.setString(1, pluginId);
                findAuMd.setString(2, auKey);
                resultSet = this.dbManager.executeQuery(findAuMd);
                if (!resultSet.next()) break block9;
                auMdSeq = resultSet.getLong("au_md_seq");
                if (log.isDebug3()) {
                    log.debug3("findAuMdByAuId(): auMdSeq = " + auMdSeq);
                }
            }
            catch (SQLException sqle) {
                try {
                    String message = "Cannot find AU metadata identifier";
                    log.error(message, (Throwable)sqle);
                    log.error("auId = " + auId);
                    log.error("SQL = 'select m.au_md_seq from au_md m,au a,plugin p where m.au_seq = a.au_seq and a.plugin_seq = p.plugin_seq and p.plugin_id = ? and a.au_key = ?'.");
                    log.error("pluginId = " + pluginId);
                    log.error("auKey = " + auKey);
                    throw new DbException(message, (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    DbManager.safeCloseResultSet(resultSet);
                    DbManager.safeCloseStatement((Statement)findAuMd);
                    throw throwable;
                }
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)findAuMd);
        if (log.isDebug2()) {
            log.debug2("findAuMdByAuId(): auMdSeq = " + auMdSeq);
        }
        return auMdSeq;
    }

    int removeAu(Connection conn, String auId) throws DbException {
        String DEBUG_HEADER = "removeAu(): ";
        if (log.isDebug2()) {
            log.debug2("removeAu(): auId = " + auId);
        }
        int count = 0;
        Long auSeq = this.findAuByAuId(conn, auId);
        if (log.isDebug3()) {
            log.debug3("removeAu(): auSeq = " + auSeq);
        }
        if (auSeq != null) {
            PreparedStatement deleteAu = this.dbManager.prepareStatement(conn, DELETE_AU_QUERY);
            try {
                deleteAu.setLong(1, auSeq);
                count = this.dbManager.executeUpdate(deleteAu);
            }
            catch (SQLException sqle) {
                String message = "Cannot delete AU";
                log.error(message, (Throwable)sqle);
                log.error("auId = " + auId);
                log.error("SQL = 'delete from au where au_seq = ?'.");
                log.error("auSeq = " + auSeq);
                throw new DbException(message, (Throwable)sqle);
            }
            finally {
                DbManager.safeCloseStatement((Statement)deleteAu);
            }
        }
        if (log.isDebug2()) {
            log.debug2("removeAu(): count = " + count);
        }
        return count;
    }

    Long findAuByAuId(Connection conn, String auId) throws DbException {
        ResultSet resultSet;
        PreparedStatement findAu;
        Long auSeq;
        block9: {
            String DEBUG_HEADER = "findAuByAuId(): ";
            if (log.isDebug2()) {
                log.debug2("findAuByAuId(): auId = " + auId);
            }
            String pluginId = PluginManager.pluginIdFromAuId((String)auId);
            String auKey = PluginManager.auKeyFromAuId((String)auId);
            auSeq = null;
            findAu = this.dbManager.prepareStatement(conn, FIND_AU_BY_AU_ID_QUERY);
            resultSet = null;
            try {
                pluginId = PluginManager.pluginIdFromAuId((String)auId);
                if (log.isDebug3()) {
                    log.debug3("findAuByAuId(): pluginId() = " + pluginId);
                }
                auKey = PluginManager.auKeyFromAuId((String)auId);
                if (log.isDebug3()) {
                    log.debug3("findAuByAuId(): auKey = " + auKey);
                }
                findAu.setString(1, pluginId);
                findAu.setString(2, auKey);
                resultSet = this.dbManager.executeQuery(findAu);
                if (!resultSet.next()) break block9;
                auSeq = resultSet.getLong("au_seq");
                if (log.isDebug3()) {
                    log.debug3("findAuByAuId(): auSeq = " + auSeq);
                }
            }
            catch (SQLException sqle) {
                try {
                    String message = "Cannot find AU identifier";
                    log.error(message, (Throwable)sqle);
                    log.error("auId = " + auId);
                    log.error("SQL = 'select a.au_seq from au a,plugin p where a.plugin_seq = p.plugin_seq and p.plugin_id = ? and a.au_key = ?'.");
                    log.error("pluginId = " + pluginId);
                    log.error("auKey = " + auKey);
                    throw new DbException(message, (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    DbManager.safeCloseResultSet(resultSet);
                    DbManager.safeCloseStatement((Statement)findAu);
                    throw throwable;
                }
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)findAu);
        if (log.isDebug2()) {
            log.debug2("findAuByAuId(): auSeq = " + auSeq);
        }
        return auSeq;
    }

    void updateAuLastExtractionTime(Connection conn, Long auMdSeq, long now) throws DbException {
        String DEBUG_HEADER = "updateAuLastExtractionTime(): ";
        if (log.isDebug2()) {
            log.debug2("updateAuLastExtractionTime(): auMdSeq = " + auMdSeq);
            log.debug2("updateAuLastExtractionTime(): now = " + now);
        }
        PreparedStatement updateAuLastExtractionTime = this.dbManager.prepareStatement(conn, UPDATE_AU_MD_EXTRACT_TIME_QUERY);
        try {
            updateAuLastExtractionTime.setLong(1, now);
            updateAuLastExtractionTime.setLong(2, auMdSeq);
            this.dbManager.executeUpdate(updateAuLastExtractionTime);
        }
        catch (SQLException sqle) {
            String message = "Cannot update the AU extraction time";
            log.error(message, (Throwable)sqle);
            log.error("SQL = 'update au_md set extract_time = ? where au_md_seq = ?'.");
            log.error("auMdSeq = '" + auMdSeq + "'.");
            log.error("now = " + now + ".");
            throw new DbException(message, (Throwable)sqle);
        }
        finally {
            DbManager.safeCloseStatement((Statement)updateAuLastExtractionTime);
        }
        if (log.isDebug2()) {
            log.debug2("updateAuLastExtractionTime(): Done.");
        }
    }

    void removeDisabledFromPendingAus(Connection conn, String auId) throws DbException {
        String DEBUG_HEADER = "removeDisabledFromPendingAus(): ";
        if (log.isDebug2()) {
            log.debug2("removeDisabledFromPendingAus(): auId = " + auId);
        }
        String pluginId = null;
        String auKey = null;
        PreparedStatement deletePendingAu = this.dbManager.prepareStatement(conn, DELETE_DISABLED_PENDING_AU_QUERY);
        try {
            pluginId = PluginManager.pluginIdFromAuId((String)auId);
            auKey = PluginManager.auKeyFromAuId((String)auId);
            deletePendingAu.setString(1, pluginId);
            deletePendingAu.setString(2, auKey);
            this.dbManager.executeUpdate(deletePendingAu);
        }
        catch (SQLException sqle) {
            String message = "Cannot remove disabled AU from pending table";
            log.error(message, (Throwable)sqle);
            log.error("auId = '" + auId + "'.");
            log.error("SQL = 'delete from pending_au where plugin_id = ? and au_key = ? and priority < 0'.");
            log.error("pluginId = '" + pluginId + "'.");
            log.error("auKey = '" + auKey + "'.");
            throw new DbException(message, (Throwable)sqle);
        }
        finally {
            DbManager.safeCloseStatement((Statement)deletePendingAu);
        }
        if (log.isDebug2()) {
            log.debug2("removeDisabledFromPendingAus(): Done.");
        }
    }

    PreparedStatement getInsertPendingAuBatchStatement(Connection conn) throws DbException {
        String DEBUG_HEADER = "getInsertPendingAuBatchStatement(): ";
        if (this.dbManager.isTypeMysql()) {
            if (log.isDebug3()) {
                log.debug3("getInsertPendingAuBatchStatement(): SQL = insert into pending_au(plugin_id,au_key,priority,fully_reindex) values (?,?,(select next_priority from (select coalesce(max(priority), 0) + 1 as next_priority from pending_au where priority >= 0) as temp_pau_table),?)");
            }
            return this.dbManager.prepareStatement(conn, INSERT_ENABLED_PENDING_AU_MYSQL_QUERY);
        }
        if (log.isDebug3()) {
            log.debug3("getInsertPendingAuBatchStatement(): SQL = insert into pending_au(plugin_id,au_key,priority,fully_reindex) values (?,?,(select coalesce(max(priority), 0) + 1 from pending_au where priority >= 0),?)");
        }
        return this.dbManager.prepareStatement(conn, INSERT_ENABLED_PENDING_AU_QUERY);
    }

    PreparedStatement getPrioritizedInsertPendingAuBatchStatement(Connection conn) throws DbException {
        String DEBUG_HEADER = "getPrioritizedInsertPendingAuBatchStatement(): ";
        if (log.isDebug3()) {
            log.debug3("getPrioritizedInsertPendingAuBatchStatement(): SQL = insert into pending_au(plugin_id,au_key,priority,fully_reindex) values (?,?,0,?)");
        }
        return this.dbManager.prepareStatement(conn, INSERT_HIGHEST_PRIORITY_PENDING_AU_QUERY);
    }

    boolean isAuPending(Connection conn, String pluginId, String auKey) throws DbException {
        String DEBUG_HEADER = "isAuPending(): ";
        if (log.isDebug2()) {
            log.debug2("isAuPending(): pluginId = " + pluginId);
            log.debug2("isAuPending(): auKey = " + auKey);
        }
        boolean result = false;
        PreparedStatement selectPendingAu = null;
        ResultSet results = null;
        try {
            selectPendingAu = this.dbManager.prepareStatement(conn, FIND_PENDING_AU_QUERY);
            selectPendingAu.setString(1, pluginId);
            selectPendingAu.setString(2, auKey);
            results = this.dbManager.executeQuery(selectPendingAu);
            result = results.next();
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot find pending AU";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'select plugin_id,au_key from pending_au where plugin_id = ? and au_key = ?'.");
                log.error("pluginId = '" + pluginId + "'.");
                log.error("auKey = '" + auKey + "'.");
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseResultSet(results);
                DbManager.safeCloseStatement((Statement)selectPendingAu);
                throw throwable;
            }
        }
        DbManager.safeCloseResultSet((ResultSet)results);
        DbManager.safeCloseStatement((Statement)selectPendingAu);
        if (log.isDebug2()) {
            log.debug2("isAuPending(): result = " + result);
        }
        return result;
    }

    void addAuToPendingAusBatch(String pluginId, String auKey, boolean fullReindex, PreparedStatement insertPendingAuBatchStatement) throws SQLException {
        insertPendingAuBatchStatement.setString(1, pluginId);
        insertPendingAuBatchStatement.setString(2, auKey);
        insertPendingAuBatchStatement.setBoolean(3, fullReindex);
        insertPendingAuBatchStatement.addBatch();
    }

    void addAuBatchToPendingAus(PreparedStatement insertPendingAuBatchStatement) throws SQLException {
        String DEBUG_HEADER = "addAuBatchToPendingAus(): ";
        if (log.isDebug2()) {
            log.debug2("addAuBatchToPendingAus(): Starting...");
        }
        insertPendingAuBatchStatement.executeBatch();
        if (log.isDebug2()) {
            log.debug2("addAuBatchToPendingAus(): Done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getAuMetadataVersion(ArchivalUnit au) {
        String DEBUG_HEADER = "getAuMetadataVersion(): ";
        if (log.isDebug2()) {
            log.debug2("getAuMetadataVersion(): au = " + au);
        }
        int version = -1;
        Connection conn = null;
        try {
            conn = this.dbManager.getConnection();
            version = this.getAuMetadataVersion(conn, au);
        }
        catch (DbException dbe) {
            log.error("Cannot get AU metadata version - Using " + version + ": " + (Object)((Object)dbe));
            log.error("au = '" + au + "'.");
        }
        finally {
            DbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("getAuMetadataVersion(): version = " + version);
        }
        return version;
    }

    int getAuMetadataVersion(Connection conn, ArchivalUnit au) throws DbException {
        ResultSet resultSet;
        PreparedStatement selectMetadataVersion;
        int version;
        block9: {
            String DEBUG_HEADER = "getAuMetadataVersion(): ";
            if (log.isDebug2()) {
                log.debug2("getAuMetadataVersion(): au = " + au);
            }
            String pluginId = null;
            String auKey = null;
            version = -1;
            selectMetadataVersion = null;
            resultSet = null;
            try {
                String auId = au.getAuId();
                pluginId = PluginManager.pluginIdFromAuId((String)auId);
                if (log.isDebug3()) {
                    log.debug3("getAuMetadataVersion(): pluginId() = " + pluginId);
                }
                auKey = PluginManager.auKeyFromAuId((String)auId);
                if (log.isDebug3()) {
                    log.debug3("getAuMetadataVersion(): auKey = " + auKey);
                }
                selectMetadataVersion = this.dbManager.prepareStatement(conn, FIND_AU_METADATA_VERSION_QUERY);
                selectMetadataVersion.setString(1, pluginId);
                selectMetadataVersion.setString(2, auKey);
                resultSet = this.dbManager.executeQuery(selectMetadataVersion);
                if (!resultSet.next()) break block9;
                version = resultSet.getShort("md_version");
                if (log.isDebug3()) {
                    log.debug3("getAuMetadataVersion(): version = " + version);
                }
            }
            catch (SQLException sqle) {
                try {
                    String message = "Cannot get AU metadata version";
                    log.error(message, (Throwable)sqle);
                    log.error("au = '" + au + "'.");
                    log.error("SQL = 'select m.md_version from au_md m,au a,plugin p where m.au_seq =  a.au_seq and a.plugin_seq =  p.plugin_seq and p.plugin_id = ? and a.au_key = ?'.");
                    log.error("pluginId = '" + pluginId + "'.");
                    log.error("auKey = '" + auKey + "'.");
                    throw new DbException(message, (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    DbManager.safeCloseResultSet(resultSet);
                    DbManager.safeCloseStatement(selectMetadataVersion);
                    throw throwable;
                }
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)selectMetadataVersion);
        if (log.isDebug2()) {
            log.debug2("getAuMetadataVersion(): version = " + version);
        }
        return version;
    }

    boolean needAuFullReindexing(Connection conn, ArchivalUnit au) throws DbException {
        ResultSet resultSet;
        PreparedStatement selectFullReindexing;
        boolean fullReindexing;
        block9: {
            String DEBUG_HEADER = "needAuFullReindexing(): ";
            if (log.isDebug2()) {
                log.debug2("needAuFullReindexing(): au = " + au);
            }
            String auId = au.getAuId();
            String pluginId = PluginManager.pluginIdFromAuId((String)auId);
            if (log.isDebug3()) {
                log.debug3("needAuFullReindexing(): pluginId() = " + pluginId);
            }
            String auKey = PluginManager.auKeyFromAuId((String)auId);
            if (log.isDebug3()) {
                log.debug3("needAuFullReindexing(): auKey = " + auKey);
            }
            fullReindexing = false;
            selectFullReindexing = null;
            resultSet = null;
            try {
                selectFullReindexing = this.dbManager.prepareStatement(conn, FIND_AU_FULL_REINDEXING_BY_AU_QUERY);
                selectFullReindexing.setString(1, pluginId);
                selectFullReindexing.setString(2, auKey);
                resultSet = this.dbManager.executeQuery(selectFullReindexing);
                if (!resultSet.next()) break block9;
                fullReindexing = resultSet.getBoolean("fully_reindex");
                if (log.isDebug3()) {
                    log.debug3("needAuFullReindexing(): full reindexing = " + fullReindexing);
                }
            }
            catch (SQLException sqle) {
                try {
                    String message = "Cannot get AU fully reindexing flag";
                    log.error(message, (Throwable)sqle);
                    log.error("au = '" + au + "'.");
                    log.error("SQL = 'select fully_reindex from pending_au where plugin_id = ? and au_key = ?'.");
                    log.error("pluginId = '" + pluginId + "'.");
                    log.error("auKey = '" + auKey + "'.");
                    throw new DbException(message, (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    DbManager.safeCloseResultSet(resultSet);
                    DbManager.safeCloseStatement((Statement)selectFullReindexing);
                    throw throwable;
                }
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)selectFullReindexing);
        if (log.isDebug2()) {
            log.debug2("needAuFullReindexing(): fullReindexing = " + fullReindexing);
        }
        return fullReindexing;
    }

    void updateAuFullReindexing(Connection conn, ArchivalUnit au, boolean fullReindexing) throws DbException {
        String DEBUG_HEADER = "updateAuFullReindexing(): ";
        if (log.isDebug2()) {
            log.debug2("updateAuFullReindexing(): au = " + au);
            log.debug2("updateAuFullReindexing(): fullReindexing = " + fullReindexing);
        }
        PreparedStatement updateFullReindexing = null;
        String auId = au.getAuId();
        if (log.isDebug3()) {
            log.debug3("updateAuFullReindexing(): auId = " + auId);
        }
        String pluginId = PluginManager.pluginIdFromAuId((String)auId);
        if (log.isDebug3()) {
            log.debug3("updateAuFullReindexing(): pluginId() = " + pluginId);
        }
        String auKey = PluginManager.auKeyFromAuId((String)auId);
        if (log.isDebug3()) {
            log.debug3("updateAuFullReindexing(): auKey = " + auKey);
        }
        try {
            updateFullReindexing = this.dbManager.prepareStatement(conn, UPDATE_AU_FULL_REINDEXING_QUERY);
            updateFullReindexing.setBoolean(1, fullReindexing);
            updateFullReindexing.setString(2, pluginId);
            updateFullReindexing.setString(3, auKey);
            this.dbManager.executeUpdate(updateFullReindexing);
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot set AU fully reindex flag";
                log.error(message, (Throwable)sqle);
                log.error("au = '" + au + "'.");
                log.error("SQL = 'update pending_au set fully_reindex = ? where plugin_id = ? and au_key = ?'.");
                log.error("fullReindexing = '" + fullReindexing + "'.");
                log.error("pluginId = '" + pluginId + "'.");
                log.error("auKey = '" + auKey + "'.");
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseStatement(updateFullReindexing);
                throw throwable;
            }
        }
        DbManager.safeCloseStatement((Statement)updateFullReindexing);
        if (log.isDebug2()) {
            log.debug2("updateAuFullReindexing(): Done.");
        }
    }

    long getAuExtractionTime(Connection conn, Long auSeq) throws DbException {
        ResultSet resultSet;
        PreparedStatement selectLastExtractionTime;
        long timestamp;
        block7: {
            String DEBUG_HEADER = "getAuExtractionTime(): ";
            if (log.isDebug2()) {
                log.debug2("getAuExtractionTime(): auSeq = " + auSeq);
            }
            timestamp = 0L;
            selectLastExtractionTime = null;
            resultSet = null;
            try {
                selectLastExtractionTime = this.dbManager.prepareStatement(conn, FIND_AU_MD_EXTRACT_TIME_BY_AUSEQ_QUERY);
                selectLastExtractionTime.setLong(1, auSeq);
                resultSet = this.dbManager.executeQuery(selectLastExtractionTime);
                if (!resultSet.next()) break block7;
                timestamp = resultSet.getLong("extract_time");
                if (log.isDebug3()) {
                    log.debug3("getAuExtractionTime(): timestamp = " + timestamp);
                }
            }
            catch (SQLException sqle) {
                try {
                    String message = "Cannot get AU extraction time";
                    log.error(message, (Throwable)sqle);
                    log.error("SQL = 'select extract_time from au_md where au_seq = ?'.");
                    log.error("auSeq = '" + auSeq + "'.");
                    throw new DbException(message, (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    DbManager.safeCloseResultSet(resultSet);
                    DbManager.safeCloseStatement((Statement)selectLastExtractionTime);
                    throw throwable;
                }
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)selectLastExtractionTime);
        if (log.isDebug2()) {
            log.debug2("getAuExtractionTime(): timestamp = " + timestamp);
        }
        return timestamp;
    }

    long getAuExtractionTime(Connection conn, ArchivalUnit au) throws DbException {
        ResultSet resultSet;
        PreparedStatement selectLastExtractionTime;
        long timestamp;
        block9: {
            String DEBUG_HEADER = "getAuExtractionTime(): ";
            if (log.isDebug2()) {
                log.debug2("getAuExtractionTime(): au = " + au);
            }
            String pluginId = null;
            String auKey = null;
            timestamp = 0L;
            selectLastExtractionTime = null;
            resultSet = null;
            try {
                String auId = au.getAuId();
                pluginId = PluginManager.pluginIdFromAuId((String)auId);
                if (log.isDebug3()) {
                    log.debug3("getAuExtractionTime(): pluginId() = " + pluginId);
                }
                auKey = PluginManager.auKeyFromAuId((String)auId);
                if (log.isDebug3()) {
                    log.debug3("getAuExtractionTime(): auKey = " + auKey);
                }
                selectLastExtractionTime = this.dbManager.prepareStatement(conn, FIND_AU_MD_EXTRACT_TIME_BY_AU_QUERY);
                selectLastExtractionTime.setString(1, pluginId);
                selectLastExtractionTime.setString(2, auKey);
                resultSet = this.dbManager.executeQuery(selectLastExtractionTime);
                if (!resultSet.next()) break block9;
                timestamp = resultSet.getLong("extract_time");
                if (log.isDebug3()) {
                    log.debug3("getAuExtractionTime(): timestamp = " + timestamp);
                }
            }
            catch (SQLException sqle) {
                try {
                    String message = "Cannot get AU extraction time";
                    log.error(message, (Throwable)sqle);
                    log.error("au = '" + au + "'.");
                    log.error("SQL = 'select m.extract_time from au_md m,au a,plugin p where m.au_seq =  a.au_seq and a.plugin_seq =  p.plugin_seq and p.plugin_id = ? and a.au_key = ?'.");
                    log.error("pluginId = '" + pluginId + "'.");
                    log.error("auKey = '" + auKey + "'.");
                    throw new DbException(message, (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    DbManager.safeCloseResultSet(resultSet);
                    DbManager.safeCloseStatement(selectLastExtractionTime);
                    throw throwable;
                }
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)selectLastExtractionTime);
        if (log.isDebug2()) {
            log.debug2("getAuExtractionTime(): timestamp = " + timestamp);
        }
        return timestamp;
    }

    void addDisabledAuToPendingAus(Connection conn, String auId) throws DbException {
        String DEBUG_HEADER = "addDisabledAuToPendingAus(): ";
        if (log.isDebug2()) {
            log.debug2("addDisabledAuToPendingAus(): auId = " + auId);
        }
        String pluginId = null;
        String auKey = null;
        PreparedStatement addPendingAuStatement = this.dbManager.prepareStatement(conn, INSERT_DISABLED_PENDING_AU_QUERY);
        try {
            pluginId = PluginManager.pluginIdFromAuId((String)auId);
            if (log.isDebug3()) {
                log.debug3("addDisabledAuToPendingAus(): pluginId = " + pluginId);
            }
            auKey = PluginManager.auKeyFromAuId((String)auId);
            if (log.isDebug3()) {
                log.debug3("addDisabledAuToPendingAus(): auKey = " + auKey);
            }
            addPendingAuStatement.setString(1, pluginId);
            addPendingAuStatement.setString(2, auKey);
            int count = this.dbManager.executeUpdate(addPendingAuStatement);
            if (log.isDebug3()) {
                log.debug3("addDisabledAuToPendingAus(): count = " + count);
            }
        }
        catch (SQLException sqle) {
            String message = "Cannot add disabled pending AU";
            log.error(message, (Throwable)sqle);
            log.error("auId = '" + auId + "'.");
            log.error("SQL = 'insert into platform(platform_seq,platform_name) values (default,?)'.");
            log.error("pluginId = '" + pluginId + "'.");
            log.error("auKey = '" + auKey + "'.");
            throw new DbException(message, (Throwable)sqle);
        }
        finally {
            DbManager.safeCloseStatement((Statement)addPendingAuStatement);
        }
        if (log.isDebug2()) {
            log.debug2("addDisabledAuToPendingAus(): Done.");
        }
    }

    void addFailedIndexingAuToPendingAus(Connection conn, String auId) throws DbException {
        String DEBUG_HEADER = "addFailedIndexingAuToPendingAus(): ";
        if (log.isDebug2()) {
            log.debug2("addFailedIndexingAuToPendingAus(): auId = " + auId);
        }
        String pluginId = null;
        String auKey = null;
        PreparedStatement addPendingAuStatement = this.dbManager.prepareStatement(conn, INSERT_FAILED_INDEXING_PENDING_AU_QUERY);
        try {
            pluginId = PluginManager.pluginIdFromAuId((String)auId);
            if (log.isDebug3()) {
                log.debug3("addFailedIndexingAuToPendingAus(): pluginId = " + pluginId);
            }
            auKey = PluginManager.auKeyFromAuId((String)auId);
            if (log.isDebug3()) {
                log.debug3("addFailedIndexingAuToPendingAus(): auKey = " + auKey);
            }
            addPendingAuStatement.setString(1, pluginId);
            addPendingAuStatement.setString(2, auKey);
            int count = this.dbManager.executeUpdate(addPendingAuStatement);
            if (log.isDebug3()) {
                log.debug3("addFailedIndexingAuToPendingAus(): count = " + count);
            }
        }
        catch (SQLException sqle) {
            String message = "Cannot add failed pending AU";
            log.error(message, (Throwable)sqle);
            log.error("auId = '" + auId + "'.");
            log.error("SQL = 'insert into platform(platform_seq,platform_name) values (default,?)'.");
            log.error("pluginId = '" + pluginId + "'.");
            log.error("auKey = '" + auKey + "'.");
            throw new DbException(message, (Throwable)sqle);
        }
        finally {
            DbManager.safeCloseStatement((Statement)addPendingAuStatement);
        }
        if (log.isDebug2()) {
            log.debug2("addFailedIndexingAuToPendingAus(): Done.");
        }
    }

    Collection<String> findPendingAusWithPriority(Connection conn, int priority) throws DbException {
        String DEBUG_HEADER = "findPendingAusWithPriority(): ";
        if (log.isDebug2()) {
            log.debug2("findPendingAusWithPriority(): priority = " + priority);
        }
        ArrayList<String> aus = new ArrayList<String>();
        ResultSet results = null;
        PreparedStatement selectAus = this.dbManager.prepareStatement(conn, FIND_PENDING_AUS_WITH_PRIORITY_QUERY);
        try {
            selectAus.setInt(1, priority);
            results = this.dbManager.executeQuery(selectAus);
            while (results.next()) {
                String pluginId = results.getString("plugin_id");
                if (log.isDebug3()) {
                    log.debug3("findPendingAusWithPriority(): pluginId = " + pluginId);
                }
                String auKey = results.getString("au_key");
                if (log.isDebug3()) {
                    log.debug3("findPendingAusWithPriority(): auKey = " + auKey);
                }
                String auId = PluginManager.generateAuId((String)pluginId, (String)auKey);
                if (log.isDebug3()) {
                    log.debug3("findPendingAusWithPriority(): auId = " + auId);
                }
                aus.add(auId);
            }
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot find pending AUs";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'insert into platform(platform_seq,platform_name) values (default,?)'.");
                log.error("priority = '" + priority + "'.");
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseResultSet(results);
                DbManager.safeCloseStatement((Statement)selectAus);
                throw throwable;
            }
        }
        DbManager.safeCloseResultSet((ResultSet)results);
        DbManager.safeCloseStatement((Statement)selectAus);
        if (log.isDebug2()) {
            log.debug2("findPendingAusWithPriority(): aus.size() = " + aus.size());
        }
        return aus;
    }

    Long findAuPublisher(Connection conn, Long auSeq) throws DbException {
        String DEBUG_HEADER = "findAuPublisher(): ";
        if (log.isDebug2()) {
            log.debug2("findAuPublisher(): auSeq = " + auSeq);
        }
        Long publisherSeq = null;
        ResultSet resultSet = null;
        PreparedStatement findPublisher = this.dbManager.prepareStatement(conn, FIND_AU_PUBLISHER_QUERY);
        try {
            findPublisher.setLong(1, auSeq);
            resultSet = this.dbManager.executeQuery(findPublisher);
            if (resultSet.next()) {
                publisherSeq = resultSet.getLong("publisher_seq");
            }
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot find the publisher of an AU";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'select distinct pr.publisher_seq from publisher pr,publication p,md_item m,au_md am where pr.publisher_seq = p.publisher_seq and p.md_item_seq = m.parent_seq and m.au_md_seq = am.au_md_seq and am.au_seq = ?'.");
                log.error("auSeq = '" + auSeq + "'.");
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseResultSet(resultSet);
                DbManager.safeCloseStatement((Statement)findPublisher);
                throw throwable;
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)findPublisher);
        if (log.isDebug2()) {
            log.debug2("findAuPublisher(): publisherSeq = " + publisherSeq);
        }
        return publisherSeq;
    }

    Collection<String> getMdItemAuthors(Connection conn, Long mdItemSeq) throws DbException {
        String DEBUG_HEADER = "getMdItemAuthors(): ";
        if (log.isDebug2()) {
            log.debug2("getMdItemAuthors(): mdItemSeq = " + mdItemSeq);
        }
        ArrayList<String> authors = new ArrayList<String>();
        PreparedStatement findMdItemAuthor = this.dbManager.prepareStatement(conn, FIND_MD_ITEM_AUTHOR_QUERY);
        ResultSet resultSet = null;
        try {
            findMdItemAuthor.setLong(1, mdItemSeq);
            resultSet = this.dbManager.executeQuery(findMdItemAuthor);
            while (resultSet.next()) {
                authors.add(resultSet.getString("author_name"));
            }
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot get the authors of a metadata item";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'select author_name from author where md_item_seq = ?'.");
                log.error("mdItemSeq = '" + mdItemSeq + "'.");
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseResultSet(resultSet);
                DbManager.safeCloseStatement((Statement)findMdItemAuthor);
                throw throwable;
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)findMdItemAuthor);
        if (log.isDebug2()) {
            log.debug2("getMdItemAuthors(): authors = " + authors);
        }
        return authors;
    }

    Collection<String> getMdItemKeywords(Connection conn, Long mdItemSeq) throws DbException {
        String DEBUG_HEADER = "getMdItemKeywords(): ";
        if (log.isDebug2()) {
            log.debug2("getMdItemKeywords(): mdItemSeq = " + mdItemSeq);
        }
        ArrayList<String> keywords = new ArrayList<String>();
        PreparedStatement findMdItemKeyword = this.dbManager.prepareStatement(conn, FIND_MD_ITEM_KEYWORD_QUERY);
        ResultSet resultSet = null;
        try {
            findMdItemKeyword.setLong(1, mdItemSeq);
            resultSet = this.dbManager.executeQuery(findMdItemKeyword);
            while (resultSet.next()) {
                keywords.add(resultSet.getString("keyword"));
            }
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot get the keywords of a metadata item";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'select keyword from keyword where md_item_seq = ?'.");
                log.error("mdItemSeq = '" + mdItemSeq + "'.");
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseResultSet(resultSet);
                DbManager.safeCloseStatement((Statement)findMdItemKeyword);
                throw throwable;
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)findMdItemKeyword);
        if (log.isDebug2()) {
            log.debug2("getMdItemKeywords(): keywords = " + keywords);
        }
        return keywords;
    }

    void addMdItemAuthors(Connection conn, Long mdItemSeq, Collection<String> authors) throws DbException {
        String DEBUG_HEADER = "addMdItemAuthors(): ";
        if (log.isDebug2()) {
            log.debug2("addMdItemAuthors(): mdItemSeq = " + mdItemSeq);
            log.debug2("addMdItemAuthors(): authors = " + authors);
        }
        if (authors == null || authors.size() == 0) {
            return;
        }
        String sql = this.getInsertMdItemAuthorSql();
        PreparedStatement insertMdItemAuthor = this.dbManager.prepareStatement(conn, sql);
        try {
            for (String author : authors) {
                insertMdItemAuthor.setLong(1, mdItemSeq);
                insertMdItemAuthor.setString(2, author);
                insertMdItemAuthor.setLong(3, mdItemSeq);
                int count = this.dbManager.executeUpdate(insertMdItemAuthor);
                if (!log.isDebug3()) continue;
                log.debug3("addMdItemAuthors(): count = " + count);
                log.debug3("addMdItemAuthors(): Added author = " + author);
            }
        }
        catch (SQLException sqle) {
            String message = "Cannot add metadata item authors";
            log.error(message, (Throwable)sqle);
            log.error("SQL = '" + sql + "'.");
            log.error("mdItemSeq = '" + mdItemSeq + "'.");
            log.error("authors = " + authors + ".");
            throw new DbException(message, (Throwable)sqle);
        }
        finally {
            DbManager.safeCloseStatement((Statement)insertMdItemAuthor);
        }
        if (log.isDebug2()) {
            log.debug2("addMdItemAuthors(): Done.");
        }
    }

    private String getInsertMdItemAuthorSql() {
        if (this.dbManager.isTypeMysql()) {
            return INSERT_AUTHOR_MYSQL_QUERY;
        }
        return INSERT_AUTHOR_QUERY;
    }

    void addMdItemKeywords(Connection conn, Long mdItemSeq, Collection<String> keywords) throws DbException {
        String DEBUG_HEADER = "addMdItemKeywords(): ";
        if (log.isDebug2()) {
            log.debug2("addMdItemKeywords(): mdItemSeq = " + mdItemSeq);
            log.debug2("addMdItemKeywords(): keywords = " + keywords);
        }
        if (keywords == null || keywords.size() == 0) {
            return;
        }
        PreparedStatement insertMdItemKeyword = this.dbManager.prepareStatement(conn, INSERT_KEYWORD_QUERY);
        try {
            for (String keyword : keywords) {
                insertMdItemKeyword.setLong(1, mdItemSeq);
                insertMdItemKeyword.setString(2, keyword);
                int count = this.dbManager.executeUpdate(insertMdItemKeyword);
                if (!log.isDebug3()) continue;
                log.debug3("addMdItemKeywords(): count = " + count);
                log.debug3("addMdItemKeywords(): Added keyword = " + keyword);
            }
        }
        catch (SQLException sqle) {
            String message = "Cannot add metadata item keywords";
            log.error(message, (Throwable)sqle);
            log.error("SQL = 'insert into keyword(md_item_seq,keyword) values (?,?)'.");
            log.error("mdItemSeq = '" + mdItemSeq + "'.");
            log.error("keywords = " + keywords + ".");
            throw new DbException(message, (Throwable)sqle);
        }
        finally {
            DbManager.safeCloseStatement((Statement)insertMdItemKeyword);
        }
        if (log.isDebug2()) {
            log.debug2("addMdItemKeywords(): Done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void removeFromUnconfiguredAus(Connection conn, String auId) {
        PreparedStatement deleteUnconfiguredAu;
        block11: {
            String DEBUG_HEADER = "removeFromUnconfiguredAus(): ";
            if (log.isDebug2()) {
                log.debug2("removeFromUnconfiguredAus(): auId = " + auId);
            }
            deleteUnconfiguredAu = null;
            String pluginId = null;
            String auKey = null;
            try {
                if (!this.mdxManager.getMetadataManager().isAuInUnconfiguredAuTable(conn, auId)) break block11;
                deleteUnconfiguredAu = this.dbManager.prepareStatement(conn, DELETE_UNCONFIGURED_AU_QUERY);
                pluginId = PluginManager.pluginIdFromAuId((String)auId);
                if (log.isDebug3()) {
                    log.debug3("removeFromUnconfiguredAus(): pluginId = " + pluginId);
                }
                auKey = PluginManager.auKeyFromAuId((String)auId);
                if (log.isDebug3()) {
                    log.debug3("removeFromUnconfiguredAus(): auKey = " + auKey);
                }
                deleteUnconfiguredAu.setString(1, pluginId);
                deleteUnconfiguredAu.setString(2, auKey);
                int count = this.dbManager.executeUpdate(deleteUnconfiguredAu);
                if (log.isDebug3()) {
                    log.debug3("removeFromUnconfiguredAus(): count = " + count);
                }
                DbManager.commitOrRollback((Connection)conn, (Logger)log);
            }
            catch (SQLException sqle) {
                String message = "Cannot delete archival unit from unconfigured table";
                log.error(message, (Throwable)sqle);
                log.error("auId = " + auId);
                log.error("SQL = 'delete from unconfigured_au where plugin_id = ? and au_key = ?'.");
                log.error("pluginId = " + pluginId);
                log.error("auKey = " + auKey);
                DbManager.safeCloseStatement((Statement)deleteUnconfiguredAu);
            }
            catch (DbException dbe) {
                String message = "Cannot delete archival unit from unconfigured table";
                log.error(message, (Throwable)dbe);
                log.error("auId = " + auId);
                log.error("SQL = 'delete from unconfigured_au where plugin_id = ? and au_key = ?'.");
                log.error("pluginId = " + pluginId);
                log.error("auKey = " + auKey);
                {
                    catch (Throwable throwable) {
                        DbManager.safeCloseStatement(deleteUnconfiguredAu);
                        throw throwable;
                    }
                }
                DbManager.safeCloseStatement((Statement)deleteUnconfiguredAu);
            }
        }
        DbManager.safeCloseStatement(deleteUnconfiguredAu);
        if (log.isDebug2()) {
            log.debug2("removeFromUnconfiguredAus(): Done.");
        }
    }

    int removeAuChildMetadataItem(Connection conn, Long auMdSeq, Long mdItemSeq) throws DbException {
        String DEBUG_HEADER = "removeAuChildMetadataItem(): ";
        if (log.isDebug2()) {
            log.debug2("removeAuChildMetadataItem(): auMdSeq = " + auMdSeq);
            log.debug2("removeAuChildMetadataItem(): mdItemSeq = " + mdItemSeq);
        }
        int count = 0;
        if (auMdSeq != null && mdItemSeq != null) {
            PreparedStatement deleteMetadataItem = this.dbManager.prepareStatement(conn, DELETE_AU_CHILD_MD_ITEM_QUERY);
            try {
                deleteMetadataItem.setLong(1, auMdSeq);
                deleteMetadataItem.setLong(2, mdItemSeq);
                count = this.dbManager.executeUpdate(deleteMetadataItem);
            }
            catch (SQLException sqle) {
                String message = "Cannot delete child metadata item";
                log.error(message, (Throwable)sqle);
                log.error("mdItemSeq = " + mdItemSeq);
                log.error("SQL = 'delete from md_item where au_md_seq = ? and md_item_seq = ? and parent_seq is not null'.");
                throw new DbException(message, (Throwable)sqle);
            }
            finally {
                DbManager.safeCloseStatement((Statement)deleteMetadataItem);
            }
        }
        if (log.isDebug2()) {
            log.debug2("removeAuChildMetadataItem(): count = " + count);
        }
        return count;
    }

    boolean updateAuUnknownProvider(Connection conn, Long auMdSeq, Long providerSeq) throws DbException {
        String DEBUG_HEADER = "updateAuUnknownProvider(): ";
        if (log.isDebug2()) {
            log.debug2("updateAuUnknownProvider(): auMdSeq = " + auMdSeq);
            log.debug2("updateAuUnknownProvider(): providerSeq = " + providerSeq);
        }
        int updatedCount = -1;
        PreparedStatement updateUnknownProvider = this.dbManager.prepareStatement(conn, UPDATE_AU_MD_UNKNOWN_PROVIDER_QUERY);
        try {
            updateUnknownProvider.setLong(1, providerSeq);
            updateUnknownProvider.setLong(2, auMdSeq);
            updatedCount = this.dbManager.executeUpdate(updateUnknownProvider);
            if (log.isDebug3()) {
                log.debug3("updateAuUnknownProvider(): updatedCount = " + updatedCount);
            }
        }
        catch (SQLException sqle) {
            String message = "Cannot update unknown provider";
            log.error(message, (Throwable)sqle);
            log.error("auMdSeq = '" + auMdSeq + "'.");
            log.error("providerSeq = '" + providerSeq + "'.");
            log.error("SQL = 'update au_md set provider_seq = ? where au_md_seq IN (select am.au_md_seq from au_md am,provider p where am.provider_seq = p.provider_seq and p.provider_name = 'UNKNOWN PROVIDER' and am.au_md_seq = ?)'.");
            throw new DbException(message, (Throwable)sqle);
        }
        finally {
            DbManager.safeCloseStatement((Statement)updateUnknownProvider);
        }
        if (log.isDebug2()) {
            log.debug2("updateAuUnknownProvider(): result = " + (updatedCount > 0));
        }
        return updatedCount > 0;
    }

    int removeAuMetadataItems(JdbcContext jdbcCtxt, String auId) throws DbException {
        String DEBUG_HEADER = "removeAuMetadataItems(): ";
        if (log.isDebug2()) {
            log.debug2("removeAuMetadataItems(): auId = " + auId);
        }
        int count = 0;
        Connection conn = jdbcCtxt.getConnection();
        Long auMdSeq = this.findAuMdByAuId(jdbcCtxt, auId);
        if (log.isDebug3()) {
            log.debug3("removeAuMetadataItems(): auMdSeq = " + auMdSeq);
        }
        if (auMdSeq != null) {
            PreparedStatement deleteMetadataItems = this.dbManager.prepareStatement(conn, DELETE_AU_MD_ITEM_QUERY);
            jdbcCtxt.setStatement((Statement)deleteMetadataItems);
            try {
                deleteMetadataItems.setLong(1, auMdSeq);
                count = this.dbManager.executeUpdate(deleteMetadataItems);
            }
            catch (SQLException sqle) {
                String message = "Cannot delete AU metadata items";
                log.error(message, (Throwable)sqle);
                log.error("auId = " + auId);
                log.error("SQL = 'delete from md_item where au_md_seq = ?'.");
                log.error("auMdSeq = " + auMdSeq);
                throw new DbException(message, (Throwable)sqle);
            }
            finally {
                DbManager.safeCloseStatement((Statement)deleteMetadataItems);
            }
        }
        if (log.isDebug2()) {
            log.debug2("removeAuMetadataItems(): count = " + count);
        }
        return count;
    }

    private Long findAuMdByAuId(JdbcContext jdbcCtxt, String auId) throws DbException {
        ResultSet resultSet;
        PreparedStatement findAuMd;
        Long auMdSeq;
        block9: {
            String DEBUG_HEADER = "findAuMdByAuId(): ";
            if (log.isDebug2()) {
                log.debug2("findAuMdByAuId(): auId = " + auId);
            }
            Connection conn = jdbcCtxt.getConnection();
            String pluginId = null;
            String auKey = null;
            auMdSeq = null;
            findAuMd = this.dbManager.prepareStatement(conn, FIND_AU_MD_BY_AU_ID_QUERY);
            resultSet = null;
            jdbcCtxt.setStatement((Statement)findAuMd);
            try {
                pluginId = PluginManager.pluginIdFromAuId((String)auId);
                if (log.isDebug3()) {
                    log.debug3("findAuMdByAuId(): pluginId() = " + pluginId);
                }
                auKey = PluginManager.auKeyFromAuId((String)auId);
                if (log.isDebug3()) {
                    log.debug3("findAuMdByAuId(): auKey = " + auKey);
                }
                findAuMd.setString(1, pluginId);
                findAuMd.setString(2, auKey);
                resultSet = this.dbManager.executeQuery(findAuMd);
                if (!resultSet.next()) break block9;
                auMdSeq = resultSet.getLong("au_md_seq");
                if (log.isDebug3()) {
                    log.debug3("findAuMdByAuId(): auMdSeq = " + auMdSeq);
                }
            }
            catch (SQLException sqle) {
                try {
                    String message = "Cannot find AU metadata identifier";
                    log.error(message, (Throwable)sqle);
                    log.error("auId = " + auId);
                    log.error("SQL = 'select m.au_md_seq from au_md m,au a,plugin p where m.au_seq = a.au_seq and a.plugin_seq = p.plugin_seq and p.plugin_id = ? and a.au_key = ?'.");
                    log.error("pluginId = " + pluginId);
                    log.error("auKey = " + auKey);
                    throw new DbException(message, (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    DbManager.safeCloseResultSet(resultSet);
                    DbManager.safeCloseStatement((Statement)findAuMd);
                    throw throwable;
                }
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)findAuMd);
        if (log.isDebug2()) {
            log.debug2("findAuMdByAuId(): auMdSeq = " + auMdSeq);
        }
        return auMdSeq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ItemMetadata> getAuMetadataDetail(String auId, Integer page, Integer limit) throws DbException {
        String DEBUG_HEADER = "getAuMetadataDetail(): ";
        if (log.isDebug2()) {
            log.debug2("getAuMetadataDetail(): auId = " + auId);
            log.debug2("getAuMetadataDetail(): page = " + page);
            log.debug2("getAuMetadataDetail(): limit = " + limit);
        }
        List<ItemMetadata> items = null;
        Connection conn = null;
        try {
            conn = this.dbManager.getConnection();
            items = this.getAuMetadataDetail(conn, auId, page, limit);
        }
        finally {
            DbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("getAuMetadataDetail(): Done.");
        }
        return items;
    }

    List<ItemMetadata> getAuMetadataDetail(Connection conn, String auId, Integer page, Integer limit) throws DbException {
        ResultSet resultSet;
        PreparedStatement getScalarMetadata;
        String sql;
        ItemMetadata itemMetadata;
        String auKey;
        String pluginId;
        HashMap<Long, ItemMetadata> itemMap;
        ArrayList<ItemMetadata> items;
        block83: {
            Serializable mdItemSeq;
            String DEBUG_HEADER = "getAuMetadataDetail(): ";
            if (log.isDebug2()) {
                log.debug2("getAuMetadataDetail(): auId = " + auId);
                log.debug2("getAuMetadataDetail(): page = " + page);
                log.debug2("getAuMetadataDetail(): limit = " + limit);
            }
            items = new ArrayList<ItemMetadata>();
            itemMap = new HashMap<Long, ItemMetadata>();
            pluginId = null;
            auKey = null;
            Serializable previousMdItemSeq = null;
            itemMetadata = null;
            sql = FIND_OFFSET_AU_MD_ITEM_QUERY;
            if (this.dbManager.isTypeDerby()) {
                sql = sql + " rows";
            }
            if (log.isDebug3()) {
                log.debug3("getAuMetadataDetail(): sql = " + sql);
            }
            int offset = 0;
            if (page != null && page > 0 && limit != null && limit >= 0) {
                offset = (page - 1) * limit;
            }
            if (log.isDebug3()) {
                log.debug3("getAuMetadataDetail(): offset = " + offset);
            }
            getScalarMetadata = this.dbManager.prepareStatement(conn, sql);
            resultSet = null;
            pluginId = PluginManager.pluginIdFromAuId((String)auId);
            if (log.isDebug3()) {
                log.debug3("getAuMetadataDetail(): pluginId() = " + pluginId);
            }
            auKey = PluginManager.auKeyFromAuId((String)auId);
            if (log.isDebug3()) {
                log.debug3("getAuMetadataDetail(): auKey = " + auKey);
            }
            getScalarMetadata.setString(1, pluginId);
            getScalarMetadata.setString(2, auKey);
            getScalarMetadata.setInt(3, offset);
            if (limit != null && limit >= 0) {
                getScalarMetadata.setMaxRows(limit);
            }
            resultSet = this.dbManager.executeQuery(getScalarMetadata);
            while (resultSet.next()) {
                mdItemSeq = resultSet.getLong("md_item_seq");
                if (log.isDebug3()) {
                    log.debug3("getAuMetadataDetail(): mdItemSeq = " + mdItemSeq);
                }
                if (!mdItemSeq.equals(previousMdItemSeq)) {
                    itemMetadata = new ItemMetadata();
                    itemMetadata.setScalarMap(new HashMap());
                    itemMetadata.setListMap(new HashMap());
                    itemMetadata.setMapMap(new HashMap());
                    Map scalarMap = itemMetadata.getScalarMap();
                    scalarMap.put("au_id", auId);
                    String providerName = resultSet.getString("provider_name");
                    if (log.isDebug3()) {
                        log.debug3("getAuMetadataDetail(): providerName = " + (String)providerName);
                    }
                    if (!resultSet.wasNull()) {
                        scalarMap.put("provider_name", providerName);
                    }
                    String publisherName = resultSet.getString("publisher_name");
                    if (log.isDebug3()) {
                        log.debug3("getAuMetadataDetail(): publisherName = " + publisherName);
                    }
                    if (!resultSet.wasNull()) {
                        scalarMap.put("publisher_name", publisherName);
                    }
                    String publicationName = resultSet.getString("publication_name");
                    if (log.isDebug3()) {
                        log.debug3("getAuMetadataDetail(): publicationName = " + publicationName);
                    }
                    if (!resultSet.wasNull()) {
                        scalarMap.put("publication_name", publicationName);
                    }
                    String date = resultSet.getString("date");
                    if (log.isDebug3()) {
                        log.debug3("getAuMetadataDetail(): date = " + date);
                    }
                    if (!resultSet.wasNull()) {
                        scalarMap.put("date", date);
                    }
                    String coverage = resultSet.getString("coverage");
                    if (log.isDebug3()) {
                        log.debug3("getAuMetadataDetail(): coverage = " + coverage);
                    }
                    if (!resultSet.wasNull()) {
                        scalarMap.put("coverage", coverage);
                    }
                    Long fetchTime = resultSet.getLong("fetch_time");
                    if (log.isDebug3()) {
                        log.debug3("getAuMetadataDetail(): fetchTime = " + fetchTime);
                    }
                    if (!resultSet.wasNull()) {
                        scalarMap.put("fetch_time", fetchTime.toString());
                    }
                    String itemTitle = resultSet.getString("item_title");
                    if (log.isDebug3()) {
                        log.debug3("getAuMetadataDetail(): itemTitle = " + itemTitle);
                    }
                    if (!resultSet.wasNull()) {
                        scalarMap.put("item_title", itemTitle);
                    }
                    String volume = resultSet.getString("volume");
                    if (log.isDebug3()) {
                        log.debug3("getAuMetadataDetail(): volume = " + volume);
                    }
                    if (!resultSet.wasNull()) {
                        scalarMap.put("volume", volume);
                    }
                    String issue = resultSet.getString("issue");
                    if (log.isDebug3()) {
                        log.debug3("getAuMetadataDetail(): issue = " + issue);
                    }
                    if (!resultSet.wasNull()) {
                        scalarMap.put("issue", issue);
                    }
                    String startPage = resultSet.getString("start_page");
                    if (log.isDebug3()) {
                        log.debug3("getAuMetadataDetail(): startPage = " + startPage);
                    }
                    if (!resultSet.wasNull()) {
                        scalarMap.put("start_page", startPage);
                    }
                    String endPage = resultSet.getString("end_page");
                    if (log.isDebug3()) {
                        log.debug3("getAuMetadataDetail(): endPage = " + endPage);
                    }
                    if (!resultSet.wasNull()) {
                        scalarMap.put("end_page", endPage);
                    }
                    String itemNo = resultSet.getString("item_no");
                    if (log.isDebug3()) {
                        log.debug3("getAuMetadataDetail(): itemNo = " + itemNo);
                    }
                    if (!resultSet.wasNull()) {
                        scalarMap.put("item_no", itemNo);
                    }
                    String doi = resultSet.getString("doi");
                    if (log.isDebug3()) {
                        log.debug3("getAuMetadataDetail(): doi = " + doi);
                    }
                    if (!resultSet.wasNull()) {
                        scalarMap.put("doi", doi);
                    }
                    if (log.isDebug3()) {
                        log.debug3("getAuMetadataDetail(): itemMetadata = " + itemMetadata);
                    }
                    items.add(itemMetadata);
                    itemMap.put((Long)mdItemSeq, itemMetadata);
                    previousMdItemSeq = mdItemSeq;
                    continue;
                }
                log.error("Ignoring unexpected multiple scalar results for mdItemSeq = " + mdItemSeq + ": Existing result: " + itemMetadata);
            }
            resultSet.close();
            if (items.size() != 0) break block83;
            if (log.isDebug2()) {
                log.debug2("getAuMetadataDetail(): items = " + items);
            }
            mdItemSeq = items;
            DbManager.safeCloseResultSet((ResultSet)resultSet);
            DbManager.safeCloseStatement((Statement)getScalarMetadata);
            return mdItemSeq;
        }
        try {
            StringBuilder inIds = new StringBuilder("(");
            boolean isFirst = true;
            for (Long id : itemMap.keySet()) {
                if (log.isDebug3()) {
                    log.debug3("getAuMetadataDetail(): id = " + id);
                }
                if (!isFirst) {
                    inIds.append(", ");
                } else {
                    isFirst = false;
                }
                inIds.append(id);
            }
            inIds.append(")");
            sql = GET_MULTIPLE_MD_DETAIL_QUERY.replaceFirst("\\(\\)", inIds.toString());
            if (log.isDebug3()) {
                log.debug3("getAuMetadataDetail(): sql = " + sql);
            }
            PreparedStatement getNonScalarMetadata = this.dbManager.prepareStatement(conn, sql);
            resultSet = this.dbManager.executeQuery(getNonScalarMetadata);
            while (resultSet.next()) {
                Long mdItemSeq = resultSet.getLong("md_item_seq");
                if (log.isDebug3()) {
                    log.debug3("getAuMetadataDetail(): mdItemSeq = " + mdItemSeq);
                }
                if ((itemMetadata = (ItemMetadata)itemMap.get(mdItemSeq)) == null) {
                    log.error("Ignoring non-scalar results for mdItemSeq = " + mdItemSeq + " with no previously retrieved scalar results");
                    continue;
                }
                String issn = resultSet.getString("issn");
                if (log.isDebug3()) {
                    log.debug3("getAuMetadataDetail(): issn = " + issn);
                }
                if (!resultSet.wasNull()) {
                    String type = resultSet.getString("issn_type");
                    if (log.isDebug3()) {
                        log.debug3("getAuMetadataDetail(): type = " + type);
                    }
                    if (!resultSet.wasNull()) {
                        Map issns = (Map)itemMetadata.getMapMap().get("issn");
                        if (issns == null) {
                            itemMetadata.getMapMap().put("issn", new HashMap());
                            ((Map)itemMetadata.getMapMap().get("issn")).put(type, issn);
                        } else {
                            issns.put(type, issn);
                        }
                    }
                }
                String isbn = resultSet.getString("isbn");
                if (log.isDebug3()) {
                    log.debug3("getAuMetadataDetail(): isbn = " + isbn);
                }
                if (!resultSet.wasNull()) {
                    String type = resultSet.getString("isbn_type");
                    if (log.isDebug3()) {
                        log.debug3("getAuMetadataDetail(): type = " + type);
                    }
                    if (!resultSet.wasNull()) {
                        Map isbns = (Map)itemMetadata.getMapMap().get("isbn");
                        if (isbns == null) {
                            itemMetadata.getMapMap().put("isbn", new HashMap());
                            ((Map)itemMetadata.getMapMap().get("isbn")).put(type, isbn);
                        } else {
                            isbns.put(type, isbn);
                        }
                    }
                }
                String proprietaryId = resultSet.getString("proprietary_id");
                if (log.isDebug3()) {
                    log.debug3("getAuMetadataDetail(): proprietaryId = " + proprietaryId);
                }
                if (!resultSet.wasNull()) {
                    List pis = (List)itemMetadata.getListMap().get("proprietary_id");
                    if (pis == null) {
                        itemMetadata.getListMap().put("proprietary_id", new ArrayList());
                        ((List)itemMetadata.getListMap().get("proprietary_id")).add(proprietaryId);
                    } else if (!pis.contains(proprietaryId)) {
                        pis.add(proprietaryId);
                    }
                }
                String url = resultSet.getString("url");
                if (log.isDebug3()) {
                    log.debug3("getAuMetadataDetail(): url = " + url);
                }
                if (!resultSet.wasNull()) {
                    String feature = resultSet.getString("feature");
                    if (log.isDebug3()) {
                        log.debug3("getAuMetadataDetail(): feature = " + feature);
                    }
                    if (!resultSet.wasNull()) {
                        Map urls = (Map)itemMetadata.getMapMap().get("url");
                        if (urls == null) {
                            itemMetadata.getMapMap().put("url", new HashMap());
                            ((Map)itemMetadata.getMapMap().get("url")).put(feature, url);
                        } else {
                            urls.put(feature, url);
                        }
                    }
                }
                String author = resultSet.getString("author_name");
                if (log.isDebug3()) {
                    log.debug3("getAuMetadataDetail(): author = " + author);
                }
                if (!resultSet.wasNull()) {
                    List authors = (List)itemMetadata.getListMap().get("author_name");
                    if (authors == null) {
                        itemMetadata.getListMap().put("author_name", new ArrayList());
                        ((List)itemMetadata.getListMap().get("author_name")).add(author);
                    } else if (!authors.contains(author)) {
                        authors.add(author);
                    }
                }
                String keyword = resultSet.getString("keyword");
                if (log.isDebug3()) {
                    log.debug3("getAuMetadataDetail(): keyword = " + keyword);
                }
                if (resultSet.wasNull()) continue;
                List keywords = (List)itemMetadata.getListMap().get("keyword");
                if (keywords == null) {
                    itemMetadata.getListMap().put("keyword", new ArrayList());
                    ((List)itemMetadata.getListMap().get("keyword")).add(keyword);
                    continue;
                }
                if (keywords.contains(keyword)) continue;
                keywords.add(keyword);
            }
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot get AU metadata";
                log.error(message, (Throwable)sqle);
                log.error("auId = '" + auId + "'.");
                log.error("page = '" + page + "'.");
                log.error("limit = '" + limit + "'.");
                log.error("SQL = '" + sql + "'.");
                log.error("pluginId = '" + pluginId + "'.");
                log.error("auKey = '" + auKey + "'.");
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseResultSet(resultSet);
                DbManager.safeCloseStatement((Statement)getScalarMetadata);
                throw throwable;
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)getScalarMetadata);
        if (log.isDebug2()) {
            log.debug2("getAuMetadataDetail(): items.size() = " + items.size());
        }
        return items;
    }
}

