/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.metadata.extractor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import org.lockss.app.LockssDaemon;
import org.lockss.daemon.LockssRunnable;
import org.lockss.db.DbException;
import org.lockss.metadata.MetadataDbManager;
import org.lockss.metadata.extractor.MetadataExtractorManager;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.plugin.AuEvent;
import org.lockss.plugin.AuEventHandler;
import org.lockss.plugin.AuUtil;
import org.lockss.plugin.PluginManager;
import org.lockss.util.CollectionUtil;
import org.lockss.util.Logger;

public class MetadataIndexingStarter
extends LockssRunnable {
    private static Logger log = Logger.getLogger(MetadataIndexingStarter.class);
    private final MetadataDbManager dbManager;
    private final MetadataExtractorManager mdxManager;
    private final PluginManager pluginManager;

    public MetadataIndexingStarter(MetadataDbManager dbManager, MetadataExtractorManager mdxManager, PluginManager pluginManager) {
        super("MetadataStarter");
        this.dbManager = dbManager;
        this.mdxManager = mdxManager;
        this.pluginManager = pluginManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockssRun() {
        Connection conn;
        String DEBUG_HEADER = "lockssRun(): ";
        log.debug("lockssRun(): Starting...");
        LockssDaemon daemon = LockssDaemon.getLockssDaemon();
        if (!daemon.areAusStarted()) {
            log.debug("lockssRun(): Waiting for aus to start");
            while (!daemon.areAusStarted()) {
                try {
                    daemon.waitUntilAusStarted();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            conn = this.dbManager.getConnection();
        }
        catch (DbException dbe) {
            log.error("Cannot connect to database -- extraction not started", (Throwable)dbe);
            return;
        }
        this.pluginManager.registerAuEventHandler((AuEventHandler)new ArchivalUnitEventHandler());
        log.debug2("lockssRun(): Examining AUs");
        ArrayList<ArchivalUnit> toBeIndexed = new ArrayList<ArchivalUnit>();
        for (ArchivalUnit au : this.pluginManager.getAllAus()) {
            if (log.isDebug3()) {
                log.debug3("lockssRun(): Plugin AU = " + au.getName());
            }
            if (!AuUtil.hasCrawled((ArchivalUnit)au)) continue;
            try {
                if (!this.mdxManager.isAuMetadataForObsoletePlugin(conn, au) && !this.mdxManager.isAuCrawledAndNotExtracted(conn, au)) continue;
                toBeIndexed.add(au);
            }
            catch (DbException dbe) {
                log.error("Cannot get AU metadata version: " + (Object)((Object)dbe));
            }
        }
        log.debug2("lockssRun(): Done examining AUs");
        for (ArchivalUnit au : CollectionUtil.randomPermutation(toBeIndexed)) {
            if (log.isDebug3()) {
                log.debug3("lockssRun(): Pending AU = " + au.getName());
            }
            try {
                boolean fullReindex = this.mdxManager.isAuMetadataForObsoletePlugin(conn, au);
                if (log.isDebug3()) {
                    log.debug3("lockssRun(): fullReindex = " + fullReindex);
                }
                this.mdxManager.addToPendingAusIfNotThere(conn, Collections.singleton(au), fullReindex);
                MetadataDbManager.commitOrRollback((Connection)conn, (Logger)log);
                log.debug2("lockssRun(): Queue updated");
            }
            catch (DbException dbe) {
                log.error("Cannot add to pending AUs table \"pending_au\"", (Throwable)dbe);
                MetadataDbManager.safeRollbackAndClose((Connection)conn);
                return;
            }
        }
        try {
            log.info("lockssRun(): Starting startReindexing...");
            this.mdxManager.startReindexing(conn);
            conn.commit();
        }
        catch (SQLException sqle) {
            log.error("Cannot start reindexing AUs", (Throwable)sqle);
        }
        finally {
            MetadataDbManager.safeRollbackAndClose((Connection)conn);
        }
    }

    private class ArchivalUnitEventHandler
    extends AuEventHandler.Base {
        private ArchivalUnitEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void auCreated(AuEvent event, ArchivalUnit au) {
            block10: {
                String DEBUG_HEADER = "auCreated(): ";
                Connection conn = null;
                PreparedStatement insertPendingAuBatchStatement = null;
                try {
                    conn = MetadataIndexingStarter.this.dbManager.getConnection();
                    MetadataIndexingStarter.this.dbManager.updateAuActiveFlag(conn, au.getAuId(), true);
                    MetadataDbManager.commitOrRollback((Connection)conn, (Logger)log);
                    MetadataIndexingStarter.this.mdxManager.getMetadataExtractorManagerSql().removeFromUnconfiguredAus(conn, au.getAuId());
                    insertPendingAuBatchStatement = MetadataIndexingStarter.this.mdxManager.getInsertPendingAuBatchStatement(conn);
                    switch (event.getType()) {
                        case StartupCreate: {
                            log.debug2("auCreated(): StartupCreate for au: " + au);
                            if (!AuUtil.hasCrawled((ArchivalUnit)au)) break;
                            MetadataIndexingStarter.this.mdxManager.enableAndAddAuToReindex(au, conn, insertPendingAuBatchStatement, event.isInBatch());
                            break;
                        }
                        case Create: {
                            log.debug2("auCreated(): Create for au: " + au);
                            if (AuUtil.getAuState((ArchivalUnit)au) == null || !AuUtil.hasCrawled((ArchivalUnit)au)) break;
                            MetadataIndexingStarter.this.mdxManager.enableAndAddAuToReindex(au, conn, insertPendingAuBatchStatement, event.isInBatch());
                            break;
                        }
                        case RestartCreate: {
                            log.debug2("auCreated(): RestartCreate for au: " + au);
                            if (!MetadataIndexingStarter.this.mdxManager.isAuMetadataForObsoletePlugin(au)) break;
                            MetadataIndexingStarter.this.mdxManager.enableAndAddAuToReindex(au, conn, insertPendingAuBatchStatement, event.isInBatch(), true);
                        }
                    }
                }
                catch (DbException dbe) {
                    log.error("Cannot reindex metadata for " + au.getName(), (Throwable)dbe);
                    break block10;
                }
                finally {
                    MetadataDbManager.safeCloseStatement(insertPendingAuBatchStatement);
                    MetadataDbManager.safeRollbackAndClose((Connection)conn);
                }
                MetadataDbManager.safeCloseStatement((Statement)insertPendingAuBatchStatement);
                MetadataDbManager.safeRollbackAndClose((Connection)conn);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void auDeleted(AuEvent event, ArchivalUnit au) {
            String DEBUG_HEADER = "auDeleted(): ";
            switch (event.getType()) {
                case Delete: {
                    log.debug2("auDeleted(): Delete for au: " + au);
                    MetadataIndexingStarter.this.mdxManager.persistUnconfiguredAu(au);
                    MetadataIndexingStarter.this.mdxManager.deleteAuAndReindex(au);
                    break;
                }
                case RestartDelete: {
                    break;
                }
                case Deactivate: {
                    if (log.isDebug3()) {
                        log.debug3("auDeleted(): Deactivate for au: " + au);
                    }
                    Connection conn = null;
                    try {
                        conn = MetadataIndexingStarter.this.dbManager.getConnection();
                        MetadataIndexingStarter.this.dbManager.updateAuActiveFlag(conn, au.getAuId(), false);
                        MetadataDbManager.commitOrRollback((Connection)conn, (Logger)log);
                    }
                    catch (DbException dbe) {
                        try {
                            log.error("Cannot deactivate AU " + au.getName(), (Throwable)dbe);
                        }
                        catch (Throwable throwable) {
                            MetadataDbManager.safeRollbackAndClose(conn);
                            throw throwable;
                        }
                        MetadataDbManager.safeRollbackAndClose((Connection)conn);
                        break;
                    }
                    MetadataDbManager.safeRollbackAndClose((Connection)conn);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void auContentChanged(AuEvent event, ArchivalUnit au, AuEventHandler.ChangeInfo info) {
            String DEBUG_HEADER = "auContentChanged(): ";
            switch (event.getType()) {
                case ContentChanged: {
                    log.debug2("auContentChanged(): ContentChanged for au: " + au);
                    if (!info.isComplete()) break;
                    Connection conn = null;
                    PreparedStatement insertPendingAuBatchStatement = null;
                    try {
                        conn = MetadataIndexingStarter.this.dbManager.getConnection();
                        insertPendingAuBatchStatement = MetadataIndexingStarter.this.mdxManager.getInsertPendingAuBatchStatement(conn);
                        MetadataIndexingStarter.this.mdxManager.enableAndAddAuToReindex(au, conn, insertPendingAuBatchStatement, event.isInBatch());
                    }
                    catch (DbException dbe) {
                        try {
                            log.error("Cannot reindex metadata for " + au.getName(), (Throwable)dbe);
                        }
                        catch (Throwable throwable) {
                            MetadataDbManager.safeCloseStatement(insertPendingAuBatchStatement);
                            MetadataDbManager.safeRollbackAndClose((Connection)conn);
                            throw throwable;
                        }
                        MetadataDbManager.safeCloseStatement((Statement)insertPendingAuBatchStatement);
                        MetadataDbManager.safeRollbackAndClose((Connection)conn);
                        break;
                    }
                    MetadataDbManager.safeCloseStatement((Statement)insertPendingAuBatchStatement);
                    MetadataDbManager.safeRollbackAndClose((Connection)conn);
                    break;
                }
            }
        }
    }
}

