/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.metadata.extractor.job;

import java.sql.Connection;
import org.lockss.app.LockssDaemon;
import org.lockss.db.DbException;
import org.lockss.metadata.extractor.MetadataExtractorManager;
import org.lockss.metadata.extractor.job.JobDbManager;
import org.lockss.metadata.extractor.job.JobManager;
import org.lockss.scheduler.StepTask;
import org.lockss.util.Logger;

public class JobTask
implements Runnable {
    private static final Logger log = Logger.getLogger(JobTask.class);
    private long sleepMs = 60000L;
    private String baseTaskName;
    private String taskName;
    private Long jobSeq = null;
    private JobDbManager dbManager;
    private MetadataExtractorManager mdxManager;
    private JobManager jobManager;
    private boolean isJobFinished = false;
    private StepTask stepTask = null;

    public JobTask(JobDbManager dbManager, MetadataExtractorManager mdxManager, JobManager jobManager) {
        this.dbManager = dbManager;
        this.mdxManager = mdxManager;
        this.jobManager = jobManager;
        this.sleepMs = jobManager.getSleepDelaySeconds() * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String DEBUG_HEADER = "run(): ";
        LockssDaemon daemon = LockssDaemon.getLockssDaemon();
        if (!daemon.areAusStarted()) {
            log.debug("run(): Waiting for Archival Units to start");
            while (!daemon.areAusStarted()) {
                try {
                    daemon.waitUntilAusStarted();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.taskName = this.baseTaskName = Thread.currentThread().getName();
        if (log.isDebug3()) {
            log.debug3("run(): Invoked task '" + this.baseTaskName + "'");
        }
        while (this.jobSeq == null) {
            try {
                this.jobSeq = this.jobManager.claimNextJob(this.taskName);
                if (this.jobSeq != null) {
                    this.taskName = this.baseTaskName + " - jobSeq=" + this.jobSeq;
                    this.processJob(this.jobSeq);
                    continue;
                }
                this.sleep("run(): ");
            }
            catch (Exception e) {
                log.error("Exception caught claiming or processing job: ", (Throwable)e);
            }
            finally {
                this.jobSeq = null;
                this.stepTask = null;
                this.taskName = this.baseTaskName;
                this.isJobFinished = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJob(Long jobSeq) throws DbException {
        String DEBUG_HEADER = "processJob() - " + this.taskName + ": ";
        if (log.isDebug2()) {
            log.debug2(DEBUG_HEADER + "jobSeq = " + jobSeq);
        }
        String jobType = this.jobManager.getJobType(jobSeq);
        if (log.isDebug3()) {
            log.debug3(DEBUG_HEADER + "jobType = " + jobType);
        }
        if ("put_au".equals(jobType)) {
            this.processPutAuJob(jobSeq, true);
        } else if ("put_incremental_au".equals(jobType)) {
            this.processPutAuJob(jobSeq, false);
        } else if ("delete_au".equals(jobType)) {
            this.processDeleteAuJob(jobSeq);
        } else {
            Connection conn = null;
            try {
                conn = this.dbManager.getConnection();
                this.jobManager.markJobAsDone(conn, jobSeq, "Unknown job type");
                JobDbManager.commitOrRollback((Connection)conn, (Logger)log);
                log.error("Ignored job " + jobSeq + " of unknown type = " + jobType);
            }
            finally {
                JobDbManager.safeRollbackAndClose((Connection)conn);
            }
        }
        if (log.isDebug2()) {
            log.debug2(DEBUG_HEADER + "Done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPutAuJob(Long jobSeq, boolean needFullReindex) throws DbException {
        String DEBUG_HEADER = "processPutAuJob() - " + this.taskName + ": ";
        if (log.isDebug2()) {
            log.debug2(DEBUG_HEADER + "jobSeq = " + jobSeq);
            log.debug2(DEBUG_HEADER + "needFullReindex = " + needFullReindex);
        }
        Connection conn = null;
        try {
            conn = this.dbManager.getConnection();
            this.processPutAuJob(conn, jobSeq, needFullReindex);
        }
        finally {
            JobDbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2(DEBUG_HEADER + "Done.");
        }
    }

    private void processPutAuJob(Connection conn, Long jobSeq, boolean needFullReindex) throws DbException {
        String DEBUG_HEADER = "processPutAuJob() - " + this.taskName + ": ";
        if (log.isDebug2()) {
            log.debug2(DEBUG_HEADER + "jobSeq = " + jobSeq);
            log.debug2(DEBUG_HEADER + "needFullReindex = " + needFullReindex);
        }
        String auId = this.jobManager.getJobAuId(conn, jobSeq);
        if (log.isDebug3()) {
            log.debug3(DEBUG_HEADER + "auId = " + auId);
        }
        this.stepTask = this.mdxManager.onDemandStartReindexing(auId, needFullReindex);
        while (!this.isJobFinished) {
            this.sleep(DEBUG_HEADER);
        }
        if (log.isDebug2()) {
            log.debug2(DEBUG_HEADER + "Done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDeleteAuJob(Long jobSeq) throws DbException {
        String DEBUG_HEADER = "processDeleteAuJob() - " + this.taskName + ": ";
        if (log.isDebug2()) {
            log.debug2(DEBUG_HEADER + "jobSeq = " + jobSeq);
        }
        Connection conn = null;
        try {
            conn = this.dbManager.getConnection();
            this.processDeleteAuJob(conn, jobSeq);
        }
        finally {
            JobDbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2(DEBUG_HEADER + "Done.");
        }
    }

    private void processDeleteAuJob(Connection conn, Long jobSeq) throws DbException {
        String DEBUG_HEADER = "processDeleteAuJob() - " + this.taskName + ": ";
        if (log.isDebug2()) {
            log.debug2(DEBUG_HEADER + "jobSeq = " + jobSeq);
        }
        String auId = this.jobManager.getJobAuId(conn, jobSeq);
        if (log.isDebug3()) {
            log.debug3(DEBUG_HEADER + "auId = " + auId);
        }
        this.stepTask = this.mdxManager.startMetadataRemoval(auId);
        while (!this.isJobFinished) {
            this.sleep(DEBUG_HEADER);
        }
        if (log.isDebug2()) {
            log.debug2(DEBUG_HEADER + "Done.");
        }
    }

    void terminateTask() throws DbException {
        String DEBUG_HEADER = "terminateTask() - " + this.taskName + ": ";
        if (log.isDebug2()) {
            log.debug2(DEBUG_HEADER + "Invoked.");
        }
        if (this.getJobId() != null) {
            Connection conn = null;
            try {
                conn = this.dbManager.getConnection();
                this.jobManager.markJobAsFinished(conn, this.jobSeq, "terminated", "Terminated by request");
                JobDbManager.commitOrRollback((Connection)conn, (Logger)log);
            }
            finally {
                JobDbManager.safeRollbackAndClose((Connection)conn);
            }
        } else if (log.isDebug3()) {
            log.debug3(DEBUG_HEADER + "Nothing to do: jobSeq is null.");
        }
        if (this.stepTask != null) {
            if (log.isDebug3()) {
                log.debug3(DEBUG_HEADER + "stepTask.isFinished() = " + this.stepTask.isFinished());
                log.debug3(DEBUG_HEADER + "Cancelling task " + this.stepTask);
            }
            this.stepTask.cancel();
        } else {
            if (log.isDebug3()) {
                log.debug3(DEBUG_HEADER + "Nothing to do: stepTask is null.");
            }
            this.notifyJobFinish();
        }
        if (log.isDebug2()) {
            log.debug2(DEBUG_HEADER + "Done.");
        }
    }

    Long getJobId() {
        return this.jobSeq;
    }

    StepTask getStepTask() {
        return this.stepTask;
    }

    void notifyJobFinish() {
        this.isJobFinished = true;
    }

    private void sleep(String id) {
        if (log.isDebug3()) {
            log.debug3(id + "Going to sleep task '" + this.taskName + "'");
        }
        try {
            Thread.sleep(this.sleepMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (log.isDebug3()) {
            log.debug3(id + "Back from sleep task '" + this.taskName + "'");
        }
    }

    public String toString() {
        return "[JobTask taskname=" + this.taskName + ", jobSeq=" + this.jobSeq + "]";
    }
}

