/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.metadata.extractor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lockss.app.LockssDaemon;
import org.lockss.config.ConfigManager;
import org.lockss.config.CurrentConfig;
import org.lockss.db.DbException;
import org.lockss.exporter.counter.CounterReportsManager;
import org.lockss.laaws.mdq.model.ItemMetadata;
import org.lockss.metadata.MetadataDbManager;
import org.lockss.metadata.MetadataManager;
import org.lockss.metadata.extractor.ArticleMetadataBuffer;
import org.lockss.metadata.extractor.MetadataExtractorManager;
import org.lockss.metadata.extractor.MetadataExtractorManagerSql;
import org.lockss.metadata.extractor.MetadataIndexingException;
import org.lockss.metadata.extractor.ReindexingTask;
import org.lockss.metadata.extractor.StoreAuItemClient;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.plugin.AuUtil;
import org.lockss.plugin.Plugin;
import org.lockss.plugin.PluginManager;
import org.lockss.util.Logger;
import org.lockss.util.MetadataUtil;
import org.lockss.util.StringUtil;
import org.lockss.util.TimeBase;

public class AuMetadataRecorder {
    private static Logger log = Logger.getLogger(AuMetadataRecorder.class);
    static final String UNKNOWN_PUBLISHER_AU_PROBLEM = "UNKNOWN_PUBLISHER";
    private static final String UPDATE_MD_ITEM_PRIMARY_NAME_QUERY = "update md_item_name set name = ? where md_item_seq = ? and name_type = 'primary'";
    private static final String DELETE_NOT_PRIMARY_MDITEM_NAMES_QUERY = "delete from md_item_name where md_item_seq = ? and name like 'UNKNOWN_TITLE%' and name_type = 'not_primary'";
    private static final String DELETE_NOT_PRIMARY_MDITEM_NAME_QUERY = "delete from md_item_name where md_item_seq = ? and name = ? and name_type = 'not_primary'";
    private static final String UPDATE_AU_MD_VERSION_QUERY = "update au_md set md_version = ? where au_md_seq = ?";
    private static final String GET_MD_ITEM_TYPE_NAME_QUERY = "select t.type_name from md_item_type t,md_item m where m.md_item_seq = ? and m.md_item_type_seq = t.md_item_type_seq";
    private static final String FIND_AU_MD_QUERY = "select au_md_seq from au_md where au_seq = ?";
    private static final String FIND_MD_ITEM_QUERY = "select m.md_item_seq from md_item m,url u where m.md_item_type_seq = ? and m.au_md_seq = ? and m.md_item_seq = u.md_item_seq and u.feature = 'Access' and u.url = ?";
    private static final String GET_PUBLISHER_NAME_QUERY = "select publisher_name from publisher where publisher_seq = ?";
    private static final String FIND_AU_PROBLEMS_QUERY = "select problem from au_problem where plugin_id = ? and au_key = ?";
    private static final String DELETE_AU_PROBLEM_QUERY = "delete from au_problem where plugin_id = ? and au_key = ? and problem = ?";
    private static final String INSERT_AU_PROBLEM_QUERY = "insert into au_problem(plugin_id,au_key,problem) values (?,?,?)";
    private static final String FIND_PUBLISHER_PUBLICATIONS_QUERY = "select publication_seq from publication where publisher_seq = ?";
    private static final String FIND_PUBLICATION_CHILD_MD_ITEMS_QUERY = "select distinct m.md_item_seq from publication p,md_item m where p.publication_seq = ? and p.md_item_seq = m.parent_seq";
    private static final String UPDATE_MD_ITEM_PARENT_SEQ_QUERY = "update md_item set parent_seq = ? where md_item_seq = ?";
    private static final String DELETE_UNKNOWN_PUBLISHER_PUBLICATION_MD_ITEM_QUERY = "delete from md_item where md_item_seq in (select md_item_seq from publication where publication_seq = ? and (select count(*) from publisher pr,publication p where pr.publisher_seq = p.publisher_seq and p.publication_seq = ? and pr.publisher_name like 'UNKNOWN_PUBLISHER%') = 1)";
    private static final String DELETE_UNKNOWN_PUBLISHER_PUBLICATION_QUERY = "delete from publication where publication_seq = ? and (select count(*) from publisher pr,publication p where pr.publisher_seq = p.publisher_seq and p.publication_seq = ? and pr.publisher_name like 'UNKNOWN_PUBLISHER%') = 1";
    private static final String DELETE_UNKNOWN_PUBLISHER_QUERY = "delete from publisher where publisher_name = ? and publisher_name like 'UNKNOWN_PUBLISHER%'";
    private final ReindexingTask task;
    private final MetadataExtractorManager mdxManager;
    private final MetadataExtractorManagerSql mdxManagerSql;
    private final MetadataDbManager dbManager;
    private final MetadataManager mdManager;
    private final ArchivalUnit au;
    private final Plugin plugin;
    private final String platform;
    private final int pluginVersion;
    private final String auId;
    private final String auKey;
    private final String pluginId;
    private final boolean isBulkContent;
    private Long publisherSeq = null;
    private Long publicationSeq = null;
    private Long pluginSeq = null;
    private Long auSeq = null;
    private Long auMdSeq = null;
    private Long parentSeq = null;
    private String seriesTitle = null;
    private String proprietarySeriesId = null;
    private String publicationTitle = null;
    private String publicationType = null;
    private String pIsbn = null;
    private String eIsbn = null;
    private String pIssn = null;
    private String eIssn = null;
    private String proprietaryId = null;
    private String volume = null;
    private String parentMdItemType = null;
    private boolean newAu = false;
    private String publisherName;

    public AuMetadataRecorder(ReindexingTask task, MetadataExtractorManager mdxManager, ArchivalUnit au) {
        this.task = task;
        this.mdxManager = mdxManager;
        this.mdxManagerSql = mdxManager.getMetadataExtractorManagerSql();
        this.dbManager = mdxManager.getDbManager();
        this.mdManager = mdxManager.getMetadataManager();
        this.au = au;
        this.plugin = au.getPlugin();
        this.isBulkContent = this.plugin.isBulkContent();
        this.platform = this.plugin.getPublishingPlatform();
        this.pluginVersion = mdxManager.getPluginMetadataVersionNumber(this.plugin);
        this.auId = au.getAuId();
        this.auKey = PluginManager.auKeyFromAuId((String)this.auId);
        this.pluginId = PluginManager.pluginIdFromAuId((String)this.auId);
    }

    public AuMetadataRecorder(MetadataExtractorManager mdxManager, Plugin plugin, String auId) {
        this.task = null;
        this.mdxManager = mdxManager;
        this.mdxManagerSql = mdxManager.getMetadataExtractorManagerSql();
        this.dbManager = mdxManager.getDbManager();
        this.mdManager = mdxManager.getMetadataManager();
        this.au = null;
        this.plugin = plugin;
        this.isBulkContent = plugin.isBulkContent();
        this.platform = plugin.getPublishingPlatform();
        this.pluginVersion = mdxManager.getPluginMetadataVersionNumber(plugin);
        this.auId = auId;
        this.auKey = PluginManager.auKeyFromAuId((String)auId);
        this.pluginId = PluginManager.pluginIdFromAuId((String)auId);
    }

    void recordMetadata(Connection conn, Iterator<ArticleMetadataBuffer.ArticleMetadataInfo> mditr) throws MetadataIndexingException, DbException {
        String DEBUG_HEADER = "recordMetadata(): ";
        List<String> mandatoryFields = this.mdxManager.getMandatoryMetadataFields();
        if (log.isDebug3()) {
            log.debug3("recordMetadata(): mandatoryFields = " + mandatoryFields);
        }
        while (mditr.hasNext()) {
            if (this.task.isCancelled()) {
                throw new MetadataIndexingException("Reindexing task cancelled");
            }
            this.task.pokeWDog();
            this.recordMetadataItem(conn, mandatoryFields, mditr);
            log.debug3("recordMetadata(): updatedArticleCount = " + this.task.getUpdatedArticleCount());
        }
        if (CurrentConfig.getParam((String)"org.lockss.metadataManager.mdRest.serviceLocation") == null) {
            if (this.auMdSeq != null) {
                this.mdxManager.updateAuLastExtractionTime(this.au, conn, this.auMdSeq);
            } else {
                log.warning("auMdSeq is null for auid = '" + this.au.getAuId() + "'.");
            }
            List<String> problems = this.findAuProblems(conn, this.auId);
            if (log.isDebug3()) {
                log.debug3("recordMetadata(): problems.size() = " + problems.size());
            }
            if (this.publisherName.startsWith(UNKNOWN_PUBLISHER_AU_PROBLEM)) {
                if (!problems.contains(this.publisherName)) {
                    this.addAuProblem(conn, this.auId, this.publisherName);
                }
            } else if (problems.size() > 0) {
                this.fixUnknownPublishersAuData(conn, problems);
            }
        }
    }

    Long recordMetadataItem(Connection conn, List<String> mandatoryFields, Iterator<ArticleMetadataBuffer.ArticleMetadataInfo> mditr) throws MetadataIndexingException, DbException {
        String DEBUG_HEADER = "recordMetadataItem(): ";
        if (log.isDebug2()) {
            log.debug2("recordMetadataItem(): mandatoryFields = " + mandatoryFields);
        }
        Long mdItemSeq = null;
        ArticleMetadataBuffer.ArticleMetadataInfo mdInfo = mditr.next();
        this.validateMetadata(mdInfo, mandatoryFields);
        ArticleMetadataBuffer.ArticleMetadataInfo normalizedMdInfo = this.normalizeMetadata(mdInfo);
        if (CurrentConfig.getParam((String)"org.lockss.metadataManager.mdRest.serviceLocation") != null) {
            ItemMetadata item = normalizedMdInfo.populateItemMetadataDetail();
            item.getScalarMap().put("au_id", this.auId);
            mdItemSeq = new StoreAuItemClient().storeAuItem(item);
        } else {
            mdItemSeq = this.storeMetadata(conn, normalizedMdInfo);
        }
        if (log.isDebug2()) {
            log.debug3("recordMetadataItem(): mdItemSeq = " + mdItemSeq);
        }
        return mdItemSeq;
    }

    void validateMetadata(ArticleMetadataBuffer.ArticleMetadataInfo mdinfo, List<String> mandatoryFields) throws MetadataIndexingException {
        if (mandatoryFields == null || mandatoryFields.size() == 0) {
            return;
        }
        Iterator<String> iterator = mandatoryFields.iterator();
        block58: while (iterator.hasNext()) {
            String mandatoryField;
            switch (mandatoryField = iterator.next()) {
                case "publisher": {
                    if (!StringUtil.isNullString((String)mdinfo.publisher)) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "provider": {
                    if (!StringUtil.isNullString((String)mdinfo.provider)) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "publicationTitle": {
                    if (!StringUtil.isNullString((String)mdinfo.publicationTitle)) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "publicationType": {
                    if (!StringUtil.isNullString((String)mdinfo.publicationType)) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "articleTitle": {
                    if (!StringUtil.isNullString((String)mdinfo.articleTitle)) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "articleType": {
                    if (!StringUtil.isNullString((String)mdinfo.articleType)) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "accessUrl": {
                    if (!StringUtil.isNullString((String)mdinfo.accessUrl)) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "isbn": {
                    if (!StringUtil.isNullString((String)mdinfo.isbn)) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "eisbn": {
                    if (!StringUtil.isNullString((String)mdinfo.eisbn)) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "issn": {
                    if (!StringUtil.isNullString((String)mdinfo.issn)) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "eissn": {
                    if (!StringUtil.isNullString((String)mdinfo.eissn)) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "doi": {
                    if (!StringUtil.isNullString((String)mdinfo.doi)) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "pubDate": {
                    if (!StringUtil.isNullString((String)mdinfo.pubDate)) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "pubYear": {
                    if (!StringUtil.isNullString((String)mdinfo.pubYear)) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "volume": {
                    if (!StringUtil.isNullString((String)mdinfo.volume)) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "issue": {
                    if (!StringUtil.isNullString((String)mdinfo.issue)) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "startPage": {
                    if (!StringUtil.isNullString((String)mdinfo.startPage)) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "endPage": {
                    if (!StringUtil.isNullString((String)mdinfo.endPage)) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "seriesTitle": {
                    if (!StringUtil.isNullString((String)mdinfo.seriesTitle)) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "authors": {
                    if (mdinfo.authors != null && mdinfo.authors.size() != 0) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "keywords": {
                    if (mdinfo.keywords != null && mdinfo.keywords.size() != 0) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "featuredUrlMap": {
                    if (mdinfo.featuredUrlMap != null && mdinfo.featuredUrlMap.size() != 0) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "coverage": {
                    if (!StringUtil.isNullString((String)mdinfo.coverage)) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "itemNumber": {
                    if (!StringUtil.isNullString((String)mdinfo.itemNumber)) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "proprietaryIdentifier": {
                    if (!StringUtil.isNullString((String)mdinfo.proprietaryIdentifier)) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "proprietarySeriesIdentifier": {
                    if (!StringUtil.isNullString((String)mdinfo.proprietarySeriesIdentifier)) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
                case "fetchTime": {
                    if (!StringUtil.isNullString((String)mdinfo.fetchTime)) continue block58;
                    throw new MetadataIndexingException("Missing mandatory metadata field '" + mandatoryField + "' in " + mdinfo.toString(), mdinfo);
                }
            }
            log.warning("Ignoring unknown mandatory field '" + mandatoryField + "'");
        }
    }

    ArticleMetadataBuffer.ArticleMetadataInfo normalizeMetadata(ArticleMetadataBuffer.ArticleMetadataInfo mdinfo) {
        String name;
        String name2;
        if (mdinfo.accessUrl != null) {
            String accessUrl = mdinfo.accessUrl.trim();
            if (accessUrl.length() > 4096) {
                log.warning("accessUrl too long '" + mdinfo.accessUrl + "' for title: '" + mdinfo.publicationTitle + "' publisher: " + mdinfo.publisher + "'");
                mdinfo.accessUrl = MetadataDbManager.truncateVarchar((String)accessUrl, (int)4096);
            } else {
                mdinfo.accessUrl = accessUrl;
            }
        }
        if (mdinfo.isbn != null) {
            mdinfo.isbn = MetadataUtil.toUnpunctuatedIsbn((String)mdinfo.isbn);
            if (mdinfo.isbn != null) {
                mdinfo.isbn = mdinfo.isbn.toUpperCase();
            }
        }
        if (mdinfo.eisbn != null) {
            mdinfo.eisbn = MetadataUtil.toUnpunctuatedIsbn((String)mdinfo.eisbn);
            if (mdinfo.eisbn != null) {
                mdinfo.eisbn = mdinfo.eisbn.toUpperCase();
            }
        }
        if (mdinfo.issn != null) {
            mdinfo.issn = MetadataUtil.toUnpunctuatedIssn((String)mdinfo.issn);
            if (mdinfo.issn != null) {
                mdinfo.issn = mdinfo.issn.toUpperCase();
            }
        }
        if (mdinfo.eissn != null) {
            mdinfo.eissn = MetadataUtil.toUnpunctuatedIssn((String)mdinfo.eissn);
            if (mdinfo.eissn != null) {
                mdinfo.eissn = mdinfo.eissn.toUpperCase();
            }
        }
        if (mdinfo.doi != null) {
            String doi = mdinfo.doi.trim();
            if (StringUtil.startsWithIgnoreCase((String)doi, (String)"doi:")) {
                doi = doi.substring("doi:".length());
                log.debug3("doi = '" + doi + "'.");
            }
            if (doi.length() > 256) {
                log.warning("doi too long '" + mdinfo.doi + "' for title: '" + mdinfo.publicationTitle + "' publisher: " + mdinfo.publisher + "'");
                mdinfo.doi = MetadataDbManager.truncateVarchar((String)doi.toLowerCase(), (int)256);
            } else {
                mdinfo.doi = doi.toLowerCase();
            }
        }
        if (mdinfo.pubDate != null) {
            String pubDate = mdinfo.pubDate.trim();
            if (pubDate.length() > 16) {
                log.warning("pubDate too long '" + mdinfo.pubDate + "' for title: '" + mdinfo.publicationTitle + "' publisher: " + mdinfo.publisher + "'");
                mdinfo.pubDate = MetadataDbManager.truncateVarchar((String)pubDate, (int)16);
            } else {
                mdinfo.pubDate = pubDate;
            }
        }
        if (mdinfo.volume != null) {
            String volume = mdinfo.volume.trim();
            if (volume.length() > 16) {
                log.warning("volume too long '" + mdinfo.volume + "' for title: '" + mdinfo.publicationTitle + "' publisher: " + mdinfo.publisher + "'");
                mdinfo.volume = MetadataDbManager.truncateVarchar((String)volume, (int)16);
            } else {
                mdinfo.volume = volume;
            }
        }
        if (mdinfo.issue != null) {
            String issue = mdinfo.issue.trim();
            if (issue.length() > 16) {
                log.warning("issue too long '" + mdinfo.issue + "' for title: '" + mdinfo.publicationTitle + "' publisher: " + mdinfo.publisher + "'");
                mdinfo.issue = MetadataDbManager.truncateVarchar((String)issue, (int)16);
            } else {
                mdinfo.issue = issue;
            }
        }
        if (mdinfo.startPage != null) {
            String startPage = mdinfo.startPage.trim();
            if (startPage.length() > 16) {
                log.warning("startPage too long '" + mdinfo.startPage + "' for title: '" + mdinfo.publicationTitle + "' publisher: " + mdinfo.publisher + "'");
                mdinfo.startPage = MetadataDbManager.truncateVarchar((String)startPage, (int)16);
            } else {
                mdinfo.startPage = startPage;
            }
        }
        if (mdinfo.articleTitle != null) {
            name2 = mdinfo.articleTitle.trim();
            if (name2.length() > 512) {
                log.warning("article title too long '" + mdinfo.articleTitle + "' for title: '" + mdinfo.publicationTitle + "' publisher: " + mdinfo.publisher + "'");
                mdinfo.articleTitle = MetadataDbManager.truncateVarchar((String)name2, (int)512);
            } else {
                mdinfo.articleTitle = name2;
            }
        }
        if (mdinfo.publisher != null) {
            name2 = mdinfo.publisher.trim();
            if (name2.length() > 512) {
                log.warning("publisher too long '" + mdinfo.publisher + "' for title: '" + mdinfo.publicationTitle + "'");
                mdinfo.publisher = MetadataDbManager.truncateVarchar((String)name2, (int)512);
            } else {
                mdinfo.publisher = name2;
            }
        }
        if (mdinfo.provider != null) {
            name2 = mdinfo.provider.trim();
            if (name2.length() > 512) {
                log.warning("provider too long '" + mdinfo.provider + "' for title: '" + mdinfo.publicationTitle + "'");
                mdinfo.provider = MetadataDbManager.truncateVarchar((String)name2, (int)512);
            } else {
                mdinfo.provider = name2;
            }
        }
        if (mdinfo.seriesTitle != null) {
            name2 = mdinfo.seriesTitle.trim();
            if (name2.length() > 512) {
                log.warning("series title too long '" + mdinfo.seriesTitle + "' for publisher: " + mdinfo.publisher + "'");
                mdinfo.seriesTitle = MetadataDbManager.truncateVarchar((String)name2, (int)512);
            } else {
                mdinfo.seriesTitle = name2;
            }
        }
        if (mdinfo.publicationTitle != null) {
            name2 = mdinfo.publicationTitle.trim();
            if (name2.length() > 512) {
                log.warning("journal title too long '" + mdinfo.publicationTitle + "' for publisher: " + mdinfo.publisher + "'");
                mdinfo.publicationTitle = MetadataDbManager.truncateVarchar((String)name2, (int)512);
            } else {
                mdinfo.publicationTitle = name2;
            }
        }
        if (mdinfo.authors != null) {
            ArrayList<String> authors = new ArrayList<String>();
            for (String author : mdinfo.authors) {
                name = author.trim();
                if (name.length() > 128) {
                    log.warning("author too long '" + author + "' for title: '" + mdinfo.publicationTitle + "' publisher: " + mdinfo.publisher + "'");
                    authors.add(MetadataDbManager.truncateVarchar((String)name, (int)128));
                    continue;
                }
                authors.add(name);
            }
            mdinfo.authors = authors;
        }
        if (mdinfo.keywords != null) {
            ArrayList<String> keywords = new ArrayList<String>();
            for (String keyword : mdinfo.keywords) {
                name = keyword.trim();
                if (name.length() > 64) {
                    log.warning("keyword too long '" + keyword + "' for title: '" + mdinfo.publicationTitle + "' publisher: " + mdinfo.publisher + "'");
                    keywords.add(MetadataDbManager.truncateVarchar((String)name, (int)64));
                    continue;
                }
                keywords.add(name);
            }
            mdinfo.keywords = keywords;
        }
        if (mdinfo.featuredUrlMap != null) {
            HashMap<String, String> featuredUrls = new HashMap<String, String>();
            Iterator<String> iterator = mdinfo.featuredUrlMap.keySet().iterator();
            while (iterator.hasNext()) {
                String url;
                String feature;
                String validFeature = feature = iterator.next();
                if (feature.length() > 32) {
                    log.warning("feature too long '" + feature + "' for title: '" + mdinfo.publicationTitle + "' publisher: " + mdinfo.publisher + "'");
                    validFeature = MetadataDbManager.truncateVarchar((String)feature, (int)32);
                }
                if ((url = mdinfo.featuredUrlMap.get(feature).trim()).length() > 4096) {
                    log.warning("URL too long '" + mdinfo.featuredUrlMap.get(feature) + "' for title: '" + mdinfo.publicationTitle + "' publisher: " + mdinfo.publisher + "'");
                    featuredUrls.put(validFeature, MetadataDbManager.truncateVarchar((String)url, (int)4096));
                    continue;
                }
                featuredUrls.put(validFeature, url);
            }
            mdinfo.featuredUrlMap = featuredUrls;
        }
        if (mdinfo.endPage != null) {
            String endPage = mdinfo.endPage.trim();
            if (endPage.length() > 16) {
                log.warning("endPage too long '" + mdinfo.endPage + "' for title: '" + mdinfo.publicationTitle + "' publisher: " + mdinfo.publisher + "'");
                mdinfo.endPage = MetadataDbManager.truncateVarchar((String)endPage, (int)16);
            } else {
                mdinfo.endPage = endPage;
            }
        }
        if (mdinfo.coverage != null) {
            String coverage = mdinfo.coverage.trim();
            if (coverage.length() > 16) {
                log.warning("coverage too long '" + mdinfo.coverage + "' for title: '" + mdinfo.publicationTitle + "' publisher: " + mdinfo.publisher + "'");
                mdinfo.coverage = MetadataDbManager.truncateVarchar((String)coverage, (int)16);
            } else {
                mdinfo.coverage = coverage;
            }
        } else {
            mdinfo.coverage = "fulltext";
        }
        if (mdinfo.itemNumber != null) {
            String itemNumber = mdinfo.itemNumber.trim();
            if (itemNumber.length() > 16) {
                log.warning("itemNumber too long '" + mdinfo.itemNumber + "' for title: '" + mdinfo.publicationTitle + "' publisher: " + mdinfo.publisher + "'");
                mdinfo.itemNumber = MetadataDbManager.truncateVarchar((String)mdinfo.itemNumber, (int)16);
            } else {
                mdinfo.itemNumber = itemNumber;
            }
        }
        if (mdinfo.proprietaryIdentifier != null) {
            name2 = mdinfo.proprietaryIdentifier.trim();
            if (name2.length() > 32) {
                log.warning("proprietaryIdentifier too long '" + mdinfo.proprietaryIdentifier + "' for title: '" + mdinfo.publicationTitle + "' publisher: " + mdinfo.publisher + "'");
                mdinfo.proprietaryIdentifier = MetadataDbManager.truncateVarchar((String)name2, (int)32);
            } else {
                mdinfo.proprietaryIdentifier = name2;
            }
        }
        if (mdinfo.proprietarySeriesIdentifier != null) {
            name2 = mdinfo.proprietarySeriesIdentifier.trim();
            if (name2.length() > 32) {
                log.warning("proprietarySeriesIdentifier too long '" + mdinfo.proprietarySeriesIdentifier + "' for series title: '" + mdinfo.seriesTitle + "' publisher: " + mdinfo.publisher + "'");
                mdinfo.proprietarySeriesIdentifier = MetadataDbManager.truncateVarchar((String)name2, (int)32);
            } else {
                mdinfo.proprietarySeriesIdentifier = name2;
            }
        }
        return mdinfo;
    }

    private void replaceUnknownMdTitle(Connection conn, Long mdSequence, String unknownRoot, String title) throws DbException {
        String DEBUG_HEADER = "replaceGenSym(): ";
        Map names = this.mdManager.getMdItemNames(conn, mdSequence);
        if (log.isDebug3()) {
            log.debug3("replaceGenSym(): names.size() = " + names.size());
        }
        for (Map.Entry entry : names.entrySet()) {
            if (log.isDebug3()) {
                log.debug3("replaceGenSym(): entry = " + entry);
            }
            if (!((String)entry.getValue()).equals("primary")) continue;
            if (title.startsWith(unknownRoot)) {
                if (((String)entry.getKey()).startsWith(unknownRoot)) break;
                this.removeNotPrimarySynthesizedMdItemNames(conn, mdSequence);
                this.publicationTitle = (String)entry.getKey();
                break;
            }
            if (!((String)entry.getKey()).startsWith(unknownRoot)) break;
            this.updatePrimarySynthesizedMdItemName(conn, mdSequence, title);
            this.removeNotPrimaryMdItemName(conn, mdSequence, title);
            break;
        }
    }

    private void updatePrimarySynthesizedMdItemName(Connection conn, Long mdItemSeq, String primaryName) throws DbException {
        String DEBUG_HEADER = "updatePrimarySynthesizedMdItemName(): ";
        if (log.isDebug2()) {
            log.debug2("updatePrimarySynthesizedMdItemName(): mdItemSeq = " + mdItemSeq);
            log.debug2("updatePrimarySynthesizedMdItemName(): primaryName = " + primaryName);
        }
        PreparedStatement updatePrimaryName = this.dbManager.prepareStatement(conn, UPDATE_MD_ITEM_PRIMARY_NAME_QUERY);
        try {
            updatePrimaryName.setString(1, primaryName);
            updatePrimaryName.setLong(2, mdItemSeq);
            int count = this.dbManager.executeUpdate(updatePrimaryName);
            if (log.isDebug3()) {
                log.debug3("updatePrimarySynthesizedMdItemName(): count = " + count);
            }
        }
        catch (SQLException sqle) {
            log.error("Cannot update the primary name", (Throwable)sqle);
            log.error("mdItemSeq = '" + mdItemSeq + "'.");
            log.error("primaryName = '" + primaryName + "'.");
            log.error("SQL = 'update md_item_name set name = ? where md_item_seq = ? and name_type = 'primary''.");
            throw new DbException("Cannot update the primary name", (Throwable)sqle);
        }
        finally {
            MetadataDbManager.safeCloseStatement((Statement)updatePrimaryName);
        }
    }

    private void removeNotPrimarySynthesizedMdItemNames(Connection conn, Long mdItemSeq) throws DbException {
        String DEBUG_HEADER = "removeNotPrimarySynthesizedMdItemNames(): ";
        PreparedStatement deleteName = this.dbManager.prepareStatement(conn, DELETE_NOT_PRIMARY_MDITEM_NAMES_QUERY);
        try {
            deleteName.setLong(1, mdItemSeq);
            int count = this.dbManager.executeUpdate(deleteName);
            if (log.isDebug3()) {
                log.debug3("removeNotPrimarySynthesizedMdItemNames(): count = " + count);
            }
        }
        catch (SQLException sqle) {
            String message = "Cannot remove metadata item non-primary synthesized names";
            log.error(message, (Throwable)sqle);
            log.error("mdItemSeq = " + mdItemSeq + ".");
            log.error("SQL = 'delete from md_item_name where md_item_seq = ? and name like 'UNKNOWN_TITLE%' and name_type = 'not_primary''.");
            throw new DbException(message, (Throwable)sqle);
        }
        finally {
            MetadataDbManager.safeCloseStatement((Statement)deleteName);
        }
    }

    private void removeNotPrimaryMdItemName(Connection conn, Long mdItemSeq, String name) throws DbException {
        String DEBUG_HEADER = "removeNotPrimaryMdItemName(): ";
        PreparedStatement deleteName = this.dbManager.prepareStatement(conn, DELETE_NOT_PRIMARY_MDITEM_NAME_QUERY);
        try {
            deleteName.setLong(1, mdItemSeq);
            deleteName.setString(2, name);
            int count = this.dbManager.executeUpdate(deleteName);
            if (log.isDebug3()) {
                log.debug3("removeNotPrimaryMdItemName(): count = " + count);
            }
        }
        catch (SQLException sqle) {
            String message = "Cannot remove metadata item non-primary name";
            log.error(message, (Throwable)sqle);
            log.error("mdItemSeq = " + mdItemSeq + ".");
            log.error("name = '" + name + "'.");
            log.error("SQL = 'delete from md_item_name where md_item_seq = ? and name = ? and name_type = 'not_primary''.");
            throw new DbException(message, (Throwable)sqle);
        }
        finally {
            MetadataDbManager.safeCloseStatement((Statement)deleteName);
        }
    }

    Long storeMetadata(Connection conn, ArticleMetadataBuffer.ArticleMetadataInfo mdinfo) throws MetadataIndexingException, DbException {
        String DEBUG_HEADER = "storeMetadata(): ";
        if (log.isDebug3()) {
            log.debug3("storeMetadata(): Starting: auId = " + this.auId);
            log.debug3("storeMetadata(): auKey = " + this.auKey);
            log.debug3("storeMetadata(): auMdSeq = " + this.auMdSeq);
            log.debug3("storeMetadata(): mdinfo.articleTitle = " + mdinfo.articleTitle);
        }
        if (this.publisherSeq == null || !this.isSamePublisher(mdinfo)) {
            if (log.isDebug3()) {
                log.debug3("storeMetadata(): is new publisher.");
            }
            this.findOrCreatePublisher(conn, mdinfo);
            this.publicationSeq = null;
        }
        if (this.publicationSeq == null || !this.isSamePublication(mdinfo)) {
            log.debug3("storeMetadata(): is new publication.");
            this.publicationType = mdinfo.publicationType;
            log.debug3("storeMetadata(): publicationType = " + this.publicationType);
            if (!this.validateMdItemTypeHierarchy(this.publicationType, mdinfo.articleType)) {
                throw new MetadataIndexingException("Mismatch between articleType '" + mdinfo.articleType + "' and publicationType '" + this.publicationType + "'", mdinfo);
            }
            this.publicationTitle = mdinfo.publicationTitle;
            log.debug3("storeMetadata(): publicationTitle = " + this.publicationTitle);
            if (StringUtil.isNullString((String)this.publicationTitle)) {
                String defaultId = Long.toString(TimeBase.nowMs());
                this.publicationTitle = this.synthesizePublicationTitle(mdinfo, defaultId);
            }
            if ("bookSeries".equals(this.publicationType)) {
                this.seriesTitle = mdinfo.seriesTitle;
                log.debug3("storeMetadata(): seriesTitle = " + this.seriesTitle);
                if (StringUtil.isNullString((String)this.seriesTitle)) {
                    this.seriesTitle = this.synthesizeSeriesTitle(mdinfo, this.publicationTitle);
                }
                this.proprietarySeriesId = mdinfo.proprietarySeriesIdentifier;
                log.debug3("storeMetadata(): proprietarySeriesId = " + this.proprietarySeriesId);
            } else {
                this.seriesTitle = null;
                this.proprietarySeriesId = null;
            }
            this.pIsbn = mdinfo.isbn;
            log.debug3("storeMetadata(): pIsbn = " + this.pIsbn);
            this.eIsbn = mdinfo.eisbn;
            log.debug3("storeMetadata(): eIsbn = " + this.eIsbn);
            this.pIssn = mdinfo.issn;
            log.debug3("storeMetadata(): pIssn = " + this.pIssn);
            this.eIssn = mdinfo.eissn;
            log.debug3("storeMetadata(): eIssn = " + this.eIssn);
            this.proprietaryId = mdinfo.proprietaryIdentifier;
            log.debug3("storeMetadata(): proprietaryId = " + this.proprietaryId);
            this.volume = mdinfo.volume;
            log.debug3("storeMetadata(): volume = " + this.volume);
            this.publicationSeq = this.mdManager.findOrCreatePublication(conn, this.publisherSeq, this.pIssn, this.eIssn, this.pIsbn, this.eIsbn, this.publicationType, this.seriesTitle, this.proprietarySeriesId, this.publicationTitle, this.proprietaryId);
            log.debug3("storeMetadata(): publicationSeq = " + this.publicationSeq);
            this.parentSeq = this.mdManager.findPublicationMetadataItem(conn, this.publicationSeq);
            log.debug3("storeMetadata(): parentSeq = " + this.parentSeq);
            this.replaceUnknownMdTitle(conn, this.parentSeq, "UNKNOWN_TITLE", this.publicationTitle);
            this.parentMdItemType = this.getMdItemTypeName(conn, this.parentSeq);
            log.debug3("storeMetadata(): parentMdItemType = " + this.parentMdItemType);
            if (this.publicationSeq == null || this.parentSeq == null || this.parentMdItemType == null) {
                if (log.isDebug3()) {
                    log.debug3("storeMetadata(): Done: publicationSeq or parentSeq or parentMdItemType is null.");
                }
                return null;
            }
            if ("bookSeries".equals(this.publicationType) && !StringUtil.isNullString((String)this.seriesTitle)) {
                Long seriesPublicationSeq = this.mdManager.findBookSeries(conn, this.publisherSeq, this.pIssn, this.eIssn, this.seriesTitle);
                log.debug3("storeMetadata(): seriesPublicationSeq = " + seriesPublicationSeq);
                if (seriesPublicationSeq != null) {
                    Long seriesSeq = this.mdManager.findPublicationMetadataItem(conn, seriesPublicationSeq);
                    log.debug3("storeMetadata(): seriesMdSeq = " + seriesSeq);
                    if (seriesSeq != null) {
                        this.replaceUnknownMdTitle(conn, seriesSeq, "UNKNOWN_SERIES", this.seriesTitle);
                    }
                }
            }
        }
        this.populateAuDbDependencies(conn);
        if (this.auMdSeq == null) {
            this.auMdSeq = this.findAuMd(conn, this.auSeq);
            if (log.isDebug3()) {
                log.debug3("storeMetadata(): old auMdSeq = " + this.auMdSeq);
            }
        }
        if (this.auMdSeq == null) {
            String providerName = mdinfo.provider;
            if (log.isDebug3()) {
                log.debug3("storeMetadata(): providerName = " + providerName);
            }
            if (StringUtil.isNullString((String)providerName)) {
                providerName = this.publisherName;
                if (log.isDebug3()) {
                    log.debug3("storeMetadata(): providerName = " + providerName);
                }
            }
            this.addAuMd(conn, null, providerName);
            this.newAu = true;
        } else {
            this.updateAuMd(conn, this.auMdSeq, this.pluginVersion);
            log.debug3("storeMetadata(): updated AU.");
            this.updateAuUnknownProvider(conn, this.auMdSeq, mdinfo);
        }
        Long mdItemSeq = this.replaceOrCreateMdItem(conn, mdinfo);
        if (log.isDebug2()) {
            log.debug2("storeMetadata(): mdItemSeq = " + mdItemSeq);
        }
        return mdItemSeq;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void findOrCreatePublisher(Connection conn, ArticleMetadataBuffer.ArticleMetadataInfo mdinfo) throws MetadataIndexingException, DbException {
        String DEBUG_HEADER = "findOrCreatePublisher(): ";
        this.publisherName = mdinfo.publisher;
        if (log.isDebug3()) {
            log.debug3("findOrCreatePublisher(): publisherName = " + this.publisherName);
        }
        if (this.publisherName != null) {
            this.publisherSeq = this.dbManager.findOrCreatePublisher(conn, this.publisherName);
            if (log.isDebug3()) {
                log.debug3("findOrCreatePublisher(): publisherSeq = " + this.publisherSeq);
            }
        } else {
            this.auSeq = this.mdxManagerSql.findAuByAuId(conn, this.auId);
            if (log.isDebug3()) {
                log.debug3("findOrCreatePublisher(): auSeq = " + this.auSeq);
            }
            if (this.auSeq != null) {
                this.publisherSeq = this.mdxManager.findAuPublisher(conn, this.auSeq);
                if (log.isDebug3()) {
                    log.debug3("findOrCreatePublisher(): publisherSeq = " + this.publisherSeq);
                }
                if (this.publisherSeq == null) {
                    log.error("Null publisherSeq for auSeq = " + this.auSeq);
                    log.error("auId = " + this.auId);
                    log.error("auKey = " + this.auKey);
                    log.error("auMdSeq = " + this.auMdSeq);
                    log.error("auSeq = " + this.auSeq);
                    throw new MetadataIndexingException("Null publisherSeq for auSeq = " + this.auSeq, mdinfo);
                }
                this.publisherName = this.getPublisherName(conn, this.publisherSeq);
                if (log.isDebug3()) {
                    log.debug3("findOrCreatePublisher(): publisherName = " + this.publisherName);
                }
            } else {
                for (String problem : this.findAuProblems(conn, this.auId)) {
                    if (!problem.startsWith(UNKNOWN_PUBLISHER_AU_PROBLEM)) continue;
                    this.publisherSeq = this.dbManager.findPublisher(conn, problem);
                    if (log.isDebug3()) {
                        log.debug3("findOrCreatePublisher(): publisherSeq = " + this.publisherSeq);
                    }
                    if (this.publisherSeq != null) {
                        this.publisherName = problem;
                        break;
                    }
                    this.removeAuProblem(conn, this.auId, problem);
                }
                if (this.publisherName == null) {
                    this.publisherName = UNKNOWN_PUBLISHER_AU_PROBLEM + TimeBase.nowMs();
                    if (log.isDebug3()) {
                        log.debug3("findOrCreatePublisher(): publisherName = " + this.publisherName);
                    }
                    this.publisherSeq = this.dbManager.addPublisher(conn, this.publisherName);
                    if (log.isDebug3()) {
                        log.debug3("findOrCreatePublisher(): publisherSeq = " + this.publisherSeq);
                    }
                }
            }
        }
        if (log.isDebug2()) {
            log.debug2("findOrCreatePublisher(): Done.");
        }
    }

    boolean validateMdItemTypeHierarchy(String parentType, String childType) {
        if ("journal_article".equals(childType)) {
            return "journal".equals(parentType);
        }
        if ("book_chapter".equals(childType)) {
            return "book".equals(parentType) || "bookSeries".equals(parentType);
        }
        if ("book_volume".equals(childType)) {
            return "book".equals(parentType) || "bookSeries".equals(parentType);
        }
        if ("proceedings_article".equals(childType)) {
            return "proceedings".equals(parentType);
        }
        return false;
    }

    private String synthesizePublicationTitle(ArticleMetadataBuffer.ArticleMetadataInfo mdinfo, String defaultId) {
        String DEBUG_HEADER = "synthesizePublicationTitle(): ";
        String result = null;
        result = !StringUtil.isNullString((String)mdinfo.isbn) ? "UNKNOWN_TITLE/isbn=" + mdinfo.isbn : (!StringUtil.isNullString((String)mdinfo.eisbn) ? "UNKNOWN_TITLE/eisbn=" + mdinfo.eisbn : (!StringUtil.isNullString((String)mdinfo.issn) ? "UNKNOWN_TITLE/issn=" + mdinfo.issn : (!StringUtil.isNullString((String)mdinfo.eissn) ? "UNKNOWN_TITLE/eissn=" + mdinfo.eissn : (!StringUtil.isNullString((String)mdinfo.proprietaryIdentifier) ? "UNKNOWN_TITLE/journalId=" + mdinfo.proprietaryIdentifier : "UNKNOWN_TITLE/id=" + defaultId))));
        if (log.isDebug2()) {
            log.debug2("synthesizePublicationTitle(): result = " + result);
        }
        return result;
    }

    private String synthesizeSeriesTitle(ArticleMetadataBuffer.ArticleMetadataInfo mdinfo, String defaultId) {
        String DEBUG_HEADER = "synthesizeSeriesTitle(): ";
        String result = null;
        result = !StringUtil.isNullString((String)mdinfo.issn) ? "UNKNOWN_SERIES/issn=" + mdinfo.issn : (!StringUtil.isNullString((String)mdinfo.eissn) ? "UNKNOWN_SERIES/eissn=" + mdinfo.eissn : (!StringUtil.isNullString((String)mdinfo.proprietarySeriesIdentifier) ? "UNKNOWN_SERIES/seriesId=" + mdinfo.proprietarySeriesIdentifier : "UNKNOWN_SERIES/id=" + defaultId));
        if (log.isDebug2()) {
            log.debug2("synthesizeSeriesTitle(): result = " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAuMd(Connection conn, Long auMdSeq, int version) throws DbException {
        String DEBUG_HEADER = "updateAuMd(): ";
        try (PreparedStatement updateAu = this.dbManager.prepareStatement(conn, UPDATE_AU_MD_VERSION_QUERY);){
            updateAu.setShort(1, (short)version);
            updateAu.setLong(2, auMdSeq);
            int count = this.dbManager.executeUpdate(updateAu);
            if (log.isDebug3()) {
                log.debug3("updateAuMd(): count = " + count);
                log.debug3("updateAuMd(): Updated auMdSeq = " + auMdSeq);
            }
        }
        catch (SQLException sqle) {
            throw new DbException("Cannot update AU metadata version", (Throwable)sqle);
        }
    }

    private Long replaceOrCreateMdItem(Connection conn, ArticleMetadataBuffer.ArticleMetadataInfo mdinfo) throws DbException {
        String mdItemType;
        long fetchTime;
        Map<String, String> featuredUrlMap;
        String doi;
        String coverage;
        String itemTitle;
        String itemNo;
        String endPage;
        String startPage;
        String issue;
        String date;
        boolean addedNewItem;
        block39: {
            String DEBUG_HEADER = "replaceOrCreateMdItem(): ";
            if (log.isDebug2()) {
                log.debug2("replaceOrCreateMdItem(): Starting...");
            }
            addedNewItem = false;
            date = mdinfo.pubDate;
            if (log.isDebug3()) {
                log.debug3("replaceOrCreateMdItem(): date = " + date);
            }
            issue = mdinfo.issue;
            if (log.isDebug3()) {
                log.debug3("replaceOrCreateMdItem(): issue = " + issue);
            }
            startPage = mdinfo.startPage;
            if (log.isDebug3()) {
                log.debug3("replaceOrCreateMdItem(): startPage = " + startPage);
            }
            endPage = mdinfo.endPage;
            if (log.isDebug3()) {
                log.debug3("replaceOrCreateMdItem(): endPage = " + endPage);
            }
            itemNo = mdinfo.itemNumber;
            if (log.isDebug3()) {
                log.debug3("replaceOrCreateMdItem(): itemNo = " + itemNo);
            }
            itemTitle = mdinfo.articleTitle;
            if (log.isDebug3()) {
                log.debug3("replaceOrCreateMdItem(): itemTitle = " + itemTitle);
            }
            coverage = mdinfo.coverage;
            if (log.isDebug3()) {
                log.debug3("replaceOrCreateMdItem(): coverage = " + coverage);
            }
            doi = mdinfo.doi;
            if (log.isDebug3()) {
                log.debug3("replaceOrCreateMdItem(): doi = " + doi);
            }
            featuredUrlMap = mdinfo.featuredUrlMap;
            if (log.isDebug3()) {
                for (String feature : featuredUrlMap.keySet()) {
                    if (!log.isDebug3()) continue;
                    log.debug3("replaceOrCreateMdItem(): feature = " + feature + ", URL = " + featuredUrlMap.get(feature));
                }
            }
            fetchTime = -1L;
            try {
                fetchTime = Long.valueOf(mdinfo.fetchTime);
            }
            catch (NumberFormatException nfe) {
                if (!log.isDebug()) break block39;
                log.debug("Unparsable fetch time '" + mdinfo.fetchTime + "'");
            }
        }
        if (log.isDebug3()) {
            log.debug3("replaceOrCreateMdItem(): fetchTime = " + fetchTime);
        }
        String accessUrl = mdinfo.accessUrl;
        if (log.isDebug3()) {
            log.debug3("replaceOrCreateMdItem(): accessUrl = " + accessUrl);
        }
        if (StringUtil.isNullString((String)(mdItemType = mdinfo.articleType))) {
            log.error("replaceOrCreateMdItem(): Unknown mdItemType = " + mdItemType);
            return null;
        }
        if (log.isDebug3()) {
            log.debug3("replaceOrCreateMdItem(): mdItemType = " + mdItemType);
        }
        Long mdItemTypeSeq = this.mdManager.findMetadataItemType(conn, mdItemType);
        if (log.isDebug3()) {
            log.debug3("replaceOrCreateMdItem(): mdItemTypeSeq = " + mdItemTypeSeq);
        }
        if (mdItemTypeSeq == null) {
            log.error("replaceOrCreateMdItem(): Unknown articleType = " + mdItemType);
            return null;
        }
        Long mdItemSeq = null;
        if (!this.newAu) {
            mdItemSeq = this.findMdItem(conn, mdItemTypeSeq, this.auMdSeq, accessUrl);
            if (log.isDebug3()) {
                log.debug3("replaceOrCreateMdItem(): mdItemSeq = " + mdItemSeq);
            }
            if (mdItemSeq != null) {
                int deletedCount = this.mdxManagerSql.removeAuChildMetadataItem(conn, this.auMdSeq, mdItemSeq);
                if (log.isDebug3()) {
                    log.debug3("replaceOrCreateMdItem(): deletedCount = " + deletedCount);
                }
            } else {
                addedNewItem = true;
                if (log.isDebug3()) {
                    log.debug3("replaceOrCreateMdItem(): New item: addedNewItem = " + addedNewItem);
                }
            }
        } else {
            addedNewItem = true;
            if (log.isDebug3()) {
                log.debug3("replaceOrCreateMdItem(): New AU: addedNewItem = " + addedNewItem);
            }
        }
        mdItemSeq = this.mdManager.addMdItem(conn, this.parentSeq, mdItemTypeSeq, this.auMdSeq, date, coverage, fetchTime);
        if (log.isDebug3()) {
            log.debug3("replaceOrCreateMdItem(): new mdItemSeq = " + mdItemSeq);
        }
        this.mdManager.addMdItemName(conn, mdItemSeq, itemTitle, "primary");
        String volume = mdinfo.volume;
        if (log.isDebug3()) {
            log.debug3("replaceOrCreateMdItem(): volume = " + volume);
        }
        int addedCount = this.dbManager.addBibItem(conn, mdItemSeq, volume, issue, startPage, endPage, itemNo);
        if (log.isDebug3()) {
            log.debug3("replaceOrCreateMdItem(): addedCount = " + addedCount);
        }
        this.mdxManager.addMdItemUrls(conn, mdItemSeq, accessUrl, featuredUrlMap);
        if (log.isDebug3()) {
            log.debug3("replaceOrCreateMdItem(): added AUItem URL.");
        }
        Collection<String> authors = mdinfo.authors;
        if (log.isDebug3()) {
            log.debug3("replaceOrCreateMdItem(): authors = " + authors);
        }
        this.mdxManagerSql.addMdItemAuthors(conn, mdItemSeq, authors);
        if (log.isDebug3()) {
            log.debug3("replaceOrCreateMdItem(): added AUItem authors.");
        }
        Collection<String> keywords = mdinfo.keywords;
        if (log.isDebug3()) {
            log.debug3("replaceOrCreateMdItem(): keywords = " + keywords);
        }
        this.mdxManagerSql.addMdItemKeywords(conn, mdItemSeq, keywords);
        if (log.isDebug3()) {
            log.debug3("replaceOrCreateMdItem(): added AUItem keywords.");
        }
        this.mdManager.addMdItemDoi(conn, mdItemSeq, doi);
        if (log.isDebug3()) {
            log.debug3("replaceOrCreateMdItem(): added AUItem DOI.");
        }
        if (log.isDebug3()) {
            log.debug3("replaceOrCreateMdItem(): addedNewItem = " + addedNewItem);
        }
        if (addedNewItem && this.task != null) {
            this.task.incrementUpdatedArticleCount();
        }
        if (log.isDebug2()) {
            log.debug2("replaceOrCreateMdItem(): mdItemSeq = " + mdItemSeq);
        }
        return mdItemSeq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMdItemTypeName(Connection conn, Long mdItemSeq) throws DbException {
        String DEBUG_HEADER = "getMdItemTypeName(): ";
        String typeName = null;
        try {
            ResultSet resultSet;
            PreparedStatement getMdItemTypeName;
            block4: {
                getMdItemTypeName = this.dbManager.prepareStatement(conn, GET_MD_ITEM_TYPE_NAME_QUERY);
                resultSet = null;
                try {
                    getMdItemTypeName.setLong(1, mdItemSeq);
                    resultSet = this.dbManager.executeQuery(getMdItemTypeName);
                    if (!resultSet.next()) break block4;
                    typeName = resultSet.getString("type_name");
                    log.debug3("getMdItemTypeName(): typeName = " + typeName);
                }
                catch (Throwable throwable) {
                    MetadataDbManager.safeCloseResultSet(resultSet);
                    getMdItemTypeName.close();
                    throw throwable;
                }
            }
            MetadataDbManager.safeCloseResultSet((ResultSet)resultSet);
            getMdItemTypeName.close();
        }
        catch (SQLException sqle) {
            throw new DbException("Cannot get a metadata item type name", (Throwable)sqle);
        }
        return typeName;
    }

    private Long findAuMd(Connection conn, Long auSeq) throws DbException {
        String DEBUG_HEADER = "findAuMd(): ";
        Long auMdSeq = null;
        ResultSet resultSet = null;
        PreparedStatement findAuMd = this.dbManager.prepareStatement(conn, FIND_AU_MD_QUERY);
        try {
            findAuMd.setLong(1, auSeq);
            resultSet = this.dbManager.executeQuery(findAuMd);
            if (resultSet.next()) {
                auMdSeq = resultSet.getLong("au_md_seq");
            }
        }
        catch (SQLException sqle) {
            try {
                throw new DbException("Cannot find AU metadata", (Throwable)sqle);
            }
            catch (Throwable throwable) {
                MetadataDbManager.safeCloseResultSet(resultSet);
                MetadataDbManager.safeCloseStatement((Statement)findAuMd);
                throw throwable;
            }
        }
        MetadataDbManager.safeCloseResultSet((ResultSet)resultSet);
        MetadataDbManager.safeCloseStatement((Statement)findAuMd);
        log.debug3("findAuMd(): auMdSeq = " + auMdSeq);
        return auMdSeq;
    }

    private Long findMdItem(Connection conn, Long mdItemTypeSeq, Long auMdSeq, String accessUrl) throws DbException {
        String DEBUG_HEADER = "findMdItem(): ";
        Long mdItemSeq = null;
        ResultSet resultSet = null;
        PreparedStatement findMdItem = this.dbManager.prepareStatement(conn, FIND_MD_ITEM_QUERY);
        try {
            findMdItem.setLong(1, mdItemTypeSeq);
            findMdItem.setLong(2, auMdSeq);
            findMdItem.setString(3, accessUrl);
            resultSet = this.dbManager.executeQuery(findMdItem);
            if (resultSet.next()) {
                mdItemSeq = resultSet.getLong("md_item_seq");
            }
        }
        catch (SQLException sqle) {
            try {
                throw new DbException("Cannot find metadata item", (Throwable)sqle);
            }
            catch (Throwable throwable) {
                MetadataDbManager.safeCloseResultSet(resultSet);
                MetadataDbManager.safeCloseStatement((Statement)findMdItem);
                throw throwable;
            }
        }
        MetadataDbManager.safeCloseResultSet((ResultSet)resultSet);
        MetadataDbManager.safeCloseStatement((Statement)findMdItem);
        log.debug3("findMdItem(): mdItemSeq = " + mdItemSeq);
        return mdItemSeq;
    }

    private boolean isSamePublisher(ArticleMetadataBuffer.ArticleMetadataInfo mdinfo) {
        return this.isSameProperty(this.publisherName, mdinfo.publisher);
    }

    private boolean isSamePublication(ArticleMetadataBuffer.ArticleMetadataInfo mdinfo) {
        return this.isSameProperty(this.publicationTitle, mdinfo.publicationTitle) && this.isSameProperty(this.publicationType, mdinfo.publicationType) && this.isSameProperty(this.pIsbn, mdinfo.isbn) && this.isSameProperty(this.eIsbn, mdinfo.eisbn) && this.isSameProperty(this.pIssn, mdinfo.issn) && this.isSameProperty(this.eIssn, mdinfo.eissn) && this.isSameProperty(this.proprietaryId, mdinfo.proprietaryIdentifier) && this.isSameProperty(this.volume, mdinfo.volume) && this.isSameProperty(this.seriesTitle, mdinfo.seriesTitle) && this.isSameProperty(this.proprietarySeriesId, mdinfo.proprietarySeriesIdentifier);
    }

    private boolean isSameProperty(String previous, String current) {
        if (!StringUtil.isNullString((String)previous)) {
            return !StringUtil.isNullString((String)current) && previous.equals(current);
        }
        return StringUtil.isNullString((String)current);
    }

    private String getPublisherName(Connection conn, Long publisherSeq) throws DbException {
        String DEBUG_HEADER = "getPublisherName(): ";
        String publisherName = null;
        ResultSet resultSet = null;
        PreparedStatement getPublisherNameStatement = this.dbManager.prepareStatement(conn, GET_PUBLISHER_NAME_QUERY);
        try {
            getPublisherNameStatement.setLong(1, publisherSeq);
            resultSet = this.dbManager.executeQuery(getPublisherNameStatement);
            if (resultSet.next()) {
                publisherName = resultSet.getString("publisher_name");
            }
        }
        catch (SQLException sqle) {
            try {
                log.error("Cannot get the name of a publisher", (Throwable)sqle);
                log.error("publisherSeq = '" + publisherSeq + "'.");
                log.error("SQL = 'select publisher_name from publisher where publisher_seq = ?'.");
                throw new DbException("Cannot get the name of a publisher", (Throwable)sqle);
            }
            catch (Throwable throwable) {
                MetadataDbManager.safeCloseResultSet(resultSet);
                MetadataDbManager.safeCloseStatement((Statement)getPublisherNameStatement);
                throw throwable;
            }
        }
        MetadataDbManager.safeCloseResultSet((ResultSet)resultSet);
        MetadataDbManager.safeCloseStatement((Statement)getPublisherNameStatement);
        log.debug3("getPublisherName(): publisherName = " + publisherName);
        return publisherName;
    }

    private List<String> findAuProblems(Connection conn, String auId) throws DbException {
        String DEBUG_HEADER = "findAuProblems(): ";
        if (log.isDebug3()) {
            log.debug3("findAuProblems(): auId = " + auId);
        }
        ArrayList<String> problems = new ArrayList<String>();
        ResultSet results = null;
        PreparedStatement findProblems = this.dbManager.prepareStatement(conn, FIND_AU_PROBLEMS_QUERY);
        try {
            String pluginId = PluginManager.pluginIdFromAuId((String)auId);
            if (log.isDebug3()) {
                log.debug3("findAuProblems(): pluginId = " + pluginId);
            }
            String auKey = PluginManager.auKeyFromAuId((String)auId);
            if (log.isDebug3()) {
                log.debug3("findAuProblems(): auKey = " + auKey);
            }
            findProblems.setString(1, pluginId);
            findProblems.setString(2, auKey);
            results = this.dbManager.executeQuery(findProblems);
            while (results.next()) {
                String problem = results.getString("problem");
                if (log.isDebug3()) {
                    log.debug3("findAuProblems(): problem = " + problem);
                }
                problems.add(problem);
            }
        }
        catch (SQLException sqle) {
            try {
                log.error("Cannot find AU problems", (Throwable)sqle);
                log.error("auId = '" + auId + "'.");
                log.error("SQL = 'select problem from au_problem where plugin_id = ? and au_key = ?'.");
                throw new DbException("Cannot find AU problems", (Throwable)sqle);
            }
            catch (Throwable throwable) {
                MetadataDbManager.safeCloseResultSet(results);
                MetadataDbManager.safeCloseStatement((Statement)findProblems);
                throw throwable;
            }
        }
        MetadataDbManager.safeCloseResultSet((ResultSet)results);
        MetadataDbManager.safeCloseStatement((Statement)findProblems);
        return problems;
    }

    private void removeAuProblem(Connection conn, String auId, String problem) throws DbException {
        String DEBUG_HEADER = "removeAuProblem(): ";
        PreparedStatement deleteAuProblem = this.dbManager.prepareStatement(conn, DELETE_AU_PROBLEM_QUERY);
        try {
            String pluginId = PluginManager.pluginIdFromAuId((String)auId);
            if (log.isDebug3()) {
                log.debug3("removeAuProblem(): pluginId = " + pluginId);
            }
            String auKey = PluginManager.auKeyFromAuId((String)auId);
            if (log.isDebug3()) {
                log.debug3("removeAuProblem(): auKey = " + auKey);
            }
            deleteAuProblem.setString(1, pluginId);
            deleteAuProblem.setString(2, auKey);
            deleteAuProblem.setString(3, problem);
            int count = this.dbManager.executeUpdate(deleteAuProblem);
            if (log.isDebug3()) {
                log.debug3("removeAuProblem(): count = " + count);
            }
        }
        catch (SQLException sqle) {
            log.error("Cannot remove problem AU entry", (Throwable)sqle);
            log.error("auId = '" + auId + "'.");
            log.error("problem = '" + problem + "'.");
            log.error("SQL = 'delete from au_problem where plugin_id = ? and au_key = ? and problem = ?'.");
            throw new DbException("Cannot remove problem AU entry", (Throwable)sqle);
        }
        finally {
            MetadataDbManager.safeCloseStatement((Statement)deleteAuProblem);
        }
    }

    private void addAuProblem(Connection conn, String auId, String problem) throws DbException {
        String DEBUG_HEADER = "addAuProblem(): ";
        PreparedStatement addAuProblemStatement = this.dbManager.prepareStatement(conn, INSERT_AU_PROBLEM_QUERY);
        try {
            String pluginId = PluginManager.pluginIdFromAuId((String)auId);
            if (log.isDebug3()) {
                log.debug3("addAuProblem(): pluginId = " + pluginId);
            }
            String auKey = PluginManager.auKeyFromAuId((String)auId);
            if (log.isDebug3()) {
                log.debug3("addAuProblem(): auKey = " + auKey);
            }
            addAuProblemStatement.setString(1, pluginId);
            addAuProblemStatement.setString(2, auKey);
            addAuProblemStatement.setString(3, problem);
            int count = this.dbManager.executeUpdate(addAuProblemStatement);
            if (log.isDebug3()) {
                log.debug3("addAuProblem(): count = " + count);
            }
        }
        catch (SQLException sqle) {
            log.error("Cannot add problem AU entry", (Throwable)sqle);
            log.error("auId = '" + auId + "'.");
            log.error("problem = '" + problem + "'.");
            log.error("SQL = 'insert into au_problem(plugin_id,au_key,problem) values (?,?,?)'.");
            throw new DbException("Cannot add problem AU entry", (Throwable)sqle);
        }
        finally {
            MetadataDbManager.safeCloseStatement((Statement)addAuProblemStatement);
        }
    }

    private void fixUnknownPublishersAuData(Connection conn, List<String> problems) throws MetadataIndexingException, DbException {
        String DEBUG_HEADER = "fixUnknownPublishersAuData(): ";
        log.debug3("fixUnknownPublishersAuData(): Starting...");
        for (String problem : problems) {
            if (this.task.isCancelled()) {
                throw new MetadataIndexingException("Reindexing task cancelled");
            }
            if (!problem.startsWith(UNKNOWN_PUBLISHER_AU_PROBLEM)) continue;
            log.debug3("fixUnknownPublishersAuData(): Need to migrate data under publisher '" + problem + "' to publisher '" + this.publisherName + "'.");
            this.fixUnknownPublisherAuData(conn, problem);
        }
        log.debug3("fixUnknownPublishersAuData(): Done.");
    }

    private void fixUnknownPublisherAuData(Connection conn, String unknownPublisherName) throws MetadataIndexingException, DbException {
        String DEBUG_HEADER = "fixUnknownPublisherAuData(): ";
        log.debug3("fixUnknownPublisherAuData(): unknownPublisherName = " + unknownPublisherName);
        Long unknownPublisherSeq = this.dbManager.findPublisher(conn, unknownPublisherName);
        log.debug3("fixUnknownPublisherAuData(): unknownPublisherSeq = " + unknownPublisherSeq);
        if (unknownPublisherSeq != null && unknownPublisherSeq != this.publisherSeq) {
            Set<Long> unknownPublicationSeqs = this.findPublisherPublications(conn, unknownPublisherSeq);
            Set<Long> mdItemSeqs = this.findPublicationChildMetadataItems(conn, this.publicationSeq);
            HashMap<String, Long> mdItemMapByName = new HashMap<String, Long>();
            for (Long mdItemSeq : mdItemSeqs) {
                if (this.task.isCancelled()) {
                    throw new MetadataIndexingException("Reindexing task cancelled");
                }
                Map mdItemSeqNames = this.mdManager.getMdItemNames(conn, mdItemSeq);
                for (String mdItemSeqName : mdItemSeqNames.keySet()) {
                    mdItemMapByName.put(mdItemSeqName, mdItemSeq);
                }
            }
            for (Long unknownPublicationSeq : unknownPublicationSeqs) {
                if (this.task.isCancelled()) {
                    throw new MetadataIndexingException("Reindexing task cancelled");
                }
                log.debug3("fixUnknownPublisherAuData(): unknownPublicationSeq = " + unknownPublicationSeq);
                if (unknownPublicationSeq == this.publicationSeq) continue;
                this.fixUnknownPublisherPublicationMetadata(conn, unknownPublicationSeq, mdItemMapByName);
                this.fixUnknownPublisherPublicationCounterReportsData(conn, unknownPublicationSeq);
                this.removeUnknownPublisherPublicationMdItem(conn, unknownPublicationSeq);
                this.removeUnknownPublisherPublication(conn, unknownPublicationSeq);
            }
        }
        this.removeUnknownPublisher(conn, unknownPublisherName);
        this.removeAuProblem(conn, this.auId, unknownPublisherName);
        log.debug3("fixUnknownPublisherAuData(): Done.");
    }

    private Set<Long> findPublisherPublications(Connection conn, Long publisherSeq) throws DbException {
        String DEBUG_HEADER = "findPublisherPublications(): ";
        HashSet<Long> publicationSeqs = new HashSet<Long>();
        Long publicationSeq = null;
        ResultSet resultSet = null;
        PreparedStatement findPublications = this.dbManager.prepareStatement(conn, FIND_PUBLISHER_PUBLICATIONS_QUERY);
        try {
            findPublications.setLong(1, publisherSeq);
            resultSet = this.dbManager.executeQuery(findPublications);
            while (resultSet.next()) {
                publicationSeq = resultSet.getLong("publication_seq");
                log.debug3("findPublisherPublications(): publicationSeq = " + publicationSeq);
                publicationSeqs.add(publicationSeq);
            }
        }
        catch (SQLException sqle) {
            try {
                log.error("Cannot find the publications of a publisher", (Throwable)sqle);
                log.error("publisherSeq = '" + publisherSeq + "'.");
                log.error("SQL = 'select publication_seq from publication where publisher_seq = ?'.");
                throw new DbException("Cannot find the publications of a publisher", (Throwable)sqle);
            }
            catch (Throwable throwable) {
                MetadataDbManager.safeCloseResultSet(resultSet);
                MetadataDbManager.safeCloseStatement((Statement)findPublications);
                throw throwable;
            }
        }
        MetadataDbManager.safeCloseResultSet((ResultSet)resultSet);
        MetadataDbManager.safeCloseStatement((Statement)findPublications);
        return publicationSeqs;
    }

    private Set<Long> findPublicationChildMetadataItems(Connection conn, Long publicationSeq) throws DbException {
        String DEBUG_HEADER = "findPublicationChildMetadataItems(): ";
        HashSet<Long> mdItemSeqs = new HashSet<Long>();
        Long mdItemSeq = null;
        ResultSet resultSet = null;
        PreparedStatement findMdItems = this.dbManager.prepareStatement(conn, FIND_PUBLICATION_CHILD_MD_ITEMS_QUERY);
        try {
            findMdItems.setLong(1, publicationSeq);
            resultSet = this.dbManager.executeQuery(findMdItems);
            while (resultSet.next()) {
                mdItemSeq = resultSet.getLong("md_item_seq");
                log.debug3("findPublicationChildMetadataItems(): mdItemSeq = " + mdItemSeq);
                mdItemSeqs.add(mdItemSeq);
            }
        }
        catch (SQLException sqle) {
            try {
                log.error("Cannot find the child metadata items of a publication", (Throwable)sqle);
                log.error("publicationSeq = '" + publicationSeq + "'.");
                log.error("SQL = 'select distinct m.md_item_seq from publication p,md_item m where p.publication_seq = ? and p.md_item_seq = m.parent_seq'.");
                throw new DbException("Cannot find the child metadata items of a publication", (Throwable)sqle);
            }
            catch (Throwable throwable) {
                MetadataDbManager.safeCloseResultSet(resultSet);
                MetadataDbManager.safeCloseStatement((Statement)findMdItems);
                throw throwable;
            }
        }
        MetadataDbManager.safeCloseResultSet((ResultSet)resultSet);
        MetadataDbManager.safeCloseStatement((Statement)findMdItems);
        return mdItemSeqs;
    }

    private void fixUnknownPublisherPublicationMetadata(Connection conn, Long unknownPublicationSeq, Map<String, Long> mdItemMapByName) throws DbException {
        String DEBUG_HEADER = "fixUnknownPublisherPublicationMetadata(): ";
        log.debug3("fixUnknownPublisherPublicationMetadata(): unknownPublicationSeq = " + unknownPublicationSeq);
        Set<Long> unknownMdItemSeqs = this.findPublicationChildMetadataItems(conn, unknownPublicationSeq);
        for (Long unknownMdItemSeq : unknownMdItemSeqs) {
            boolean merged = false;
            Map unknownMdItemSeqNames = this.mdManager.getMdItemNames(conn, unknownMdItemSeq);
            for (String unknownMdItemSeqName : unknownMdItemSeqNames.keySet()) {
                if (!mdItemMapByName.containsKey(unknownMdItemSeqName)) continue;
                this.mdxManager.mergeChildMdItemProperties(conn, unknownMdItemSeq, mdItemMapByName.get(unknownMdItemSeqName));
                merged = true;
                break;
            }
            if (merged) continue;
            this.updateMdItemParentSeq(conn, unknownMdItemSeq, this.parentSeq);
        }
        Long unknownParentSeq = this.mdManager.findPublicationMetadataItem(conn, unknownPublicationSeq);
        log.debug3("fixUnknownPublisherPublicationMetadata(): unknownParentSeq = " + unknownParentSeq);
        this.mdxManager.mergeParentMdItemProperties(conn, unknownParentSeq, this.parentSeq);
        log.debug3("fixUnknownPublisherPublicationMetadata(): Done.");
    }

    private void updateMdItemParentSeq(Connection conn, Long mdItemSeq, Long parentSeq) throws DbException {
        String DEBUG_HEADER = "updateMdItemParentSeq(): ";
        if (log.isDebug2()) {
            log.debug2("updateMdItemParentSeq(): mdItemSeq = " + mdItemSeq);
            log.debug2("updateMdItemParentSeq(): parentSeq = " + parentSeq);
        }
        PreparedStatement updateParentSeq = this.dbManager.prepareStatement(conn, UPDATE_MD_ITEM_PARENT_SEQ_QUERY);
        try {
            updateParentSeq.setLong(1, parentSeq);
            updateParentSeq.setLong(2, mdItemSeq);
            int count = this.dbManager.executeUpdate(updateParentSeq);
            if (log.isDebug3()) {
                log.debug3("updateMdItemParentSeq(): count = " + count);
            }
        }
        catch (SQLException sqle) {
            log.error("Cannot update the parent sequence", (Throwable)sqle);
            log.error("mdItemSeq = '" + mdItemSeq + "'.");
            log.error("parentSeq = '" + parentSeq + "'.");
            log.error("SQL = 'update md_item set parent_seq = ? where md_item_seq = ?'.");
            throw new DbException("Cannot update the parent sequence", (Throwable)sqle);
        }
        finally {
            MetadataDbManager.safeCloseStatement((Statement)updateParentSeq);
        }
    }

    private void fixUnknownPublisherPublicationCounterReportsData(Connection conn, Long unknownPublicationSeq) throws DbException {
        String DEBUG_HEADER = "fixUnknownPublisherPublicationCounterReportsData(): ";
        log.debug3("fixUnknownPublisherPublicationCounterReportsData(): unknownPublicationSeq = " + unknownPublicationSeq);
        CounterReportsManager crManager = LockssDaemon.getLockssDaemon().getCounterReportsManager();
        crManager.mergeBookTypeAggregates(conn, unknownPublicationSeq, this.publicationSeq);
        crManager.deleteBookTypeAggregates(conn, unknownPublicationSeq);
        crManager.mergeJournalTypeAggregates(conn, unknownPublicationSeq, this.publicationSeq);
        crManager.deleteJournalTypeAggregates(conn, unknownPublicationSeq);
        crManager.mergeJournalPubYearAggregates(conn, unknownPublicationSeq, this.publicationSeq);
        crManager.deleteJournalPubYearAggregates(conn, unknownPublicationSeq);
        log.debug3("fixUnknownPublisherPublicationCounterReportsData(): Done.");
    }

    private int removeUnknownPublisherPublicationMdItem(Connection conn, Long publicationSeq) throws DbException {
        String DEBUG_HEADER = "removeUnknownPublisherPublicationMdItem(): ";
        log.debug3("removeUnknownPublisherPublicationMdItem(): publicationSeq = " + publicationSeq);
        int count = 0;
        if (publicationSeq != null) {
            log.debug3("removeUnknownPublisherPublicationMdItem(): SQL = 'delete from md_item where md_item_seq in (select md_item_seq from publication where publication_seq = ? and (select count(*) from publisher pr,publication p where pr.publisher_seq = p.publisher_seq and p.publication_seq = ? and pr.publisher_name like 'UNKNOWN_PUBLISHER%') = 1)'.");
            PreparedStatement deleteMdItem = null;
            try {
                deleteMdItem = this.dbManager.prepareStatement(conn, DELETE_UNKNOWN_PUBLISHER_PUBLICATION_MD_ITEM_QUERY);
                deleteMdItem.setLong(1, publicationSeq);
                deleteMdItem.setLong(2, publicationSeq);
                count = this.dbManager.executeUpdate(deleteMdItem);
            }
            catch (SQLException sqle) {
                try {
                    log.error("Cannot delete an unknown publisher publication", (Throwable)sqle);
                    log.error("publicationSeq = " + publicationSeq);
                    log.error("SQL = 'delete from md_item where md_item_seq in (select md_item_seq from publication where publication_seq = ? and (select count(*) from publisher pr,publication p where pr.publisher_seq = p.publisher_seq and p.publication_seq = ? and pr.publisher_name like 'UNKNOWN_PUBLISHER%') = 1)'.");
                    throw new DbException("Cannot delete an unknown publisher publication", (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    MetadataDbManager.safeCloseStatement(deleteMdItem);
                    throw throwable;
                }
            }
            MetadataDbManager.safeCloseStatement((Statement)deleteMdItem);
        }
        log.debug3("removeUnknownPublisherPublicationMdItem(): count = " + count);
        return count;
    }

    private int removeUnknownPublisherPublication(Connection conn, Long publicationSeq) throws DbException {
        String DEBUG_HEADER = "removeUnknownPublisherPublication(): ";
        log.debug3("removeUnknownPublisherPublication(): publicationSeq = " + publicationSeq);
        int count = 0;
        if (publicationSeq != null) {
            log.debug3("removeUnknownPublisherPublication(): SQL = 'delete from publication where publication_seq = ? and (select count(*) from publisher pr,publication p where pr.publisher_seq = p.publisher_seq and p.publication_seq = ? and pr.publisher_name like 'UNKNOWN_PUBLISHER%') = 1'.");
            PreparedStatement deletePublication = null;
            try {
                deletePublication = this.dbManager.prepareStatement(conn, DELETE_UNKNOWN_PUBLISHER_PUBLICATION_QUERY);
                deletePublication.setLong(1, publicationSeq);
                deletePublication.setLong(2, publicationSeq);
                count = this.dbManager.executeUpdate(deletePublication);
            }
            catch (SQLException sqle) {
                try {
                    log.error("Cannot delete an unknown publisher publication", (Throwable)sqle);
                    log.error("publicationSeq = " + publicationSeq);
                    log.error("SQL = 'delete from publication where publication_seq = ? and (select count(*) from publisher pr,publication p where pr.publisher_seq = p.publisher_seq and p.publication_seq = ? and pr.publisher_name like 'UNKNOWN_PUBLISHER%') = 1'.");
                    throw new DbException("Cannot delete an unknown publisher publication", (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    MetadataDbManager.safeCloseStatement(deletePublication);
                    throw throwable;
                }
            }
            MetadataDbManager.safeCloseStatement((Statement)deletePublication);
        }
        log.debug3("removeUnknownPublisherPublication(): count = " + count);
        return count;
    }

    private int removeUnknownPublisher(Connection conn, String publisherName) throws DbException {
        String DEBUG_HEADER = "removeUnknownPublisherPublication(): ";
        log.debug3("removeUnknownPublisherPublication(): publicationSeq = " + this.publicationSeq);
        int count = 0;
        if (publisherName != null && publisherName.startsWith(UNKNOWN_PUBLISHER_AU_PROBLEM)) {
            log.debug3("removeUnknownPublisherPublication(): SQL = 'delete from publisher where publisher_name = ? and publisher_name like 'UNKNOWN_PUBLISHER%''.");
            PreparedStatement deletePublisher = null;
            try {
                deletePublisher = this.dbManager.prepareStatement(conn, DELETE_UNKNOWN_PUBLISHER_QUERY);
                deletePublisher.setString(1, publisherName);
                count = this.dbManager.executeUpdate(deletePublisher);
            }
            catch (SQLException sqle) {
                try {
                    log.error("Cannot delete an unknown publisher", (Throwable)sqle);
                    log.error("publisherName = " + publisherName);
                    log.error("SQL = 'delete from publisher where publisher_name = ? and publisher_name like 'UNKNOWN_PUBLISHER%''.");
                    throw new DbException("Cannot delete an unknown publisher", (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    MetadataDbManager.safeCloseStatement(deletePublisher);
                    throw throwable;
                }
            }
            MetadataDbManager.safeCloseStatement((Statement)deletePublisher);
        }
        log.debug3("removeUnknownPublisherPublication(): count = " + count);
        return count;
    }

    private void populateAuDbDependencies(Connection conn) throws DbException, MetadataIndexingException {
        String DEBUG_HEADER = "populateAuDbDependencies(): ";
        if (this.pluginSeq == null) {
            Long platformSeq = this.mdManager.findOrCreatePlatform(conn, this.platform);
            if (log.isDebug3()) {
                log.debug3("populateAuDbDependencies(): platformSeq = " + platformSeq);
            }
            if (platformSeq == null) {
                String message = "Cannot find or create platform '" + this.platform + "'";
                log.error(message);
                throw new MetadataIndexingException(message);
            }
            this.pluginSeq = this.mdManager.findOrCreatePlugin(conn, this.pluginId, platformSeq, this.isBulkContent);
            if (log.isDebug3()) {
                log.debug3("populateAuDbDependencies(): pluginSeq = " + this.pluginSeq);
            }
            if (this.pluginSeq == null) {
                String message = "Cannot find or create plugin '" + this.pluginId + "' for platform '" + this.platform + "'";
                log.error(message);
                log.error("platformSeq = " + platformSeq);
                throw new MetadataIndexingException(message);
            }
        }
        if (this.auSeq == null) {
            this.auSeq = this.mdManager.findOrCreateAu(conn, this.pluginSeq, this.auKey);
            if (log.isDebug3()) {
                log.debug3("populateAuDbDependencies(): auSeq = " + this.auSeq);
            }
            if (this.auSeq == null) {
                String message = "Cannot find or create AU '" + this.auKey + "' for plugin '" + this.pluginId + "'";
                log.error(message);
                log.error("pluginSeq = " + this.pluginSeq);
                throw new MetadataIndexingException(message);
            }
        }
    }

    private void addAuMd(Connection conn, String providerLid, String providerName) throws DbException, MetadataIndexingException {
        String DEBUG_HEADER = "addAuMd(): ";
        long creationTime = 0L;
        if (!ConfigManager.getCurrentConfig().getBoolean("org.lockss.plugin.auContentFromWs", true)) {
            if (this.au != null && AuUtil.getAuState((ArchivalUnit)this.au) != null) {
                creationTime = AuUtil.getAuCreationTime((ArchivalUnit)this.au);
            }
        } else if (log.isDebug()) {
            log.debug("addAuMd(): Not storing the (unavailable) Archival Unit creation time.");
        }
        Long providerSeq = this.dbManager.findOrCreateProvider(conn, providerLid, providerName);
        if (log.isDebug3()) {
            log.debug3("addAuMd(): providerSeq = " + providerSeq);
        }
        this.auMdSeq = this.mdManager.addAuMd(conn, this.auSeq, this.pluginVersion, 0L, creationTime, providerSeq);
        log.debug3("addAuMd(): new auSeq = " + this.auMdSeq);
        if (this.auMdSeq == null) {
            String message = "Cannot create AuMd for '" + this.auKey + "' and plugin '" + this.pluginId + "'";
            log.error(message);
            throw new MetadataIndexingException(message);
        }
    }

    void recordMetadataExtraction(Connection conn) throws DbException, MetadataIndexingException {
        String DEBUG_HEADER = "recordMetadataExtraction(): ";
        if (log.isDebug2()) {
            log.debug2("recordMetadataExtraction(): Invoked.");
        }
        this.auSeq = this.mdxManagerSql.findAuByAuId(conn, this.auId);
        if (log.isDebug3()) {
            log.debug3("recordMetadataExtraction(): auSeq = " + this.auSeq);
        }
        if (this.auSeq == null) {
            this.populateAuDbDependencies(conn);
        }
        this.auMdSeq = this.findAuMd(conn, this.auSeq);
        if (log.isDebug3()) {
            log.debug3("recordMetadataExtraction(): auMdSeq = " + this.auMdSeq);
        }
        if (this.auMdSeq == null) {
            this.addAuMd(conn, null, "UNKNOWN PROVIDER");
        } else {
            this.updateAuMd(conn, this.auMdSeq, this.pluginVersion);
            if (log.isDebug3()) {
                log.debug3("recordMetadataExtraction(): Updated AU plugin version.");
            }
        }
        if (this.au != null) {
            this.mdxManager.updateAuLastExtractionTime(this.au, conn, this.auMdSeq);
            if (log.isDebug3()) {
                log.debug3("recordMetadataExtraction(): Updated AU last extraction time.");
            }
        } else if (log.isDebug3()) {
            log.debug3("recordMetadataExtraction(): AU is null: AU last extraction time NOT updated.");
        }
        if (log.isDebug2()) {
            log.debug2("recordMetadataExtraction(): Done.");
        }
    }

    private void updateAuUnknownProvider(Connection conn, Long auMdSeq, ArticleMetadataBuffer.ArticleMetadataInfo mdinfo) throws DbException {
        String DEBUG_HEADER = "findOrCreateProvider(): ";
        if (log.isDebug2()) {
            log.debug2("findOrCreateProvider(): Invoked.");
        }
        String providerName = mdinfo.provider;
        if (log.isDebug3()) {
            log.debug3("findOrCreateProvider(): providerName = " + providerName);
        }
        if (StringUtil.isNullString((String)providerName)) {
            providerName = this.publisherName;
            if (log.isDebug3()) {
                log.debug3("findOrCreateProvider(): providerName = " + providerName);
            }
        }
        Long providerSeq = this.dbManager.findOrCreateProvider(conn, null, providerName);
        if (log.isDebug3()) {
            log.debug3("findOrCreateProvider(): providerSeq = " + providerSeq);
        }
        boolean updated = this.mdxManagerSql.updateAuUnknownProvider(conn, auMdSeq, providerSeq);
        if (log.isDebug3()) {
            log.debug3("findOrCreateProvider(): updated = " + updated);
        }
        if (log.isDebug2()) {
            log.debug2("findOrCreateProvider(): Done.");
        }
    }
}

