/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.metadata.extractor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import org.lockss.daemon.PublicationDate;
import org.lockss.extractor.ArticleMetadata;
import org.lockss.extractor.MetadataField;
import org.lockss.metadata.ItemMetadata;
import org.lockss.metadata.MetadataManager;
import org.lockss.metadata.extractor.MetadataExtractorManager;
import org.lockss.util.CloseCallbackInputStream;
import org.lockss.util.FileUtil;
import org.lockss.util.IOUtil;
import org.lockss.util.Logger;
import org.lockss.util.StringUtil;

class ArticleMetadataBuffer {
    private static Logger log = Logger.getLogger(ArticleMetadataBuffer.class);
    File collectedMetadataFile = null;
    ObjectOutputStream outstream = null;
    ObjectInputStream instream = null;
    long infoCount = 0L;

    public ArticleMetadataBuffer(File tmpdir) throws IOException {
        this.collectedMetadataFile = FileUtil.createTempFile((String)"MetadataManager", (String)"md", (File)tmpdir);
        this.outstream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.collectedMetadataFile)));
    }

    void add(ArticleMetadata md) throws IOException {
        if (this.outstream == null) {
            throw new IllegalStateException("collectedMetadataOutputStream closed");
        }
        ArticleMetadataInfo mdinfo = new ArticleMetadataInfo(md);
        this.outstream.writeObject(mdinfo);
        ++this.infoCount;
    }

    Iterator<ArticleMetadataInfo> iterator() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Buffer is closed");
        }
        if (this.instream != null) {
            throw new IllegalStateException("Iterator already obtained.");
        }
        IOUtil.safeClose((OutputStream)this.outstream);
        this.outstream = null;
        return new Iterator<ArticleMetadataInfo>(){
            {
                try {
                    ArticleMetadataBuffer.this.instream = new ObjectInputStream(new BufferedInputStream((InputStream)new CloseCallbackInputStream.DeleteFileOnCloseInputStream(ArticleMetadataBuffer.this.collectedMetadataFile)));
                }
                catch (IOException ex) {
                    log.warning("Error opening input stream", (Throwable)ex);
                }
            }

            @Override
            public boolean hasNext() {
                return ArticleMetadataBuffer.this.instream != null && ArticleMetadataBuffer.this.infoCount > 0L;
            }

            @Override
            public ArticleMetadataInfo next() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    ArticleMetadataInfo info = (ArticleMetadataInfo)ArticleMetadataBuffer.this.instream.readObject();
                    --ArticleMetadataBuffer.this.infoCount;
                    return info;
                }
                catch (ClassNotFoundException ex) {
                    NoSuchElementException ex2 = new NoSuchElementException("Error reading next element");
                    ex2.initCause(ex);
                    throw ex2;
                }
                catch (IOException ex) {
                    NoSuchElementException ex2 = new NoSuchElementException("Error reading next element");
                    ex2.initCause(ex);
                    throw ex2;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private boolean isOpen() {
        return this.collectedMetadataFile != null;
    }

    void close() {
        IOUtil.safeClose((OutputStream)this.outstream);
        IOUtil.safeClose((InputStream)this.instream);
        this.outstream = null;
        this.instream = null;
        FileUtil.safeDeleteFile((File)this.collectedMetadataFile);
        this.collectedMetadataFile = null;
    }

    static class ArticleMetadataInfo
    implements Serializable {
        private static final long serialVersionUID = -2372571567706061080L;
        String publisher;
        String provider;
        String seriesTitle;
        String proprietarySeriesIdentifier;
        String publicationTitle;
        String publicationType;
        String isbn;
        String eisbn;
        String issn;
        String eissn;
        String volume;
        String issue;
        String startPage;
        String pubDate;
        final String pubYear;
        String articleTitle;
        String articleType;
        Collection<String> authors;
        String doi;
        String accessUrl;
        Map<String, String> featuredUrlMap;
        Collection<String> keywords;
        String endPage;
        String coverage;
        String itemNumber;
        String proprietaryIdentifier;
        String fetchTime;
        Map<String, String> mdMap;

        public ArticleMetadataInfo(ArticleMetadata md) {
            this.publisher = md.get(MetadataField.FIELD_PUBLISHER);
            this.provider = md.get(MetadataField.FIELD_PROVIDER);
            this.seriesTitle = md.get(MetadataField.FIELD_SERIES_TITLE);
            this.proprietarySeriesIdentifier = md.get(MetadataField.FIELD_PROPRIETARY_SERIES_IDENTIFIER);
            this.publicationTitle = md.get(MetadataField.FIELD_PUBLICATION_TITLE);
            this.isbn = md.get(MetadataField.FIELD_ISBN);
            this.eisbn = md.get(MetadataField.FIELD_EISBN);
            this.issn = md.get(MetadataField.FIELD_ISSN);
            this.eissn = md.get(MetadataField.FIELD_EISSN);
            this.volume = md.get(MetadataField.FIELD_VOLUME);
            this.issue = md.get(MetadataField.FIELD_ISSUE);
            String allPages = md.get(MetadataField.FIELD_START_PAGE);
            if (allPages != null) {
                String[] pages = allPages.split("\\D");
                if (pages.length == 2) {
                    this.startPage = pages[0];
                    this.endPage = StringUtil.isNullString((String)md.get(MetadataField.FIELD_END_PAGE)) ? pages[1] : md.get(MetadataField.FIELD_END_PAGE);
                } else {
                    this.startPage = allPages;
                    this.endPage = md.get(MetadataField.FIELD_END_PAGE);
                }
            } else {
                this.startPage = null;
                this.endPage = md.get(MetadataField.FIELD_END_PAGE);
            }
            PublicationDate pd = ArticleMetadataInfo.getDateField(md);
            if (pd == null) {
                this.pubYear = null;
                this.pubDate = null;
            } else {
                this.pubDate = pd.toString();
                this.pubYear = Integer.toString(pd.getYear());
            }
            this.articleTitle = md.get(MetadataField.FIELD_ARTICLE_TITLE);
            this.authors = md.getList(MetadataField.FIELD_AUTHOR);
            this.doi = md.get(MetadataField.FIELD_DOI);
            this.accessUrl = md.get(MetadataField.FIELD_ACCESS_URL);
            this.featuredUrlMap = md.getRawMap(MetadataField.FIELD_FEATURED_URL_MAP);
            log.debug3("featuredUrlMap = " + this.featuredUrlMap);
            this.keywords = md.getList(MetadataField.FIELD_KEYWORDS);
            this.coverage = md.get(MetadataField.FIELD_COVERAGE);
            this.itemNumber = md.get(MetadataField.FIELD_ITEM_NUMBER);
            this.proprietaryIdentifier = md.get(MetadataField.FIELD_PROPRIETARY_IDENTIFIER);
            this.fetchTime = md.get(MetadataField.FIELD_FETCH_TIME);
            this.mdMap = md.getRawMap(MetadataField.FIELD_MD_MAP);
            if (log.isDebug3()) {
                log.debug3("mdMap = " + this.mdMap);
            }
            this.publicationType = md.get(MetadataField.FIELD_PUBLICATION_TYPE);
            if (StringUtil.isNullString((String)this.publicationType)) {
                this.publicationType = MetadataExtractorManager.isBookSeries(this.issn, this.eissn, this.isbn, this.eisbn, this.seriesTitle, this.volume) ? "bookSeries" : (MetadataManager.isBook((String)this.isbn, (String)this.eisbn) ? "book" : "journal");
            }
            this.articleType = md.get(MetadataField.FIELD_ARTICLE_TYPE);
            if (StringUtil.isNullString((String)this.articleType)) {
                if ("book".equals(this.publicationType) || "bookSeries".equals(this.publicationType)) {
                    this.articleType = !(StringUtil.isNullString((String)this.startPage) && StringUtil.isNullString((String)this.endPage) && StringUtil.isNullString((String)this.itemNumber)) ? "book_chapter" : "book_volume";
                } else if ("journal".equals(this.publicationType)) {
                    this.articleType = "journal_article";
                } else if ("proceedings".equals(this.publicationType)) {
                    this.articleType = "proceedings_article";
                } else if ("file".equals(this.publicationType)) {
                    this.articleType = "file";
                }
            } else if ("file".equals(this.articleType) && StringUtil.isNullString((String)this.publicationType)) {
                this.publicationType = "file";
            }
            if (StringUtil.isNullString((String)this.publicationTitle) && "file".equals(this.publicationType) && StringUtil.isNullString((String)this.publisher)) {
                this.publicationTitle = "File from " + this.publisher;
            }
        }

        private static PublicationDate getDateField(ArticleMetadata md) {
            PublicationDate pubDate = null;
            String dateStr = md.get(MetadataField.FIELD_DATE);
            if (dateStr != null) {
                Locale locale = md.getLocale();
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                try {
                    pubDate = new PublicationDate(dateStr, locale);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return pubDate;
        }

        public ItemMetadata populateItemMetadataDetail() {
            Map<String, String> metadataMap;
            String DEBUG_HEADER = "populateItemMetadataDetail(): ";
            ItemMetadata item = new ItemMetadata();
            Map scalarMap = item.getScalarMap();
            Map setMap = item.getSetMap();
            Map listMap = item.getListMap();
            Map mapMap = item.getMapMap();
            if (this.publisher != null) {
                scalarMap.put("publisher_name", this.publisher);
            }
            if (this.provider != null) {
                scalarMap.put("provider_name", this.provider);
            }
            if (this.seriesTitle != null) {
                scalarMap.put("series_title_name", this.seriesTitle);
            }
            if (this.proprietarySeriesIdentifier != null) {
                scalarMap.put("proprietary_series_identifier", this.proprietarySeriesIdentifier);
            }
            if (this.publicationTitle != null) {
                scalarMap.put("publication_name", this.publicationTitle);
            }
            HashMap<String, String> isbnMap = new HashMap<String, String>();
            if (this.isbn != null) {
                isbnMap.put("p_isbn", this.isbn);
            }
            if (this.eisbn != null) {
                isbnMap.put("e_isbn", this.eisbn);
            }
            if (isbnMap.size() > 0) {
                mapMap.put("isbn", isbnMap);
            }
            HashMap<String, String> issnMap = new HashMap<String, String>();
            if (this.issn != null) {
                issnMap.put("p_issn", this.issn);
            }
            if (this.eissn != null) {
                issnMap.put("e_issn", this.eissn);
            }
            if (issnMap.size() > 0) {
                mapMap.put("issn", issnMap);
            }
            if (this.volume != null) {
                scalarMap.put("volume", this.volume);
            }
            if (this.issue != null) {
                scalarMap.put("issue", this.issue);
            }
            if (this.startPage != null) {
                scalarMap.put("start_page", this.startPage);
            }
            if (this.endPage != null) {
                scalarMap.put("end_page", this.endPage);
            }
            if (this.pubDate != null) {
                scalarMap.put("date", this.pubDate);
            }
            if (this.articleTitle != null) {
                scalarMap.put("item_title", this.articleTitle);
            }
            if (this.authors != null && this.authors.size() > 0) {
                listMap.put("author_name", new ArrayList<String>(this.authors));
            }
            if (this.doi != null) {
                scalarMap.put("doi", this.doi);
            }
            Map<String, String> urlMap = this.featuredUrlMap;
            if (this.accessUrl != null) {
                urlMap.put("Access", this.accessUrl);
            }
            if (urlMap.size() > 0) {
                mapMap.put("url", urlMap);
            }
            if (this.keywords != null && this.keywords.size() > 0) {
                setMap.put("keyword", new HashSet<String>(this.keywords));
            }
            if (this.coverage != null) {
                scalarMap.put("coverage", this.coverage);
            }
            if (this.itemNumber != null) {
                scalarMap.put("item_no", this.itemNumber);
            }
            if (this.proprietaryIdentifier != null) {
                HashSet<String> pis = new HashSet<String>();
                setMap.put("proprietary_id", pis);
                pis.add(this.proprietaryIdentifier);
            }
            if (this.fetchTime != null) {
                scalarMap.put("fetch_time", this.fetchTime);
            }
            if ((metadataMap = this.mdMap).size() > 0) {
                mapMap.put("md_value", metadataMap);
            }
            if (log.isDebug2()) {
                log.debug2("populateItemMetadataDetail(): item = " + item);
            }
            return item;
        }

        public String toString() {
            return "[ArticleMetadataInfo publisher=" + this.publisher + ", provider=" + this.provider + ", seriesTitle=" + this.seriesTitle + ", proprietarySeriesIdentifier=" + this.proprietarySeriesIdentifier + ", publicationTitle=" + this.publicationTitle + ", publicationType=" + this.publicationType + ", isbn=" + this.isbn + ", eisbn=" + this.eisbn + ", issn=" + this.issn + ", eissn=" + this.eissn + ", volume=" + this.volume + ", issue=" + this.issue + ", startPage=" + this.startPage + ", pubDate=" + this.pubDate + ", pubYear=" + this.pubYear + ", articleTitle=" + this.articleTitle + ", articleType=" + this.articleType + ", authorSet=" + this.authors + ", doi=" + this.doi + ", accessUrl=" + this.accessUrl + ", featuredUrlMap=" + this.featuredUrlMap + ", keywordSet=" + this.keywords + ", endPage=" + this.endPage + ", coverage=" + this.coverage + ", itemNumber=" + this.itemNumber + ", proprietaryIdentifier=" + this.proprietaryIdentifier + ", fetchTime=" + this.fetchTime + ", mdMap=" + this.mdMap + "]";
        }
    }
}

