/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.metadata.extractor;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.sql.Connection;
import org.lockss.app.LockssApp;
import org.lockss.app.LockssDaemon;
import org.lockss.config.CurrentConfig;
import org.lockss.daemon.LockssWatchdog;
import org.lockss.db.JdbcContext;
import org.lockss.metadata.MetadataDbManager;
import org.lockss.metadata.extractor.DeleteAuItemsClient;
import org.lockss.metadata.extractor.MetadataExtractorManager;
import org.lockss.metadata.extractor.MetadataExtractorManagerSql;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.scheduler.SchedulableTask;
import org.lockss.scheduler.Schedule;
import org.lockss.scheduler.StepTask;
import org.lockss.scheduler.TaskCallback;
import org.lockss.util.Logger;
import org.lockss.util.TimeInterval;
import org.lockss.util.time.TimeBase;

public class DeleteMetadataTask
extends StepTask {
    private static Logger log = Logger.getLogger(DeleteMetadataTask.class);
    private final ArchivalUnit au;
    private volatile MetadataExtractorManager.ReindexingStatus status = MetadataExtractorManager.ReindexingStatus.Running;
    private final String auName;
    private final String auId;
    private volatile long startCpuTime = 0L;
    private volatile long startUserTime = 0L;
    private volatile long startClockTime = 0L;
    private volatile long endCpuTime = 0L;
    private volatile long endUserTime = 0L;
    private volatile long endClockTime = 0L;
    private final MetadataDbManager dbManager;
    private final MetadataExtractorManager mdxManager;
    private final MetadataExtractorManagerSql mdxManagerSql;
    private LockssWatchdog watchDog;
    private static ThreadMXBean tmxb = ManagementFactory.getThreadMXBean();
    private JdbcContext jdbcCtxt;

    public DeleteMetadataTask(ArchivalUnit au) {
        super(new TimeInterval(TimeBase.nowMs(), TimeBase.nowMs() + 3600000L), 0L, null, null);
        this.au = au;
        this.auName = au.getName();
        this.auId = au.getAuId();
        this.dbManager = LockssDaemon.getLockssDaemon().getMetadataDbManager();
        this.mdxManager = (MetadataExtractorManager)((Object)LockssApp.getManagerByTypeStatic(MetadataExtractorManager.class));
        this.mdxManagerSql = this.mdxManager.getMetadataExtractorManagerSql();
        this.callback = new MetadataRemovalEventHandler();
    }

    void setWDog(LockssWatchdog watchDog) {
        this.watchDog = watchDog;
    }

    void pokeWDog() {
        this.watchDog.pokeWDog();
    }

    public void cancel() {
        String DEBUG_HEADER = "cancel(): ";
        if (log.isDebug2()) {
            log.debug2("cancel(): Invoked.");
        }
        if (log.isDebug3()) {
            log.debug3("cancel(): isFinished() = " + this.isFinished());
            log.debug3("cancel(): status = " + (Object)((Object)this.status));
        }
        this.jdbcCtxt.abort();
        if (!this.isFinished() && this.status == MetadataExtractorManager.ReindexingStatus.Running) {
            this.status = MetadataExtractorManager.ReindexingStatus.Failed;
            super.cancel();
            this.setFinished();
        }
        if (log.isDebug2()) {
            log.debug2("cancel(): Done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int step(int n) {
        block16: {
            String DEBUG_HEADER = "step(): ";
            if (log.isDebug2()) {
                log.debug2("step(): n = " + n);
            }
            if (log.isDebug3()) {
                log.debug3("step(): auId = " + this.auId);
            }
            if (CurrentConfig.getParam((String)"org.lockss.metadataManager.mdRest.serviceLocation") != null) {
                try {
                    Integer removedArticleCount = new DeleteAuItemsClient().deleteAuItems(this.auId);
                    log.info("Metadata removal task for AU '" + this.auName + "' removed " + removedArticleCount + " database items.");
                }
                catch (Exception ex) {
                    this.e = ex;
                    log.warning("Error removing metadata", (Throwable)this.e);
                    this.setFinished();
                    if (this.status == MetadataExtractorManager.ReindexingStatus.Running) {
                        this.status = MetadataExtractorManager.ReindexingStatus.Failed;
                    }
                    break block16;
                }
            }
            Connection conn = null;
            try {
                conn = this.dbManager.getConnection();
                this.jdbcCtxt = new JdbcContext(conn);
                int removedArticleCount = this.mdxManagerSql.removeAuMetadataItems(this.jdbcCtxt, this.auId);
                log.info("Metadata removal task for AU '" + this.auName + "' removed " + removedArticleCount + " database items.");
                MetadataDbManager.commitOrRollback((Connection)conn, (Logger)log);
            }
            catch (Exception ex) {
                this.e = ex;
                log.warning("Error removing metadata", (Throwable)this.e);
                this.setFinished();
                if (this.status == MetadataExtractorManager.ReindexingStatus.Running) {
                    this.status = MetadataExtractorManager.ReindexingStatus.Failed;
                }
            }
            finally {
                MetadataDbManager.safeRollbackAndClose((Connection)conn);
            }
        }
        if (log.isDebug3()) {
            log.debug3("step(): isFinished() = " + this.isFinished());
        }
        if (!this.isFinished()) {
            this.setFinished();
            if (log.isDebug3()) {
                log.debug3("step(): isFinished() = " + this.isFinished());
            }
        }
        if (log.isDebug2()) {
            log.debug2("step(): Done.");
        }
        return 0;
    }

    ArchivalUnit getAu() {
        return this.au;
    }

    public String getAuId() {
        return this.auId;
    }

    protected void handleEvent(Schedule.EventType evt) {
        this.callback.taskEvent((SchedulableTask)this, evt);
    }

    static {
        log.debug3("current thread CPU time supported? " + tmxb.isCurrentThreadCpuTimeSupported());
        if (tmxb.isCurrentThreadCpuTimeSupported()) {
            tmxb.setThreadCpuTimeEnabled(true);
        }
    }

    private class MetadataRemovalEventHandler
    implements TaskCallback {
        private final Logger log = Logger.getLogger(MetadataRemovalEventHandler.class);

        private MetadataRemovalEventHandler() {
        }

        public void taskEvent(SchedulableTask task, Schedule.EventType type) {
            long threadCpuTime = 0L;
            long threadUserTime = 0L;
            long currentClockTime = TimeBase.nowMs();
            if (tmxb.isCurrentThreadCpuTimeSupported()) {
                threadCpuTime = tmxb.getCurrentThreadCpuTime();
                threadUserTime = tmxb.getCurrentThreadUserTime();
            }
            if (type == Schedule.EventType.START) {
                this.handleStartEvent(threadCpuTime, threadUserTime, currentClockTime);
            } else if (type == Schedule.EventType.FINISH) {
                this.handleFinishEvent(task, threadCpuTime, threadUserTime, currentClockTime);
            } else {
                this.log.error("Received unknown metadata removal lifecycle event type '" + type + "' for AU '" + DeleteMetadataTask.this.auName + "' - Ignored.");
            }
        }

        private void handleStartEvent(long threadCpuTime, long threadUserTime, long currentClockTime) {
            block3: {
                String DEBUG_HEADER = "handleStartEvent(): ";
                this.log.info("Starting metadata removal task for AU '" + DeleteMetadataTask.this.auName + "'");
                DeleteMetadataTask.this.startCpuTime = threadCpuTime;
                DeleteMetadataTask.this.startUserTime = threadUserTime;
                DeleteMetadataTask.this.startClockTime = currentClockTime;
                try {
                    DeleteMetadataTask.this.mdxManager.notifyStartAuMetadataRemoval(DeleteMetadataTask.this.au);
                }
                catch (Exception e) {
                    this.log.error("Failed to set up metadata removal for AU '" + DeleteMetadataTask.this.auName + "'", (Throwable)e);
                    DeleteMetadataTask.this.setFinished();
                    if (DeleteMetadataTask.this.status != MetadataExtractorManager.ReindexingStatus.Running) break block3;
                    DeleteMetadataTask.this.status = MetadataExtractorManager.ReindexingStatus.Failed;
                }
            }
            if (this.log.isDebug2()) {
                this.log.debug2("handleStartEvent(): Done.");
            }
        }

        private void handleFinishEvent(SchedulableTask task, long threadCpuTime, long threadUserTime, long currentClockTime) {
            String DEBUG_HEADER = "handleFinishEvent(): ";
            if (this.log.isDebug2()) {
                this.log.debug2("handleFinishEvent(): task = " + task);
            }
            if (this.log.isDebug3()) {
                this.log.debug3("handleFinishEvent(): AU '" + DeleteMetadataTask.this.auName + "': status = " + (Object)((Object)DeleteMetadataTask.this.status));
            }
            if (DeleteMetadataTask.this.status == MetadataExtractorManager.ReindexingStatus.Running) {
                DeleteMetadataTask.this.status = MetadataExtractorManager.ReindexingStatus.Success;
            }
            DeleteMetadataTask.this.endClockTime = TimeBase.nowMs();
            if (tmxb.isCurrentThreadCpuTimeSupported()) {
                DeleteMetadataTask.this.endCpuTime = tmxb.getCurrentThreadCpuTime();
                DeleteMetadataTask.this.endUserTime = tmxb.getCurrentThreadUserTime();
            }
            long elapsedCpuTime = threadCpuTime - DeleteMetadataTask.this.startCpuTime;
            long elapsedUserTime = threadUserTime - DeleteMetadataTask.this.startUserTime;
            long elapsedClockTime = currentClockTime - DeleteMetadataTask.this.startClockTime;
            this.log.info("Finished metadata removal task for AU '" + DeleteMetadataTask.this.auName + "': status = " + (Object)((Object)DeleteMetadataTask.this.status) + ", CPU time: " + (double)elapsedCpuTime / 1.0E9 + " (" + (double)DeleteMetadataTask.this.endCpuTime / 1.0E9 + "), User time: " + (double)elapsedUserTime / 1.0E9 + " (" + (double)DeleteMetadataTask.this.endUserTime / 1.0E9 + "), Clock time: " + (double)elapsedClockTime / 1000.0 + " (" + (double)DeleteMetadataTask.this.endClockTime / 1000.0 + ")");
            DeleteMetadataTask.this.mdxManager.notifyFinishAuMetadataRemoval(DeleteMetadataTask.this.au, DeleteMetadataTask.this.status, task.getException());
            if (this.log.isDebug2()) {
                this.log.debug2("handleFinishEvent(): Done.");
            }
        }
    }
}

