/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.metadata.extractor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lockss.daemon.status.ColumnDescriptor;
import org.lockss.daemon.status.StatusAccessor;
import org.lockss.daemon.status.StatusService;
import org.lockss.daemon.status.StatusTable;
import org.lockss.metadata.extractor.ArticleMetadataBuffer;
import org.lockss.metadata.extractor.MetadataExtractorManager;
import org.lockss.metadata.extractor.MetadataIndexingException;
import org.lockss.metadata.extractor.ReindexingTask;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.plugin.Plugin;
import org.lockss.plugin.PluginManager;
import org.lockss.plugin.PluginStatus;
import org.lockss.util.CatalogueOrderComparator;
import org.lockss.util.ListUtil;
import org.lockss.util.Logger;
import org.lockss.util.time.TimeBase;

public class MetadataManagerStatusAccessor
implements StatusAccessor {
    public static final String NEW_INDEX_TEXT = "New Index";
    public static final String FULL_REINDEX_TEXT = "Full Reindex";
    public static final String REINDEX_TEXT = "Reindex";
    private static Logger log = Logger.getLogger(MetadataManagerStatusAccessor.class);
    final MetadataExtractorManager mdxMgr;
    private String key = null;
    private static final String AU_COL_NAME = "au";
    private static final String INDEX_TYPE = "index_type";
    private static final String START_TIME_COL_NAME = "start";
    private static final String INDEX_DURATION_COL_NAME = "index_dur";
    private static final String UPDATE_DURATION_COL_NAME = "update_dur";
    private static final String INDEX_STATUS_COL_NAME = "status";
    private static final String NUM_INDEXED_COL_NAME = "num_indexed";
    private static final String NUM_UPDATED_COL_NAME = "num_updated";
    private static final String SORT_KEY1 = "sort1";
    private static final String SORT_KEY2 = "sort2";
    private static int SORT_BASE_INDEXING = 0;
    private static int SORT_BASE_WAITING = 1000000;
    private static int SORT_BASE_DONE = 2000000;
    private final List<ColumnDescriptor> colDescs = ListUtil.fromArray((Object[])new ColumnDescriptor[]{new ColumnDescriptor("au", "Journal Volume", 4).setComparator((Comparator)CatalogueOrderComparator.SINGLETON), new ColumnDescriptor("index_type", "Index Type", 4, "Indicates whether new content is being indexed or existing content index is being fully or partially updated"), new ColumnDescriptor("status", "Status", 4, "Status of indexing operation."), new ColumnDescriptor("start", "Start Time", 6, "Start date and time of indexing operation"), new ColumnDescriptor("index_dur", "Index Duration", 3, "Duration of metadata indexing, including scanning articles and extracting metadata."), new ColumnDescriptor("num_indexed", "Articles Indexed", 0), new ColumnDescriptor("update_dur", "Update Duration", 3, "Duration of updating stored metadata."), new ColumnDescriptor("num_updated", "Articles Updated", 0)});
    private final List<StatusTable.SortRule> sortRules = ListUtil.list((Object[])new StatusTable.SortRule[]{new StatusTable.SortRule("sort1", true), new StatusTable.SortRule("sort2", false)});

    public MetadataManagerStatusAccessor(MetadataExtractorManager mdxMgr) {
        this.mdxMgr = mdxMgr;
    }

    private List<StatusTable.SummaryInfo> getErrorItemSummaryInfo(long taskTime) {
        ArrayList<StatusTable.SummaryInfo> res;
        ReindexingTask task;
        block11: {
            List<ReindexingTask> tasks;
            block10: {
                task = null;
                res = new ArrayList<StatusTable.SummaryInfo>();
                if (taskTime != 0L) break block10;
                tasks = this.mdxMgr.getReindexingTasks();
                if (tasks.size() <= 0) break block11;
                task = tasks.get(0);
                break block11;
            }
            tasks = this.mdxMgr.getFailedReindexingTasks();
            for (ReindexingTask t : tasks) {
                if (taskTime != t.getStartTime()) continue;
                task = t;
                break;
            }
        }
        res.add(new StatusTable.SummaryInfo(null, 4, (Object)"\u00a0"));
        if (task == null) {
            res.add(new StatusTable.SummaryInfo(null, 4, (Object)"Reindexing task no longer available"));
            res.add(new StatusTable.SummaryInfo(null, 4, (Object)new StatusTable.Reference((Object)"Back to Metadata Indexing Errors", "MetadataStatusTable", "errors")));
        } else {
            String status;
            res.add(new StatusTable.SummaryInfo("Volume", 4, (Object)task.getAuName()));
            ArchivalUnit au = task.getAu();
            Plugin plugin = au.getPlugin();
            res.add(new StatusTable.SummaryInfo("Plugin", 4, (Object)PluginStatus.makePlugRef((Object)plugin.getPluginName(), (Plugin)plugin)));
            res.add(new StatusTable.SummaryInfo("Index Type", 4, (Object)this.getIndexTypeDisplayString(task)));
            MetadataExtractorManager.ReindexingStatus reindexingStatus = task.getReindexingStatus();
            switch (reindexingStatus) {
                case Success: {
                    status = "Success";
                    break;
                }
                case Failed: {
                    status = "Failed";
                    break;
                }
                case Rescheduled: {
                    status = "Rescheduled";
                    break;
                }
                default: {
                    status = reindexingStatus.toString();
                }
            }
            res.add(new StatusTable.SummaryInfo("Status", 4, (Object)status));
            res.add(new StatusTable.SummaryInfo("Has substance", 4, (Object)(task.hasNoAuSubstance() ? "No" : "Yes")));
            res.add(new StatusTable.SummaryInfo("Start time", 6, (Object)task.getStartTime()));
            res.add(new StatusTable.SummaryInfo("Index duration", 3, (Object)(task.getStartUpdateTime() - task.getStartTime())));
            res.add(new StatusTable.SummaryInfo("Articles indexed", 0, (Object)task.getIndexedArticleCount()));
            res.add(new StatusTable.SummaryInfo("Update duration", 3, (Object)(task.getEndTime() - task.getStartUpdateTime())));
            res.add(new StatusTable.SummaryInfo("Articles updated", 0, (Object)task.getUpdatedArticleCount()));
            res.add(new StatusTable.SummaryInfo(null, 4, (Object)new StatusTable.Reference((Object)"AU configuration", "AuConfiguration", au.getAuId())));
            res.add(new StatusTable.SummaryInfo(null, 4, (Object)new StatusTable.Reference((Object)"Back to Metadata Indexing Errors", "MetadataStatusTable", "errors")));
            Exception taskException = task.getException();
            if (taskException != null) {
                ArticleMetadataBuffer.ArticleMetadataInfo info;
                res.add(new StatusTable.SummaryInfo(null, 4, (Object)"\u00a0"));
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                taskException.printStackTrace(pw);
                res.add(new StatusTable.SummaryInfo("Exception", 4, (Object)sw.toString()));
                if (taskException instanceof MetadataIndexingException && (info = ((MetadataIndexingException)taskException).getArticleMetadataInfo()) != null) {
                    res.add(new StatusTable.SummaryInfo("MetadataInfo", 4, (Object)info.toString()));
                }
            }
        }
        return res;
    }

    private String getIndexTypeDisplayString(ReindexingTask task) {
        return task.isNewAu() ? NEW_INDEX_TEXT : (task.needsFullReindex() ? FULL_REINDEX_TEXT : REINDEX_TEXT);
    }

    private List<StatusTable.SummaryInfo> getSummaryInfo() {
        ArrayList<StatusTable.SummaryInfo> res = new ArrayList<StatusTable.SummaryInfo>();
        long activeOps = this.mdxMgr.getActiveReindexingCount();
        long pendingOps = this.mdxMgr.getPendingAusCount();
        long successfulOps = this.mdxMgr.getSuccessfulReindexingCount();
        long failedOps = this.mdxMgr.getFailedReindexingCount();
        long articleCount = this.mdxMgr.getArticleCount();
        long publicationCount = this.mdxMgr.getMetadataManager().getPublicationCount();
        long publisherCount = this.mdxMgr.getPublisherCount();
        long providerCount = this.mdxMgr.getProviderCount();
        boolean indexingEnabled = this.mdxMgr.isIndexingEnabled();
        if (activeOps > 0L && !"indexing".equals(this.key)) {
            res.add(new StatusTable.SummaryInfo("Active Indexing Operations", 0, (Object)new StatusTable.Reference((Object)activeOps, "MetadataStatusTable")));
        } else {
            res.add(new StatusTable.SummaryInfo("Active Indexing Operations", 0, (Object)activeOps));
        }
        if (pendingOps > 0L && !"pending".equals(this.key)) {
            res.add(new StatusTable.SummaryInfo("Pending Indexing Operations", 0, (Object)new StatusTable.Reference((Object)pendingOps, "MetadataStatusTable", "pending")));
        } else {
            res.add(new StatusTable.SummaryInfo("Pending Indexing Operations", 0, (Object)pendingOps));
        }
        if (successfulOps > 0L && !"indexing".equals(this.key)) {
            res.add(new StatusTable.SummaryInfo("Successful Indexing Operations", 0, (Object)new StatusTable.Reference((Object)successfulOps, "MetadataStatusTable")));
        } else {
            res.add(new StatusTable.SummaryInfo("Successful Indexing Operations", 0, (Object)successfulOps));
        }
        if (failedOps > 0L && !"errors".equals(this.key)) {
            res.add(new StatusTable.SummaryInfo("Failed/Rescheduled Indexing Operations", 0, (Object)new StatusTable.Reference((Object)failedOps, "MetadataStatusTable", "errors")));
        } else {
            res.add(new StatusTable.SummaryInfo("Failed/Rescheduled Indexing Operations", 0, (Object)failedOps));
        }
        res.add(new StatusTable.SummaryInfo("Total Articles in Index", 0, (Object)articleCount));
        res.add(new StatusTable.SummaryInfo("Total Publications in Index", 0, (Object)publicationCount));
        res.add(new StatusTable.SummaryInfo("Total Publishers in Index", 0, (Object)publisherCount));
        res.add(new StatusTable.SummaryInfo("Total Providers in Index", 0, (Object)providerCount));
        res.add(new StatusTable.SummaryInfo("Indexing Enabled", 4, (Object)indexingEnabled));
        return res;
    }

    List<Map<String, Object>> getRows() {
        return this.getTaskRows(this.mdxMgr.getReindexingTasks());
    }

    private List<Map<String, Object>> getPrioritizedAus(Collection<MetadataExtractorManager.PrioritizedAuId> pendingAuIds) {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        PluginManager pluginMgr = this.mdxMgr.getApp().getPluginManager();
        for (MetadataExtractorManager.PrioritizedAuId pendingAuId : pendingAuIds) {
            ArchivalUnit au = pluginMgr.getAuFromId(pendingAuId.auId);
            if (au == null) {
                if (!log.isDebug3()) continue;
                log.debug3("Unknown pending AU: " + pendingAuId.auId);
                continue;
            }
            String auName = au.getName();
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put(AU_COL_NAME, new StatusTable.Reference((Object)auName, "ArchivalUnitTable", pendingAuId.auId));
            row.put(INDEX_TYPE, this.getIndexTypeDisplayString(pendingAuId));
            row.put(INDEX_STATUS_COL_NAME, "Pending");
            rows.add(row);
        }
        return rows;
    }

    String getIndexTypeDisplayString(MetadataExtractorManager.PrioritizedAuId pAuId) {
        return pAuId.isNew ? NEW_INDEX_TEXT : (pAuId.needFullReindex ? FULL_REINDEX_TEXT : REINDEX_TEXT);
    }

    private List<Map<String, Object>> getTaskRows(Collection<ReindexingTask> tasks) {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        int rowNum = 0;
        for (ReindexingTask task : tasks) {
            String auName = task.getAuName();
            String auId = task.getAuId();
            boolean auNoSubstance = task.hasNoAuSubstance();
            long startTime = task.getStartTime();
            long startUpdateTime = task.getStartUpdateTime();
            long endTime = task.getEndTime();
            MetadataExtractorManager.ReindexingStatus indexStatus = task.getReindexingStatus();
            long numIndexed = task.getIndexedArticleCount();
            long numUpdated = task.getUpdatedArticleCount();
            long curTime = TimeBase.nowMs();
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put(AU_COL_NAME, new StatusTable.Reference((Object)auName, "ArchivalUnitTable", auId));
            row.put(INDEX_TYPE, this.getIndexTypeDisplayString(task));
            if (startTime == 0L) {
                row.put(INDEX_STATUS_COL_NAME, "Waiting");
                row.put(SORT_KEY1, SORT_BASE_WAITING);
                row.put(SORT_KEY2, rowNum);
            }
            if (startUpdateTime == 0L) {
                row.put(START_TIME_COL_NAME, startTime);
                row.put(INDEX_DURATION_COL_NAME, curTime - startTime);
                row.put(INDEX_STATUS_COL_NAME, "Indexing");
                row.put(NUM_INDEXED_COL_NAME, numIndexed);
                row.put(SORT_KEY1, SORT_BASE_INDEXING);
                row.put(SORT_KEY2, startTime);
            } else if (endTime == 0L) {
                row.put(START_TIME_COL_NAME, startTime);
                row.put(INDEX_DURATION_COL_NAME, startUpdateTime - startTime);
                row.put(UPDATE_DURATION_COL_NAME, curTime - startUpdateTime);
                row.put(INDEX_STATUS_COL_NAME, "Updating");
                row.put(NUM_INDEXED_COL_NAME, numIndexed);
                row.put(NUM_UPDATED_COL_NAME, numUpdated);
                row.put(SORT_KEY1, SORT_BASE_INDEXING);
                row.put(SORT_KEY2, startTime);
            } else {
                String status;
                row.put(START_TIME_COL_NAME, startTime);
                row.put(INDEX_DURATION_COL_NAME, startUpdateTime - startTime);
                row.put(UPDATE_DURATION_COL_NAME, endTime - startUpdateTime);
                switch (indexStatus) {
                    case Success: {
                        status = "Success";
                        break;
                    }
                    case Failed: {
                        status = "Failed";
                        break;
                    }
                    case Rescheduled: {
                        status = "Rescheduled";
                        break;
                    }
                    default: {
                        status = indexStatus.toString();
                    }
                }
                if (auId != null && indexStatus == MetadataExtractorManager.ReindexingStatus.Success && auNoSubstance) {
                    status = new StatusTable.DisplayedValue((Object)status).setFootnote("Though metadata indexing finished successfully, no article files containing substantial content were found");
                }
                if (task.getException() != null) {
                    row.put(INDEX_STATUS_COL_NAME, new StatusTable.Reference((Object)status, "MetadataStatusTable", Long.toString(task.getStartTime())));
                } else {
                    row.put(INDEX_STATUS_COL_NAME, status);
                }
                row.put(NUM_INDEXED_COL_NAME, numIndexed);
                row.put(NUM_UPDATED_COL_NAME, numUpdated);
                row.put(SORT_KEY1, SORT_BASE_DONE);
                row.put(SORT_KEY2, endTime);
            }
            rows.add(row);
            ++rowNum;
        }
        return rows;
    }

    private List<ColumnDescriptor> getColDescs() {
        ArrayList<ColumnDescriptor> res = new ArrayList<ColumnDescriptor>(this.colDescs.size());
        for (ColumnDescriptor desc : this.colDescs) {
            res.add(desc);
        }
        return res;
    }

    public void populateTable(StatusTable table) throws StatusService.NoSuchTableException {
        this.key = table.getKey() == null ? "indexing" : table.getKey();
        try {
            long taskTime = Long.parseLong(this.key);
            table.setTitle("Metadata Indexing Error Information");
            table.setSummaryInfo(this.getErrorItemSummaryInfo(taskTime));
        }
        catch (NumberFormatException ex) {
            if ("pending".equals(this.key)) {
                table.setTitle("Metadata Pending Index Status");
                table.setRows(this.getPrioritizedAus(this.mdxMgr.getPendingReindexingAus()));
            } else if ("errors".equals(this.key)) {
                table.setTitle("Metadata Indexing Errors");
                table.setRows(this.getTaskRows(this.mdxMgr.getFailedReindexingTasks()));
            } else {
                this.key = "indexing";
                table.setTitle("Metadata Indexing Status");
                table.setRows(this.getTaskRows(this.mdxMgr.getReindexingTasks()));
            }
            table.setDefaultSortRules(this.sortRules);
            table.setColumnDescriptors(this.getColDescs());
            table.setSummaryInfo(this.getSummaryInfo());
        }
    }

    public String getDisplayName() {
        return "Metadata Indexing Status";
    }

    public boolean requiresKey() {
        return false;
    }
}

