/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.metadata.extractor.job;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import org.lockss.app.ConfigurableManager;
import org.lockss.config.ConfigManager;
import org.lockss.config.Configuration;
import org.lockss.db.DbException;
import org.lockss.db.DbManager;
import org.lockss.metadata.extractor.job.JobDbManagerSql;
import org.lockss.util.FileUtil;
import org.lockss.util.Logger;

public class JobDbManager
extends DbManager
implements ConfigurableManager {
    protected static final Logger log = Logger.getLogger(JobDbManager.class);
    private static final String PREFIX = "org.lockss.jobDbManager.";
    private static final String DERBY_ROOT = "org.lockss.jobDbManager.derby";
    public static final String PARAM_DERBY_INFOLOG_APPEND = "org.lockss.jobDbManager.derby.infologAppend";
    public static final String PARAM_DERBY_LANGUAGE_LOGQUERYPLAN = "org.lockss.jobDbManager.derby.languageLogqueryplan";
    public static final String PARAM_DERBY_LANGUAGE_LOGSTATEMENTTEXT = "org.lockss.jobDbManager.derby.languageLogstatementtext";
    public static final String PARAM_DERBY_STREAM_ERROR_FILE = "org.lockss.jobDbManager.derby.streamErrorFile";
    public static final String PARAM_DERBY_STREAM_ERROR_LOGSEVERITYLEVEL = "org.lockss.jobDbManager.derby.streamErrorLogseveritylevel";
    private static final String DATASOURCE_ROOT = "org.lockss.jobDbManager.datasource";
    public static final String PARAM_DATASOURCE_CLASSNAME = "org.lockss.jobDbManager.datasource.className";
    public static final String PARAM_DATASOURCE_CREATEDATABASE = "org.lockss.jobDbManager.datasource.createDatabase";
    public static final String PARAM_DATASOURCE_DATABASENAME = "org.lockss.jobDbManager.datasource.databaseName";
    public static final String PARAM_DATASOURCE_PORTNUMBER = "org.lockss.jobDbManager.datasource.portNumber";
    public static final String PARAM_DATASOURCE_SERVERNAME = "org.lockss.jobDbManager.datasource.serverName";
    public static final String PARAM_DATASOURCE_USER = "org.lockss.jobDbManager.datasource.user";
    public static final String PARAM_DATASOURCE_PASSWORD = "org.lockss.jobDbManager.datasource.password";
    public static final String PARAM_DBMANAGER_ENABLED = "org.lockss.jobDbManager.enabled";
    public static final String PARAM_MAX_RETRY_COUNT = "org.lockss.jobDbManager.maxRetryCount";
    public static final String PARAM_RETRY_DELAY = "org.lockss.jobDbManager.retryDelay";
    public static final String PARAM_FETCH_SIZE = "org.lockss.jobDbManager.fetchSize";
    private JobDbManagerSql jobDbManagerSql = new JobDbManagerSql(null, DEFAULT_DATASOURCE_CLASSNAME, "LOCKSS", 10, 3000L, 5000);

    public JobDbManager() {
        this.setUpVersions();
    }

    private void setUpVersions() {
        this.targetDatabaseVersion = 3;
        this.asynchronousUpdates = new int[0];
    }

    public void startService() {
        String DEBUG_HEADER = "startService(): ";
        if (log.isDebug2()) {
            log.debug2("startService(): Starting...");
        }
        this.setDbManagerSql(this.jobDbManagerSql);
        super.startService();
    }

    public void setConfig(Configuration config, Configuration prevConfig, Configuration.Differences changedKeys) {
        String DEBUG_HEADER = "setConfig(): ";
        if (log.isDebug2()) {
            log.debug2("setConfig(): Starting...");
        }
        if (changedKeys.contains(PREFIX)) {
            this.maxRetryCount = config.getInt(PARAM_MAX_RETRY_COUNT, 10);
            this.dbManagerSql.setMaxRetryCount(this.maxRetryCount);
            this.retryDelay = config.getTimeInterval(PARAM_RETRY_DELAY, 3000L);
            this.dbManagerSql.setRetryDelay(this.retryDelay);
            this.dbManagerEnabled = config.getBoolean(PARAM_DBMANAGER_ENABLED, true);
            this.fetchSize = config.getInt(PARAM_FETCH_SIZE, 5000);
            this.dbManagerSql.setFetchSize(this.fetchSize);
        }
        if (log.isDebug2()) {
            log.debug2("setConfig(): Done.");
        }
    }

    protected String getDataSourceRootName() {
        return DATASOURCE_ROOT;
    }

    protected String getDataSourceClassName(Configuration config) {
        return config.get(PARAM_DATASOURCE_CLASSNAME, DEFAULT_DATASOURCE_CLASSNAME);
    }

    protected String getDataSourceCreatedDatabase(Configuration config) {
        return config.get(PARAM_DATASOURCE_CREATEDATABASE, "create");
    }

    protected String getDataSourcePortNumber(Configuration config) {
        if (this.isTypePostgresql()) {
            return config.get(PARAM_DATASOURCE_PORTNUMBER, "5432");
        }
        if (this.isTypeMysql()) {
            return config.get(PARAM_DATASOURCE_PORTNUMBER, "3306");
        }
        return config.get(PARAM_DATASOURCE_PORTNUMBER, "1527");
    }

    protected String getDataSourceServerName(Configuration config) {
        return config.get(PARAM_DATASOURCE_SERVERNAME, "localhost");
    }

    protected String getDataSourceUser(Configuration config) {
        return config.get(PARAM_DATASOURCE_USER, "LOCKSS");
    }

    protected String getDataSourcePassword(Configuration config) {
        return config.get(PARAM_DATASOURCE_PASSWORD, "insecure");
    }

    protected String getDataSourceDatabaseName(Configuration config) {
        String dbName = config.get(PARAM_DATASOURCE_DATABASENAME, ((Object)((Object)this)).getClass().getSimpleName());
        if (this.isTypeDerby() && !dbName.startsWith(File.separator)) {
            String pathFromCache = "db/" + dbName;
            File datasourceDir = ConfigManager.getConfigManager().findConfiguredDataDir(pathFromCache, pathFromCache, false);
            return FileUtil.getCanonicalOrAbsolutePath((File)datasourceDir);
        }
        return dbName;
    }

    protected String getDerbyInfoLogAppend(Configuration config) {
        return config.get(PARAM_DERBY_INFOLOG_APPEND, "false");
    }

    protected String getDerbyLanguageLogQueryPlan(Configuration config) {
        return config.get(PARAM_DERBY_LANGUAGE_LOGQUERYPLAN, "false");
    }

    protected String getDerbyLanguageLogStatementText(Configuration config) {
        return config.get(PARAM_DERBY_LANGUAGE_LOGSTATEMENTTEXT, "false");
    }

    protected String getDerbyStreamErrorFile(Configuration config) {
        return config.get(PARAM_DERBY_STREAM_ERROR_FILE, "derby.log");
    }

    protected String getDerbyStreamErrorLogSeverityLevel(Configuration config) {
        return config.get(PARAM_DERBY_STREAM_ERROR_LOGSEVERITYLEVEL, "4000");
    }

    JobDbManagerSql getJobDbManagerSql() throws DbException {
        if (!this.ready) {
            throw new DbException("JobDbManager has not been initialized.");
        }
        return this.getJobDbManagerSqlBeforeReady();
    }

    JobDbManagerSql getJobDbManagerSqlBeforeReady() {
        return this.jobDbManagerSql;
    }

    void setTargetDatabaseVersion(int version) {
        this.targetDatabaseVersion = version;
    }

    /*
     * Exception decompiling
     */
    boolean setUpDatabase(int finalVersion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void updateDatabaseToVersion(Connection conn, int databaseVersion) throws SQLException {
        String DEBUG_HEADER = "updateDatabaseToVersion(): ";
        if (log.isDebug2()) {
            log.debug2("updateDatabaseToVersion(): databaseVersion = " + databaseVersion);
        }
        if (databaseVersion == 1) {
            this.jobDbManagerSql.setUpDatabaseVersion1(conn);
        } else if (databaseVersion == 2) {
            this.jobDbManagerSql.updateDatabaseFrom1To2(conn);
        } else if (databaseVersion == 3) {
            this.jobDbManagerSql.updateDatabaseFrom2To3(conn);
        } else {
            throw new RuntimeException("Non-existent method to update the database to version " + databaseVersion + ".");
        }
    }
}

