/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.metadata.extractor;

import java.nio.charset.Charset;
import java.util.Base64;
import org.lockss.config.CurrentConfig;
import org.lockss.metadata.ItemMetadata;
import org.lockss.util.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class StoreAuItemClient {
    private static Logger log = Logger.getLogger(StoreAuItemClient.class);

    public Long storeAuItem(ItemMetadata item) {
        String DEBUG_HEADER = "storeAuItem(): ";
        if (log.isDebug2()) {
            log.debug2("storeAuItem(): item = " + item);
        }
        String restServiceLocation = CurrentConfig.getParam((String)"org.lockss.metadataManager.mdRest.serviceLocation");
        if (log.isDebug3()) {
            log.debug3("storeAuItem(): restServiceLocation = " + restServiceLocation);
        }
        int timeoutValue = CurrentConfig.getIntParam((String)"org.lockss.metadataManager.mdRest.timeoutValue", (int)600);
        if (log.isDebug3()) {
            log.debug3("storeAuItem(): timeoutValue = " + timeoutValue);
        }
        String userName = CurrentConfig.getParam((String)"org.lockss.metadataManager.mdRest.userName");
        if (log.isDebug3()) {
            log.debug3("storeAuItem(): userName = '" + userName + "'");
        }
        String password = CurrentConfig.getParam((String)"org.lockss.metadataManager.mdRest.password");
        if (log.isDebug3()) {
            log.debug3("storeAuItem(): password = '" + password + "'");
        }
        RestTemplate restTemplate = new RestTemplate();
        SimpleClientHttpRequestFactory requestFactory = (SimpleClientHttpRequestFactory)restTemplate.getRequestFactory();
        requestFactory.setReadTimeout(1000 * timeoutValue);
        requestFactory.setConnectTimeout(1000 * timeoutValue);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String credentials = userName + ":" + password;
        String authHeaderValue = "Basic " + Base64.getEncoder().encodeToString(credentials.getBytes(Charset.forName("US-ASCII")));
        headers.set("Authorization", authHeaderValue);
        ResponseEntity response = restTemplate.exchange(restServiceLocation + "/aus", HttpMethod.POST, new HttpEntity((Object)item, (MultiValueMap)headers), Long.class, new Object[0]);
        HttpStatus statusCode = response.getStatusCode();
        if (log.isDebug3()) {
            log.debug3("storeAuItem(): statusCode = " + statusCode);
        }
        Long mdItemSeq = (Long)response.getBody();
        if (log.isDebug2()) {
            log.debug2("storeAuItem(): mdItemSeq = " + mdItemSeq);
        }
        return mdItemSeq;
    }
}

