/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.metadata.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lockss.db.DbException;
import org.lockss.db.DbManager;
import org.lockss.log.L4JLogger;
import org.lockss.metadata.ItemMetadata;
import org.lockss.metadata.ItemMetadataContinuationToken;
import org.lockss.metadata.ItemMetadataPage;
import org.lockss.plugin.PluginManager;

public class MetadataQueryManagerSql {
    private static final L4JLogger log = L4JLogger.getLogger();
    private static final String FIND_AU_MD_BY_AU_ID_QUERY = "select m.au_md_seq from au_md m,au a,plugin p where m.au_seq = a.au_seq and a.plugin_seq = p.plugin_seq and p.plugin_id = ? and a.au_key = ?";
    private static final String FIND_AU_BY_AU_ID_QUERY = "select a.au_seq from au a,plugin p where a.plugin_seq = p.plugin_seq and p.plugin_id = ? and a.au_key = ?";
    private static final String UPDATE_AU_MD_EXTRACT_TIME_QUERY = "update au_md set extract_time = ? where au_md_seq = ?";
    private static final String FIND_AU_MD_EXTRACT_TIME_BY_AUSEQ_QUERY = "select extract_time from au_md where au_seq = ?";
    private static final String INSERT_AUTHOR_QUERY = "insert into author(md_item_seq,author_name,author_idx) values (?,?,(select coalesce(max(author_idx), 0) + 1 from author where md_item_seq = ?))";
    private static final String INSERT_AUTHOR_MYSQL_QUERY = "insert into author(md_item_seq,author_name,author_idx) values (?,?,(select next_idx from (select coalesce(max(author_idx), 0) + 1 as next_idx from author where md_item_seq = ?) as temp_author_table))";
    private static final String INSERT_KEYWORD_QUERY = "insert into keyword(md_item_seq,keyword) values (?,?)";
    private static final String UPDATE_AU_MD_UNKNOWN_PROVIDER_QUERY = "update au_md set provider_seq = ? where au_md_seq IN (select am.au_md_seq from au_md am,provider p where am.provider_seq = p.provider_seq and p.provider_name = 'UNKNOWN PROVIDER' and am.au_md_seq = ?)";
    private static final String FIND_NEXT_PAGE_AU_MD_ITEM_QUERY = "select distinct pr.publisher_name, min1.name as publication_name, mi2.md_item_seq, min2.name as item_title, mi2.date, mi2.coverage, mi2.fetch_time, b.volume, b.issue, b.start_page, b.end_page, b.item_no, d.doi, pv.provider_name from publisher pr,plugin pl,publication pn,md_item_name min1,au_md am,au,provider pv,md_item mi2 left outer join md_item_name min2 on mi2.md_item_seq = min2.md_item_seq and min2.name_type = 'primary' left outer join doi d on mi2.md_item_seq = d.md_item_seq left outer join bib_item b on mi2.md_item_seq = b.md_item_seq where pr.publisher_seq = pn.publisher_seq and pn.md_item_seq = min1.md_item_seq and min1.name_type = 'primary' and pn.md_item_seq = mi2.parent_seq and mi2.au_md_seq = am.au_md_seq and am.au_seq = au.au_seq and au.plugin_seq = pl.plugin_seq and am.provider_seq = pv.provider_seq and pl.plugin_id = ? and au.au_key = ? and mi2.md_item_seq > ? order by mi2.md_item_seq";
    private static final String GET_MULTIPLE_MD_DETAIL_QUERY = "select distinct mi2.md_item_seq, u.feature, u.url, a.author_name, a.author_idx, k.keyword, issn.issn, issn.issn_type, isbn.isbn, isbn.isbn_type, pi.proprietary_id from md_item mi2 left outer join md_item_name min2 on mi2.md_item_seq = min2.md_item_seq and min2.name_type = 'primary' left outer join issn on mi2.parent_seq = issn.md_item_seq left outer join isbn on mi2.parent_seq = isbn.md_item_seq left outer join proprietary_id pi on mi2.parent_seq = pi.md_item_seq left outer join url u on mi2.md_item_seq = u.md_item_seq left outer join author a on mi2.md_item_seq = a.md_item_seq left outer join keyword k on mi2.md_item_seq = k.md_item_seq where mi2.md_item_seq in () order by mi2.md_item_seq, a.author_idx";
    private DbManager dbManager;

    MetadataQueryManagerSql(DbManager dbManager) throws DbException {
        this.dbManager = dbManager;
    }

    Long findAuMdByAuId(Connection conn, String auId) throws DbException {
        log.debug2("auId = {}", (Object)auId);
        String pluginId = null;
        String auKey = null;
        Long auMdSeq = null;
        PreparedStatement findAuMd = this.dbManager.prepareStatement(conn, FIND_AU_MD_BY_AU_ID_QUERY);
        ResultSet resultSet = null;
        try {
            pluginId = PluginManager.pluginIdFromAuId((String)auId);
            log.trace("pluginId() = {}", (Object)pluginId);
            auKey = PluginManager.auKeyFromAuId((String)auId);
            log.trace("auKey = {}", (Object)auKey);
            findAuMd.setString(1, pluginId);
            findAuMd.setString(2, auKey);
            resultSet = this.dbManager.executeQuery(findAuMd);
            if (resultSet.next()) {
                auMdSeq = resultSet.getLong("au_md_seq");
                log.trace("auMdSeq = {}", (Object)auMdSeq);
            }
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot find AU metadata identifier";
                log.error(message, (Throwable)sqle);
                log.error("auId = {}", (Object)auId);
                log.error("SQL = '{}'", (Object)FIND_AU_MD_BY_AU_ID_QUERY);
                log.error("pluginId = {}", (Object)pluginId);
                log.error("auKey = {}", (Object)auKey);
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseResultSet(resultSet);
                DbManager.safeCloseStatement((Statement)findAuMd);
                throw throwable;
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)findAuMd);
        log.debug2("auMdSeq = {}", (Object)auMdSeq);
        return auMdSeq;
    }

    Long findAuByAuId(Connection conn, String auId) throws DbException {
        log.debug2("auId = {}", (Object)auId);
        String pluginId = PluginManager.pluginIdFromAuId((String)auId);
        String auKey = PluginManager.auKeyFromAuId((String)auId);
        Long auSeq = null;
        PreparedStatement findAu = this.dbManager.prepareStatement(conn, FIND_AU_BY_AU_ID_QUERY);
        ResultSet resultSet = null;
        try {
            pluginId = PluginManager.pluginIdFromAuId((String)auId);
            log.trace("pluginId = {}", (Object)pluginId);
            auKey = PluginManager.auKeyFromAuId((String)auId);
            log.trace("auKey = {}", (Object)auKey);
            findAu.setString(1, pluginId);
            findAu.setString(2, auKey);
            resultSet = this.dbManager.executeQuery(findAu);
            if (resultSet.next()) {
                auSeq = resultSet.getLong("au_seq");
                log.trace("auSeq = {}", (Object)auSeq);
            }
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot find AU identifier";
                log.error(message, (Throwable)sqle);
                log.error("auId = {}", (Object)auId);
                log.error("SQL = '{}'", (Object)FIND_AU_BY_AU_ID_QUERY);
                log.error("pluginId = {}", (Object)pluginId);
                log.error("auKey = {}", (Object)auKey);
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseResultSet(resultSet);
                DbManager.safeCloseStatement((Statement)findAu);
                throw throwable;
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)findAu);
        log.debug2("auSeq = {}", (Object)auSeq);
        return auSeq;
    }

    void updateAuLastExtractionTime(Connection conn, Long auMdSeq, long now) throws DbException {
        log.debug2("auMdSeq = {}", (Object)auMdSeq);
        log.debug2("now = {}", (Object)now);
        PreparedStatement updateAuLastExtractionTime = this.dbManager.prepareStatement(conn, UPDATE_AU_MD_EXTRACT_TIME_QUERY);
        try {
            updateAuLastExtractionTime.setLong(1, now);
            updateAuLastExtractionTime.setLong(2, auMdSeq);
            this.dbManager.executeUpdate(updateAuLastExtractionTime);
        }
        catch (SQLException sqle) {
            String message = "Cannot update the AU extraction time";
            log.error(message, (Throwable)sqle);
            log.error("SQL = '{}'", (Object)UPDATE_AU_MD_EXTRACT_TIME_QUERY);
            log.error("auMdSeq = {}", (Object)auMdSeq);
            log.error("now = {}", (Object)now);
            throw new DbException(message, (Throwable)sqle);
        }
        finally {
            DbManager.safeCloseStatement((Statement)updateAuLastExtractionTime);
        }
        log.debug2("Done.");
    }

    long getAuExtractionTime(Connection conn, Long auSeq) throws DbException {
        log.debug2("auSeq = {}", (Object)auSeq);
        long timestamp = 0L;
        PreparedStatement selectLastExtractionTime = null;
        ResultSet resultSet = null;
        try {
            selectLastExtractionTime = this.dbManager.prepareStatement(conn, FIND_AU_MD_EXTRACT_TIME_BY_AUSEQ_QUERY);
            selectLastExtractionTime.setLong(1, auSeq);
            resultSet = this.dbManager.executeQuery(selectLastExtractionTime);
            if (resultSet.next()) {
                timestamp = resultSet.getLong("extract_time");
                log.trace("timestamp = {}", (Object)timestamp);
            }
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot get AU extraction time";
                log.error(message, (Throwable)sqle);
                log.error("SQL = '{}'", (Object)FIND_AU_MD_EXTRACT_TIME_BY_AUSEQ_QUERY);
                log.error("auSeq = {}", (Object)auSeq);
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseResultSet(resultSet);
                DbManager.safeCloseStatement((Statement)selectLastExtractionTime);
                throw throwable;
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)selectLastExtractionTime);
        log.debug2("timestamp = {}", (Object)timestamp);
        return timestamp;
    }

    public void addMdItemAuthors(Connection conn, Long mdItemSeq, Collection<String> authors) throws DbException {
        log.debug2("mdItemSeq = {}", (Object)mdItemSeq);
        log.debug2("authors = {}", authors);
        if (authors == null || authors.size() == 0) {
            return;
        }
        String sql = this.getInsertMdItemAuthorSql();
        PreparedStatement insertMdItemAuthor = this.dbManager.prepareStatement(conn, sql);
        try {
            for (String author : authors) {
                insertMdItemAuthor.setLong(1, mdItemSeq);
                insertMdItemAuthor.setString(2, author);
                insertMdItemAuthor.setLong(3, mdItemSeq);
                int count = this.dbManager.executeUpdate(insertMdItemAuthor);
                log.trace("count = {}", (Object)count);
                log.trace("Added author = {}", (Object)author);
            }
        }
        catch (SQLException sqle) {
            String message = "Cannot add metadata item authors";
            log.error(message, (Throwable)sqle);
            log.error("SQL = '{}'", (Object)sql);
            log.error("mdItemSeq = {}", (Object)mdItemSeq);
            log.error("authors = {}", authors);
            throw new DbException(message, (Throwable)sqle);
        }
        finally {
            DbManager.safeCloseStatement((Statement)insertMdItemAuthor);
        }
        log.debug2("Done.");
    }

    private String getInsertMdItemAuthorSql() {
        if (this.dbManager.isTypeMysql()) {
            return INSERT_AUTHOR_MYSQL_QUERY;
        }
        return INSERT_AUTHOR_QUERY;
    }

    public void addMdItemKeywords(Connection conn, Long mdItemSeq, Collection<String> keywords) throws DbException {
        log.debug2("mdItemSeq = {}", (Object)mdItemSeq);
        log.debug2("keywords = {}", keywords);
        if (keywords == null || keywords.size() == 0) {
            return;
        }
        PreparedStatement insertMdItemKeyword = this.dbManager.prepareStatement(conn, INSERT_KEYWORD_QUERY);
        try {
            for (String keyword : keywords) {
                insertMdItemKeyword.setLong(1, mdItemSeq);
                insertMdItemKeyword.setString(2, keyword);
                int count = this.dbManager.executeUpdate(insertMdItemKeyword);
                log.trace("count = {}", (Object)count);
                log.trace("Added keyword = {}", (Object)keyword);
            }
        }
        catch (SQLException sqle) {
            String message = "Cannot add metadata item keywords";
            log.error(message, (Throwable)sqle);
            log.error("SQL = '{}'", (Object)INSERT_KEYWORD_QUERY);
            log.error("mdItemSeq = {}", (Object)mdItemSeq);
            log.error("keywords = {}", keywords);
            throw new DbException(message, (Throwable)sqle);
        }
        finally {
            DbManager.safeCloseStatement((Statement)insertMdItemKeyword);
        }
        log.debug2("Done.");
    }

    public boolean updateAuUnknownProvider(Connection conn, Long auMdSeq, Long providerSeq) throws DbException {
        log.debug2("auMdSeq = {}", (Object)auMdSeq);
        log.debug2("providerSeq = {}", (Object)providerSeq);
        int updatedCount = -1;
        PreparedStatement updateUnknownProvider = this.dbManager.prepareStatement(conn, UPDATE_AU_MD_UNKNOWN_PROVIDER_QUERY);
        try {
            updateUnknownProvider.setLong(1, providerSeq);
            updateUnknownProvider.setLong(2, auMdSeq);
            updatedCount = this.dbManager.executeUpdate(updateUnknownProvider);
            log.trace("updatedCount = {}", (Object)updatedCount);
        }
        catch (SQLException sqle) {
            String message = "Cannot update unknown provider";
            log.error(message, (Throwable)sqle);
            log.error("auMdSeq = {}", (Object)auMdSeq);
            log.error("providerSeq = {}", (Object)providerSeq);
            log.error("SQL = '{}'", (Object)UPDATE_AU_MD_UNKNOWN_PROVIDER_QUERY);
            throw new DbException(message, (Throwable)sqle);
        }
        finally {
            DbManager.safeCloseStatement((Statement)updateUnknownProvider);
        }
        log.debug2("result = {}", (Object)(updatedCount > 0 ? 1 : 0));
        return updatedCount > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ItemMetadataPage getAuMetadataDetail(String auId, Integer limit, ItemMetadataContinuationToken continuationToken) throws DbException {
        log.debug2("auId = {}", (Object)auId);
        log.debug2("limit = {}", (Object)limit);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        ItemMetadataPage result = new ItemMetadataPage();
        Connection conn = null;
        try {
            conn = this.dbManager.getConnection();
            Long auSeq = this.findAuByAuId(conn, auId);
            log.trace("auSeq = {}", (Object)auSeq);
            if (auSeq == null) {
                throw new IllegalArgumentException("AuId not found in DB: " + auId);
            }
            long extractionTime = this.getAuExtractionTime(conn, auSeq);
            log.trace("extractionTime = {}", (Object)extractionTime);
            Long auExtractionTimestamp = null;
            Long lastItemMdItemSeq = null;
            if (continuationToken != null) {
                auExtractionTimestamp = continuationToken.getAuExtractionTimestamp();
                lastItemMdItemSeq = continuationToken.getLastItemMdItemSeq();
            }
            if (auExtractionTimestamp != null && auExtractionTimestamp != extractionTime) {
                log.warn("Incompatible pagination request: request timestamp: {}, current timestamp: {}", (Object)continuationToken.getAuExtractionTimestamp(), (Object)extractionTime);
                throw new ConcurrentModificationException("Incompatible pagination for auid '" + auId + "': Metadata has changed since previous request");
            }
            result = this.getAuMetadataDetail(conn, auId, extractionTime, limit, lastItemMdItemSeq);
        }
        finally {
            DbManager.safeRollbackAndClose((Connection)conn);
        }
        log.debug2("Done.");
        return result;
    }

    private ItemMetadataPage getAuMetadataDetail(Connection conn, String auId, long auExtractionTime, Integer limit, Long lastItemMdItemSeq) throws DbException {
        boolean hasMore;
        ResultSet resultSet;
        PreparedStatement getScalarMetadata;
        String sql;
        ItemMetadata itemMetadata;
        String auKey;
        String pluginId;
        HashMap<Long, ItemMetadata> itemMap;
        ArrayList<ItemMetadata> items;
        ItemMetadataPage result;
        block51: {
            Long mdItemSeq;
            log.debug2("auId = {}", (Object)auId);
            log.debug2("auExtractionTime = {}", (Object)auExtractionTime);
            log.debug2("limit = {}", (Object)limit);
            log.debug2("lastItemMdItemSeq = {}", (Object)lastItemMdItemSeq);
            result = new ItemMetadataPage();
            items = new ArrayList<ItemMetadata>();
            result.setItems(items);
            itemMap = new HashMap<Long, ItemMetadata>();
            pluginId = null;
            auKey = null;
            Long previousMdItemSeq = null;
            itemMetadata = null;
            sql = FIND_NEXT_PAGE_AU_MD_ITEM_QUERY;
            getScalarMetadata = this.dbManager.prepareStatement(conn, sql);
            resultSet = null;
            hasMore = false;
            pluginId = PluginManager.pluginIdFromAuId((String)auId);
            log.trace("pluginId() = {}", (Object)pluginId);
            auKey = PluginManager.auKeyFromAuId((String)auId);
            log.trace("auKey = {}", (Object)auKey);
            getScalarMetadata.setString(1, pluginId);
            getScalarMetadata.setString(2, auKey);
            if (lastItemMdItemSeq == null) {
                getScalarMetadata.setLong(3, -1L);
            } else {
                getScalarMetadata.setLong(3, lastItemMdItemSeq);
            }
            boolean isPaginating = false;
            if (limit != null && limit > 0) {
                isPaginating = true;
                getScalarMetadata.setMaxRows(limit + 1);
            }
            resultSet = this.dbManager.executeQuery(getScalarMetadata);
            while (resultSet.next()) {
                if (isPaginating && items.size() == limit.intValue()) {
                    hasMore = true;
                    break;
                }
                mdItemSeq = resultSet.getLong("md_item_seq");
                log.trace("mdItemSeq = {}", (Object)mdItemSeq);
                if (!mdItemSeq.equals(previousMdItemSeq)) {
                    itemMetadata = new ItemMetadata(mdItemSeq);
                    itemMetadata.setScalarMap(new HashMap());
                    itemMetadata.setSetMap(new HashMap());
                    itemMetadata.setListMap(new HashMap());
                    itemMetadata.setMapMap(new HashMap());
                    Map scalarMap = itemMetadata.getScalarMap();
                    scalarMap.put("au_id", auId);
                    String providerName = resultSet.getString("provider_name");
                    log.trace("providerName = {}", (Object)providerName);
                    if (!resultSet.wasNull()) {
                        scalarMap.put("provider_name", providerName);
                    }
                    String publisherName = resultSet.getString("publisher_name");
                    log.trace("publisherName = {}", (Object)publisherName);
                    if (!resultSet.wasNull()) {
                        scalarMap.put("publisher_name", publisherName);
                    }
                    String publicationName = resultSet.getString("publication_name");
                    log.trace("publicationName = {}", (Object)publicationName);
                    if (!resultSet.wasNull()) {
                        scalarMap.put("publication_name", publicationName);
                    }
                    String date = resultSet.getString("date");
                    log.trace("date = {}", (Object)date);
                    if (!resultSet.wasNull()) {
                        scalarMap.put("date", date);
                    }
                    String coverage = resultSet.getString("coverage");
                    log.trace("coverage = {}", (Object)coverage);
                    if (!resultSet.wasNull()) {
                        scalarMap.put("coverage", coverage);
                    }
                    Long fetchTime = resultSet.getLong("fetch_time");
                    log.trace("fetchTime = {}", (Object)fetchTime);
                    if (!resultSet.wasNull()) {
                        scalarMap.put("fetch_time", fetchTime.toString());
                    }
                    String itemTitle = resultSet.getString("item_title");
                    log.trace("itemTitle = {}", (Object)itemTitle);
                    if (!resultSet.wasNull()) {
                        scalarMap.put("item_title", itemTitle);
                    }
                    String volume = resultSet.getString("volume");
                    log.trace("volume = {}", (Object)volume);
                    if (!resultSet.wasNull()) {
                        scalarMap.put("volume", volume);
                    }
                    String issue = resultSet.getString("issue");
                    log.trace("issue = {}", (Object)issue);
                    if (!resultSet.wasNull()) {
                        scalarMap.put("issue", issue);
                    }
                    String startPage = resultSet.getString("start_page");
                    log.trace("startPage = {}", (Object)startPage);
                    if (!resultSet.wasNull()) {
                        scalarMap.put("start_page", startPage);
                    }
                    String endPage = resultSet.getString("end_page");
                    log.trace("endPage = {}", (Object)endPage);
                    if (!resultSet.wasNull()) {
                        scalarMap.put("end_page", endPage);
                    }
                    String itemNo = resultSet.getString("item_no");
                    log.trace("itemNo = {}", (Object)itemNo);
                    if (!resultSet.wasNull()) {
                        scalarMap.put("item_no", itemNo);
                    }
                    String doi = resultSet.getString("doi");
                    log.trace("doi = {}", (Object)doi);
                    if (!resultSet.wasNull()) {
                        scalarMap.put("doi", doi);
                    }
                    log.trace("itemMetadata = {}", (Object)itemMetadata);
                    items.add(itemMetadata);
                    itemMap.put(mdItemSeq, itemMetadata);
                    previousMdItemSeq = mdItemSeq;
                    continue;
                }
                log.error("Ignoring unexpected multiple scalar results for mdItemSeq = {}: Existing result: {}", (Object)mdItemSeq, (Object)itemMetadata);
            }
            resultSet.close();
            if (items.size() != 0) break block51;
            log.debug2("result = {}", (Object)result);
            mdItemSeq = result;
            DbManager.safeCloseResultSet((ResultSet)resultSet);
            DbManager.safeCloseStatement((Statement)getScalarMetadata);
            return mdItemSeq;
        }
        try {
            StringBuilder inIds = new StringBuilder("(");
            boolean isFirst = true;
            for (Long id : itemMap.keySet()) {
                log.trace("id = {}", (Object)id);
                if (!isFirst) {
                    inIds.append(", ");
                } else {
                    isFirst = false;
                }
                inIds.append(id);
            }
            inIds.append(")");
            sql = GET_MULTIPLE_MD_DETAIL_QUERY.replaceFirst("\\(\\)", inIds.toString());
            log.trace("sql = '{}'", (Object)sql);
            PreparedStatement getNonScalarMetadata = this.dbManager.prepareStatement(conn, sql);
            resultSet = this.dbManager.executeQuery(getNonScalarMetadata);
            while (resultSet.next()) {
                Long mdItemSeq = resultSet.getLong("md_item_seq");
                log.trace("mdItemSeq = {}", (Object)mdItemSeq);
                itemMetadata = (ItemMetadata)itemMap.get(mdItemSeq);
                if (itemMetadata == null) {
                    log.error("Ignoring non-scalar results for mdItemSeq = {} with no previously retrieved scalar results.", (Object)mdItemSeq);
                    continue;
                }
                String issn = resultSet.getString("issn");
                log.trace("issn = {}", (Object)issn);
                if (!resultSet.wasNull()) {
                    String type = resultSet.getString("issn_type");
                    log.trace("type = {}", (Object)type);
                    if (!resultSet.wasNull()) {
                        Map issns = (Map)itemMetadata.getMapMap().get("issn");
                        if (issns == null) {
                            itemMetadata.getMapMap().put("issn", new HashMap());
                            ((Map)itemMetadata.getMapMap().get("issn")).put(type, issn);
                        } else {
                            issns.put(type, issn);
                        }
                    }
                }
                String isbn = resultSet.getString("isbn");
                log.trace("isbn = {}", (Object)isbn);
                if (!resultSet.wasNull()) {
                    String type = resultSet.getString("isbn_type");
                    log.trace("type = {}", (Object)type);
                    if (!resultSet.wasNull()) {
                        Map isbns = (Map)itemMetadata.getMapMap().get("isbn");
                        if (isbns == null) {
                            itemMetadata.getMapMap().put("isbn", new HashMap());
                            ((Map)itemMetadata.getMapMap().get("isbn")).put(type, isbn);
                        } else {
                            isbns.put(type, isbn);
                        }
                    }
                }
                String proprietaryId = resultSet.getString("proprietary_id");
                log.trace("proprietaryId = {}", (Object)proprietaryId);
                if (!resultSet.wasNull()) {
                    Set pis = (Set)itemMetadata.getSetMap().get("proprietary_id");
                    if (pis == null) {
                        itemMetadata.getSetMap().put("proprietary_id", new HashSet());
                        ((Set)itemMetadata.getSetMap().get("proprietary_id")).add(proprietaryId);
                    } else if (!pis.contains(proprietaryId)) {
                        pis.add(proprietaryId);
                    }
                }
                String url = resultSet.getString("url");
                log.trace("url = {}", (Object)url);
                if (!resultSet.wasNull()) {
                    String feature = resultSet.getString("feature");
                    log.trace("feature = {}", (Object)feature);
                    if (!resultSet.wasNull()) {
                        Map urls = (Map)itemMetadata.getMapMap().get("url");
                        if (urls == null) {
                            itemMetadata.getMapMap().put("url", new HashMap());
                            ((Map)itemMetadata.getMapMap().get("url")).put(feature, url);
                        } else {
                            urls.put(feature, url);
                        }
                    }
                }
                String author = resultSet.getString("author_name");
                log.trace("author = {}", (Object)author);
                if (!resultSet.wasNull()) {
                    List authors = (List)itemMetadata.getListMap().get("author_name");
                    if (authors == null) {
                        itemMetadata.getListMap().put("author_name", new ArrayList());
                        ((List)itemMetadata.getListMap().get("author_name")).add(author);
                    } else if (!authors.contains(author)) {
                        authors.add(author);
                    }
                }
                String keyword = resultSet.getString("keyword");
                log.trace("keyword = {}", (Object)keyword);
                if (resultSet.wasNull()) continue;
                Set keywords = (Set)itemMetadata.getSetMap().get("keyword");
                if (keywords == null) {
                    itemMetadata.getSetMap().put("keyword", new HashSet());
                    ((Set)itemMetadata.getSetMap().get("keyword")).add(keyword);
                    continue;
                }
                if (keywords.contains(keyword)) continue;
                keywords.add(keyword);
            }
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot get AU metadata";
                log.error(message, (Throwable)sqle);
                log.error("auId = '{}'", (Object)auId);
                log.error("auExtractionTime = {}", (Object)auExtractionTime);
                log.error("limit = {}", (Object)limit);
                log.error("lastItemMdItemSeq = {}", (Object)lastItemMdItemSeq);
                log.error("SQL = '{}'", (Object)sql);
                log.error("pluginId = '{}'", (Object)pluginId);
                log.error("auKey = '{}'", (Object)auKey);
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseResultSet(resultSet);
                DbManager.safeCloseStatement((Statement)getScalarMetadata);
                throw throwable;
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)getScalarMetadata);
        if (hasMore) {
            ItemMetadataContinuationToken continuationToken = new ItemMetadataContinuationToken(Long.valueOf(auExtractionTime), ((ItemMetadata)items.get(items.size() - 1)).getId());
            log.trace("continuationToken = {}", (Object)continuationToken);
            result.setContinuationToken(continuationToken);
        }
        log.debug2("Done.");
        return result;
    }
}

