/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.metadata.extractor.job;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lockss.db.DbException;
import org.lockss.metadata.extractor.job.Job;
import org.lockss.metadata.extractor.job.JobAuStatus;
import org.lockss.metadata.extractor.job.JobContinuationToken;
import org.lockss.metadata.extractor.job.JobDbManager;
import org.lockss.metadata.extractor.job.JobPage;
import org.lockss.plugin.PluginManager;
import org.lockss.util.Logger;

public class JobManagerSql {
    private static final Logger log = Logger.getLogger(JobManagerSql.class);
    private static final String INITIAL_JOB_STATUS_MESSAGE = "Waiting for launch";
    private static final String FIND_JOB_QUERY = "select job_seq, job_type_seq, description, plugin_id, au_key, creation_time, start_time, end_time, job_status_seq, status_message, priority from job where job_seq = ?";
    private static final String FIND_AU_JOB_QUERY = "select job_seq, job_type_seq, description, plugin_id, au_key, creation_time, start_time, end_time, job_status_seq, status_message, priority from job where plugin_id = ? and au_key = ? order by job_seq";
    private static final String DELETE_ALL_JOBS_QUERY = "delete from job";
    private static final String DELETE_JOB_QUERY = "delete from job where job_seq = ?";
    private static final String GET_JOB_STATUSES_QUERY = "select job_status_seq,status_name from job_status";
    private static final String GET_JOB_TYPES_QUERY = "select job_type_seq,type_name from job_type";
    private static final String INSERT_JOB_QUERY = "insert into job(job_seq,job_type_seq,description,plugin_id,au_key,creation_time,start_time,end_time,job_status_seq,status_message,priority) values (default,?,?,?,?,?,?,?,?,?,(select coalesce(max(priority), 0) + 1 from job where priority >= 0))";
    private static final String INSERT_JOB_MYSQL_QUERY = "insert into job(job_seq,job_type_seq,description,plugin_id,plugin_id,au_key,creation_time,start_time,end_time,job_status_seq,status_message,priority) values (default,?,?,?,?,?,?,?,?,?,?,(select next_priority from (select coalesce(max(priority), 0) + 1 as next_priority from job where priority >= 0) as temp_job_table))";
    private static final String FIND_NEXT_PAGE_JOBS_QUERY = "select job_seq, job_type_seq, description, plugin_id, au_key, creation_time, start_time, end_time, job_status_seq, status_message, priority from job where job_seq > ? order by job_seq";
    private static final String DELETE_INACTIVE_JOBS_QUERY = "delete from job where job_status_seq != ? and job_status_seq != ?";
    private static final String DELETE_INACTIVE_JOB_QUERY = "delete from job where job_seq = ? and job_status_seq != ? and job_status_seq != ?";
    private static final String FREE_INCOMPLETE_JOBS_QUERY = "update job set start_time = null, end_time = null, job_status_seq = ?, status_message = 'Waiting for launch', owner = null where owner is not null and job_status_seq < ?";
    private static final String FIND_HIGHEST_PRIORITY_JOBS_QUERY = "select job_seq from job where owner is null order by priority, job_seq";
    private static final String CLAIM_UNCLAIMED_JOB_QUERY = "update job set owner = ? where owner is null and job_seq = ?";
    private static final String FIND_JOB_TYPE_QUERY = "select jt.type_name from job j, job_type jt where j.job_type_seq = jt.job_type_seq and j.job_seq = ?";
    private static final String MARK_JOB_AS_RUNNING_QUERY = "update job set start_time = ?, job_status_seq = ?, status_message = ? where job_seq = ?";
    private static final String MARK_JOB_AS_FINISHED_QUERY = "update job set end_time = ?, job_status_seq = ?, status_message = ? where job_seq = ?";
    private static final String COUNT_REINDEXING_JOBS_BY_STATUS_QUERY = "select count(*) from job where job_type_seq != ?  and job_status_seq = ?";
    private static final String REINDEXING_JOBS_BY_STATUS_QUERY = "select job_seq, job_type_seq, plugin_id, au_key, start_time, end_time, priority, status_message from job where job_type_seq != ? and job_status_seq = ?";
    private static final String REINDEXING_JOBS_BEFORE_BY_STATUS_QUERY = "select job_seq, job_type_seq, plugin_id, au_key, start_time, end_time, priority, status_message from job where job_type_seq != ? and job_status_seq = ? and start_time < ?";
    private static final String UPDATE_TRUNCATION_TIMESTAMP_QUERY = "update job_metadata set truncation_time = ?";
    private static final String GET_TRUNCATION_TIMESTAMP_QUERY = "select truncation_time from job_metadata";
    private static final String COUNT_REINDEXING_JOBS_QUERY = "select count(*) from job where job_type_seq != ? ";
    private static final String COUNT_REINDEXING_JOBS_BY_STATUS_AND_MESSAGE_QUERY = "select count(*) from job where job_type_seq != ?  and job_status_seq = ? and status_message = ?";
    private final JobDbManager dbManager;
    private final Map<String, Long> jobStatusSeqByName;
    private final Map<String, Long> jobTypeSeqByName;

    JobManagerSql(JobDbManager dbManager) throws DbException {
        this.dbManager = dbManager;
        Connection conn = dbManager.getConnection();
        try {
            this.jobStatusSeqByName = this.mapJobStatusByName(conn);
            this.jobTypeSeqByName = this.mapJobTypeByName(conn);
        }
        finally {
            JobDbManager.safeRollbackAndClose((Connection)conn);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Long> mapJobStatusByName(Connection conn) throws DbException {
        String DEBUG_HEADER = "mapJobStatusByName(): ";
        if (log.isDebug2()) {
            log.debug2("mapJobStatusByName(): Invoked.");
        }
        HashMap<String, Long> result = new HashMap<String, Long>();
        PreparedStatement stmt = this.dbManager.prepareStatement(conn, GET_JOB_STATUSES_QUERY);
        ResultSet resultSet = null;
        try {
            resultSet = this.dbManager.executeQuery(stmt);
            while (resultSet.next()) {
                Long jobStatusSeq = resultSet.getLong("job_status_seq");
                if (log.isDebug3()) {
                    log.debug3("mapJobStatusByName(): jobStatusSeq = " + jobStatusSeq);
                }
                String statusName = resultSet.getString("status_name");
                if (log.isDebug3()) {
                    log.debug3("mapJobStatusByName(): statusName = " + statusName);
                }
                result.put(statusName, jobStatusSeq);
            }
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot get the job statuses";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'select job_status_seq,status_name from job_status'.");
                throw new DbException(message, (Throwable)sqle);
                catch (DbException dbe) {
                    message = "Cannot get the job statuses";
                    log.error(message, (Throwable)dbe);
                    log.error("SQL = 'select job_status_seq,status_name from job_status'.");
                    throw dbe;
                }
            }
            catch (Throwable throwable) {
                JobDbManager.safeCloseResultSet(resultSet);
                JobDbManager.safeCloseStatement((Statement)stmt);
                throw throwable;
            }
        }
        JobDbManager.safeCloseResultSet((ResultSet)resultSet);
        JobDbManager.safeCloseStatement((Statement)stmt);
        if (log.isDebug2()) {
            log.debug2("mapJobStatusByName(): Done.");
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Long> mapJobTypeByName(Connection conn) throws DbException {
        String DEBUG_HEADER = "mapJobTypeByName(): ";
        if (log.isDebug2()) {
            log.debug2("mapJobTypeByName(): Invoked.");
        }
        HashMap<String, Long> result = new HashMap<String, Long>();
        PreparedStatement stmt = this.dbManager.prepareStatement(conn, GET_JOB_TYPES_QUERY);
        ResultSet resultSet = null;
        try {
            resultSet = this.dbManager.executeQuery(stmt);
            while (resultSet.next()) {
                Long jobTypeSeq = resultSet.getLong("job_type_seq");
                if (log.isDebug3()) {
                    log.debug3("mapJobTypeByName(): jobTypeSeq = " + jobTypeSeq);
                }
                String typeName = resultSet.getString("type_name");
                if (log.isDebug3()) {
                    log.debug3("mapJobTypeByName(): typeName = " + typeName);
                }
                result.put(typeName, jobTypeSeq);
            }
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot get the job statuses";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'select job_type_seq,type_name from job_type'.");
                throw new DbException(message, (Throwable)sqle);
                catch (DbException dbe) {
                    message = "Cannot get the job statuses";
                    log.error(message, (Throwable)dbe);
                    log.error("SQL = 'select job_type_seq,type_name from job_type'.");
                    throw dbe;
                }
            }
            catch (Throwable throwable) {
                JobDbManager.safeCloseResultSet(resultSet);
                JobDbManager.safeCloseStatement((Statement)stmt);
                throw throwable;
            }
        }
        JobDbManager.safeCloseResultSet((ResultSet)resultSet);
        JobDbManager.safeCloseStatement((Statement)stmt);
        if (log.isDebug2()) {
            log.debug2("mapJobTypeByName(): Done.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobAuStatus createMetadataExtractionJob(String auId, boolean needFullReindex) throws IllegalArgumentException, DbException {
        String DEBUG_HEADER = "createMetadataExtractionJob(): ";
        if (log.isDebug2()) {
            log.debug2("createMetadataExtractionJob(): auId = " + auId);
            log.debug2("createMetadataExtractionJob(): needFullReindex = " + needFullReindex);
        }
        JobAuStatus result = null;
        Connection conn = null;
        try {
            conn = this.dbManager.getConnection();
            result = this.createMetadataExtractionJob(conn, auId, needFullReindex);
            JobDbManager.commitOrRollback((Connection)conn, (Logger)log);
        }
        finally {
            JobDbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("createMetadataExtractionJob(): result = " + result);
        }
        return result;
    }

    private JobAuStatus createMetadataExtractionJob(Connection conn, String auId, boolean needFullReindex) throws IllegalArgumentException, DbException {
        String DEBUG_HEADER = "createMetadataExtractionJob(): ";
        if (log.isDebug2()) {
            log.debug2("createMetadataExtractionJob(): auId = " + auId);
            log.debug2("createMetadataExtractionJob(): needFullReindex = " + needFullReindex);
        }
        JobAuStatus result = null;
        List<JobAuStatus> auJobs = this.getAuJobs(conn, auId);
        for (JobAuStatus job : auJobs) {
            Long jobTypeSeq = job.getType();
            if (log.isDebug3()) {
                log.debug3("createMetadataExtractionJob(): jobTypeSeq = " + jobTypeSeq);
            }
            if (this.jobTypeSeqByName.get("put_au").equals(jobTypeSeq) && needFullReindex || this.jobTypeSeqByName.get("put_incremental_au").equals(jobTypeSeq) && !needFullReindex) {
                Long jobStatusSeq = (long)job.getStatusCode();
                if (this.jobStatusSeqByName.get("created").equals(jobStatusSeq)) {
                    if (log.isDebug3()) {
                        log.debug3("createMetadataExtractionJob(): Reusing job = " + job);
                    }
                    result = job;
                    continue;
                }
                boolean deletedPutJob = this.deleteInactiveJob(conn, Long.valueOf(job.getId()));
                if (log.isDebug3()) {
                    log.debug3("createMetadataExtractionJob(): deletedPutJob = " + deletedPutJob);
                }
                if (!deletedPutJob) {
                    if (log.isDebug3()) {
                        log.debug3("createMetadataExtractionJob(): Reusing job = " + job);
                    }
                    result = job;
                    continue;
                }
                if (!log.isDebug3()) continue;
                log.debug3("createMetadataExtractionJob(): New job needed");
                continue;
            }
            if (!this.jobTypeSeqByName.get("delete_au").equals(jobTypeSeq) && (!this.jobTypeSeqByName.get("put_au").equals(jobTypeSeq) || needFullReindex) && (!this.jobTypeSeqByName.get("put_incremental_au").equals(jobTypeSeq) || !needFullReindex)) continue;
            boolean deletedJob = this.deleteInactiveJob(conn, Long.valueOf(job.getId()));
            if (!log.isDebug3()) continue;
            log.debug3("createMetadataExtractionJob(): deletedJob = " + deletedJob);
        }
        if (result == null) {
            String jobTypeLabel;
            String jobType;
            String string = jobType = needFullReindex ? "put_au" : "put_incremental_au";
            if (log.isDebug3()) {
                log.debug3("createMetadataExtractionJob(): jobType = " + jobType);
            }
            String string2 = jobTypeLabel = needFullReindex ? "Full Metadata Extraction" : "Incremental Metadata Extraction";
            if (log.isDebug3()) {
                log.debug3("createMetadataExtractionJob(): jobTypeLabel = " + jobTypeLabel);
            }
            Long jobSeq = this.addJob(conn, this.jobTypeSeqByName.get(jobType), jobTypeLabel, auId, new Date().getTime(), null, null, this.jobStatusSeqByName.get("created"), INITIAL_JOB_STATUS_MESSAGE);
            if (log.isDebug3()) {
                log.debug3("createMetadataExtractionJob(): jobSeq = " + jobSeq);
            }
            result = this.getJob(conn, jobSeq);
        }
        if (log.isDebug2()) {
            log.debug2("createMetadataExtractionJob(): result = " + result);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JobAuStatus getJob(Connection conn, Long jobSeq) throws DbException {
        ResultSet resultSet;
        PreparedStatement findJob;
        JobAuStatus job;
        block8: {
            String DEBUG_HEADER = "getJob(): ";
            if (log.isDebug2()) {
                log.debug2("getJob(): jobSeq = " + jobSeq);
            }
            job = null;
            findJob = this.dbManager.prepareStatement(conn, FIND_JOB_QUERY);
            resultSet = null;
            try {
                findJob.setLong(1, jobSeq);
                resultSet = this.dbManager.executeQuery(findJob);
                if (!resultSet.next()) break block8;
                job = this.getJobFromResultSet(resultSet);
                if (log.isDebug3()) {
                    log.debug3("getJob(): Found job " + job);
                }
            }
            catch (SQLException sqle) {
                try {
                    String message = "Cannot find AU jobs";
                    log.error(message, (Throwable)sqle);
                    log.error("SQL = 'select job_seq, job_type_seq, description, plugin_id, au_key, creation_time, start_time, end_time, job_status_seq, status_message, priority from job where job_seq = ?'.");
                    log.error("jobSeq = " + jobSeq);
                    throw new DbException(message, (Throwable)sqle);
                    catch (DbException dbe) {
                        message = "Cannot find AU jobs";
                        log.error(message, (Throwable)dbe);
                        log.error("SQL = 'select job_seq, job_type_seq, description, plugin_id, au_key, creation_time, start_time, end_time, job_status_seq, status_message, priority from job where job_seq = ?'.");
                        log.error("jobSeq = " + jobSeq);
                        throw dbe;
                    }
                }
                catch (Throwable throwable) {
                    JobDbManager.safeCloseResultSet(resultSet);
                    JobDbManager.safeCloseStatement((Statement)findJob);
                    throw throwable;
                }
            }
        }
        JobDbManager.safeCloseResultSet((ResultSet)resultSet);
        JobDbManager.safeCloseStatement((Statement)findJob);
        if (log.isDebug2()) {
            log.debug2("getJob(): job = " + job);
        }
        return job;
    }

    private JobAuStatus getJobFromResultSet(ResultSet resultSet) throws SQLException {
        String auKey;
        String pluginId;
        JobAuStatus job = new JobAuStatus();
        job.setId(String.valueOf(resultSet.getLong("job_seq")));
        job.setType(resultSet.getLong("job_type_seq"));
        String description = resultSet.getString("description");
        if (!resultSet.wasNull()) {
            job.setDescription(description);
        }
        job.setCreationDate(new Date(resultSet.getLong("creation_time")));
        Long startTime = resultSet.getLong("start_time");
        if (!resultSet.wasNull()) {
            job.setStartDate(new Date(startTime));
        }
        Long endTime = resultSet.getLong("end_time");
        if (!resultSet.wasNull()) {
            job.setEndDate(new Date(endTime));
        }
        if ((pluginId = resultSet.getString("plugin_id")) != null && pluginId.trim().length() > 0 && (auKey = resultSet.getString("au_key")) != null && auKey.trim().length() > 0) {
            job.setAuId(PluginManager.generateAuId((String)pluginId, (String)auKey));
        }
        job.setStatusCode((int)resultSet.getLong("job_status_seq"));
        String statusMessage = resultSet.getString("status_message");
        if (!resultSet.wasNull()) {
            job.setStatusMessage(statusMessage);
        }
        return job;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<JobAuStatus> getAuJobs(Connection conn, String auId) throws DbException {
        String DEBUG_HEADER = "getAuJobs(): ";
        if (log.isDebug2()) {
            log.debug2("getAuJobs(): auId = " + auId);
        }
        ArrayList<JobAuStatus> jobs = new ArrayList<JobAuStatus>();
        String pluginId = null;
        String auKey = null;
        PreparedStatement findJobs = this.dbManager.prepareStatement(conn, FIND_AU_JOB_QUERY);
        ResultSet resultSet = null;
        try {
            pluginId = PluginManager.pluginIdFromAuId((String)auId);
            findJobs.setString(1, pluginId);
            auKey = PluginManager.auKeyFromAuId((String)auId);
            findJobs.setString(2, auKey);
            resultSet = this.dbManager.executeQuery(findJobs);
            while (resultSet.next()) {
                JobAuStatus job = this.getJobFromResultSet(resultSet);
                if (log.isDebug3()) {
                    log.debug3("getAuJobs(): Found job " + job);
                }
                jobs.add(job);
            }
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot find AU jobs";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'select job_seq, job_type_seq, description, plugin_id, au_key, creation_time, start_time, end_time, job_status_seq, status_message, priority from job where plugin_id = ? and au_key = ? order by job_seq'.");
                log.error("auId = " + auId);
                log.error("pluginId = " + pluginId);
                log.error("auKey = " + auKey);
                throw new DbException(message, (Throwable)sqle);
                catch (DbException dbe) {
                    message = "Cannot find AU jobs";
                    log.error(message, (Throwable)dbe);
                    log.error("SQL = 'select job_seq, job_type_seq, description, plugin_id, au_key, creation_time, start_time, end_time, job_status_seq, status_message, priority from job where plugin_id = ? and au_key = ? order by job_seq'.");
                    log.error("auId = " + auId);
                    log.error("pluginId = " + pluginId);
                    log.error("auKey = " + auKey);
                    throw dbe;
                }
            }
            catch (Throwable throwable) {
                JobDbManager.safeCloseResultSet(resultSet);
                JobDbManager.safeCloseStatement((Statement)findJobs);
                throw throwable;
            }
        }
        JobDbManager.safeCloseResultSet((ResultSet)resultSet);
        JobDbManager.safeCloseStatement((Statement)findJobs);
        if (log.isDebug2()) {
            log.debug2("getAuJobs(): jobs = " + jobs);
        }
        return jobs;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Long addJob(Connection conn, Long jobTypeSeq, String description, String auId, long creationTime, Long startTime, Long endTime, Long jobStatusSeq, String statusMessage) throws DbException {
        Long jobSeq;
        block17: {
            PreparedStatement createJob;
            ResultSet resultSet;
            block16: {
                String auKey;
                String pluginId;
                block15: {
                    String DEBUG_HEADER = "addJob(): ";
                    if (log.isDebug2()) {
                        log.debug("addJob(): jobTypeSeq = " + jobTypeSeq);
                        log.debug("addJob(): description = " + description);
                        log.debug("addJob(): auId = " + auId);
                        log.debug("addJob(): creationTime = " + creationTime);
                        log.debug("addJob(): startTime = " + startTime);
                        log.debug("addJob(): endTime = " + endTime);
                        log.debug("addJob(): jobStatusSeq = " + jobStatusSeq);
                        log.debug("addJob(): statusMessage = " + statusMessage);
                    }
                    pluginId = null;
                    auKey = null;
                    resultSet = null;
                    jobSeq = null;
                    createJob = null;
                    createJob = this.dbManager.isTypeMysql() ? this.dbManager.prepareStatement(conn, INSERT_JOB_MYSQL_QUERY, 1) : this.dbManager.prepareStatement(conn, INSERT_JOB_QUERY, 1);
                    createJob.setLong(1, jobTypeSeq);
                    if (description != null) {
                        createJob.setString(2, JobDbManager.truncateVarchar((String)description, (int)128));
                    } else {
                        createJob.setNull(2, 12);
                    }
                    pluginId = PluginManager.pluginIdFromAuId((String)auId);
                    createJob.setString(3, pluginId);
                    auKey = PluginManager.auKeyFromAuId((String)auId);
                    createJob.setString(4, auKey);
                    createJob.setLong(5, creationTime);
                    if (startTime != null) {
                        createJob.setLong(6, startTime);
                    } else {
                        createJob.setNull(6, -5);
                    }
                    if (endTime != null) {
                        createJob.setLong(7, endTime);
                    } else {
                        createJob.setNull(7, -5);
                    }
                    createJob.setLong(8, jobStatusSeq);
                    if (statusMessage != null) {
                        createJob.setString(9, JobDbManager.truncateVarchar((String)statusMessage, (int)512));
                    } else {
                        createJob.setNull(9, 12);
                    }
                    this.dbManager.executeUpdate(createJob);
                    resultSet = createJob.getGeneratedKeys();
                    if (resultSet.next()) break block15;
                    log.error("Unable to create Job table row for auId " + auId);
                    Long l = null;
                    JobDbManager.safeCloseResultSet((ResultSet)resultSet);
                    JobDbManager.safeCloseStatement((Statement)createJob);
                    return l;
                }
                try {
                    jobSeq = resultSet.getLong(1);
                    if (!log.isDebug3()) break block16;
                    log.debug3("addJob(): Added jobSeq = " + jobSeq);
                }
                catch (SQLException sqle) {
                    try {
                        String message = "Cannot add job";
                        log.error(message, (Throwable)sqle);
                        log.error("SQL = 'insert into job(job_seq,job_type_seq,description,plugin_id,au_key,creation_time,start_time,end_time,job_status_seq,status_message,priority) values (default,?,?,?,?,?,?,?,?,?,(select coalesce(max(priority), 0) + 1 from job where priority >= 0))'.");
                        log.error("jobTypeSeq = " + jobTypeSeq);
                        log.error("description = " + description);
                        log.error("auId = " + auId);
                        log.error("pluginId = " + pluginId);
                        log.error("auKey = " + auKey);
                        log.error("creationTime = " + creationTime);
                        log.error("startTime = " + startTime);
                        log.error("endTime = " + endTime);
                        log.error("jobStatusSeq = " + jobStatusSeq);
                        log.error("statusMessage = " + statusMessage);
                        throw new DbException(message, (Throwable)sqle);
                        catch (DbException dbe) {
                            message = "Cannot add job";
                            log.error(message, (Throwable)dbe);
                            log.error("SQL = 'insert into job(job_seq,job_type_seq,description,plugin_id,au_key,creation_time,start_time,end_time,job_status_seq,status_message,priority) values (default,?,?,?,?,?,?,?,?,?,(select coalesce(max(priority), 0) + 1 from job where priority >= 0))'.");
                            log.error("jobTypeSeq = " + jobTypeSeq);
                            log.error("description = " + description);
                            log.error("auId = " + auId);
                            log.error("pluginId = " + pluginId);
                            log.error("auKey = " + auKey);
                            log.error("creationTime = " + creationTime);
                            log.error("startTime = " + startTime);
                            log.error("endTime = " + endTime);
                            log.error("jobStatusSeq = " + jobStatusSeq);
                            log.error("statusMessage = " + statusMessage);
                            throw dbe;
                        }
                    }
                    catch (Throwable throwable) {
                        JobDbManager.safeCloseResultSet(resultSet);
                        JobDbManager.safeCloseStatement((Statement)createJob);
                        throw throwable;
                    }
                }
            }
            JobDbManager.safeCloseResultSet((ResultSet)resultSet);
            JobDbManager.safeCloseStatement((Statement)createJob);
            if (!log.isDebug2()) break block17;
            log.debug2("addJob(): jobSeq = " + jobSeq);
        }
        return jobSeq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobAuStatus createMetadataRemovalJob(String auId) throws IllegalArgumentException, DbException {
        String DEBUG_HEADER = "createMetadataRemovalJob(): ";
        if (log.isDebug2()) {
            log.debug2("createMetadataRemovalJob(): auId = " + auId);
        }
        JobAuStatus result = null;
        Connection conn = null;
        try {
            conn = this.dbManager.getConnection();
            result = this.createMetadataRemovalJob(conn, auId);
            JobDbManager.commitOrRollback((Connection)conn, (Logger)log);
        }
        finally {
            JobDbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("createMetadataRemovalJob(): result = " + result);
        }
        return result;
    }

    private JobAuStatus createMetadataRemovalJob(Connection conn, String auId) throws IllegalArgumentException, DbException {
        String DEBUG_HEADER = "createMetadataRemovalJob(): ";
        if (log.isDebug2()) {
            log.debug2("createMetadataRemovalJob(): auId = " + auId);
        }
        JobAuStatus result = null;
        List<JobAuStatus> auJobs = this.getAuJobs(conn, auId);
        for (JobAuStatus job : auJobs) {
            Long jobTypeSeq = job.getType();
            if (log.isDebug3()) {
                log.debug3("createMetadataRemovalJob(): jobTypeSeq = " + jobTypeSeq);
            }
            if (this.jobTypeSeqByName.get("delete_au").equals(jobTypeSeq)) {
                Long jobStatusSeq = (long)job.getStatusCode();
                if (this.jobStatusSeqByName.get("created").equals(jobStatusSeq)) {
                    if (log.isDebug3()) {
                        log.debug3("createMetadataRemovalJob(): Reusing job = " + job);
                    }
                    result = job;
                    continue;
                }
                boolean deletedDeleteJob = this.deleteInactiveJob(conn, Long.valueOf(job.getId()));
                if (log.isDebug3()) {
                    log.debug3("createMetadataRemovalJob(): deletedDeleteJob = " + deletedDeleteJob);
                }
                if (!deletedDeleteJob) {
                    if (log.isDebug3()) {
                        log.debug3("createMetadataRemovalJob(): Reusing job = " + job);
                    }
                    result = job;
                    continue;
                }
                if (!log.isDebug3()) continue;
                log.debug3("createMetadataRemovalJob(): New job needed");
                continue;
            }
            if (!this.jobTypeSeqByName.get("put_au").equals(jobTypeSeq) && !this.jobTypeSeqByName.get("put_incremental_au").equals(jobTypeSeq)) continue;
            boolean deletedPutJob = this.deleteInactiveJob(conn, Long.valueOf(job.getId()));
            if (!log.isDebug3()) continue;
            log.debug3("createMetadataRemovalJob(): deletedPutJob = " + deletedPutJob);
        }
        if (log.isDebug3()) {
            log.debug3("createMetadataRemovalJob(): result = " + result);
        }
        if (result == null) {
            Long jobSeq = this.addJob(conn, this.jobTypeSeqByName.get("delete_au"), "Metadata Removal", auId, new Date().getTime(), null, null, this.jobStatusSeqByName.get("created"), INITIAL_JOB_STATUS_MESSAGE);
            if (log.isDebug3()) {
                log.debug3("createMetadataRemovalJob(): jobSeq = " + jobSeq);
            }
            result = this.getJob(conn, jobSeq);
        }
        if (log.isDebug2()) {
            log.debug2("createMetadataRemovalJob(): result = " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobAuStatus getAuJob(String auId) throws DbException {
        String DEBUG_HEADER = "getAuJob(): ";
        if (log.isDebug2()) {
            log.debug2("getAuJob(): auId = " + auId);
        }
        JobAuStatus result = null;
        Connection conn = null;
        try {
            conn = this.dbManager.getConnection();
            result = this.getAuJob(conn, auId);
        }
        finally {
            JobDbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("getAuJob(): result = " + result);
        }
        return result;
    }

    JobAuStatus getAuJob(Connection conn, String auId) throws DbException {
        String DEBUG_HEADER = "getAuJob(): ";
        if (log.isDebug2()) {
            log.debug2("getAuJob(): auId = " + auId);
        }
        JobAuStatus result = null;
        List<JobAuStatus> auJobs = this.getAuJobs(conn, auId);
        for (JobAuStatus job : auJobs) {
            Long jobTypeSeq = job.getType();
            if (log.isDebug3()) {
                log.debug3("getAuJob(): jobTypeSeq = " + jobTypeSeq);
            }
            if (this.jobTypeSeqByName.get("put_au").equals(jobTypeSeq) || this.jobTypeSeqByName.get("put_incremental_au").equals(jobTypeSeq)) {
                result = job;
                break;
            }
            if (!this.jobTypeSeqByName.get("delete_au").equals(jobTypeSeq)) continue;
            result = job;
        }
        if (log.isDebug2()) {
            log.debug2("getAuJob(): result = " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobPage getJobs(Integer limit, JobContinuationToken continuationToken) throws DbException {
        String DEBUG_HEADER = "getJobs(): ";
        if (log.isDebug2()) {
            log.debug2("getJobs(): limit = " + limit);
            log.debug2("getJobs(): continuationToken = " + continuationToken);
        }
        JobPage result = null;
        Connection conn = null;
        try {
            conn = this.dbManager.getConnection();
            long truncationTime = this.getJobQueueTruncationTimestamp(conn);
            if (log.isDebug3()) {
                log.debug3("getJobs(): truncationTime = " + truncationTime);
            }
            Long queueTruncationTimestamp = null;
            Long lastJobSeq = null;
            if (continuationToken != null) {
                queueTruncationTimestamp = continuationToken.getQueueTruncationTimestamp();
                lastJobSeq = continuationToken.getLastJobSeq();
            }
            if (queueTruncationTimestamp != null && queueTruncationTimestamp != truncationTime) {
                String message = "Incompatible pagination request: request timestamp: " + queueTruncationTimestamp + ", current timestamp: " + truncationTime;
                log.warning(message);
                throw new ConcurrentModificationException("Incompatible pagination for jobs: Content has changed since previous request");
            }
            result = this.getJobs(conn, truncationTime, limit, lastJobSeq);
        }
        finally {
            JobDbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("getJobs(): result = " + result);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JobPage getJobs(Connection conn, Long queueTruncationTimestamp, Integer limit, Long lastJobSeq) throws DbException {
        String DEBUG_HEADER = "getJobs(): ";
        if (log.isDebug2()) {
            log.debug2("getJobs(): queueTruncationTimestamp = " + queueTruncationTimestamp);
            log.debug2("getJobs(): limit = " + limit);
            log.debug2("getJobs(): lastJobSeq = " + lastJobSeq);
        }
        JobPage result = new JobPage();
        ArrayList<Job> jobs = new ArrayList<Job>();
        result.setJobs(jobs);
        String sql = FIND_NEXT_PAGE_JOBS_QUERY;
        PreparedStatement findJobs = this.dbManager.prepareStatement(conn, sql);
        ResultSet resultSet = null;
        boolean hasMore = false;
        try {
            if (lastJobSeq == null) {
                findJobs.setLong(1, -1L);
            } else {
                findJobs.setLong(1, lastJobSeq);
            }
            boolean isPaginating = false;
            if (limit != null && limit > 0) {
                isPaginating = true;
                findJobs.setMaxRows(limit + 1);
            }
            if (log.isDebug3()) {
                log.debug3("getJobs(): isPaginating = " + isPaginating);
            }
            resultSet = this.dbManager.executeQuery(findJobs);
            while (resultSet.next()) {
                if (isPaginating && jobs.size() == limit.intValue()) {
                    hasMore = true;
                    if (log.isDebug3()) {
                        log.debug3("getJobs(): hasMore = " + hasMore);
                    }
                    break;
                }
                Job job = new Job(this.getJobFromResultSet(resultSet));
                if (log.isDebug3()) {
                    log.debug3("getJobs(): Found job " + job);
                }
                jobs.add(job);
            }
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot find jobs";
                log.error(message, (Throwable)sqle);
                log.error("SQL = '" + sql + "'.");
                log.error("limit = " + limit);
                log.error("lastJobSeq = " + lastJobSeq);
                throw new DbException(message, (Throwable)sqle);
                catch (DbException dbe) {
                    message = "Cannot find jobs";
                    log.error(message, (Throwable)dbe);
                    log.error("SQL = '" + sql + "'.");
                    log.error("limit = " + limit);
                    log.error("lastJobSeq = " + lastJobSeq);
                    throw dbe;
                }
            }
            catch (Throwable throwable) {
                JobDbManager.safeCloseResultSet(resultSet);
                JobDbManager.safeCloseStatement((Statement)findJobs);
                throw throwable;
            }
        }
        JobDbManager.safeCloseResultSet((ResultSet)resultSet);
        JobDbManager.safeCloseStatement((Statement)findJobs);
        if (hasMore) {
            JobContinuationToken continuationToken = new JobContinuationToken(queueTruncationTimestamp, Long.valueOf(((Job)jobs.get(jobs.size() - 1)).getId()));
            if (log.isDebug3()) {
                log.debug3("getJobs(): continuationToken = " + continuationToken);
            }
            result.setContinuationToken(continuationToken);
        }
        if (log.isDebug2()) {
            log.debug2("getJobs(): Done.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int deleteAllInactiveJobs() throws Exception {
        String DEBUG_HEADER = "deleteAllInactiveJobs(): ";
        if (log.isDebug2()) {
            log.debug2("deleteAllInactiveJobs(): Invoked.");
        }
        int deletedCount = -1;
        Connection conn = null;
        try {
            conn = this.dbManager.getConnection();
            deletedCount = this.deleteInactiveJobs(conn);
            this.updateJobQueueTruncationTimestamp(conn);
            JobDbManager.commitOrRollback((Connection)conn, (Logger)log);
        }
        finally {
            JobDbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("deleteAllInactiveJobs(): deletedCount = " + deletedCount);
        }
        return deletedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobAuStatus deleteJob(Long jobSeq) throws IllegalArgumentException, DbException {
        String DEBUG_HEADER = "deleteJob(): ";
        if (log.isDebug2()) {
            log.debug2("deleteJob(): jobSeq = " + jobSeq);
        }
        JobAuStatus job = null;
        Connection conn = null;
        try {
            conn = this.dbManager.getConnection();
            job = this.deleteJob(conn, jobSeq);
            JobDbManager.commitOrRollback((Connection)conn, (Logger)log);
        }
        finally {
            JobDbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("deleteJob(): job = " + job);
        }
        return job;
    }

    private JobAuStatus deleteJob(Connection conn, Long jobSeq) throws IllegalArgumentException, DbException {
        String DEBUG_HEADER = "deleteJob(): ";
        if (log.isDebug2()) {
            log.debug2("deleteJob(): jobSeq = " + jobSeq);
        }
        String message = "Cannot find job for jobSeq " + jobSeq + "'";
        JobAuStatus job = null;
        boolean deleted = false;
        try {
            job = this.getJob(conn, jobSeq);
            if (job == null) {
                log.error(message);
                throw new IllegalArgumentException(message);
            }
            message = "Cannot delete job for jobSeq " + jobSeq + "'";
            deleted = this.deleteInactiveJob(conn, jobSeq);
        }
        catch (DbException dbe) {
            log.error(message, (Throwable)dbe);
            throw dbe;
        }
        if (deleted) {
            job.setStatusCode(this.jobStatusSeqByName.get("deleted").intValue());
            job.setEndDate(new Date());
            job.setStatusMessage("Deleted");
        }
        if (log.isDebug2()) {
            log.debug2("deleteJob(): job = " + job);
        }
        return job;
    }

    private int deleteInactiveJobs(Connection conn) throws DbException {
        String DEBUG_HEADER = "deleteInactiveJobs(): ";
        if (log.isDebug2()) {
            log.debug2("deleteInactiveJobs(): Invoked.");
        }
        int deletedCount = -1;
        String message = "Cannot delete all inactive jobs";
        PreparedStatement deleteJob = this.dbManager.prepareStatement(conn, DELETE_INACTIVE_JOBS_QUERY);
        try {
            deleteJob.setLong(1, this.jobStatusSeqByName.get("running"));
            deleteJob.setLong(2, this.jobStatusSeqByName.get("terminating"));
            deletedCount = this.dbManager.executeUpdate(deleteJob);
        }
        catch (DbException dbe) {
            log.error(message, (Throwable)dbe);
            log.error("SQL = 'delete from job where job_status_seq != ? and job_status_seq != ?'.");
            throw dbe;
        }
        catch (SQLException sqle) {
            log.error(message, (Throwable)sqle);
            log.error("SQL = 'delete from job where job_status_seq != ? and job_status_seq != ?'.");
            throw new DbException(message, (Throwable)sqle);
        }
        finally {
            JobDbManager.safeCloseStatement((Statement)deleteJob);
        }
        if (log.isDebug2()) {
            log.debug2("deleteInactiveJobs(): deletedCount = " + deletedCount);
        }
        return deletedCount;
    }

    private boolean deleteInactiveJob(Connection conn, Long jobSeq) throws DbException {
        String DEBUG_HEADER = "deleteInactiveJob(): ";
        if (log.isDebug2()) {
            log.debug2("deleteInactiveJob(): jobSeq = " + jobSeq);
        }
        int deletedCount = -1;
        PreparedStatement deleteJob = this.dbManager.prepareStatement(conn, DELETE_INACTIVE_JOB_QUERY);
        try {
            deleteJob.setLong(1, jobSeq);
            deleteJob.setLong(2, this.jobStatusSeqByName.get("running"));
            deleteJob.setLong(3, this.jobStatusSeqByName.get("terminating"));
            deletedCount = this.dbManager.executeUpdate(deleteJob);
        }
        catch (SQLException sqle) {
            String message = "Cannot delete job";
            log.error(message, (Throwable)sqle);
            log.error("jobSeq = " + jobSeq);
            log.error("SQL = 'delete from job where job_seq = ? and job_status_seq != ? and job_status_seq != ?'.");
            throw new DbException(message, (Throwable)sqle);
        }
        catch (DbException dbe) {
            String message = "Cannot delete job";
            log.error(message, (Throwable)dbe);
            log.error("jobSeq = " + jobSeq);
            log.error("SQL = 'delete from job where job_seq = ? and job_status_seq != ? and job_status_seq != ?'.");
            throw dbe;
        }
        finally {
            JobDbManager.safeCloseStatement((Statement)deleteJob);
        }
        if (log.isDebug2()) {
            log.debug2("deleteInactiveJob(): result = " + (deletedCount > 0));
        }
        return deletedCount > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobAuStatus getJob(String jobId) throws IllegalArgumentException, DbException {
        String DEBUG_HEADER = "getJob(): ";
        if (log.isDebug2()) {
            log.debug2("getJob(): jobId = " + jobId);
        }
        JobAuStatus result = null;
        Connection conn = null;
        try {
            conn = this.dbManager.getConnection();
            result = this.getJob(conn, jobId);
        }
        finally {
            JobDbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("getJob(): result = " + result);
        }
        return result;
    }

    private JobAuStatus getJob(Connection conn, String jobId) throws IllegalArgumentException, DbException {
        String DEBUG_HEADER = "getJob(): ";
        if (log.isDebug2()) {
            log.debug2("getJob(): jobId = " + jobId);
        }
        String message = "Cannot find job for jobId " + jobId + "'";
        Long jobSeq = null;
        JobAuStatus job = null;
        try {
            jobSeq = Long.valueOf(jobId);
            job = this.getJob(conn, jobSeq);
        }
        catch (NumberFormatException nfe) {
            log.error(message, (Throwable)nfe);
            throw new IllegalArgumentException(message + ": Not numeric jobId");
        }
        if (job == null) {
            String message2 = "No job found for jobId " + jobId + "'";
            log.error(message2);
            throw new IllegalArgumentException(message2);
        }
        if (log.isDebug2()) {
            log.debug2("getJob(): job = " + job);
        }
        return job;
    }

    void freeIncompleteJobs() throws DbException {
        String DEBUG_HEADER = "freeIncompleteJobs(): ";
        if (log.isDebug2()) {
            log.debug2("freeIncompleteJobs(): Invoked.");
        }
        Connection conn = null;
        try {
            conn = this.dbManager.getConnection();
            this.freeIncompleteJobs(conn);
            JobDbManager.commitOrRollback((Connection)conn, (Logger)log);
        }
        finally {
            JobDbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("freeIncompleteJobs(): Done.");
        }
    }

    private void freeIncompleteJobs(Connection conn) throws DbException {
        String DEBUG_HEADER = "freeIncompleteJobs(): ";
        if (log.isDebug2()) {
            log.debug2("freeIncompleteJobs(): Invoked.");
        }
        int updatedCount = -1;
        PreparedStatement freeIncompleteJobs = this.dbManager.prepareStatement(conn, FREE_INCOMPLETE_JOBS_QUERY);
        try {
            freeIncompleteJobs.setLong(1, this.jobStatusSeqByName.get("created"));
            freeIncompleteJobs.setLong(2, this.jobStatusSeqByName.get("terminated"));
            updatedCount = this.dbManager.executeUpdate(freeIncompleteJobs);
            if (log.isDebug3()) {
                log.debug3("freeIncompleteJobs(): updatedCount = " + updatedCount);
            }
        }
        catch (SQLException sqle) {
            String message = "Cannot free incomplete jobs";
            log.error(message, (Throwable)sqle);
            log.error("SQL = 'update job set start_time = null, end_time = null, job_status_seq = ?, status_message = 'Waiting for launch', owner = null where owner is not null and job_status_seq < ?'.");
            throw new DbException(message, (Throwable)sqle);
        }
        catch (DbException dbe) {
            String message = "Cannot free incomplete jobs";
            log.error(message, (Throwable)dbe);
            log.error("SQL = 'update job set start_time = null, end_time = null, job_status_seq = ?, status_message = 'Waiting for launch', owner = null where owner is not null and job_status_seq < ?'.");
            throw dbe;
        }
        finally {
            JobDbManager.safeCloseStatement((Statement)freeIncompleteJobs);
        }
        if (log.isDebug2()) {
            log.debug2("freeIncompleteJobs(): Done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Long claimNextJob(String owner) throws DbException {
        String DEBUG_HEADER = "claimNextJob(): ";
        if (log.isDebug2()) {
            log.debug2("claimNextJob(): owner = " + owner);
        }
        Long jobSeq = null;
        Connection conn = null;
        try {
            conn = this.dbManager.getConnection();
            jobSeq = this.claimNextJob(conn, owner);
            JobDbManager.commitOrRollback((Connection)conn, (Logger)log);
        }
        finally {
            JobDbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("claimNextJob(): jobSeq = " + jobSeq);
        }
        return jobSeq;
    }

    private Long claimNextJob(Connection conn, String owner) throws DbException {
        String DEBUG_HEADER = "claimNextJob(): ";
        if (log.isDebug2()) {
            log.debug2("claimNextJob(): owner = " + owner);
        }
        Long jobSeq = null;
        boolean claimed = false;
        while (!claimed) {
            jobSeq = this.findHighestPriorityUnclaimedJob(conn);
            if (log.isDebug3()) {
                log.debug3("claimNextJob(): jobSeq = " + jobSeq);
            }
            if (jobSeq == null) break;
            claimed = this.claimUnclaimedJob(conn, owner, jobSeq);
            if (!log.isDebug3()) continue;
            log.debug3("claimNextJob(): claimed = " + claimed);
        }
        if (log.isDebug2()) {
            log.debug2("claimNextJob(): jobSeq = " + jobSeq);
        }
        return jobSeq;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Long findHighestPriorityUnclaimedJob(Connection conn) throws DbException {
        ResultSet resultSet;
        PreparedStatement findHighestPriorityJob;
        Long jobSeq;
        block8: {
            String DEBUG_HEADER = "findHighestPriorityUnclaimedJob(): ";
            if (log.isDebug2()) {
                log.debug2("findHighestPriorityUnclaimedJob(): Invoked.");
            }
            jobSeq = null;
            findHighestPriorityJob = this.dbManager.prepareStatement(conn, FIND_HIGHEST_PRIORITY_JOBS_QUERY);
            resultSet = null;
            try {
                findHighestPriorityJob.setMaxRows(1);
                resultSet = this.dbManager.executeQuery(findHighestPriorityJob);
                if (!resultSet.next()) break block8;
                jobSeq = resultSet.getLong("job_seq");
                if (log.isDebug3()) {
                    log.debug3("findHighestPriorityUnclaimedJob(): jobSeq = " + jobSeq);
                }
            }
            catch (SQLException sqle) {
                try {
                    String message = "Cannot find the highest priority unclaimed job";
                    log.error(message, (Throwable)sqle);
                    log.error("SQL = 'select job_seq from job where owner is null order by priority, job_seq'.");
                    throw new DbException(message, (Throwable)sqle);
                    catch (DbException dbe) {
                        message = "Cannot find the highest priority unclaimed job";
                        log.error(message, (Throwable)dbe);
                        log.error("SQL = 'select job_seq from job where owner is null order by priority, job_seq'.");
                        throw dbe;
                    }
                }
                catch (Throwable throwable) {
                    JobDbManager.safeCloseResultSet(resultSet);
                    JobDbManager.safeCloseStatement((Statement)findHighestPriorityJob);
                    throw throwable;
                }
            }
        }
        JobDbManager.safeCloseResultSet((ResultSet)resultSet);
        JobDbManager.safeCloseStatement((Statement)findHighestPriorityJob);
        if (log.isDebug2()) {
            log.debug2("findHighestPriorityUnclaimedJob(): jobSeq = " + jobSeq);
        }
        return jobSeq;
    }

    boolean claimUnclaimedJob(Connection conn, String owner, Long jobSeq) throws DbException {
        String DEBUG_HEADER = "claimUnclaimedJob(): ";
        if (log.isDebug2()) {
            log.debug("claimUnclaimedJob(): owner = " + owner);
            log.debug("claimUnclaimedJob(): jobSeq = " + jobSeq);
        }
        int updatedCount = -1;
        PreparedStatement claimUnclaimedJob = this.dbManager.prepareStatement(conn, CLAIM_UNCLAIMED_JOB_QUERY);
        try {
            claimUnclaimedJob.setString(1, JobDbManager.truncateVarchar((String)owner, (int)32));
            claimUnclaimedJob.setLong(2, jobSeq);
            updatedCount = this.dbManager.executeUpdate(claimUnclaimedJob);
            if (log.isDebug3()) {
                log.debug3("claimUnclaimedJob(): updatedCount = " + updatedCount);
            }
        }
        catch (SQLException sqle) {
            String message = "Cannot claim unclaimed job";
            log.error(message, (Throwable)sqle);
            log.error("owner = '" + owner + "'.");
            log.error("jobSeq = " + jobSeq);
            log.error("SQL = 'update job set owner = ? where owner is null and job_seq = ?'.");
            throw new DbException(message, (Throwable)sqle);
        }
        catch (DbException dbe) {
            String message = "Cannot claim unclaimed job";
            log.error(message, (Throwable)dbe);
            log.error("owner = '" + owner + "'.");
            log.error("jobSeq = " + jobSeq);
            log.error("SQL = 'update job set owner = ? where owner is null and job_seq = ?'.");
            throw dbe;
        }
        finally {
            JobDbManager.safeCloseStatement((Statement)claimUnclaimedJob);
        }
        if (log.isDebug2()) {
            log.debug("claimUnclaimedJob(): updatedCount == 1 = " + (updatedCount == 1));
        }
        return updatedCount == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getJobType(Long jobSeq) throws DbException {
        String DEBUG_HEADER = "getJobType(): ";
        if (log.isDebug2()) {
            log.debug2("getJobType(): jobSeq = " + jobSeq);
        }
        String result = null;
        Connection conn = null;
        try {
            conn = this.dbManager.getConnection();
            result = this.getJobType(conn, jobSeq);
        }
        finally {
            JobDbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("getJobType(): result = " + result);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getJobType(Connection conn, Long jobSeq) throws DbException {
        ResultSet resultSet;
        PreparedStatement findJob;
        String jobType;
        block8: {
            String DEBUG_HEADER = "getJobType(): ";
            if (log.isDebug2()) {
                log.debug2("getJobType(): jobSeq = " + jobSeq);
            }
            jobType = null;
            findJob = this.dbManager.prepareStatement(conn, FIND_JOB_TYPE_QUERY);
            resultSet = null;
            try {
                findJob.setLong(1, jobSeq);
                resultSet = this.dbManager.executeQuery(findJob);
                if (!resultSet.next()) break block8;
                jobType = resultSet.getString("type_name");
                if (log.isDebug3()) {
                    log.debug3("getJobType(): jobType " + jobType);
                }
            }
            catch (SQLException sqle) {
                try {
                    String message = "Cannot find Archival Unit jobs";
                    log.error(message, (Throwable)sqle);
                    log.error("SQL = 'select jt.type_name from job j, job_type jt where j.job_type_seq = jt.job_type_seq and j.job_seq = ?'.");
                    log.error("jobSeq = " + jobSeq);
                    throw new DbException(message, (Throwable)sqle);
                    catch (DbException dbe) {
                        message = "Cannot find Archival Unit jobs";
                        log.error(message, (Throwable)dbe);
                        log.error("SQL = 'select jt.type_name from job j, job_type jt where j.job_type_seq = jt.job_type_seq and j.job_seq = ?'.");
                        log.error("jobSeq = " + jobSeq);
                        throw dbe;
                    }
                }
                catch (Throwable throwable) {
                    JobDbManager.safeCloseResultSet(resultSet);
                    JobDbManager.safeCloseStatement((Statement)findJob);
                    throw throwable;
                }
            }
        }
        JobDbManager.safeCloseResultSet((ResultSet)resultSet);
        JobDbManager.safeCloseStatement((Statement)findJob);
        if (log.isDebug2()) {
            log.debug2("getJobType(): jobType = " + jobType);
        }
        return jobType;
    }

    int markJobAsRunning(Connection conn, Long jobSeq, String statusMessage) throws DbException {
        String DEBUG_HEADER = "markJobAsRunning(): ";
        if (log.isDebug2()) {
            log.debug("markJobAsRunning(): jobSeq = " + jobSeq);
            log.debug("markJobAsRunning(): statusMessage = " + statusMessage);
        }
        int updatedCount = -1;
        PreparedStatement updateJobStatus = this.dbManager.prepareStatement(conn, MARK_JOB_AS_RUNNING_QUERY);
        try {
            updateJobStatus.setLong(1, new Date().getTime());
            updateJobStatus.setLong(2, this.jobStatusSeqByName.get("running"));
            updateJobStatus.setString(3, JobDbManager.truncateVarchar((String)statusMessage, (int)512));
            updateJobStatus.setLong(4, jobSeq);
            updatedCount = this.dbManager.executeUpdate(updateJobStatus);
            if (log.isDebug3()) {
                log.debug3("markJobAsRunning(): updatedCount = " + updatedCount);
            }
        }
        catch (SQLException sqle) {
            String message = "Cannot update job status";
            log.error(message, (Throwable)sqle);
            log.error("jobSeq = " + jobSeq);
            log.error("statusMessage = '" + statusMessage + "'.");
            log.error("SQL = 'update job set start_time = ?, job_status_seq = ?, status_message = ? where job_seq = ?'.");
            throw new DbException(message, (Throwable)sqle);
        }
        catch (DbException dbe) {
            String message = "Cannot update job status";
            log.error(message, (Throwable)dbe);
            log.error("jobSeq = " + jobSeq);
            log.error("statusMessage = '" + statusMessage + "'.");
            log.error("SQL = 'update job set start_time = ?, job_status_seq = ?, status_message = ? where job_seq = ?'.");
            throw dbe;
        }
        finally {
            JobDbManager.safeCloseStatement((Statement)updateJobStatus);
        }
        if (log.isDebug2()) {
            log.debug2("markJobAsRunning(): updatedCount = " + updatedCount);
        }
        return updatedCount;
    }

    int markJobAsFinished(Connection conn, Long jobSeq, String statusName, String statusMessage) throws DbException {
        String DEBUG_HEADER = "markJobAsFinished(): ";
        if (log.isDebug2()) {
            log.debug("markJobAsFinished(): jobSeq = " + jobSeq);
            log.debug("markJobAsFinished(): statusName = " + statusName);
            log.debug("markJobAsFinished(): statusMessage = " + statusMessage);
        }
        int updatedCount = -1;
        PreparedStatement updateJobStatus = this.dbManager.prepareStatement(conn, MARK_JOB_AS_FINISHED_QUERY);
        try {
            updateJobStatus.setLong(1, new Date().getTime());
            updateJobStatus.setLong(2, this.jobStatusSeqByName.get(statusName));
            updateJobStatus.setString(3, JobDbManager.truncateVarchar((String)statusMessage, (int)512));
            updateJobStatus.setLong(4, jobSeq);
            updatedCount = this.dbManager.executeUpdate(updateJobStatus);
            if (log.isDebug3()) {
                log.debug3("markJobAsFinished(): updatedCount = " + updatedCount);
            }
        }
        catch (SQLException sqle) {
            String message = "Cannot mark a job as finished";
            log.error(message, (Throwable)sqle);
            log.error("jobSeq = " + jobSeq);
            log.error("statusName = '" + statusName + "'.");
            log.error("statusMessage = '" + statusMessage + "'.");
            log.error("SQL = 'update job set end_time = ?, job_status_seq = ?, status_message = ? where job_seq = ?'.");
            throw new DbException(message, (Throwable)sqle);
        }
        catch (DbException dbe) {
            String message = "Cannot mark a job as finished";
            log.error(message, (Throwable)dbe);
            log.error("jobSeq = " + jobSeq);
            log.error("statusName = '" + statusName + "'.");
            log.error("statusMessage = '" + statusMessage + "'.");
            log.error("SQL = 'update job set end_time = ?, job_status_seq = ?, status_message = ? where job_seq = ?'.");
            throw dbe;
        }
        finally {
            JobDbManager.safeCloseStatement((Statement)updateJobStatus);
        }
        if (log.isDebug2()) {
            log.debug2("markJobAsFinished(): updatedCount = " + updatedCount);
        }
        return updatedCount;
    }

    int markJobAsDone(Connection conn, Long jobSeq, String statusMessage) throws DbException {
        return this.markJobAsFinished(conn, jobSeq, "done", statusMessage);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getJobAuId(Connection conn, Long jobSeq) throws DbException {
        ResultSet resultSet;
        PreparedStatement findJob;
        String auId;
        block10: {
            String DEBUG_HEADER = "getJobAuId(): ";
            if (log.isDebug2()) {
                log.debug2("getJobAuId(): jobSeq = " + jobSeq);
            }
            auId = null;
            findJob = this.dbManager.prepareStatement(conn, FIND_JOB_QUERY);
            resultSet = null;
            try {
                findJob.setLong(1, jobSeq);
                resultSet = this.dbManager.executeQuery(findJob);
                if (!resultSet.next()) break block10;
                String auKey = resultSet.getString("au_key");
                if (log.isDebug3()) {
                    log.debug3("getJobAuId(): auKey = " + auKey);
                }
                String pluginId = resultSet.getString("plugin_id");
                if (log.isDebug3()) {
                    log.debug3("getJobAuId(): pluginId = " + pluginId);
                }
                auId = PluginManager.generateAuId((String)pluginId, (String)auKey);
                if (log.isDebug3()) {
                    log.debug3("getJobAuId(): auId = " + auId);
                }
            }
            catch (SQLException sqle) {
                try {
                    String message = "Cannot find job AuId";
                    log.error(message, (Throwable)sqle);
                    log.error("SQL = 'select job_seq, job_type_seq, description, plugin_id, au_key, creation_time, start_time, end_time, job_status_seq, status_message, priority from job where job_seq = ?'.");
                    log.error("jobSeq = " + jobSeq);
                    throw new DbException(message, (Throwable)sqle);
                    catch (DbException dbe) {
                        message = "Cannot find job AuId";
                        log.error(message, (Throwable)dbe);
                        log.error("SQL = 'select job_seq, job_type_seq, description, plugin_id, au_key, creation_time, start_time, end_time, job_status_seq, status_message, priority from job where job_seq = ?'.");
                        log.error("jobSeq = " + jobSeq);
                        throw dbe;
                    }
                }
                catch (Throwable throwable) {
                    JobDbManager.safeCloseResultSet(resultSet);
                    JobDbManager.safeCloseStatement((Statement)findJob);
                    throw throwable;
                }
            }
        }
        JobDbManager.safeCloseResultSet((ResultSet)resultSet);
        JobDbManager.safeCloseStatement((Statement)findJob);
        if (log.isDebug2()) {
            log.debug2("getJobAuId(): auId = " + auId);
        }
        return auId;
    }

    long getNotStartedReindexingJobsCount() throws DbException {
        return this.getReindexingJobsWithStatusCount("created");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<Map<String, Object>> getNotStartedReindexingJobs(int maxJobCount) throws DbException {
        String DEBUG_HEADER = "getNotStartedReindexingJobs(): ";
        if (log.isDebug2()) {
            log.debug2("getNotStartedReindexingJobs(): maxJobCount = " + maxJobCount);
        }
        ArrayList<Map<String, Object>> notStartedJobs = new ArrayList<Map<String, Object>>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        String sql = "select job_seq, job_type_seq, plugin_id, au_key, start_time, end_time, priority, status_message from job where job_type_seq != ? and job_status_seq = ? order by priority, job_seq";
        if (log.isDebug3()) {
            log.debug3("getNotStartedReindexingJobs(): sql = " + sql);
        }
        try {
            conn = this.dbManager.getConnection();
            stmt = this.dbManager.prepareStatement(conn, sql);
            stmt.setLong(1, this.jobTypeSeqByName.get("delete_au"));
            stmt.setLong(2, this.jobStatusSeqByName.get("created"));
            stmt.setMaxRows(maxJobCount);
            resultSet = this.dbManager.executeQuery(stmt);
            while (resultSet.next()) {
                HashMap<String, Object> job = new HashMap<String, Object>();
                Long jobTypeSeq = resultSet.getLong("job_type_seq");
                if (log.isDebug3()) {
                    log.debug3("getNotStartedReindexingJobs(): jobTypeSeq = " + jobTypeSeq);
                }
                job.put("job_type_seq", jobTypeSeq);
                String auKey = resultSet.getString("au_key");
                if (log.isDebug3()) {
                    log.debug3("getNotStartedReindexingJobs(): auKey = " + auKey);
                }
                job.put("au_key", auKey);
                String pluginId = resultSet.getString("plugin_id");
                if (log.isDebug3()) {
                    log.debug3("getNotStartedReindexingJobs(): pluginId = " + pluginId);
                }
                job.put("plugin_id", pluginId);
                Long priority = resultSet.getLong("priority");
                if (log.isDebug3()) {
                    log.debug3("getNotStartedReindexingJobs(): priority = " + priority);
                }
                job.put("priority", priority);
                notStartedJobs.add(job);
            }
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot get the jobs not started yet";
                log.error(message, (Throwable)sqle);
                log.error("SQL = '" + sql + "'.");
                log.error("maxJobCount = " + maxJobCount);
                throw new DbException(message, (Throwable)sqle);
                catch (DbException dbe) {
                    message = "Cannot get the jobs not started yet";
                    log.error(message, (Throwable)dbe);
                    log.error("SQL = '" + sql + "'.");
                    log.error("maxJobCount = " + maxJobCount);
                    throw dbe;
                }
            }
            catch (Throwable throwable) {
                JobDbManager.safeCloseResultSet(resultSet);
                JobDbManager.safeCloseStatement(stmt);
                JobDbManager.safeRollbackAndClose((Connection)conn);
                throw throwable;
            }
        }
        JobDbManager.safeCloseResultSet((ResultSet)resultSet);
        JobDbManager.safeCloseStatement((Statement)stmt);
        JobDbManager.safeRollbackAndClose((Connection)conn);
        if (log.isDebug2()) {
            log.debug2("getNotStartedReindexingJobs(): notStartedJobs.size() = " + notStartedJobs.size());
        }
        return notStartedJobs;
    }

    private void updateJobQueueTruncationTimestamp(Connection conn) throws DbException {
        log.debug2("Invoked");
        int updatedCount = -1;
        PreparedStatement updateTruncationTimestamp = this.dbManager.prepareStatement(conn, UPDATE_TRUNCATION_TIMESTAMP_QUERY);
        try {
            updateTruncationTimestamp.setLong(1, new Date().getTime());
            updatedCount = this.dbManager.executeUpdate(updateTruncationTimestamp);
            if (log.isDebug3()) {
                log.debug3("updatedCount = " + updatedCount);
            }
        }
        catch (SQLException sqle) {
            String message = "Cannot update job queue truncation timestamp";
            log.error(message, (Throwable)sqle);
            log.error("SQL = 'update job_metadata set truncation_time = ?'.");
            throw new DbException(message, (Throwable)sqle);
        }
        catch (DbException dbe) {
            String message = "Cannot update job queue truncation timestamp";
            log.error(message, (Throwable)dbe);
            log.error("SQL = 'update job_metadata set truncation_time = ?'.");
            throw dbe;
        }
        finally {
            JobDbManager.safeCloseStatement((Statement)updateTruncationTimestamp);
        }
        log.debug2("Done");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long getJobQueueTruncationTimestamp(Connection conn) throws DbException {
        log.debug2("Invoked");
        long timestamp = -1L;
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = this.dbManager.prepareStatement(conn, GET_TRUNCATION_TIMESTAMP_QUERY);
            resultSet = this.dbManager.executeQuery(stmt);
            if (resultSet.next()) {
                timestamp = resultSet.getLong("truncation_time");
            }
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot get the queue truncation timestamp";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'select truncation_time from job_metadata'.");
                throw new DbException(message, (Throwable)sqle);
                catch (DbException dbe) {
                    message = "Cannot get the queue truncation timestamp";
                    log.error(message, (Throwable)dbe);
                    log.error("SQL = 'select truncation_time from job_metadata'.");
                    throw dbe;
                }
            }
            catch (Throwable throwable) {
                JobDbManager.safeCloseResultSet(resultSet);
                JobDbManager.safeCloseStatement((Statement)stmt);
                throw throwable;
            }
        }
        JobDbManager.safeCloseResultSet((ResultSet)resultSet);
        JobDbManager.safeCloseStatement((Statement)stmt);
        if (log.isDebug2()) {
            log.debug2("timestamp = " + timestamp);
        }
        return timestamp;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long getReindexingJobsCount() throws DbException {
        String DEBUG_HEADER = "getReindexingJobsCount(): ";
        if (log.isDebug2()) {
            log.debug2("getReindexingJobsCount(): Starting...");
        }
        long rowCount = -1L;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            conn = this.dbManager.getConnection();
            stmt = this.dbManager.prepareStatement(conn, COUNT_REINDEXING_JOBS_QUERY);
            stmt.setLong(1, this.jobTypeSeqByName.get("delete_au"));
            resultSet = this.dbManager.executeQuery(stmt);
            resultSet.next();
            rowCount = resultSet.getLong(1);
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot get the count of all jobs";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'select count(*) from job where job_type_seq != ? '.");
                throw new DbException(message, (Throwable)sqle);
                catch (DbException dbe) {
                    message = "Cannot get the count of all jobs";
                    log.error(message, (Throwable)dbe);
                    log.error("SQL = 'select count(*) from job where job_type_seq != ? '.");
                    throw dbe;
                }
            }
            catch (Throwable throwable) {
                JobDbManager.safeCloseResultSet(resultSet);
                JobDbManager.safeCloseStatement(stmt);
                JobDbManager.safeRollbackAndClose((Connection)conn);
                throw throwable;
            }
        }
        JobDbManager.safeCloseResultSet((ResultSet)resultSet);
        JobDbManager.safeCloseStatement((Statement)stmt);
        JobDbManager.safeRollbackAndClose((Connection)conn);
        if (log.isDebug2()) {
            log.debug2("getReindexingJobsCount(): rowCount = " + rowCount);
        }
        return rowCount;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long getReindexingJobsWithStatusCount(String status) throws DbException {
        String DEBUG_HEADER = "getReindexingJobsWithStatusCount(): ";
        if (log.isDebug2()) {
            log.debug2("getReindexingJobsWithStatusCount(): status = " + status);
        }
        long rowCount = -1L;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            conn = this.dbManager.getConnection();
            stmt = this.dbManager.prepareStatement(conn, COUNT_REINDEXING_JOBS_BY_STATUS_QUERY);
            stmt.setLong(1, this.jobTypeSeqByName.get("delete_au"));
            stmt.setLong(2, this.jobStatusSeqByName.get(status));
            resultSet = this.dbManager.executeQuery(stmt);
            resultSet.next();
            rowCount = resultSet.getLong(1);
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot get the count of reindexing jobs";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'select count(*) from job where job_type_seq != ?  and job_status_seq = ?'.");
                log.error("status = '" + status + "'.");
                throw new DbException(message, (Throwable)sqle);
                catch (DbException dbe) {
                    message = "Cannot get the count of reindexing jobs";
                    log.error(message, (Throwable)dbe);
                    log.error("SQL = 'select count(*) from job where job_type_seq != ?  and job_status_seq = ?'.");
                    log.error("status = '" + status + "'.");
                    throw dbe;
                }
            }
            catch (Throwable throwable) {
                JobDbManager.safeCloseResultSet(resultSet);
                JobDbManager.safeCloseStatement(stmt);
                JobDbManager.safeRollbackAndClose((Connection)conn);
                throw throwable;
            }
        }
        JobDbManager.safeCloseResultSet((ResultSet)resultSet);
        JobDbManager.safeCloseStatement((Statement)stmt);
        JobDbManager.safeRollbackAndClose((Connection)conn);
        if (log.isDebug2()) {
            log.debug2("getReindexingJobsWithStatusCount(): rowCount = " + rowCount);
        }
        return rowCount;
    }

    long getSuccessfulReindexingJobsCount() throws DbException {
        return this.getReindexingJobsWithStatusAndMessageCount("done", "Success");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long getReindexingJobsWithStatusAndMessageCount(String status, String statusMessage) throws DbException {
        String DEBUG_HEADER = "getReindexingJobsWithStatusAndMessageCount(): ";
        if (log.isDebug2()) {
            log.debug2("getReindexingJobsWithStatusAndMessageCount(): status = " + status);
            log.debug2("getReindexingJobsWithStatusAndMessageCount(): statusMessage = " + statusMessage);
        }
        long rowCount = -1L;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            conn = this.dbManager.getConnection();
            stmt = this.dbManager.prepareStatement(conn, COUNT_REINDEXING_JOBS_BY_STATUS_AND_MESSAGE_QUERY);
            stmt.setLong(1, this.jobTypeSeqByName.get("delete_au"));
            stmt.setLong(2, this.jobStatusSeqByName.get(status));
            stmt.setString(3, statusMessage);
            resultSet = this.dbManager.executeQuery(stmt);
            resultSet.next();
            rowCount = resultSet.getLong(1);
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot get the count of reindexing jobs";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'select count(*) from job where job_type_seq != ?  and job_status_seq = ? and status_message = ?'.");
                log.error("status = '" + status + "'.");
                log.error("statusMessage = '" + statusMessage + "'.");
                throw new DbException(message, (Throwable)sqle);
                catch (DbException dbe) {
                    message = "Cannot get the count of reindexing jobs";
                    log.error(message, (Throwable)dbe);
                    log.error("SQL = 'select count(*) from job where job_type_seq != ?  and job_status_seq = ? and status_message = ?'.");
                    log.error("status = '" + status + "'.");
                    log.error("statusMessage = '" + statusMessage + "'.");
                    throw dbe;
                }
            }
            catch (Throwable throwable) {
                JobDbManager.safeCloseResultSet(resultSet);
                JobDbManager.safeCloseStatement(stmt);
                JobDbManager.safeRollbackAndClose((Connection)conn);
                throw throwable;
            }
        }
        JobDbManager.safeCloseResultSet((ResultSet)resultSet);
        JobDbManager.safeCloseStatement((Statement)stmt);
        JobDbManager.safeRollbackAndClose((Connection)conn);
        if (log.isDebug2()) {
            log.debug2("getReindexingJobsWithStatusAndMessageCount(): rowCount = " + rowCount);
        }
        return rowCount;
    }

    long getFailedReindexingJobsCount() throws DbException {
        return this.getReindexingJobsWithStatusCount("done") - this.getSuccessfulReindexingJobsCount();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<Map<String, Object>> getFinishedReindexingJobsBefore(int maxJobCount, long beforeTime) throws DbException {
        String DEBUG_HEADER = "getFinishedReindexingJobsBefore(): ";
        if (log.isDebug2()) {
            log.debug2("getFinishedReindexingJobsBefore(): maxJobCount = " + maxJobCount);
            log.debug2("getFinishedReindexingJobsBefore(): beforeTime = " + beforeTime);
        }
        ArrayList<Map<String, Object>> finishedJobs = new ArrayList<Map<String, Object>>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        String sql = "select job_seq, job_type_seq, plugin_id, au_key, start_time, end_time, priority, status_message from job where job_type_seq != ? and job_status_seq = ? and start_time < ? order by start_time desc";
        if (log.isDebug3()) {
            log.debug3("getFinishedReindexingJobsBefore(): sql = " + sql);
        }
        try {
            conn = this.dbManager.getConnection();
            stmt = this.dbManager.prepareStatement(conn, sql);
            stmt.setLong(1, this.jobTypeSeqByName.get("delete_au"));
            stmt.setLong(2, this.jobStatusSeqByName.get("done"));
            stmt.setLong(3, beforeTime);
            stmt.setMaxRows(maxJobCount);
            resultSet = this.dbManager.executeQuery(stmt);
            while (resultSet.next()) {
                HashMap<String, Object> job = new HashMap<String, Object>();
                Long jobTypeSeq = resultSet.getLong("job_type_seq");
                if (log.isDebug3()) {
                    log.debug3("getFinishedReindexingJobsBefore(): jobTypeSeq = " + jobTypeSeq);
                }
                job.put("job_type_seq", jobTypeSeq);
                String auKey = resultSet.getString("au_key");
                if (log.isDebug3()) {
                    log.debug3("getFinishedReindexingJobsBefore(): auKey = " + auKey);
                }
                job.put("au_key", auKey);
                String pluginId = resultSet.getString("plugin_id");
                if (log.isDebug3()) {
                    log.debug3("getFinishedReindexingJobsBefore(): pluginId = " + pluginId);
                }
                job.put("plugin_id", pluginId);
                Long startTime = resultSet.getLong("start_time");
                if (log.isDebug3()) {
                    log.debug3("getFinishedReindexingJobsBefore(): startTime = " + startTime);
                }
                job.put("start_time", startTime);
                Long endTime = resultSet.getLong("end_time");
                if (log.isDebug3()) {
                    log.debug3("getFinishedReindexingJobsBefore(): endTime = " + endTime);
                }
                job.put("end_time", endTime);
                Long priority = resultSet.getLong("priority");
                if (log.isDebug3()) {
                    log.debug3("getFinishedReindexingJobsBefore(): priority = " + priority);
                }
                job.put("priority", priority);
                String statusMessage = resultSet.getString("status_message");
                if (log.isDebug3()) {
                    log.debug3("getFinishedReindexingJobsBefore(): statusMessage = '" + statusMessage + "'");
                }
                job.put("status_message", statusMessage);
                finishedJobs.add(job);
            }
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot get the finished jobs";
                log.error(message, (Throwable)sqle);
                log.error("SQL = '" + sql + "'.");
                log.error("maxJobCount = " + maxJobCount);
                log.error("beforeTime = " + beforeTime);
                throw new DbException(message, (Throwable)sqle);
                catch (DbException dbe) {
                    message = "Cannot get the finished jobs";
                    log.error(message, (Throwable)dbe);
                    log.error("SQL = '" + sql + "'.");
                    log.error("maxJobCount = " + maxJobCount);
                    log.error("beforeTime = " + beforeTime);
                    throw dbe;
                }
            }
            catch (Throwable throwable) {
                JobDbManager.safeCloseResultSet(resultSet);
                JobDbManager.safeCloseStatement(stmt);
                JobDbManager.safeRollbackAndClose((Connection)conn);
                throw throwable;
            }
        }
        JobDbManager.safeCloseResultSet((ResultSet)resultSet);
        JobDbManager.safeCloseStatement((Statement)stmt);
        JobDbManager.safeRollbackAndClose((Connection)conn);
        if (log.isDebug2()) {
            log.debug2("getFinishedReindexingJobsBefore(): finishedJobs.size() = " + finishedJobs.size());
        }
        return finishedJobs;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<Map<String, Object>> getFailedReindexingJobsBefore(int maxJobCount, long beforeTime) throws DbException {
        String DEBUG_HEADER = "getFailedReindexingJobsBefore(): ";
        if (log.isDebug2()) {
            log.debug2("getFailedReindexingJobsBefore(): maxJobCount = " + maxJobCount);
            log.debug2("getFailedReindexingJobsBefore(): beforeTime = " + beforeTime);
        }
        ArrayList<Map<String, Object>> failedJobs = new ArrayList<Map<String, Object>>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        String sql = "select job_seq, job_type_seq, plugin_id, au_key, start_time, end_time, priority, status_message from job where job_type_seq != ? and job_status_seq = ? and start_time < ? and status_message != ? order by start_time desc";
        if (log.isDebug3()) {
            log.debug3("getFailedReindexingJobsBefore(): sql = " + sql);
        }
        try {
            conn = this.dbManager.getConnection();
            stmt = this.dbManager.prepareStatement(conn, sql);
            stmt.setLong(1, this.jobTypeSeqByName.get("delete_au"));
            stmt.setLong(2, this.jobStatusSeqByName.get("done"));
            stmt.setLong(3, beforeTime);
            stmt.setString(4, "Success");
            stmt.setMaxRows(maxJobCount);
            resultSet = this.dbManager.executeQuery(stmt);
            while (resultSet.next()) {
                HashMap<String, Object> job = new HashMap<String, Object>();
                Long jobTypeSeq = resultSet.getLong("job_type_seq");
                if (log.isDebug3()) {
                    log.debug3("getFailedReindexingJobsBefore(): jobTypeSeq = " + jobTypeSeq);
                }
                job.put("job_type_seq", jobTypeSeq);
                String auKey = resultSet.getString("au_key");
                if (log.isDebug3()) {
                    log.debug3("getFailedReindexingJobsBefore(): auKey = " + auKey);
                }
                job.put("au_key", auKey);
                String pluginId = resultSet.getString("plugin_id");
                if (log.isDebug3()) {
                    log.debug3("getFailedReindexingJobsBefore(): pluginId = " + pluginId);
                }
                job.put("plugin_id", pluginId);
                Long startTime = resultSet.getLong("start_time");
                if (log.isDebug3()) {
                    log.debug3("getFailedReindexingJobsBefore(): startTime = " + startTime);
                }
                job.put("start_time", startTime);
                Long endTime = resultSet.getLong("end_time");
                if (log.isDebug3()) {
                    log.debug3("getFailedReindexingJobsBefore(): endTime = " + endTime);
                }
                job.put("end_time", endTime);
                Long priority = resultSet.getLong("priority");
                if (log.isDebug3()) {
                    log.debug3("getFailedReindexingJobsBefore(): priority = " + priority);
                }
                job.put("priority", priority);
                String statusMessage = resultSet.getString("status_message");
                if (log.isDebug3()) {
                    log.debug3("getFailedReindexingJobsBefore(): statusMessage = '" + statusMessage + "'");
                }
                job.put("status_message", statusMessage);
                failedJobs.add(job);
            }
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot get the failed jobs";
                log.error(message, (Throwable)sqle);
                log.error("SQL = '" + sql + "'.");
                log.error("maxJobCount = " + maxJobCount);
                log.error("beforeTime = " + beforeTime);
                throw new DbException(message, (Throwable)sqle);
                catch (DbException dbe) {
                    message = "Cannot get the failed jobs";
                    log.error(message, (Throwable)dbe);
                    log.error("SQL = '" + sql + "'.");
                    log.error("maxJobCount = " + maxJobCount);
                    log.error("beforeTime = " + beforeTime);
                    throw dbe;
                }
            }
            catch (Throwable throwable) {
                JobDbManager.safeCloseResultSet(resultSet);
                JobDbManager.safeCloseStatement(stmt);
                JobDbManager.safeRollbackAndClose((Connection)conn);
                throw throwable;
            }
        }
        JobDbManager.safeCloseResultSet((ResultSet)resultSet);
        JobDbManager.safeCloseStatement((Statement)stmt);
        JobDbManager.safeRollbackAndClose((Connection)conn);
        if (log.isDebug2()) {
            log.debug2("getFailedReindexingJobsBefore(): failedJobs.size() = " + failedJobs.size());
        }
        return failedJobs;
    }

    public Map<String, Long> getJobTypeSeqByName() {
        return this.jobTypeSeqByName;
    }
}

