/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.metadata.query;

import java.io.File;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lockss.app.BaseLockssManager;
import org.lockss.app.ConfigurableManager;
import org.lockss.config.Configuration;
import org.lockss.db.DbException;
import org.lockss.db.DbManager;
import org.lockss.extractor.ArticleMetadata;
import org.lockss.extractor.MetadataField;
import org.lockss.log.L4JLogger;
import org.lockss.metadata.ArticleMetadataBuffer;
import org.lockss.metadata.AuMetadataRecorder;
import org.lockss.metadata.ItemMetadata;
import org.lockss.metadata.ItemMetadataContinuationToken;
import org.lockss.metadata.ItemMetadataPage;
import org.lockss.metadata.MetadataDbManager;
import org.lockss.metadata.MetadataManager;
import org.lockss.metadata.query.MetadataQueryManagerSql;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.plugin.AuUtil;
import org.lockss.plugin.Plugin;
import org.lockss.util.StringUtil;
import org.lockss.util.os.PlatformUtil;
import org.lockss.util.time.TimeBase;

public class MetadataQueryManager
extends BaseLockssManager
implements ConfigurableManager {
    private static final L4JLogger log = L4JLogger.getLogger();
    public static final String PREFIX = "org.lockss.metadataManager.";
    static final String PARAM_MANDATORY_FIELDS = "org.lockss.metadataManager.mandatoryFields";
    static final List<String> DEFAULT_MANDATORY_FIELDS = null;
    private MetadataDbManager dbManager = null;
    private MetadataManager mdManager;
    private MetadataQueryManagerSql mdqManagerSql;
    private List<String> mandatoryMetadataFields = DEFAULT_MANDATORY_FIELDS;

    public MetadataQueryManager() {
    }

    public MetadataQueryManager(MetadataDbManager dbManager) throws DbException {
        this.dbManager = dbManager;
        this.mdManager = new MetadataManager(dbManager);
        this.mdqManagerSql = new MetadataQueryManagerSql((DbManager)dbManager);
    }

    public void startService() {
        super.startService();
        log.debug("Starting MetadataQueryManager");
        this.dbManager = (MetadataDbManager)this.getManagerByType(MetadataDbManager.class);
        this.mdManager = (MetadataManager)this.getManagerByType(MetadataManager.class);
        try {
            this.mdqManagerSql = new MetadataQueryManagerSql((DbManager)this.dbManager);
        }
        catch (DbException dbe) {
            log.error("Cannot obtain MetadataManagerSql", (Throwable)dbe);
            return;
        }
        this.resetConfig();
        log.debug("MetadataQueryManager service successfully started");
    }

    public void setConfig(Configuration config, Configuration prevConfig, Configuration.Differences changedKeys) {
        if (changedKeys.contains(PREFIX) && changedKeys.contains(PARAM_MANDATORY_FIELDS)) {
            this.mandatoryMetadataFields = config.getList(PARAM_MANDATORY_FIELDS, DEFAULT_MANDATORY_FIELDS);
            log.trace("mandatoryMetadataFields = {}", this.mandatoryMetadataFields);
        }
    }

    public static boolean isBookSeries(String pIssn, String eIssn, String pIsbn, String eIsbn, String seriesName, String volume) {
        boolean isBookSeries = MetadataManager.isBook((String)pIsbn, (String)eIsbn) && (!StringUtil.isNullString((String)seriesName) || !StringUtil.isNullString((String)volume) || !StringUtil.isNullString((String)pIssn) || !StringUtil.isNullString((String)eIssn));
        log.debug2("isBookSeries = {}", (Object)isBookSeries);
        return isBookSeries;
    }

    public MetadataDbManager getDbManager() {
        return this.dbManager;
    }

    public MetadataManager getMetadataManager() {
        return this.mdManager;
    }

    private List<String> getMandatoryMetadataFields() {
        return this.mandatoryMetadataFields;
    }

    public void addMdItemUrls(Connection conn, Long mdItemSeq, String accessUrl, Map<String, String> featuredUrlMap) throws DbException {
        if (!StringUtil.isNullString((String)accessUrl)) {
            this.mdManager.addMdItemUrl(conn, mdItemSeq, "Access", accessUrl);
            log.trace("Added feature = {}, URL = {}", (Object)"Access", (Object)accessUrl);
        }
        for (String feature : featuredUrlMap.keySet()) {
            this.mdManager.addMdItemUrl(conn, mdItemSeq, feature, featuredUrlMap.get(feature));
            log.trace("Added feature = {}, URL = {}", (Object)feature, (Object)featuredUrlMap.get(feature));
        }
    }

    public MetadataQueryManagerSql getMetadataQueryManagerSql() {
        return this.mdqManagerSql;
    }

    public ItemMetadataPage getAuMetadataDetail(String auId, Integer limit, ItemMetadataContinuationToken continuationToken) throws DbException {
        log.debug2("auId = {}", (Object)auId);
        log.debug2("limit = {}", (Object)limit);
        log.debug2("continuationToken = {}", (Object)continuationToken);
        return this.mdqManagerSql.getAuMetadataDetail(auId, limit, continuationToken);
    }

    private Long storeAuItemMetadata(ItemMetadata item, ArchivalUnit au, Plugin plugin, String auId, long creationTime) throws Exception {
        log.debug2("item = {}", (Object)item);
        log.debug2("auId = {}", (Object)auId);
        Long mdItemSeq = null;
        Connection conn = null;
        ArticleMetadataBuffer articleMetadataInfoBuffer = null;
        try {
            articleMetadataInfoBuffer = new ArticleMetadataBuffer(new File(PlatformUtil.getSystemTempDir()));
            ArticleMetadata md = this.populateArticleMetadata(item);
            log.trace("md = {}", (Object)md);
            articleMetadataInfoBuffer.add(md);
            Iterator<ArticleMetadataBuffer.ArticleMetadataInfo> mditr = articleMetadataInfoBuffer.iterator();
            conn = this.dbManager.getConnection();
            List<String> mandatoryFields = this.getMandatoryMetadataFields();
            log.trace("mandatoryFields = {}", mandatoryFields);
            mdItemSeq = new AuMetadataRecorder(null, this, null, au, plugin, auId).recordMetadataItem(conn, mandatoryFields, mditr, creationTime);
            MetadataDbManager.commitOrRollback((Connection)conn, (L4JLogger)log);
        }
        catch (Exception e) {
            try {
                log.error("Error storing AU item metadata", (Throwable)e);
                log.error("item = {}", (Object)item);
                throw e;
            }
            catch (Throwable throwable) {
                MetadataDbManager.safeRollbackAndClose(conn);
                articleMetadataInfoBuffer.close();
                throw throwable;
            }
        }
        MetadataDbManager.safeRollbackAndClose((Connection)conn);
        articleMetadataInfoBuffer.close();
        log.debug2("mdItemSeq = {}", (Object)mdItemSeq);
        return mdItemSeq;
    }

    private ArticleMetadata populateArticleMetadata(ItemMetadata item) {
        Set keywords;
        Map issnMap;
        HashMap mapMap;
        HashMap listMap;
        HashMap setMap;
        HashMap scalarMap = item.getScalarMap();
        if (scalarMap == null) {
            scalarMap = new HashMap();
        }
        if ((setMap = item.getSetMap()) == null) {
            setMap = new HashMap();
        }
        if ((listMap = item.getListMap()) == null) {
            listMap = new HashMap();
        }
        if ((mapMap = item.getMapMap()) == null) {
            mapMap = new HashMap();
        }
        ArticleMetadata am = new ArticleMetadata();
        am.put(MetadataField.FIELD_PUBLISHER, (String)scalarMap.get("publisher_name"));
        am.put(MetadataField.FIELD_PROVIDER, (String)scalarMap.get("provider_name"));
        am.put(MetadataField.FIELD_SERIES_TITLE, (String)scalarMap.get("series_title_name"));
        am.put(MetadataField.FIELD_PROPRIETARY_SERIES_IDENTIFIER, (String)scalarMap.get("proprietary_series_identifier"));
        am.put(MetadataField.FIELD_PUBLICATION_TITLE, (String)scalarMap.get("publication_name"));
        Map isbnMap = (Map)mapMap.get("isbn");
        if (isbnMap != null && isbnMap.size() > 0) {
            am.put(MetadataField.FIELD_ISBN, (String)isbnMap.get("p_isbn"));
            am.put(MetadataField.FIELD_EISBN, (String)isbnMap.get("e_isbn"));
        }
        if ((issnMap = (Map)mapMap.get("issn")) != null && issnMap.size() > 0) {
            am.put(MetadataField.FIELD_ISSN, (String)issnMap.get("p_issn"));
            am.put(MetadataField.FIELD_EISSN, (String)issnMap.get("e_issn"));
        }
        am.put(MetadataField.FIELD_VOLUME, (String)scalarMap.get("volume"));
        am.put(MetadataField.FIELD_ISSUE, (String)scalarMap.get("issue"));
        am.put(MetadataField.FIELD_START_PAGE, (String)scalarMap.get("start_page"));
        am.put(MetadataField.FIELD_END_PAGE, (String)scalarMap.get("end_page"));
        am.put(MetadataField.FIELD_DATE, (String)scalarMap.get("date"));
        am.put(MetadataField.FIELD_ARTICLE_TITLE, (String)scalarMap.get("item_title"));
        List authors = (List)listMap.get("author_name");
        if (authors != null) {
            for (String author : authors) {
                am.put(MetadataField.FIELD_AUTHOR, author);
            }
        }
        am.put(MetadataField.FIELD_DOI, (String)scalarMap.get("doi"));
        Map urlMap = (Map)mapMap.get("url");
        if (urlMap != null && urlMap.size() > 0) {
            am.put(MetadataField.FIELD_ACCESS_URL, (String)urlMap.get("Access"));
            am.putRaw(MetadataField.FIELD_FEATURED_URL_MAP.getKey(), urlMap);
        }
        if ((keywords = (Set)setMap.get("keyword")) != null) {
            for (String keyword : keywords) {
                am.put(MetadataField.FIELD_KEYWORDS, keyword);
            }
        }
        am.put(MetadataField.FIELD_COVERAGE, (String)scalarMap.get("coverage"));
        am.put(MetadataField.FIELD_ITEM_NUMBER, (String)scalarMap.get("item_no"));
        Set pis = (Set)setMap.get("proprietary_id");
        if (pis != null && pis.size() > 0) {
            am.put(MetadataField.FIELD_PROPRIETARY_IDENTIFIER, (String)pis.iterator().next());
        }
        am.put(MetadataField.FIELD_FETCH_TIME, (String)scalarMap.get("fetch_time"));
        return am;
    }

    public Long storeAuItemMetadataForTesting(ItemMetadata item, ArchivalUnit au) throws Exception {
        log.debug2("item = {}", (Object)item);
        Long mdItemSeq = this.storeAuItemMetadata(item, au, au.getPlugin(), au.getAuId(), AuUtil.getAuCreationTime((ArchivalUnit)au));
        this.updateAuLastExtractionTime(au.getAuId());
        log.debug2("mdItemSeq = {}", (Object)mdItemSeq);
        return mdItemSeq;
    }

    private void updateAuLastExtractionTime(String auId) throws DbException {
        log.debug2("auId = {}", (Object)auId);
        Connection conn = null;
        try {
            conn = this.dbManager.getConnection();
            Long auMdSeq = this.mdqManagerSql.findAuMdByAuId(conn, auId);
            log.trace("auMdSeq = {}", (Object)auMdSeq);
            long now = TimeBase.nowMs();
            log.trace("now = {}", (Object)now);
            this.mdqManagerSql.updateAuLastExtractionTime(conn, auMdSeq, now);
            MetadataDbManager.commitOrRollback((Connection)conn, (L4JLogger)log);
        }
        catch (Exception e) {
            log.error("Error updating AU extraction time", (Throwable)e);
            log.error("auId = {}", (Object)auId);
            throw e;
        }
        finally {
            MetadataDbManager.safeRollbackAndClose((Connection)conn);
        }
    }
}

