/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.metadata.extractor;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Base64;
import org.lockss.config.CurrentConfig;
import org.lockss.util.Logger;
import org.lockss.util.rest.RestUtil;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class DeleteAuItemsClient {
    private static Logger log = Logger.getLogger(DeleteAuItemsClient.class);

    Integer deleteAuItems(String auId) throws UnsupportedEncodingException {
        String DEBUG_HEADER = "deleteAuItems(): ";
        if (log.isDebug2()) {
            log.debug2("deleteAuItems(): auId = " + auId);
        }
        String restServiceLocation = CurrentConfig.getParam((String)"org.lockss.metadataManager.mdRest.serviceLocation");
        if (log.isDebug3()) {
            log.debug3("deleteAuItems(): restServiceLocation = " + restServiceLocation);
        }
        long timeoutValue = CurrentConfig.getIntParam((String)"org.lockss.metadataManager.mdRest.timeoutValue", (int)600);
        if (log.isDebug3()) {
            log.debug3("deleteAuItems(): timeoutValue = " + timeoutValue);
        }
        String userName = CurrentConfig.getParam((String)"org.lockss.metadataManager.mdRest.userName");
        if (log.isDebug3()) {
            log.debug3("deleteAuItems(): userName = '" + userName + "'");
        }
        String password = CurrentConfig.getParam((String)"org.lockss.metadataManager.mdRest.password");
        if (log.isDebug3()) {
            log.debug3("deleteAuItems(): password = '" + password + "'");
        }
        RestTemplate restTemplate = RestUtil.getRestTemplate((long)(1000L * timeoutValue), (long)(1000L * timeoutValue));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String credentials = userName + ":" + password;
        String authHeaderValue = "Basic " + Base64.getEncoder().encodeToString(credentials.getBytes(Charset.forName("US-ASCII")));
        headers.set("Authorization", authHeaderValue);
        ResponseEntity response = restTemplate.exchange(restServiceLocation + "/aus/" + auId, HttpMethod.DELETE, new HttpEntity(null, (MultiValueMap)headers), Integer.class, new Object[0]);
        HttpStatusCode statusCode = response.getStatusCode();
        HttpStatus status = HttpStatus.valueOf((int)statusCode.value());
        if (log.isDebug3()) {
            log.debug3("deleteAuItems(): status = " + status);
        }
        Integer mdItemSeq = (Integer)response.getBody();
        if (log.isDebug2()) {
            log.debug2("deleteAuItems(): mdItemSeq = " + mdItemSeq);
        }
        return mdItemSeq;
    }
}

