/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.metadata.extractor;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lockss.app.BaseLockssManager;
import org.lockss.app.ConfigurableManager;
import org.lockss.app.LockssApp;
import org.lockss.config.Configuration;
import org.lockss.daemon.LockssRunnable;
import org.lockss.daemon.status.OverviewAccessor;
import org.lockss.daemon.status.StatusAccessor;
import org.lockss.daemon.status.StatusService;
import org.lockss.db.DbException;
import org.lockss.db.DbManager;
import org.lockss.extractor.ArticleMetadata;
import org.lockss.extractor.ArticleMetadataExtractor;
import org.lockss.extractor.BaseArticleMetadataExtractor;
import org.lockss.extractor.MetadataField;
import org.lockss.extractor.MetadataTarget;
import org.lockss.metadata.ArticleMetadataBuffer;
import org.lockss.metadata.AuMetadataRecorder;
import org.lockss.metadata.Isbn;
import org.lockss.metadata.Issn;
import org.lockss.metadata.ItemMetadata;
import org.lockss.metadata.MetadataDbManager;
import org.lockss.metadata.MetadataManager;
import org.lockss.metadata.extractor.DeleteMetadataTask;
import org.lockss.metadata.extractor.DisplayReindexingTask;
import org.lockss.metadata.extractor.MetadataExtractorManagerSql;
import org.lockss.metadata.extractor.MetadataIndexingOverviewAccessor;
import org.lockss.metadata.extractor.MetadataIndexingStarter;
import org.lockss.metadata.extractor.MetadataManagerStatusAccessor;
import org.lockss.metadata.extractor.ReindexingTask;
import org.lockss.metadata.extractor.job.JobAuStatus;
import org.lockss.metadata.extractor.job.JobManager;
import org.lockss.metadata.query.MetadataQueryManager;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.plugin.AuUtil;
import org.lockss.plugin.Plugin;
import org.lockss.plugin.PluginManager;
import org.lockss.scheduler.Schedule;
import org.lockss.state.AuStateBean;
import org.lockss.state.StateManager;
import org.lockss.state.SubstanceChecker;
import org.lockss.util.LockssWatchdog;
import org.lockss.util.Logger;
import org.lockss.util.PatternIntMap;
import org.lockss.util.StringUtil;
import org.lockss.util.os.PlatformUtil;
import org.lockss.util.time.TimeBase;

public class MetadataExtractorManager
extends BaseLockssManager
implements ConfigurableManager {
    private static Logger log = Logger.getLogger(MetadataExtractorManager.class);
    public static final String PREFIX = "org.lockss.metadataManager.";
    public static final String PARAM_USE_METADATA_EXTRACTOR = "org.lockss.metadataManager.use_metadata_extractor";
    public static final boolean DEFAULT_USE_METADATA_EXTRACTOR = true;
    public static final String PARAM_INDEXING_ENABLED = "org.lockss.metadataManager.indexing_enabled";
    public static final boolean DEFAULT_INDEXING_ENABLED = false;
    public static final String PARAM_MAX_REINDEXING_TASKS = "org.lockss.metadataManager.maxReindexingTasks";
    public static final int DEFAULT_MAX_REINDEXING_TASKS = 1;
    public static final String PARAM_DISABLE_CRAWL_RESCHEDULE_TASK = "org.lockss.metadataManager.disableCrawlRescheduleTask";
    public static final boolean DEFAULT_DISABLE_CRAWL_RESCHEDULE_TASK = false;
    public static final String PARAM_HISTORY_MAX = "org.lockss.metadataManager.historySize";
    static final String WDOG_PARAM_INDEXER = "MetadataIndexer";
    static final long WDOG_DEFAULT_INDEXER = 21600000L;
    public static final int DEFAULT_HISTORY_MAX = 200;
    private static final String PARAM_PENDING_AU_LIST_SIZE = "org.lockss.metadataManager.maxPendingAuListSize";
    private static final int DEFAULT_PENDING_AU_LIST_SIZE = 200;
    public static final String PARAM_PRIORTIZE_INDEXING_NEW_AUS = "org.lockss.metadataManager.prioritizeIndexingNewAus";
    public static final boolean DEFAULT_PRIORTIZE_INDEXING_NEW_AUS = true;
    static final String PARAM_INDEX_PRIORITY_AUID_MAP = "org.lockss.metadataManager.indexPriorityAuidMap";
    static final List<String> DEFAULT_INDEX_PRIORITY_AUID_MAP = null;
    static final int FAILED_INDEX_PRIORITY = -1000;
    static final int MIN_INDEX_PRIORITY = -10000;
    private static final int ABORT_INDEX_PRIORITY = -20000;
    public static final String PARAM_MAX_PENDING_TO_REINDEX_AU_BATCH_SIZE = "org.lockss.metadataManager.maxPendingToReindexAuBatchSize";
    private static final int DEFAULT_MAX_PENDING_TO_REINDEX_AU_BATCH_SIZE = 1000;
    static final String PARAM_MANDATORY_FIELDS = "org.lockss.metadataManager.mandatoryFields";
    static final List<String> DEFAULT_MANDATORY_FIELDS = null;
    static final String PARAM_ON_DEMAND_METADATA_EXTRACTION_ONLY = "org.lockss.metadataManager.onDemandMetadataExtractionOnly";
    static final boolean DEFAULT_ON_DEMAND_METADATA_EXTRACTION_ONLY = false;
    static final String PARAM_MD_REST_TIMEOUT_VALUE = "org.lockss.metadataManager.mdRest.timeoutValue";
    static final int DEFAULT_MD_REST_TIMEOUT_VALUE = 600;
    static final String PARAM_MD_REST_USER_NAME = "org.lockss.metadataManager.mdRest.userName";
    static final String PARAM_MD_REST_PASSWORD = "org.lockss.metadataManager.mdRest.password";
    static final String PARAM_METADATA_EXTRACTION_CHECK_INTERVAL = "org.lockss.metadataManager.metadataExtractionCheckInterval";
    static final long DEFAULT_METADATA_EXTRACTION_CHECK_INTERVAL = 86400000L;
    final Map<String, ReindexingTask> activeReindexingTasks = new HashMap<String, ReindexingTask>();
    final List<ReindexingTask> reindexingTaskHistory = new LinkedList<ReindexingTask>();
    final List<ReindexingTask> failedReindexingTasks = new LinkedList<ReindexingTask>();
    boolean reindexingEnabled = false;
    boolean everEnabled = false;
    boolean useMetadataExtractor = true;
    int maxReindexingTasks = 1;
    boolean disableCrawlRescheduleTask = false;
    private long metadataArticleCount = 0L;
    private long metadataPublisherCount = -1L;
    private long metadataProviderCount = -1L;
    private long pendingAusCount = 0L;
    private int pendingAuListSize = 200;
    private boolean prioritizeIndexingNewAus = true;
    private long successfulReindexingCount = -1L;
    private long failedReindexingCount = -1L;
    private int maxReindexingTaskHistory = 200;
    private PluginManager pluginMgr = null;
    private MetadataDbManager dbManager = null;
    private MetadataManager mdManager;
    private JobManager jobMgr;
    private StateManager stateManager;
    private PatternIntMap indexPriorityAuidMap;
    private int maxPendingAuBatchSize = 1000;
    private int pendingAuBatchCurrentSize = 0;
    private MetadataExtractorManagerSql mdxManagerSql;
    private List<String> mandatoryMetadataFields = DEFAULT_MANDATORY_FIELDS;
    private boolean onDemandMetadataExtractionOnly = false;
    private long metadataExtractionCheckInterval = 86400000L;

    public MetadataExtractorManager() {
    }

    public MetadataExtractorManager(MetadataDbManager dbManager) throws DbException {
        this.pluginMgr = new PluginManager();
        this.dbManager = dbManager;
        this.mdManager = new MetadataManager(dbManager);
        this.mdxManagerSql = new MetadataExtractorManagerSql((DbManager)dbManager, this);
    }

    public void startService() {
        super.startService();
        String DEBUG_HEADER = "startService(): ";
        log.debug("startService(): Starting MetadataExtractorManager");
        this.pluginMgr = (PluginManager)this.getManagerByType(PluginManager.class);
        this.dbManager = (MetadataDbManager)this.getManagerByType(MetadataDbManager.class);
        this.mdManager = (MetadataManager)this.getManagerByType(MetadataManager.class);
        this.jobMgr = (JobManager)((Object)this.getManagerByType(JobManager.class));
        this.stateManager = (StateManager)this.getManagerByType(StateManager.class);
        try {
            this.mdxManagerSql = new MetadataExtractorManagerSql((DbManager)this.dbManager, this);
        }
        catch (DbException dbe) {
            log.error("Cannot obtain MetadataManagerSql", (Throwable)dbe);
            return;
        }
        try {
            this.pendingAusCount = this.mdxManagerSql.getEnabledPendingAusCount();
            this.metadataArticleCount = this.mdxManagerSql.getArticleCount();
            this.metadataPublisherCount = this.mdxManagerSql.getPublisherCount();
            this.metadataProviderCount = this.mdxManagerSql.getProviderCount();
        }
        catch (DbException dbe) {
            log.error("Cannot get pending AUs and counts", (Throwable)dbe);
        }
        StatusService statusServ = (StatusService)this.getApp().getManagerByType(StatusService.class);
        statusServ.registerStatusAccessor("MetadataStatusTable", (StatusAccessor)new MetadataManagerStatusAccessor(this));
        statusServ.registerOverviewAccessor("MetadataStatusTable", (OverviewAccessor)new MetadataIndexingOverviewAccessor(this));
        this.resetConfig();
        log.debug("startService(): MetadataExtractorManager service successfully started");
    }

    void startStarter() {
        MetadataIndexingStarter starter = new MetadataIndexingStarter(this.dbManager, this, this.pluginMgr, this.jobMgr, this.metadataExtractionCheckInterval);
        new Thread((Runnable)((Object)starter)).start();
    }

    public void setConfig(Configuration config, Configuration prevConfig, Configuration.Differences changedKeys) {
        if (changedKeys.contains(PREFIX)) {
            this.useMetadataExtractor = config.getBoolean(PARAM_USE_METADATA_EXTRACTOR, true);
            this.maxReindexingTasks = Math.max(0, config.getInt(PARAM_MAX_REINDEXING_TASKS, 1));
            this.disableCrawlRescheduleTask = config.getBoolean(PARAM_DISABLE_CRAWL_RESCHEDULE_TASK, false);
            this.pendingAuListSize = Math.max(0, config.getInt(PARAM_PENDING_AU_LIST_SIZE, 200));
            this.prioritizeIndexingNewAus = config.getBoolean(PARAM_PRIORTIZE_INDEXING_NEW_AUS, true);
            if (changedKeys.contains(PARAM_ON_DEMAND_METADATA_EXTRACTION_ONLY)) {
                this.onDemandMetadataExtractionOnly = config.getBoolean(PARAM_ON_DEMAND_METADATA_EXTRACTION_ONLY, false);
                if (log.isDebug3()) {
                    log.debug3("onDemandMetadataExtractionOnly = " + this.onDemandMetadataExtractionOnly);
                }
            }
            if (this.isAppInited() && !this.onDemandMetadataExtractionOnly) {
                this.metadataExtractionCheckInterval = config.getLong(PARAM_METADATA_EXTRACTION_CHECK_INTERVAL, 86400000L);
                boolean doEnable = config.getBoolean(PARAM_INDEXING_ENABLED, false);
                this.setIndexingEnabled(doEnable);
            }
            if (changedKeys.contains(PARAM_HISTORY_MAX)) {
                int histSize = config.getInt(PARAM_HISTORY_MAX, 200);
                this.setMaxHistory(histSize);
            }
            if (changedKeys.contains(PARAM_INDEX_PRIORITY_AUID_MAP)) {
                this.installIndexPriorityAuidMap(config.getList(PARAM_INDEX_PRIORITY_AUID_MAP, DEFAULT_INDEX_PRIORITY_AUID_MAP));
                if (this.isAppInited() && !this.onDemandMetadataExtractionOnly) {
                    this.processAbortPriorities();
                    if (this.dbManager != null) {
                        this.startReindexing();
                    }
                }
            }
            if (changedKeys.contains(PARAM_MAX_PENDING_TO_REINDEX_AU_BATCH_SIZE)) {
                this.maxPendingAuBatchSize = config.getInt(PARAM_MAX_PENDING_TO_REINDEX_AU_BATCH_SIZE, 1000);
            }
            if (changedKeys.contains(PARAM_MANDATORY_FIELDS)) {
                this.mandatoryMetadataFields = config.getList(PARAM_MANDATORY_FIELDS, DEFAULT_MANDATORY_FIELDS);
                if (log.isDebug3()) {
                    log.debug3("mandatoryMetadataFields = " + this.mandatoryMetadataFields);
                }
            }
        }
    }

    void setIndexingEnabled(boolean enable) {
        String DEBUG_HEADER = "setIndexingEnabled(): ";
        log.debug("setIndexingEnabled(): enabled: " + enable);
        if (this.dbManager != null) {
            if (!this.reindexingEnabled && enable) {
                if (this.everEnabled) {
                    this.startReindexing();
                } else {
                    this.startStarter();
                    this.everEnabled = true;
                }
                this.reindexingEnabled = enable;
            } else if (this.reindexingEnabled && !enable) {
                this.stopReindexing();
            }
            this.reindexingEnabled = enable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMaxHistory(int maxSize) {
        this.maxReindexingTaskHistory = maxSize;
        List<ReindexingTask> list = this.reindexingTaskHistory;
        synchronized (list) {
            while (this.reindexingTaskHistory.size() > this.maxReindexingTaskHistory) {
                this.reindexingTaskHistory.remove(this.maxReindexingTaskHistory);
            }
        }
        list = this.failedReindexingTasks;
        synchronized (list) {
            while (this.failedReindexingTasks.size() > this.maxReindexingTaskHistory) {
                this.failedReindexingTasks.remove(this.maxReindexingTaskHistory);
            }
        }
    }

    private void installIndexPriorityAuidMap(List<String> patternPairs) {
        if (patternPairs == null) {
            log.debug("Installing empty index priority map");
            this.indexPriorityAuidMap = PatternIntMap.EMPTY;
        } else {
            try {
                this.indexPriorityAuidMap = new PatternIntMap(patternPairs);
                log.debug("Installing index priority map: " + this.indexPriorityAuidMap);
            }
            catch (IllegalArgumentException e) {
                log.error("Illegal index priority map, ignoring", (Throwable)e);
                log.error("Index priority map unchanged: " + this.indexPriorityAuidMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAbortPriorities() {
        ArrayList<ArchivalUnit> abortAus = new ArrayList<ArchivalUnit>();
        Map<String, ReindexingTask> map = this.activeReindexingTasks;
        synchronized (map) {
            for (ReindexingTask task : this.activeReindexingTasks.values()) {
                ArchivalUnit au = task.getAu();
                if (this.indexPriorityAuidMap.getMatch(au.getAuId()) >= -20000) continue;
                abortAus.add(au);
            }
        }
        for (ArchivalUnit au : abortAus) {
            log.info("Aborting indexing: " + au);
            this.cancelAuTask(au.getAuId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int startReindexing() {
        String DEBUG_HEADER = "startReindexing(): ";
        Connection conn = null;
        int count = 0;
        try {
            conn = this.dbManager.getConnection();
            count = this.startReindexing(conn);
            MetadataDbManager.commitOrRollback((Connection)conn, (Logger)log);
        }
        catch (DbException dbe) {
            log.error("Cannot start reindexing", (Throwable)dbe);
        }
        finally {
            MetadataDbManager.safeRollbackAndClose((Connection)conn);
        }
        log.debug3("startReindexing(): count = " + count);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopReindexing() {
        String DEBUG_HEADER = "stopReindexing(): ";
        log.debug("stopReindexing(): Number of reindexing tasks being stopped: " + this.activeReindexingTasks.size());
        Map<String, ReindexingTask> map = this.activeReindexingTasks;
        synchronized (map) {
            for (ReindexingTask task : this.activeReindexingTasks.values()) {
                task.cancel();
            }
            this.activeReindexingTasks.clear();
        }
    }

    private boolean cancelAuTask(String auId) {
        String DEBUG_HEADER = "cancelAuTask(): ";
        ReindexingTask task = this.activeReindexingTasks.get(auId);
        if (task != null) {
            log.debug2("cancelAuTask(): Canceling pending reindexing task for auId " + auId);
            task.cancel();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int startReindexing(Connection conn) {
        String DEBUG_HEADER = "startReindexing(): ";
        if (log.isDebug2()) {
            log.debug2("Starting...");
        }
        if (!this.isAppInited()) {
            if (log.isDebug()) {
                log.debug("startReindexing(): Daemon not initialized: No reindexing tasks.");
            }
            return 0;
        }
        if (!this.reindexingEnabled) {
            if (log.isDebug()) {
                log.debug("startReindexing(): Metadata manager reindexing is disabled: No reindexing tasks.");
            }
            return 0;
        }
        int reindexedTaskCount = 0;
        Map<String, ReindexingTask> map = this.activeReindexingTasks;
        synchronized (map) {
            block13: while (this.activeReindexingTasks.size() < this.maxReindexingTasks) {
                if (log.isDebug3()) {
                    log.debug3("activeReindexingTasks.size() = " + this.activeReindexingTasks.size());
                    log.debug3("maxReindexingTasks = " + this.maxReindexingTasks);
                }
                List<Object> auIdsToReindex = new ArrayList();
                if (this.pluginMgr != null) {
                    auIdsToReindex = this.mdxManagerSql.getPrioritizedAuIdsToReindex(conn, this.maxReindexingTasks - this.activeReindexingTasks.size(), this.prioritizeIndexingNewAus);
                    if (log.isDebug3()) {
                        log.debug3("auIdsToReindex.size() = " + auIdsToReindex.size());
                    }
                }
                if (auIdsToReindex.isEmpty()) break;
                for (PrioritizedAuId prioritizedAuId : auIdsToReindex) {
                    Long auSeq;
                    ReindexingTask task;
                    ArchivalUnit au;
                    block33: {
                        if (log.isDebug3()) {
                            log.debug3("auIdToReindex.auId = " + prioritizedAuId.auId);
                        }
                        au = this.pluginMgr.getAuFromId(prioritizedAuId.auId);
                        if (log.isDebug3()) {
                            log.debug3("au = " + au);
                        }
                        if (au == null) {
                            try {
                                this.deleteAu(conn, prioritizedAuId.auId);
                            }
                            catch (DbException dbe) {
                                log.error("Error removing AU for auId " + prioritizedAuId.auId + " from the database", (Throwable)dbe);
                            }
                            continue;
                        }
                        ArticleMetadataExtractor ae = this.getMetadataExtractor(au);
                        if (ae == null) {
                            log.debug("startReindexing(): Not running reindexing task for AU '" + au.getName() + "' because it nas no metadata extractor");
                            try {
                                this.pendingAusCount = this.mdxManagerSql.removeFromPendingAus(conn, au.getAuId());
                                continue;
                            }
                            catch (DbException dbe) {
                                log.error("Error removing AU " + au.getName() + " from the table of pending AUs", (Throwable)dbe);
                                continue block13;
                            }
                        }
                        if (log.isDebug3()) {
                            log.debug3("startReindexing(): Creating the reindexing task for AU: " + au.getName());
                        }
                        task = new ReindexingTask(au, ae);
                        auSeq = null;
                        try {
                            auSeq = this.findAuSeq(conn, au.getAuId());
                            if (!log.isDebug3()) break block33;
                            log.debug3("startReindexing(): auSeq = " + auSeq);
                        }
                        catch (DbException dbe) {
                            log.error("Error trying to locate in the database AU " + au.getName(), (Throwable)dbe);
                            continue block13;
                        }
                    }
                    task.setNewAu(auSeq == null);
                    if (auSeq != null) {
                        boolean fullReindex = true;
                        try {
                            fullReindex = this.mdxManagerSql.needAuFullReindexing(conn, au);
                            if (log.isDebug3()) {
                                log.debug3("startReindexing(): fullReindex = " + fullReindex);
                            }
                        }
                        catch (DbException dbe) {
                            log.warning("Error getting from the database the full re-indexing flag for AU " + au.getName() + ": Doing full re-index", (Throwable)dbe);
                        }
                        if (fullReindex) {
                            task.setFullReindex(fullReindex);
                        } else {
                            long lastExtractTime = 0L;
                            try {
                                lastExtractTime = this.mdxManagerSql.getAuExtractionTime(conn, au);
                                if (log.isDebug3()) {
                                    log.debug3("startReindexing(): lastExtractTime = " + lastExtractTime);
                                }
                            }
                            catch (DbException dbe) {
                                log.warning("Error getting the last extraction time for AU " + au.getName() + ": Doing a full re-index", (Throwable)dbe);
                            }
                            task.setLastExtractTime(lastExtractTime);
                        }
                    }
                    this.activeReindexingTasks.put(au.getAuId(), task);
                    this.addToIndexingTaskHistory(task);
                    log.debug("startReindexing(): Running the reindexing task for AU: " + au.getName());
                    this.runReindexingTask(task);
                    ++reindexedTaskCount;
                }
            }
        }
        log.debug("startReindexing(): Started " + reindexedTaskCount + " AU reindexing tasks");
        return reindexedTaskCount;
    }

    List<PrioritizedAuId> getPrioritizedAuIdsToReindex(Connection conn, int maxAuIds, boolean prioritizeIndexingNewAus) {
        return this.mdxManagerSql.getPrioritizedAuIdsToReindex(conn, maxAuIds, prioritizeIndexingNewAus);
    }

    private int deleteAu(Connection conn, String auId) throws DbException {
        String DEBUG_HEADER = "deleteAu(): ";
        log.debug3("deleteAu(): auid = " + auId);
        this.cancelAuTask(auId);
        this.removeFromIndexingTaskHistory(auId);
        this.removeFromFailedIndexingTasks(auId);
        int articleCount = this.mdxManagerSql.removeAuMetadataItems(conn, auId);
        log.debug3("deleteAu(): articleCount = " + articleCount);
        this.mdxManagerSql.removeAu(conn, auId);
        this.pendingAusCount = this.mdxManagerSql.removeFromPendingAus(conn, auId);
        this.notifyDeletedAu(auId, articleCount);
        return articleCount;
    }

    protected void notifyDeletedAu(String auId, int articleCount) {
    }

    private ArticleMetadataExtractor getMetadataExtractor(ArchivalUnit au) {
        BaseArticleMetadataExtractor ae = null;
        if (this.useMetadataExtractor) {
            Plugin plugin = au.getPlugin();
            ae = plugin.getArticleMetadataExtractor(MetadataTarget.OpenURL(), au);
        }
        if (ae == null) {
            ae = new BaseArticleMetadataExtractor(null);
        }
        return ae;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToIndexingTaskHistory(ReindexingTask task) {
        List<ReindexingTask> list = this.reindexingTaskHistory;
        synchronized (list) {
            this.reindexingTaskHistory.add(0, task);
            this.setMaxHistory(this.maxReindexingTaskHistory);
        }
    }

    private void runReindexingTask(final ReindexingTask task) {
        LockssRunnable runnable = new LockssRunnable(AuUtil.getThreadNameFor((String)"Reindexing", (ArchivalUnit)task.getAu())){

            public void lockssRun() {
                this.startWDog(MetadataExtractorManager.WDOG_PARAM_INDEXER, 21600000L);
                this.triggerWDogOnExit(true);
                task.setWDog((LockssWatchdog)this);
                task.handleEvent(Schedule.EventType.START);
                while (!task.isFinished()) {
                    task.step(Integer.MAX_VALUE);
                }
                task.handleEvent(Schedule.EventType.FINISH);
                this.stopWDog();
                this.triggerWDogOnExit(false);
            }
        };
        Thread runThread = new Thread((Runnable)runnable);
        runThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeFromIndexingTaskHistory(String auId) {
        int count = 0;
        List<ReindexingTask> list = this.reindexingTaskHistory;
        synchronized (list) {
            Iterator<ReindexingTask> itr = this.reindexingTaskHistory.iterator();
            while (itr.hasNext()) {
                ReindexingTask task = itr.next();
                if (!auId.equals(task.getAu().getAuId())) continue;
                itr.remove();
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeFromFailedIndexingTasks(String auId) {
        int count = 0;
        List<ReindexingTask> list = this.failedReindexingTasks;
        synchronized (list) {
            Iterator<ReindexingTask> itr = this.failedReindexingTasks.iterator();
            while (itr.hasNext()) {
                ReindexingTask task = itr.next();
                if (!auId.equals(task.getAu().getAuId())) continue;
                itr.remove();
                ++count;
            }
        }
        return count;
    }

    boolean isEligibleForReindexing(ArchivalUnit au) {
        return this.isEligibleForReindexing(au.getAuId());
    }

    boolean isEligibleForReindexing(String auId) {
        return this.indexPriorityAuidMap == null || this.indexPriorityAuidMap.getMatch(auId, 0) >= 0;
    }

    long getActiveReindexingCount() {
        return this.activeReindexingTasks.size();
    }

    synchronized long getSuccessfulReindexingCount() {
        if (this.successfulReindexingCount < 0L) {
            try {
                this.successfulReindexingCount = this.jobMgr.getSuccessfulReindexingJobsCount();
            }
            catch (DbException ex) {
                log.error("getSuccessfulReindexingCount", (Throwable)ex);
            }
        }
        return this.successfulReindexingCount < 0L ? 0L : this.successfulReindexingCount;
    }

    synchronized long getFailedReindexingCount() {
        if (this.failedReindexingCount < 0L) {
            try {
                this.failedReindexingCount = this.jobMgr.getFailedReindexingJobsCount();
            }
            catch (DbException ex) {
                log.error("getFailedReindexingCount", (Throwable)ex);
            }
        }
        return this.failedReindexingCount < 0L ? 0L : this.failedReindexingCount;
    }

    List<DisplayReindexingTask> getReindexingTasks() {
        Object task;
        log.debug2("Invoked");
        ArrayList<DisplayReindexingTask> tasks = new ArrayList<DisplayReindexingTask>();
        int taskCount = 0;
        log.debug3("Running tasks:");
        for (ReindexingTask reindexingTask : this.reindexingTaskHistory) {
            if (!reindexingTask.hasStarted() || reindexingTask.isFinished()) continue;
            task = new DisplayReindexingTask(reindexingTask);
            if (log.isDebug3()) {
                log.debug3("task = " + (DisplayReindexingTask)task);
            }
            tasks.add((DisplayReindexingTask)task);
            if (++taskCount != this.maxReindexingTaskHistory) continue;
            return tasks;
        }
        log.debug3("Pending tasks:");
        try {
            for (Map map : this.jobMgr.getNotStartedReindexingJobs(this.maxReindexingTaskHistory - taskCount)) {
                task = new DisplayReindexingTask();
                String string = PluginManager.generateAuId((String)((String)map.get("plugin_id")), (String)((String)map.get("au_key")));
                if (log.isDebug3()) {
                    log.debug3("auId = " + string);
                }
                ((DisplayReindexingTask)task).setAuId(string);
                String auName = this.getAuName(string);
                ((DisplayReindexingTask)task).setAuName(auName);
                Long jobTypeSeq = (Long)map.get("job_type_seq");
                if (log.isDebug3()) {
                    log.debug3("jobTypeSeq = " + jobTypeSeq);
                }
                ((DisplayReindexingTask)task).setNeedFullReindex(this.jobMgr.isFullReindexJob(jobTypeSeq));
                if (log.isDebug3()) {
                    log.debug3("task = " + (DisplayReindexingTask)task);
                }
                tasks.add((DisplayReindexingTask)task);
                ++taskCount;
            }
        }
        catch (DbException dbe) {
            log.error("jobMgr.getNotStartedReindexingJobs() threw", (Throwable)dbe);
        }
        catch (Exception e) {
            log.error("getAuName() threw", (Throwable)e);
        }
        if (taskCount == this.maxReindexingTaskHistory) {
            return tasks;
        }
        log.debug3("Current finished tasks:");
        for (ReindexingTask reindexingTask : this.reindexingTaskHistory) {
            if (!reindexingTask.isFinished()) continue;
            task = new DisplayReindexingTask(reindexingTask);
            tasks.add((DisplayReindexingTask)task);
            if (log.isDebug3()) {
                log.debug3("task = " + (DisplayReindexingTask)task);
            }
            if (++taskCount != this.maxReindexingTaskHistory) continue;
            return tasks;
        }
        long startTime = this.theApp.getStartTime();
        log.debug3("Older finished tasks:");
        try {
            for (Map map : this.jobMgr.getFinishedReindexingJobsBefore(this.maxReindexingTaskHistory - taskCount, startTime)) {
                ReindexingStatus reindexingStatus;
                DisplayReindexingTask task2 = new DisplayReindexingTask();
                String auId = PluginManager.generateAuId((String)((String)map.get("plugin_id")), (String)((String)map.get("au_key")));
                if (log.isDebug3()) {
                    log.debug3("auId = " + auId);
                }
                task2.setAuId(auId);
                String auName = this.getAuName(auId);
                task2.setAuName(auName);
                Long jobTypeSeq = (Long)map.get("job_type_seq");
                if (log.isDebug3()) {
                    log.debug3("jobTypeSeq = " + jobTypeSeq);
                }
                task2.setNeedFullReindex(this.jobMgr.isFullReindexJob(jobTypeSeq));
                task2.setStartTime((Long)map.get("start_time"));
                task2.setEndTime((Long)map.get("end_time"));
                String statusMessage = (String)map.get("status_message");
                if (log.isDebug3()) {
                    log.debug3("statusMessage = '" + statusMessage + "'");
                }
                ReindexingStatus reindexingStatus2 = reindexingStatus = "Success".equals(statusMessage) ? ReindexingStatus.Success : ReindexingStatus.Failed;
                if (log.isDebug3()) {
                    log.debug3("reindexingStatus = " + reindexingStatus);
                }
                task2.setReindexingStatus(reindexingStatus);
                if (reindexingStatus == ReindexingStatus.Success) {
                    boolean auNoSubstance;
                    AuStateBean auStateBean = this.stateManager.getAuStateBean(auId);
                    if (log.isDebug3()) {
                        log.debug3("auStateBean = " + auStateBean);
                    }
                    boolean bl = auNoSubstance = auStateBean.getHasSubstance() == SubstanceChecker.State.No;
                    if (log.isDebug3()) {
                        log.debug3("auNoSubstance = " + auNoSubstance);
                    }
                    task2.setAuNoSubstance(auNoSubstance);
                } else {
                    task2.setE(new Exception(statusMessage));
                }
                if (log.isDebug3()) {
                    log.debug3("task = " + task2);
                }
                tasks.add(task2);
                ++taskCount;
            }
        }
        catch (DbException dbe) {
            log.error("jobMgr.getFinishedReindexingJobsBefore() threw", (Throwable)dbe);
        }
        catch (Exception e) {
            log.error("getAuName() threw", (Throwable)e);
        }
        if (log.isDebug2()) {
            log.debug2("tasks.size = " + tasks.size());
        }
        return tasks;
    }

    List<DisplayReindexingTask> getFailedReindexingTasks() {
        ArrayList<DisplayReindexingTask> tasks = new ArrayList<DisplayReindexingTask>();
        int taskCount = 0;
        log.debug3("Current failed tasks:");
        for (ReindexingTask reindexingTask : this.failedReindexingTasks) {
            DisplayReindexingTask task = new DisplayReindexingTask(reindexingTask);
            tasks.add(task);
            if (++taskCount != this.maxReindexingTaskHistory) continue;
            return tasks;
        }
        long startTime = this.theApp.getStartTime();
        log.debug3("Older failed tasks:");
        try {
            for (Map map : this.jobMgr.getFailedReindexingJobsBefore(this.maxReindexingTaskHistory - taskCount, startTime)) {
                DisplayReindexingTask task = new DisplayReindexingTask();
                String auId = PluginManager.generateAuId((String)((String)map.get("plugin_id")), (String)((String)map.get("au_key")));
                if (log.isDebug3()) {
                    log.debug3("auId = " + auId);
                }
                task.setAuId(auId);
                String auName = this.getAuName(auId);
                task.setAuName(auName);
                Long jobTypeSeq = (Long)map.get("job_type_seq");
                if (log.isDebug3()) {
                    log.debug3("jobTypeSeq = " + jobTypeSeq);
                }
                task.setNeedFullReindex(this.jobMgr.isFullReindexJob(jobTypeSeq));
                task.setStartTime((Long)map.get("start_time"));
                task.setEndTime((Long)map.get("end_time"));
                task.setReindexingStatus(ReindexingStatus.Failed);
                String statusMessage = (String)map.get("status_message");
                if (log.isDebug3()) {
                    log.debug3("statusMessage = '" + statusMessage + "'");
                }
                task.setE(new Exception(statusMessage));
                tasks.add(task);
                ++taskCount;
            }
        }
        catch (DbException dbe) {
            log.error("jobMgr.getFailedReindexingJobsBefore() threw", (Throwable)dbe);
        }
        catch (Exception e) {
            log.error("getAuName() threw", (Throwable)e);
        }
        return tasks;
    }

    List<PrioritizedAuId> getPendingReindexingAus() {
        return this.getPendingReindexingAus(this.pendingAuListSize);
    }

    private List<PrioritizedAuId> getPendingReindexingAus(int maxAuIds) {
        String DEBUG_HEADER = "getPendingReindexingAus(): ";
        if (log.isDebug2()) {
            log.debug2("getPendingReindexingAus(): maxAuIds = " + maxAuIds);
        }
        ArrayList<PrioritizedAuId> auidsToReindex = new ArrayList<PrioritizedAuId>();
        if (this.pluginMgr != null) {
            try {
                List<Map<String, Object>> notStartedJobs = this.jobMgr.getNotStartedReindexingJobs(maxAuIds);
                if (log.isDebug3()) {
                    log.debug3("getPendingReindexingAus(): notStartedJobs.size() = " + notStartedJobs.size());
                }
                for (Map<String, Object> job : notStartedJobs) {
                    PrioritizedAuId auToReindex = new PrioritizedAuId();
                    String pluginId = (String)job.get("plugin_id");
                    if (log.isDebug3()) {
                        log.debug3("getPendingReindexingAus(): pluginId = " + pluginId);
                    }
                    String auKey = (String)job.get("au_key");
                    if (log.isDebug3()) {
                        log.debug3("getPendingReindexingAus(): auKey = " + auKey);
                    }
                    String auId = PluginManager.generateAuId((String)pluginId, (String)auKey);
                    if (log.isDebug3()) {
                        log.debug3("getPendingReindexingAus(): auId = " + auId);
                    }
                    auToReindex.auId = auId;
                    long priority = (Long)job.get("priority");
                    if (log.isDebug3()) {
                        log.debug3("getPendingReindexingAus(): priority = " + priority);
                    }
                    auToReindex.priority = priority;
                    auToReindex.isNew = false;
                    Long jobTypeSeq = (Long)job.get("job_type_seq");
                    if (log.isDebug3()) {
                        log.debug3("getPendingReindexingAus(): jobTypeSeq = " + jobTypeSeq);
                    }
                    boolean needFullReindex = this.jobMgr.isFullReindexJob(jobTypeSeq);
                    if (log.isDebug3()) {
                        log.debug3("getPendingReindexingAus(): needFullReindex = " + needFullReindex);
                    }
                    auToReindex.needFullReindex = needFullReindex;
                    auidsToReindex.add(auToReindex);
                    if (!log.isDebug3()) continue;
                    log.debug3("getPendingReindexingAus(): Added auId = " + auId + " to reindex list");
                }
            }
            catch (DbException dbe) {
                log.error("Cannot get pending AU ids for reindexing", (Throwable)dbe);
            }
        }
        if (log.isDebug2()) {
            log.debug2("getPendingReindexingAus(): auidsToReindex.size() = " + auidsToReindex.size());
        }
        return auidsToReindex;
    }

    long getArticleCount() {
        return this.metadataArticleCount;
    }

    long getPublisherCount() {
        if (this.metadataPublisherCount < 0L) {
            try {
                this.metadataPublisherCount = this.mdxManagerSql.getPublisherCount();
            }
            catch (DbException ex) {
                log.error("getPublisherCount", (Throwable)ex);
            }
        }
        return this.metadataPublisherCount < 0L ? 0L : this.metadataPublisherCount;
    }

    long getProviderCount() {
        if (this.metadataProviderCount < 0L) {
            try {
                this.metadataProviderCount = this.mdxManagerSql.getProviderCount();
            }
            catch (DbException ex) {
                log.error("getProviderCount", (Throwable)ex);
            }
        }
        return this.metadataProviderCount < 0L ? 0L : this.metadataProviderCount;
    }

    long getPendingAusCount() {
        try {
            return this.jobMgr.getNotStartedReindexingJobsCount();
        }
        catch (DbException dbe) {
            log.error("getPendingAusCount", (Throwable)dbe);
            return 0L;
        }
    }

    void updatePendingAusCount(Connection conn) throws DbException {
        String DEBUG_HEADER = "updatePendingAusCount(): ";
        this.pendingAusCount = this.mdxManagerSql.getEnabledPendingAusCount(conn);
        if (log.isDebug3()) {
            log.debug3("updatePendingAusCount(): pendingAusCount = " + this.pendingAusCount);
        }
    }

    public boolean isIndexingEnabled() {
        return this.reindexingEnabled;
    }

    public void updateAuLastExtractionTime(ArchivalUnit au, Connection conn, Long auMdSeq) throws DbException {
        String DEBUG_HEADER = "updateAuLastExtractionTime(): ";
        long now = TimeBase.nowMs();
        if (log.isDebug3()) {
            log.debug3("updateAuLastExtractionTime(): now = " + now);
        }
        this.mdxManagerSql.updateAuLastExtractionTime(conn, auMdSeq, now);
        this.pendingAusCount = this.mdxManagerSql.getEnabledPendingAusCount(conn);
    }

    boolean enableAndAddAuToReindex(ArchivalUnit au, Connection conn, PreparedStatement insertPendingAuBatchStatement, boolean inBatch) {
        boolean fullReindex = this.isAuMetadataForObsoletePlugin(au);
        return this.enableAndAddAuToReindex(au, conn, insertPendingAuBatchStatement, inBatch, fullReindex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enableAndAddAuToReindex(ArchivalUnit au, Connection conn, PreparedStatement insertPendingAuBatchStatement, boolean inBatch, boolean fullReindex) {
        String DEBUG_HEADER = "enableAndAddAuToReindex(): ";
        Map<String, ReindexingTask> map = this.activeReindexingTasks;
        synchronized (map) {
            try {
                if (this.disableCrawlRescheduleTask && this.activeReindexingTasks.containsKey(au.getAuId())) {
                    log.debug2("enableAndAddAuToReindex(): Not adding AU to reindex: " + au.getName());
                    return false;
                }
                log.debug2("enableAndAddAuToReindex(): Adding AU to reindex: " + au.getName());
                this.removeDisabledFromPendingAus(conn, au.getAuId());
                if (!this.rescheduleAuTask(au.getAuId())) {
                    this.addToPendingAusIfNotThere(conn, Collections.singleton(au), insertPendingAuBatchStatement, inBatch, fullReindex);
                }
                this.startReindexing(conn);
                MetadataDbManager.commitOrRollback((Connection)conn, (Logger)log);
                return true;
            }
            catch (DbException dbe) {
                log.error("Cannot add au to pending AUs: " + au.getName(), (Throwable)dbe);
                return false;
            }
        }
    }

    private void removeDisabledFromPendingAus(Connection conn, String auId) throws DbException {
        this.mdxManagerSql.removeDisabledFromPendingAus(conn, auId);
        this.pendingAusCount = this.mdxManagerSql.getEnabledPendingAusCount(conn);
    }

    private boolean rescheduleAuTask(String auId) {
        String DEBUG_HEADER = "rescheduleAuTask(): ";
        ReindexingTask task = this.activeReindexingTasks.get(auId);
        if (task != null) {
            log.debug2("rescheduleAuTask(): Rescheduling pending reindexing task for auId " + auId);
            task.reschedule();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disableAuIndexing(ArchivalUnit au) throws DbException {
        String DEBUG_HEADER = "disableAuIndexing(): ";
        Map<String, ReindexingTask> map = this.activeReindexingTasks;
        synchronized (map) {
            Connection conn = null;
            try {
                log.debug2("disableAuIndexing(): Disabling indexing for AU " + au.getName());
                conn = this.dbManager.getConnection();
                if (conn == null) {
                    log.error("Cannot disable indexing for AU '" + au.getName() + "' - Cannot connect to database");
                    throw new DbException("Cannot connect to database");
                }
                String auId = au.getAuId();
                log.debug2("disableAuIndexing(): auId " + auId);
                if (this.activeReindexingTasks.containsKey(auId)) {
                    ReindexingTask task = this.activeReindexingTasks.get(auId);
                    task.cancel();
                    this.activeReindexingTasks.remove(auId);
                }
                this.pendingAusCount = this.mdxManagerSql.removeFromPendingAus(conn, auId);
                this.mdxManagerSql.addDisabledAuToPendingAus(conn, auId);
                MetadataDbManager.commitOrRollback((Connection)conn, (Logger)log);
            }
            catch (DbException dbe) {
                try {
                    String errorMessage = "Cannot disable indexing for AU '" + au.getName() + "'";
                    log.error(errorMessage, (Throwable)dbe);
                    throw dbe;
                }
                catch (Throwable throwable) {
                    MetadataDbManager.safeRollbackAndClose(conn);
                    throw throwable;
                }
            }
            MetadataDbManager.safeRollbackAndClose((Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToPendingAusIfNotThere(Connection conn, Collection<ArchivalUnit> aus, boolean fullReindex) throws DbException {
        PreparedStatement insertPendingAuBatchStatement = null;
        try {
            insertPendingAuBatchStatement = this.mdxManagerSql.getInsertPendingAuBatchStatement(conn);
            this.addToPendingAusIfNotThere(conn, aus, insertPendingAuBatchStatement, false, fullReindex);
        }
        catch (Throwable throwable) {
            MetadataDbManager.safeCloseStatement(insertPendingAuBatchStatement);
            throw throwable;
        }
        MetadataDbManager.safeCloseStatement((Statement)insertPendingAuBatchStatement);
    }

    void addToPendingAusIfNotThere(Connection conn, Collection<ArchivalUnit> aus, PreparedStatement insertPendingAuBatchStatement, boolean inBatch, boolean fullReindex) throws DbException {
        String DEBUG_HEADER = "addToPendingAusIfNotThere(): ";
        if (log.isDebug2()) {
            log.debug2("addToPendingAusIfNotThere(): Number of pending aus to add: " + aus.size());
            log.debug2("addToPendingAusIfNotThere(): inBatch = " + inBatch);
            log.debug2("addToPendingAusIfNotThere(): fullReindex = " + fullReindex);
        }
        if (log.isDebug3()) {
            log.debug3("addToPendingAusIfNotThere(): maxPendingAuBatchSize = " + this.maxPendingAuBatchSize);
        }
        try {
            for (ArchivalUnit au : aus) {
                String auKey;
                if (!this.hasArticleMetadata(au)) {
                    log.debug3("addToPendingAusIfNotThere(): Not adding au " + au.getName() + " to pending list because it has no metadata");
                    continue;
                }
                String auid = au.getAuId();
                String pluginKey = PluginManager.pluginKeyFromAuId((String)auid);
                if (!this.mdxManagerSql.isAuPending(conn, pluginKey, auKey = PluginManager.auKeyFromAuId((String)auid))) {
                    log.debug3("addToPendingAusIfNotThere(): Adding au " + au.getName() + " to pending list");
                    this.mdxManagerSql.addAuToPendingAusBatch(pluginKey, auKey, fullReindex, insertPendingAuBatchStatement);
                    ++this.pendingAuBatchCurrentSize;
                    log.debug3("addToPendingAusIfNotThere(): pendingAuBatchCurrentSize = " + this.pendingAuBatchCurrentSize);
                    if (this.pendingAuBatchCurrentSize < this.maxPendingAuBatchSize) continue;
                    this.addAuBatchToPendingAus(insertPendingAuBatchStatement);
                    continue;
                }
                if (fullReindex) {
                    this.mdxManagerSql.updateAuFullReindexing(conn, au, true);
                    continue;
                }
                log.debug3("addToPendingAusIfNotThere(): Not adding au " + au.getName() + " to pending list because it is already on the list");
            }
            if (!inBatch && this.pendingAuBatchCurrentSize > 0) {
                this.addAuBatchToPendingAus(insertPendingAuBatchStatement);
            }
        }
        catch (SQLException sqle) {
            throw new DbException("Cannot add pending AUs", (Throwable)sqle);
        }
        this.pendingAusCount = this.mdxManagerSql.getEnabledPendingAusCount(conn);
    }

    private boolean hasArticleMetadata(ArchivalUnit au) {
        Plugin p;
        if (au.getArticleIterator(MetadataTarget.OpenURL()) == null) {
            return false;
        }
        if (this.useMetadataExtractor && (p = au.getPlugin()).getArticleMetadataExtractor(MetadataTarget.OpenURL(), au) != null) {
            return true;
        }
        return au.getTdbAu() != null;
    }

    private void addAuBatchToPendingAus(PreparedStatement insertPendingAuBatchStatement) throws SQLException {
        String DEBUG_HEADER = "addAuBatchToPendingAus(): ";
        this.mdxManagerSql.addAuBatchToPendingAus(insertPendingAuBatchStatement);
        this.pendingAuBatchCurrentSize = 0;
        if (log.isDebug3()) {
            log.debug3("addAuBatchToPendingAus(): pendingAuBatchCurrentSize = " + this.pendingAuBatchCurrentSize);
        }
    }

    protected void notifyStartReindexingAu(ArchivalUnit au) {
        String DEBUG_HEADER = "notifyStartReindexingAu(): ";
        if (log.isDebug2()) {
            log.debug2("notifyStartReindexingAu(): au = " + au);
        }
        this.jobMgr.handlePutAuJobStartEvent(au.getAuId());
        if (log.isDebug2()) {
            log.debug2("notifyStartReindexingAu(): Done");
        }
    }

    protected void notifyFinishReindexingAu(ArchivalUnit au, ReindexingStatus status, Exception exception) {
        String DEBUG_HEADER = "notifyFinishReindexingAu(): ";
        if (log.isDebug2()) {
            log.debug2("notifyFinishReindexingAu(): au = " + au);
            log.debug2("notifyFinishReindexingAu(): status = " + status);
            log.debug2("notifyFinishReindexingAu(): exception = " + exception);
        }
        this.jobMgr.handlePutAuJobFinishEvent(au.getAuId(), status, exception);
        if (log.isDebug2()) {
            log.debug2("notifyFinishReindexingAu(): Done");
        }
    }

    protected void notifyStartAuMetadataRemoval(ArchivalUnit au) {
        String DEBUG_HEADER = "notifyStartAuMetadataRemoval(): ";
        if (log.isDebug2()) {
            log.debug2("notifyStartAuMetadataRemoval(): au = " + au);
        }
        this.jobMgr.handleDeleteAuJobStartEvent(au.getAuId());
        if (log.isDebug2()) {
            log.debug2("notifyStartAuMetadataRemoval(): Done");
        }
    }

    protected void notifyFinishAuMetadataRemoval(ArchivalUnit au, ReindexingStatus status, Exception exception) {
        String DEBUG_HEADER = "notifyFinishAuMetadataRemoval(): ";
        if (log.isDebug2()) {
            log.debug2("notifyFinishAuMetadataRemoval(): au = " + au);
            log.debug2("notifyFinishAuMetadataRemoval(): status = " + status);
            log.debug2("notifyFinishAuMetadataRemoval(): exception = " + exception);
        }
        this.jobMgr.handleDeleteAuJobFinishEvent(au.getAuId(), status, exception);
        if (log.isDebug2()) {
            log.debug2("notifyFinishAuMetadataRemoval(): Done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean deleteAuAndReindex(ArchivalUnit au) {
        String DEBUG_HEADER = "deleteAuAndReindex(): ";
        Map<String, ReindexingTask> map = this.activeReindexingTasks;
        synchronized (map) {
            boolean bl;
            Connection conn;
            block7: {
                conn = null;
                log.debug2("deleteAuAndReindex(): Removing au to reindex: " + au.getName());
                conn = this.dbManager.getConnection();
                if (conn != null) break block7;
                log.error("Cannot connect to database -- cannot add aus to pending aus");
                boolean bl2 = false;
                MetadataDbManager.safeRollbackAndClose((Connection)conn);
                return bl2;
            }
            try {
                this.deleteAu(conn, au.getAuId());
                this.startReindexing(conn);
                MetadataDbManager.commitOrRollback((Connection)conn, (Logger)log);
                bl = true;
            }
            catch (DbException dbe) {
                boolean bl2;
                try {
                    log.error("Cannot remove au: " + au.getName(), (Throwable)dbe);
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    MetadataDbManager.safeRollbackAndClose(conn);
                    throw throwable;
                }
                MetadataDbManager.safeRollbackAndClose((Connection)conn);
                return bl2;
            }
            MetadataDbManager.safeRollbackAndClose((Connection)conn);
            return bl;
        }
    }

    public int getPluginMetadataVersionNumber(Plugin plugin) {
        String DEBUG_HEADER = "getPluginMetadataVersionNumber(): ";
        int version = 1;
        String pluginVersion = plugin.getFeatureVersion(Plugin.Feature.Metadata);
        if (log.isDebug3()) {
            log.debug3("getPluginMetadataVersionNumber(): Metadata Feature version: " + pluginVersion + " for " + plugin.getPluginName());
        }
        if (StringUtil.isNullString((String)pluginVersion)) {
            log.debug2("Plugin version not found: Using " + version);
            return version;
        }
        String prefix = Plugin.Feature.Metadata + "_";
        if (!pluginVersion.startsWith(prefix)) {
            log.error("Plugin version '" + pluginVersion + "' does not start with '" + prefix + "': Using " + version);
            return version;
        }
        try {
            version = Integer.valueOf(pluginVersion.substring(prefix.length()));
        }
        catch (NumberFormatException nfe) {
            log.error("Plugin version '" + pluginVersion + "' does not end with a number after '" + prefix + "': Using " + version);
        }
        log.debug3("getPluginMetadataVersionNumber(): version = " + version);
        return version;
    }

    void addToSuccessfulReindexingTasks() {
        this.successfulReindexingCount = this.getSuccessfulReindexingCount() + 1L;
    }

    synchronized void addToMetadataArticleCount(long count) {
        this.metadataArticleCount += count;
        this.mdManager.resetPublicationCount();
        this.metadataPublisherCount = -1L;
        this.metadataProviderCount = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToFailedReindexingTasks(ReindexingTask task) {
        this.failedReindexingCount = this.getFailedReindexingCount() + 1L;
        String taskAuId = task.getAuId();
        List<ReindexingTask> list = this.failedReindexingTasks;
        synchronized (list) {
            this.removeFromFailedIndexingTasks(taskAuId);
            this.failedReindexingTasks.add(0, task);
            this.setMaxHistory(this.maxReindexingTaskHistory);
        }
    }

    boolean isAuMetadataForObsoletePlugin(ArchivalUnit au) {
        String DEBUG_HEADER = "isAuMetadataForObsoletePlugin(): ";
        int auVersion = this.mdxManagerSql.getAuMetadataVersion(au);
        log.debug("isAuMetadataForObsoletePlugin(): auVersion = " + auVersion);
        int pVersion = this.getPluginMetadataVersionNumber(au.getPlugin());
        log.debug("isAuMetadataForObsoletePlugin(): pVersion = " + pVersion);
        return pVersion > auVersion;
    }

    boolean isAuMetadataForObsoletePlugin(Connection conn, ArchivalUnit au) throws DbException {
        String DEBUG_HEADER = "isAuMetadataForObsoletePlugin(): ";
        int auVersion = this.mdxManagerSql.getAuMetadataVersion(conn, au);
        log.debug2("isAuMetadataForObsoletePlugin(): auVersion = " + auVersion);
        int pVersion = this.getPluginMetadataVersionNumber(au.getPlugin());
        log.debug2("isAuMetadataForObsoletePlugin(): pVersion = " + pVersion);
        return pVersion > auVersion;
    }

    boolean isAuCrawledAndNotExtracted(Connection conn, ArchivalUnit au) throws DbException {
        String DEBUG_HEADER = "isAuCrawledAndNotExtracted(): ";
        long lastCrawlTime = AuUtil.getAuState((ArchivalUnit)au).getLastCrawlTime();
        log.debug2("isAuCrawledAndNotExtracted(): lastCrawlTime = " + lastCrawlTime);
        long lastExtractionTime = this.mdxManagerSql.getAuExtractionTime(conn, au);
        log.debug2("isAuCrawledAndNotExtracted(): lastExtractionTime = " + lastExtractionTime);
        return lastCrawlTime > lastExtractionTime;
    }

    MetadataManager getMetadataManager() {
        return this.mdManager;
    }

    PreparedStatement getInsertPendingAuBatchStatement(Connection conn) throws DbException {
        return this.mdxManagerSql.getInsertPendingAuBatchStatement(conn);
    }

    PreparedStatement getPrioritizedInsertPendingAuBatchStatement(Connection conn) throws DbException {
        return this.mdxManagerSql.getPrioritizedInsertPendingAuBatchStatement(conn);
    }

    Collection<String> findDisabledPendingAus() throws DbException {
        Connection conn = null;
        try {
            conn = this.dbManager.getConnection();
            Collection<String> collection = this.findDisabledPendingAus(conn);
            return collection;
        }
        finally {
            MetadataDbManager.safeRollbackAndClose((Connection)conn);
        }
    }

    Collection<String> findDisabledPendingAus(Connection conn) throws DbException {
        return this.mdxManagerSql.findPendingAusWithPriority(conn, -10000);
    }

    Collection<String> findFailedIndexingPendingAus() throws DbException {
        Connection conn = null;
        try {
            conn = this.dbManager.getConnection();
            Collection<String> collection = this.findFailedIndexingPendingAus(conn);
            return collection;
        }
        finally {
            MetadataDbManager.safeRollbackAndClose((Connection)conn);
        }
    }

    Collection<String> findFailedIndexingPendingAus(Connection conn) throws DbException {
        return this.mdxManagerSql.findPendingAusWithPriority(conn, -1000);
    }

    public Long findAuPublisher(Connection conn, Long auSeq) throws DbException {
        return this.mdxManagerSql.findAuPublisher(conn, auSeq);
    }

    private void addNewMdItemUrls(Connection conn, Long mdItemSeq, Map<String, String> featuredUrlMap) throws DbException {
        String DEBUG_HEADER = "addNewMdItemUrls(): ";
        HashMap<String, String> newUrls = new HashMap<String, String>(featuredUrlMap);
        Map oldUrls = this.dbManager.getMdItemUrls(conn, mdItemSeq);
        for (String feature : oldUrls.keySet()) {
            String url = (String)oldUrls.get(feature);
            log.debug3("addNewMdItemUrls(): Found feature = " + feature + ", URL = " + url);
            if (!newUrls.containsKey(feature) || !((String)newUrls.get(feature)).equals(url)) continue;
            log.debug3("addNewMdItemUrls(): Feature = " + feature + ", URL = " + url + " already exists: Not adding it.");
            newUrls.remove(feature);
        }
        this.addMdItemUrls(conn, mdItemSeq, null, newUrls);
    }

    private void addNewMdItemAuthors(Connection conn, Long mdItemSeq, Collection<String> authors) throws DbException {
        if (authors == null || authors.size() == 0) {
            return;
        }
        ArrayList<String> newAuthors = new ArrayList<String>(authors);
        Collection<String> oldAuthors = this.mdxManagerSql.getMdItemAuthors(conn, mdItemSeq);
        newAuthors.removeAll(oldAuthors);
        this.mdxManagerSql.addMdItemAuthors(conn, mdItemSeq, newAuthors);
    }

    private void addNewMdItemKeywords(Connection conn, Long mdItemSeq, Collection<String> keywords) throws DbException {
        if (keywords == null || keywords.size() == 0) {
            return;
        }
        ArrayList<String> newKeywords = new ArrayList<String>(keywords);
        Collection<String> oldKeywords = this.mdxManagerSql.getMdItemKeywords(conn, mdItemSeq);
        newKeywords.removeAll(oldKeywords);
        this.mdxManagerSql.addMdItemKeywords(conn, mdItemSeq, newKeywords);
    }

    void addMdItemUrls(Connection conn, Long mdItemSeq, String accessUrl, Map<String, String> featuredUrlMap) throws DbException {
        String DEBUG_HEADER = "addMdItemUrls(): ";
        if (!StringUtil.isNullString((String)accessUrl)) {
            this.mdManager.addMdItemUrl(conn, mdItemSeq, "Access", accessUrl);
            log.debug3("addMdItemUrls(): Added feature = Access, URL = " + accessUrl);
        }
        for (String feature : featuredUrlMap.keySet()) {
            this.mdManager.addMdItemUrl(conn, mdItemSeq, feature, featuredUrlMap.get(feature));
            log.debug3("addMdItemUrls(): Added feature = " + feature + ", URL = " + featuredUrlMap.get(feature));
        }
    }

    public void mergeChildMdItemProperties(Connection conn, Long sourceMdItemSeq, Long targetMdItemSeq) throws DbException {
        String DEBUG_HEADER = "mergeChildMdItemProperties(): ";
        log.debug3("mergeChildMdItemProperties(): sourceMdItemSeq = " + sourceMdItemSeq);
        log.debug3("mergeChildMdItemProperties(): targetMdItemSeq = " + targetMdItemSeq);
        if (!sourceMdItemSeq.equals(targetMdItemSeq)) {
            this.mergeMdItemNames(conn, sourceMdItemSeq, targetMdItemSeq);
            this.mergeMdItemAuthors(conn, sourceMdItemSeq, targetMdItemSeq);
            this.mergeMdItemKeywords(conn, sourceMdItemSeq, targetMdItemSeq);
            this.mergeMdItemUrls(conn, sourceMdItemSeq, targetMdItemSeq);
        }
        log.debug3("mergeChildMdItemProperties(): Done.");
    }

    private void mergeMdItemNames(Connection conn, Long sourceMdItemSeq, Long targetMdItemSeq) throws DbException {
        String DEBUG_HEADER = "mergeMdItemNames(): ";
        log.debug3("mergeMdItemNames(): sourceMdItemSeq = " + sourceMdItemSeq);
        log.debug3("mergeMdItemNames(): targetMdItemSeq = " + targetMdItemSeq);
        Map sourceMdItemNames = this.mdManager.getMdItemNames(conn, sourceMdItemSeq);
        for (String mdItemName : sourceMdItemNames.keySet()) {
            this.mdManager.addNewMdItemName(conn, targetMdItemSeq, mdItemName);
        }
        log.debug3("mergeMdItemNames(): Done.");
    }

    private void mergeMdItemAuthors(Connection conn, Long sourceMdItemSeq, Long targetMdItemSeq) throws DbException {
        String DEBUG_HEADER = "mergeMdItemAuthors(): ";
        log.debug3("mergeMdItemAuthors(): sourceMdItemSeq = " + sourceMdItemSeq);
        log.debug3("mergeMdItemAuthors(): targetMdItemSeq = " + targetMdItemSeq);
        Collection<String> sourceMdItemAuthors = this.mdxManagerSql.getMdItemAuthors(conn, sourceMdItemSeq);
        this.addNewMdItemAuthors(conn, targetMdItemSeq, sourceMdItemAuthors);
        log.debug3("mergeMdItemAuthors(): Done.");
    }

    private void mergeMdItemKeywords(Connection conn, Long sourceMdItemSeq, Long targetMdItemSeq) throws DbException {
        String DEBUG_HEADER = "mergeMdItemKeywords(): ";
        log.debug3("mergeMdItemKeywords(): sourceMdItemSeq = " + sourceMdItemSeq);
        log.debug3("mergeMdItemKeywords(): targetMdItemSeq = " + targetMdItemSeq);
        Collection<String> sourceMdItemKeywords = this.mdxManagerSql.getMdItemKeywords(conn, sourceMdItemSeq);
        this.addNewMdItemKeywords(conn, targetMdItemSeq, sourceMdItemKeywords);
        log.debug3("mergeMdItemKeywords(): Done.");
    }

    private void mergeMdItemUrls(Connection conn, Long sourceMdItemSeq, Long targetMdItemSeq) throws DbException {
        String DEBUG_HEADER = "mergeMdItemUrls(): ";
        log.debug3("mergeMdItemUrls(): sourceMdItemSeq = " + sourceMdItemSeq);
        log.debug3("mergeMdItemUrls(): targetMdItemSeq = " + targetMdItemSeq);
        Map sourceMdItemUrls = this.dbManager.getMdItemUrls(conn, sourceMdItemSeq);
        this.addNewMdItemUrls(conn, targetMdItemSeq, sourceMdItemUrls);
        log.debug3("mergeMdItemUrls(): Done.");
    }

    public void mergeParentMdItemProperties(Connection conn, Long sourceMdItemSeq, Long targetMdItemSeq) throws DbException {
        String DEBUG_HEADER = "mergeParentMdItemProperties(): ";
        log.debug3("mergeParentMdItemProperties(): sourceMdItemSeq = " + sourceMdItemSeq);
        log.debug3("mergeParentMdItemProperties(): targetMdItemSeq = " + targetMdItemSeq);
        if (!sourceMdItemSeq.equals(targetMdItemSeq)) {
            this.mergeMdItemNames(conn, sourceMdItemSeq, targetMdItemSeq);
            this.mergeMdItemIsbns(conn, sourceMdItemSeq, targetMdItemSeq);
            this.mergeMdItemIssns(conn, sourceMdItemSeq, targetMdItemSeq);
            this.mergeMdItemProprietaryIds(conn, sourceMdItemSeq, targetMdItemSeq);
        }
        log.debug3("mergeParentMdItemProperties(): Done.");
    }

    private void mergeMdItemIsbns(Connection conn, Long sourceMdItemSeq, Long targetMdItemSeq) throws DbException {
        String DEBUG_HEADER = "mergeMdItemIsbns(): ";
        if (log.isDebug2()) {
            log.debug2("mergeMdItemIsbns(): sourceMdItemSeq = " + sourceMdItemSeq);
            log.debug2("mergeMdItemIsbns(): targetMdItemSeq = " + targetMdItemSeq);
        }
        Set sourceMdItemIsbns = this.mdManager.getMdItemIsbns(conn, sourceMdItemSeq);
        for (Isbn isbn : sourceMdItemIsbns) {
            String isbnValue = isbn.getValue();
            if (log.isDebug3()) {
                log.debug3("mergeMdItemIsbns(): isbnValue = " + isbnValue);
            }
            String isbnType = isbn.getType();
            if (log.isDebug3()) {
                log.debug3("mergeMdItemIsbns(): isbnType = " + isbnType);
            }
            if ("p_isbn".equals(isbnType)) {
                this.mdManager.addNewMdItemIsbns(conn, targetMdItemSeq, isbnValue, null);
                continue;
            }
            if (!"e_isbn".equals(isbnType)) continue;
            this.mdManager.addNewMdItemIsbns(conn, targetMdItemSeq, null, isbnValue);
        }
        if (log.isDebug2()) {
            log.debug2("mergeMdItemIsbns(): Done.");
        }
    }

    private void mergeMdItemIssns(Connection conn, Long sourceMdItemSeq, Long targetMdItemSeq) throws DbException {
        String DEBUG_HEADER = "mergeMdItemIssns(): ";
        if (log.isDebug2()) {
            log.debug2("mergeMdItemIssns(): sourceMdItemSeq = " + sourceMdItemSeq);
            log.debug2("mergeMdItemIssns(): targetMdItemSeq = " + targetMdItemSeq);
        }
        Set sourceMdItemIssns = this.mdManager.getMdItemIssns(conn, sourceMdItemSeq);
        for (Issn issn : sourceMdItemIssns) {
            String issnValue = issn.getValue();
            if (log.isDebug3()) {
                log.debug3("mergeMdItemIssns(): issnValue = " + issnValue);
            }
            String issnType = issn.getType();
            if (log.isDebug3()) {
                log.debug3("mergeMdItemIssns(): issnType = " + issnType);
            }
            if ("p_issn".equals(issnType)) {
                this.mdManager.addNewMdItemIssns(conn, targetMdItemSeq, issnValue, null);
                continue;
            }
            if (!"e_issn".equals(issnType)) continue;
            this.mdManager.addNewMdItemIssns(conn, targetMdItemSeq, null, issnValue);
        }
        if (log.isDebug2()) {
            log.debug2("mergeMdItemIssns(): Done.");
        }
    }

    private void mergeMdItemProprietaryIds(Connection conn, Long sourceMdItemSeq, Long targetMdItemSeq) throws DbException {
        String DEBUG_HEADER = "mergeMdItemProprietaryIds(): ";
        log.debug3("mergeMdItemProprietaryIds(): sourceMdItemSeq = " + sourceMdItemSeq);
        log.debug3("mergeMdItemProprietaryIds(): targetMdItemSeq = " + targetMdItemSeq);
        Collection sourceMdItemProprietaryIds = this.mdManager.getMdItemProprietaryIds(conn, sourceMdItemSeq);
        this.mdManager.addNewMdItemProprietaryIds(conn, targetMdItemSeq, sourceMdItemProprietaryIds);
        log.debug3("mergeMdItemProprietaryIds(): Done.");
    }

    void persistUnconfiguredAu(ArchivalUnit au) {
        this.persistUnconfiguredAu(au.getAuId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistUnconfiguredAu(String auId) {
        String DEBUG_HEADER = "persistUnconfiguredAu(): ";
        if (log.isDebug2()) {
            log.debug2("persistUnconfiguredAu(): auId = " + auId);
        }
        Connection conn = null;
        try {
            conn = this.dbManager.getConnection();
            if (conn == null) {
                log.error("Cannot connect to database - Cannot insert archival unit " + auId + " in unconfigured table");
                return;
            }
            if (log.isDebug3()) {
                log.debug3("persistUnconfiguredAu(): auId = " + auId);
            }
            if (!this.mdManager.isAuInUnconfiguredAuTable(conn, auId)) {
                this.mdManager.persistUnconfiguredAu(conn, auId);
                MetadataDbManager.commitOrRollback((Connection)conn, (Logger)log);
            }
        }
        catch (DbException dbe) {
            log.error("Cannot insert archival unit in unconfigured table", (Throwable)dbe);
            log.error("auId = " + auId);
        }
        finally {
            MetadataDbManager.safeRollbackAndClose((Connection)conn);
        }
    }

    public MetadataExtractorManagerSql getMetadataExtractorManagerSql() {
        return this.mdxManagerSql;
    }

    boolean isPrioritizeIndexingNewAus() {
        return this.prioritizeIndexingNewAus;
    }

    private Long findAuSeq(Connection conn, String auId) throws DbException {
        String DEBUG_HEADER = "findAuSeq(): ";
        if (log.isDebug2()) {
            log.debug2("findAuSeq(): auId = " + auId);
        }
        Long auSeq = null;
        Long pluginSeq = this.mdManager.findPlugin(conn, PluginManager.pluginKeyFromAuId((String)auId));
        if (pluginSeq != null) {
            String auKey = PluginManager.auKeyFromAuId((String)auId);
            auSeq = this.mdManager.findAu(conn, pluginSeq, auKey);
        }
        if (log.isDebug2()) {
            log.debug2("findAuSeq(): auSeq = " + auSeq);
        }
        return auSeq;
    }

    void enableAuIndexing(ArchivalUnit au) throws DbException {
        String DEBUG_HEADER = "disableAuIndexing(): ";
        Connection conn = null;
        try {
            log.debug2("disableAuIndexing(): Enabling indexing for AU " + au.getName());
            conn = this.dbManager.getConnection();
            if (conn == null) {
                log.error("Cannot enable indexing for AU '" + au.getName() + "' - Cannot connect to database");
                throw new DbException("Cannot connect to database");
            }
            String auId = au.getAuId();
            log.debug2("disableAuIndexing(): auId " + auId);
            this.removeDisabledFromPendingAus(conn, auId);
            MetadataDbManager.commitOrRollback((Connection)conn, (Logger)log);
        }
        catch (DbException dbe) {
            try {
                String errorMessage = "Cannot enable indexing for AU '" + au.getName() + "'";
                log.error(errorMessage, (Throwable)dbe);
                throw dbe;
            }
            catch (Throwable throwable) {
                MetadataDbManager.safeRollbackAndClose(conn);
                throw throwable;
            }
        }
        MetadataDbManager.safeRollbackAndClose((Connection)conn);
    }

    public List<String> getMandatoryMetadataFields() {
        return this.mandatoryMetadataFields;
    }

    boolean isOnDemandMetadataExtractionOnly() {
        return this.onDemandMetadataExtractionOnly;
    }

    public ReindexingTask onDemandStartReindexing(String auId, boolean needFullReindex) {
        String DEBUG_HEADER = "onDemandStartReindexing(): ";
        if (log.isDebug2()) {
            log.debug2("onDemandStartReindexing(): auId = " + auId);
        }
        ArchivalUnit au = this.pluginMgr.getAuFromId(auId);
        if (log.isDebug3()) {
            log.debug3("au = " + au);
        }
        if (au == null) {
            String message = "Cannot find Archival Unit for auId '" + auId + "'";
            log.error(message);
            throw new IllegalArgumentException(message);
        }
        if (log.isDebug3()) {
            log.debug3("onDemandStartReindexing(): Creating the reindexing task for AU: " + au.getName());
        }
        ReindexingTask task = new ReindexingTask(au, this.getMetadataExtractor(au));
        task.setNewAu(false);
        task.setFullReindex(needFullReindex);
        this.activeReindexingTasks.put(au.getAuId(), task);
        this.addToIndexingTaskHistory(task);
        log.debug("onDemandStartReindexing(): Running the reindexing task for AU: " + au.getName());
        this.runReindexingTask(task);
        return task;
    }

    public DeleteMetadataTask startMetadataRemoval(String auId) {
        String DEBUG_HEADER = "startMetadataRemoval(): ";
        if (log.isDebug2()) {
            log.debug2("auId = " + auId);
        }
        ArchivalUnit au = this.pluginMgr.getAuFromId(auId);
        if (log.isDebug3()) {
            log.debug3("au = " + au);
        }
        if (au == null) {
            String message = "Cannot find Archival Unit for auId '" + auId + "'";
            log.error(message);
            throw new IllegalArgumentException(message);
        }
        if (log.isDebug3()) {
            log.debug3("startMetadataRemoval(): Creating the metadata removal task for AU: " + au.getName());
        }
        DeleteMetadataTask task = new DeleteMetadataTask(au);
        log.debug("startMetadataRemoval(): Running the metadata removal task for AU: " + au.getName());
        this.runMetadataRemovalTask(task);
        return task;
    }

    private void runMetadataRemovalTask(final DeleteMetadataTask task) {
        LockssRunnable runnable = new LockssRunnable(AuUtil.getThreadNameFor((String)"Removing_Metadata", (ArchivalUnit)task.getAu())){

            public void lockssRun() {
                this.startWDog(MetadataExtractorManager.WDOG_PARAM_INDEXER, 21600000L);
                task.setWDog((LockssWatchdog)this);
                task.handleEvent(Schedule.EventType.START);
                while (!task.isFinished()) {
                    task.step(Integer.MAX_VALUE);
                }
                task.handleEvent(Schedule.EventType.FINISH);
                this.stopWDog();
            }
        };
        Thread runThread = new Thread((Runnable)runnable);
        runThread.start();
    }

    public Long storeAuItemMetadata(ItemMetadata item) throws Exception {
        String DEBUG_HEADER = "storeAuItemMetadata(): ";
        if (log.isDebug2()) {
            log.debug2("storeAuItemMetadata(): item = " + item);
        }
        String auId = (String)item.getScalarMap().get("au_id");
        if (log.isDebug3()) {
            log.debug2("storeAuItemMetadata(): auId = " + auId);
        }
        return this.storeAuItemMetadata(item, null, this.pluginMgr.getPluginFromAuId(auId), auId, 0L);
    }

    public Long storeAuItemMetadata(ItemMetadata item, ArchivalUnit au, Plugin plugin, String auId, long creationTime) throws Exception {
        String DEBUG_HEADER = "storeAuItemMetadata(): ";
        if (log.isDebug2()) {
            log.debug2("storeAuItemMetadata(): item = " + item);
            log.debug2("storeAuItemMetadata(): auId = " + auId);
        }
        Long mdItemSeq = null;
        Connection conn = null;
        ArticleMetadataBuffer articleMetadataInfoBuffer = null;
        try {
            articleMetadataInfoBuffer = new ArticleMetadataBuffer(new File(PlatformUtil.getSystemTempDir()));
            ArticleMetadata md = this.populateArticleMetadata(item);
            if (log.isDebug3()) {
                log.debug3("storeAuItemMetadata(): md = " + md);
            }
            articleMetadataInfoBuffer.add(md);
            Iterator<ArticleMetadataBuffer.ArticleMetadataInfo> mditr = articleMetadataInfoBuffer.iterator();
            conn = this.dbManager.getConnection();
            List<String> mandatoryFields = this.getMandatoryMetadataFields();
            if (log.isDebug3()) {
                log.debug3("storeAuItemMetadata(): mandatoryFields = " + mandatoryFields);
            }
            mdItemSeq = new AuMetadataRecorder(null, (MetadataQueryManager)((Object)LockssApp.getManagerByTypeStatic(MetadataQueryManager.class)), this, au, plugin, auId).recordMetadataItem(conn, mandatoryFields, mditr, creationTime);
            MetadataDbManager.commitOrRollback((Connection)conn, (Logger)log);
        }
        catch (Exception e) {
            try {
                log.error("Error storing AU item metadata", (Throwable)e);
                log.error("item = " + item);
                throw e;
            }
            catch (Throwable throwable) {
                MetadataDbManager.safeRollbackAndClose(conn);
                articleMetadataInfoBuffer.close();
                throw throwable;
            }
        }
        MetadataDbManager.safeRollbackAndClose((Connection)conn);
        articleMetadataInfoBuffer.close();
        if (log.isDebug2()) {
            log.debug2("storeAuItemMetadata(): mdItemSeq = " + mdItemSeq);
        }
        return mdItemSeq;
    }

    private ArticleMetadata populateArticleMetadata(ItemMetadata item) {
        Set keywords;
        Map issnMap;
        HashMap mapMap;
        HashMap listMap;
        HashMap setMap;
        HashMap scalarMap = item.getScalarMap();
        if (scalarMap == null) {
            scalarMap = new HashMap();
        }
        if ((setMap = item.getSetMap()) == null) {
            setMap = new HashMap();
        }
        if ((listMap = item.getListMap()) == null) {
            listMap = new HashMap();
        }
        if ((mapMap = item.getMapMap()) == null) {
            mapMap = new HashMap();
        }
        ArticleMetadata am = new ArticleMetadata();
        am.put(MetadataField.FIELD_PUBLISHER, (String)scalarMap.get("publisher_name"));
        am.put(MetadataField.FIELD_PROVIDER, (String)scalarMap.get("provider_name"));
        am.put(MetadataField.FIELD_SERIES_TITLE, (String)scalarMap.get("series_title_name"));
        am.put(MetadataField.FIELD_PROPRIETARY_SERIES_IDENTIFIER, (String)scalarMap.get("proprietary_series_identifier"));
        am.put(MetadataField.FIELD_PUBLICATION_TITLE, (String)scalarMap.get("publication_name"));
        Map isbnMap = (Map)mapMap.get("isbn");
        if (isbnMap != null && isbnMap.size() > 0) {
            am.put(MetadataField.FIELD_ISBN, (String)isbnMap.get("p_isbn"));
            am.put(MetadataField.FIELD_EISBN, (String)isbnMap.get("e_isbn"));
        }
        if ((issnMap = (Map)mapMap.get("issn")) != null && issnMap.size() > 0) {
            am.put(MetadataField.FIELD_ISSN, (String)issnMap.get("p_issn"));
            am.put(MetadataField.FIELD_EISSN, (String)issnMap.get("e_issn"));
        }
        am.put(MetadataField.FIELD_VOLUME, (String)scalarMap.get("volume"));
        am.put(MetadataField.FIELD_ISSUE, (String)scalarMap.get("issue"));
        am.put(MetadataField.FIELD_START_PAGE, (String)scalarMap.get("start_page"));
        am.put(MetadataField.FIELD_END_PAGE, (String)scalarMap.get("end_page"));
        am.put(MetadataField.FIELD_DATE, (String)scalarMap.get("date"));
        am.put(MetadataField.FIELD_ARTICLE_TITLE, (String)scalarMap.get("item_title"));
        List authors = (List)listMap.get("author_name");
        if (authors != null) {
            for (String author : authors) {
                am.put(MetadataField.FIELD_AUTHOR, author);
            }
        }
        am.put(MetadataField.FIELD_DOI, (String)scalarMap.get("doi"));
        Map urlMap = (Map)mapMap.get("url");
        if (urlMap != null && urlMap.size() > 0) {
            am.put(MetadataField.FIELD_ACCESS_URL, (String)urlMap.get("Access"));
            am.putRaw(MetadataField.FIELD_FEATURED_URL_MAP.getKey(), urlMap);
        }
        if ((keywords = (Set)setMap.get("keyword")) != null) {
            for (String keyword : keywords) {
                am.put(MetadataField.FIELD_KEYWORDS, keyword);
            }
        }
        am.put(MetadataField.FIELD_COVERAGE, (String)scalarMap.get("coverage"));
        am.put(MetadataField.FIELD_ITEM_NUMBER, (String)scalarMap.get("item_no"));
        Set pis = (Set)setMap.get("proprietary_id");
        if (pis != null && pis.size() > 0) {
            am.put(MetadataField.FIELD_PROPRIETARY_IDENTIFIER, (String)pis.iterator().next());
        }
        am.put(MetadataField.FIELD_FETCH_TIME, (String)scalarMap.get("fetch_time"));
        return am;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteAu(String auId) throws DbException {
        String DEBUG_HEADER = "deleteAu(): ";
        if (log.isDebug2()) {
            log.debug2("deleteAu(): auid = " + auId);
        }
        Connection conn = null;
        int itemCount = 0;
        try {
            conn = this.dbManager.getConnection();
            if (conn == null) {
                String message = "Cannot delete Archival Unit for auid '" + auId + "' - Cannot connect to database";
                log.error(message);
                throw new DbException(message);
            }
            Long auSeq = this.mdxManagerSql.findAuByAuId(conn, auId);
            if (log.isDebug3()) {
                log.debug3("deleteAu(): auSeq = " + auSeq);
            }
            if (auSeq == null) {
                throw new IllegalArgumentException("AuId not found in DB: " + auId);
            }
            itemCount = this.deleteAu(conn, auId);
            if (log.isDebug3()) {
                log.debug3("deleteAu(): itemCount = " + itemCount);
            }
            DbManager.commitOrRollback((Connection)conn, (Logger)log);
        }
        finally {
            DbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("deleteAu(): itemCount = " + itemCount);
        }
        return itemCount;
    }

    private String getAuName(String auId) throws IllegalArgumentException, Exception {
        String DEBUG_HEADER = "getAuName(): ";
        if (log.isDebug2()) {
            log.debug2("getAuName(): auId = " + auId);
        }
        String message = "Cannot find Archival Unit for auId '" + auId + "'";
        try {
            ArchivalUnit au = this.pluginMgr.getAuFromId(auId);
            if (log.isDebug3()) {
                log.debug3("getAuName(): au = " + au);
            }
            if (au != null) {
                String auName = au.getName();
                if (log.isDebug2()) {
                    log.debug2("getAuName(): auName = " + auName);
                }
                return auName;
            }
        }
        catch (IllegalArgumentException iae) {
            log.error(message, (Throwable)iae);
            throw iae;
        }
        catch (Exception e) {
            log.error(message, (Throwable)e);
            throw e;
        }
        log.error(message);
        throw new IllegalArgumentException(message);
    }

    public void scheduleMetadataExtraction(ArchivalUnit au, String auId) throws Exception {
        String DEBUG_HEADER = "scheduleMetadataExtraction(): ";
        if (log.isDebug2()) {
            log.debug2("scheduleMetadataExtraction(): au = " + au);
            log.debug2("scheduleMetadataExtraction(): auId = " + auId);
        }
        try {
            boolean fullReindex = true;
            if (au != null) {
                fullReindex = this.isAuMetadataForObsoletePlugin(au);
                if (log.isDebug3()) {
                    log.debug3("fullReindex = " + fullReindex);
                }
            }
            JobAuStatus jobAuStatus = this.jobMgr.scheduleMetadataExtraction(auId, fullReindex);
            log.info("Scheduled metadata extraction job: " + jobAuStatus);
        }
        catch (Exception e) {
            log.error("Cannot reindex metadata for " + auId, (Throwable)e);
            throw e;
        }
    }

    public static class PrioritizedAuId {
        public String auId;
        long priority;
        boolean isNew;
        boolean needFullReindex;
    }

    public static enum ReindexingStatus {
        Running,
        Success,
        Failed,
        Rescheduled;

    }
}

