/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.metadata.extractor.job;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.lockss.app.BaseLockssDaemonManager;
import org.lockss.app.ConfigurableManager;
import org.lockss.app.LockssApp;
import org.lockss.config.Configuration;
import org.lockss.db.DbException;
import org.lockss.metadata.extractor.DeleteMetadataTask;
import org.lockss.metadata.extractor.MetadataExtractorManager;
import org.lockss.metadata.extractor.ReindexingTask;
import org.lockss.metadata.extractor.job.Job;
import org.lockss.metadata.extractor.job.JobAuStatus;
import org.lockss.metadata.extractor.job.JobContinuationToken;
import org.lockss.metadata.extractor.job.JobDbManager;
import org.lockss.metadata.extractor.job.JobManagerSql;
import org.lockss.metadata.extractor.job.JobPage;
import org.lockss.metadata.extractor.job.JobTask;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.plugin.PluginManager;
import org.lockss.scheduler.StepTask;
import org.lockss.util.Logger;

public class JobManager
extends BaseLockssDaemonManager
implements ConfigurableManager {
    private static final Logger log = Logger.getLogger(JobManager.class);
    public static final String PREFIX = "org.lockss.jobManager.";
    public static final String PARAM_JOBMANAGER_ENABLED = "org.lockss.jobManager.enabled";
    public static final boolean DEFAULT_JOBMANAGER_ENABLED = false;
    public static final String PARAM_TASK_LIST_SIZE = "org.lockss.jobManager.taskListSize";
    public static final int DEFAULT_TASK_LIST_SIZE = 1;
    public static final String PARAM_SLEEP_DELAY_SECONDS = "org.lockss.jobManager.sleepDelaySeconds";
    public static final long DEFAULT_SLEEP_DELAY_SECONDS = 60L;
    private boolean jobManagerEnabled = false;
    private int taskCount = 1;
    private long sleepDelaySeconds = 60L;
    private PluginManager pluginManager = null;
    private JobDbManager dbManager = null;
    private MetadataExtractorManager mdxManager = null;
    private JobManagerSql jobManagerSql;
    private ExecutorService taskExecutor = null;
    private List<JobTask> tasks = null;

    public JobManager() {
    }

    public JobManager(JobDbManager dbManager) {
        this.dbManager = dbManager;
        try {
            this.jobManagerSql = new JobManagerSql(dbManager);
        }
        catch (DbException dbe) {
            log.error("Cannot obtain JobManagerSql", (Throwable)dbe);
            return;
        }
    }

    public void setConfig(Configuration config, Configuration prevConfig, Configuration.Differences changedKeys) {
        String DEBUG_HEADER = "setConfig(): ";
        if (log.isDebug2()) {
            log.debug2("setConfig(): Starting...");
        }
        if (changedKeys.contains(PREFIX)) {
            this.jobManagerEnabled = config.getBoolean(PARAM_JOBMANAGER_ENABLED, false);
            if (log.isDebug3()) {
                log.debug3("setConfig(): jobManagerEnabled = " + this.jobManagerEnabled);
            }
            this.taskCount = Math.max(0, config.getInt(PARAM_TASK_LIST_SIZE, 1));
            if (log.isDebug3()) {
                log.debug3("setConfig(): taskCount = " + this.taskCount);
            }
            this.sleepDelaySeconds = Math.max(0L, config.getLong(PARAM_SLEEP_DELAY_SECONDS, 60L));
            if (log.isDebug3()) {
                log.debug3("setConfig(): sleepDelaySeconds = " + this.sleepDelaySeconds);
            }
        }
        if (log.isDebug2()) {
            log.debug2("setConfig(): Done.");
        }
    }

    public void startService() {
        String DEBUG_HEADER = "startService(): ";
        if (log.isDebug2()) {
            log.debug2("startService(): Starting JobManager");
        }
        if (!this.jobManagerEnabled) {
            log.info("JobManager not enabled.");
            return;
        }
        this.pluginManager = this.getDaemon().getPluginManager();
        this.dbManager = (JobDbManager)((Object)LockssApp.getManagerByTypeStatic(JobDbManager.class));
        this.mdxManager = (MetadataExtractorManager)((Object)LockssApp.getManagerByTypeStatic(MetadataExtractorManager.class));
        try {
            this.jobManagerSql = new JobManagerSql(this.dbManager);
        }
        catch (DbException dbe) {
            log.error("Cannot obtain JobManagerSql", (Throwable)dbe);
            return;
        }
        try {
            this.jobManagerSql.freeIncompleteJobs();
        }
        catch (DbException dbe) {
            log.error("Cannot free incomplete jobs", (Throwable)dbe);
            return;
        }
        this.taskExecutor = Executors.newFixedThreadPool(this.taskCount);
        this.tasks = new ArrayList<JobTask>(this.taskCount);
        for (int i = 0; i < this.taskCount; ++i) {
            JobTask task = new JobTask(this.dbManager, this.mdxManager, this);
            if (log.isDebug3()) {
                log.debug3("startService(): task = " + task);
            }
            this.taskExecutor.submit(task);
            this.tasks.add(task);
        }
        if (log.isDebug3()) {
            log.debug3("startService(): tasks.size() = " + this.tasks.size());
        }
        if (log.isDebug2()) {
            log.debug2("startService(): JobManager service successfully started");
        }
    }

    public JobAuStatus scheduleMetadataExtraction(String auId, boolean needFullReindex) throws IllegalArgumentException, Exception {
        String DEBUG_HEADER = "scheduleMetadataExtraction(): ";
        if (log.isDebug2()) {
            log.debug2("scheduleMetadataExtraction(): auId = " + auId);
            log.debug2("scheduleMetadataExtraction(): needFullReindex = " + needFullReindex);
        }
        JobAuStatus job = null;
        String auName = this.getAuName(auId);
        String message = null;
        message = needFullReindex ? "Cannot schedule a full metadata extraction for auId = '" + auId + "'" : "Cannot schedule an incremental metadata extraction for auId = '" + auId + "'";
        try {
            job = this.jobManagerSql.createMetadataExtractionJob(auId, needFullReindex);
            job.setAuName(auName);
        }
        catch (IllegalArgumentException iae) {
            log.error(message, (Throwable)iae);
            throw iae;
        }
        catch (Exception e) {
            log.error(message, (Throwable)e);
            throw e;
        }
        if (log.isDebug2()) {
            log.debug2("scheduleMetadataExtraction(): job = " + job);
        }
        return job;
    }

    public JobAuStatus scheduleMetadataRemoval(String auId) throws IllegalArgumentException, Exception {
        String DEBUG_HEADER = "scheduleMetadataRemoval(): ";
        if (log.isDebug2()) {
            log.debug2("scheduleMetadataRemoval(): auId = " + auId);
        }
        JobAuStatus job = null;
        String auName = this.getAuName(auId);
        String message = "Cannot schedule metadata removal for auId = '" + auId + "'";
        try {
            job = this.jobManagerSql.createMetadataRemovalJob(auId);
            job.setAuName(auName);
        }
        catch (IllegalArgumentException iae) {
            log.error(message, (Throwable)iae);
            throw iae;
        }
        catch (Exception e) {
            log.error(message, (Throwable)e);
            throw e;
        }
        if (log.isDebug2()) {
            log.debug2("scheduleMetadataRemoval(): job = " + job);
        }
        return job;
    }

    public JobPage getJobs(Integer limit, JobContinuationToken continuationToken) throws Exception {
        String DEBUG_HEADER = "getJobs(): ";
        if (log.isDebug2()) {
            log.debug2("getJobs(): limit = " + limit);
            log.debug2("getJobs(): continuationToken = " + continuationToken);
        }
        JobPage jobPage = this.jobManagerSql.getJobs(limit, continuationToken);
        for (Job job : jobPage.getJobs()) {
            job.getAu().setName(this.getAuName(job.getAu().getId()));
        }
        return jobPage;
    }

    public int removeAllJobs() throws Exception {
        String DEBUG_HEADER = "removeAllJobs(): ";
        if (log.isDebug2()) {
            log.debug2("removeAllJobs(): Invoked.");
        }
        for (JobTask jobTask : this.tasks) {
            if (log.isDebug3()) {
                log.debug3("removeAllJobs(): jobTask = " + jobTask);
            }
            jobTask.terminateTask();
        }
        return this.jobManagerSql.deleteAllInactiveJobs();
    }

    public JobAuStatus removeJob(String jobId) throws IllegalArgumentException, Exception {
        String DEBUG_HEADER = "removeJob(): ";
        if (log.isDebug2()) {
            log.debug2("removeJob(): jobId = " + jobId);
        }
        String message = "Cannot remove job for jobId = " + jobId;
        JobAuStatus job = null;
        try {
            job = this.jobManagerSql.getJob(jobId);
            Long jobSeq = Long.valueOf(job.getId());
            if (log.isDebug3()) {
                log.debug3("removeJob(): jobSeq = " + jobSeq);
            }
            job = this.removeJob(jobSeq);
        }
        catch (IllegalArgumentException iae) {
            log.error(message, (Throwable)iae);
            throw iae;
        }
        catch (Exception e) {
            log.error(message, (Throwable)e);
            throw new Exception(message, e);
        }
        if (log.isDebug2()) {
            log.debug2("removeJob(): job = " + job);
        }
        return job;
    }

    private JobAuStatus removeJob(Long jobSeq) throws IllegalArgumentException, Exception {
        String DEBUG_HEADER = "removeJob(): ";
        if (log.isDebug2()) {
            log.debug2("removeJob(): jobSeq = " + jobSeq);
        }
        String message = "Cannot remove job for jobSeq = " + jobSeq;
        JobAuStatus jobAuStatus = null;
        try {
            for (JobTask jobTask : this.tasks) {
                if (log.isDebug3()) {
                    log.debug3("removeJob(): jobTask = " + jobTask);
                }
                if (!jobSeq.equals(jobTask.getJobId())) continue;
                jobTask.terminateTask();
                break;
            }
            jobAuStatus = this.jobManagerSql.deleteJob(jobSeq);
        }
        catch (IllegalArgumentException iae) {
            log.error(message, (Throwable)iae);
            throw iae;
        }
        catch (Exception e) {
            log.error(message, (Throwable)e);
            throw new Exception(message, e);
        }
        jobAuStatus.setAuName(this.getAuName(jobAuStatus.getAuId()));
        if (log.isDebug2()) {
            log.debug2("removeJob(): jobAuStatus = " + jobAuStatus);
        }
        return jobAuStatus;
    }

    public JobAuStatus getJobStatus(String jobId) throws IllegalArgumentException, Exception {
        String DEBUG_HEADER = "getJobStatus(): ";
        if (log.isDebug2()) {
            log.debug2("getJobStatus(): jobId = " + jobId);
        }
        String message = "Cannot get status job for jobId = " + jobId;
        JobAuStatus status = null;
        try {
            status = this.jobManagerSql.getJob(jobId);
        }
        catch (IllegalArgumentException iae) {
            log.error(message, (Throwable)iae);
            throw iae;
        }
        catch (Exception e) {
            log.error(message, (Throwable)e);
            throw new Exception(message, e);
        }
        if (log.isDebug2()) {
            log.debug2("getJobStatus(): status = " + status);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePutAuJobStartEvent(String auId) {
        String DEBUG_HEADER = "handlePutAuJobStartEvent(): ";
        if (log.isDebug2()) {
            log.debug2("handlePutAuJobStartEvent(): auId = " + auId);
        }
        Connection conn = null;
        try {
            conn = this.dbManager.getConnection();
            Long jobSeq = Long.valueOf(this.jobManagerSql.getAuJob(conn, auId).getId());
            if (log.isDebug3()) {
                log.debug3("handlePutAuJobStartEvent(): jobSeq = " + jobSeq);
            }
            this.jobManagerSql.markJobAsRunning(conn, jobSeq, "Extracting metadata");
            JobDbManager.commitOrRollback((Connection)conn, (Logger)log);
        }
        catch (Exception e) {
            String message = "Error handling start of metadata extraction";
            log.error(message, (Throwable)e);
        }
        finally {
            JobDbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("handlePutAuJobStartEvent(): Done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePutAuJobFinishEvent(String auId, MetadataExtractorManager.ReindexingStatus status, Exception exception) {
        String DEBUG_HEADER = "handlePutAuJobFinishEvent(): ";
        if (log.isDebug2()) {
            log.debug2("handlePutAuJobFinishEvent(): auId = " + auId);
            log.debug2("handlePutAuJobFinishEvent(): status = " + status);
            log.debug2("handlePutAuJobFinishEvent(): exception = " + exception);
        }
        Connection conn = null;
        try {
            conn = this.dbManager.getConnection();
            JobAuStatus jobAuStatus = this.jobManagerSql.getAuJob(conn, auId);
            if (log.isDebug3()) {
                log.debug3("handlePutAuJobFinishEvent(): jobAuStatus = " + jobAuStatus);
            }
            if (jobAuStatus != null) {
                Long jobSeq = Long.valueOf(jobAuStatus.getId());
                if (log.isDebug3()) {
                    log.debug3("handlePutAuJobFinishEvent(): jobSeq = " + (Long)jobSeq);
                }
                int markedJobs = -1;
                markedJobs = status == MetadataExtractorManager.ReindexingStatus.Success ? this.markJobAsDone(conn, jobSeq, "Success") : this.markJobAsDone(conn, jobSeq, "Failure: " + exception);
                if (log.isDebug3()) {
                    log.debug3("handlePutAuJobFinishEvent(): markedJobs = " + markedJobs);
                }
                JobDbManager.commitOrRollback((Connection)conn, (Logger)log);
            }
            for (JobTask jobTask : this.tasks) {
                if (log.isDebug3()) {
                    log.debug3("handlePutAuJobFinishEvent(): jobTask = " + jobTask);
                }
                StepTask stepTask = jobTask.getStepTask();
                if (log.isDebug3()) {
                    log.debug3("handlePutAuJobFinishEvent(): stepTask = " + stepTask);
                }
                if (stepTask == null || !auId.equals(((ReindexingTask)stepTask).getAuId())) continue;
                jobTask.notifyJobFinish();
                break;
            }
        }
        catch (Exception e) {
            String message = "Error handling finish of metadata extraction";
            log.error(message, (Throwable)e);
        }
        finally {
            JobDbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("handlePutAuJobFinishEvent(): Done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDeleteAuJobStartEvent(String auId) {
        String DEBUG_HEADER = "handleDeleteAuJobStartEvent(): ";
        if (log.isDebug2()) {
            log.debug2("handleDeleteAuJobStartEvent(): auId = " + auId);
        }
        Connection conn = null;
        try {
            conn = this.dbManager.getConnection();
            Long jobSeq = Long.valueOf(this.jobManagerSql.getAuJob(conn, auId).getId());
            if (log.isDebug3()) {
                log.debug3("handleDeleteAuJobStartEvent(): jobSeq = " + jobSeq);
            }
            this.jobManagerSql.markJobAsRunning(conn, jobSeq, "Deleting metadata");
            JobDbManager.commitOrRollback((Connection)conn, (Logger)log);
        }
        catch (Exception e) {
            String message = "Error handling start of metadata removal";
            log.error(message, (Throwable)e);
        }
        finally {
            JobDbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("handleDeleteAuJobStartEvent(): Done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDeleteAuJobFinishEvent(String auId, MetadataExtractorManager.ReindexingStatus status, Exception exception) {
        String DEBUG_HEADER = "handleDeleteAuJobFinishEvent(): ";
        if (log.isDebug2()) {
            log.debug2("handleDeleteAuJobFinishEvent(): auId = " + auId);
            log.debug2("handleDeleteAuJobFinishEvent(): status = " + status);
            log.debug2("handleDeleteAuJobFinishEvent(): exception = " + exception);
        }
        Connection conn = null;
        try {
            conn = this.dbManager.getConnection();
            JobAuStatus jobAuStatus = this.jobManagerSql.getAuJob(conn, auId);
            if (log.isDebug3()) {
                log.debug3("handleDeleteAuJobFinishEvent(): jobAuStatus = " + jobAuStatus);
            }
            if (jobAuStatus != null) {
                Long jobSeq = Long.valueOf(jobAuStatus.getId());
                if (log.isDebug3()) {
                    log.debug3("handleDeleteAuJobFinishEvent(): jobSeq = " + (Long)jobSeq);
                }
                int markedJobs = -1;
                markedJobs = status == MetadataExtractorManager.ReindexingStatus.Success ? this.markJobAsDone(conn, jobSeq, "Success") : this.markJobAsDone(conn, jobSeq, "Failure: " + exception);
                if (log.isDebug3()) {
                    log.debug3("handleDeleteAuJobFinishEvent(): markedJobs = " + markedJobs);
                }
                JobDbManager.commitOrRollback((Connection)conn, (Logger)log);
            }
            for (JobTask jobTask : this.tasks) {
                if (log.isDebug3()) {
                    log.debug3("handleDeleteAuJobFinishEvent(): jobTask = " + jobTask);
                }
                if (!auId.equals(((DeleteMetadataTask)jobTask.getStepTask()).getAuId())) continue;
                jobTask.notifyJobFinish();
                break;
            }
        }
        catch (Exception e) {
            String message = "Error handling finish of metadata removal";
            log.error(message, (Throwable)e);
        }
        finally {
            JobDbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("handleDeleteAuJobFinishEvent(): Done.");
        }
    }

    String getJobAuId(Connection conn, Long jobSeq) throws DbException {
        return this.jobManagerSql.getJobAuId(conn, jobSeq);
    }

    Long claimNextJob(String owner) throws DbException {
        return this.jobManagerSql.claimNextJob(owner);
    }

    String getJobType(Long jobSeq) throws DbException {
        return this.jobManagerSql.getJobType(jobSeq);
    }

    int markJobAsFinished(Connection conn, Long jobSeq, String statusName, String statusMessage) throws DbException {
        return this.jobManagerSql.markJobAsFinished(conn, jobSeq, statusName, statusMessage);
    }

    int markJobAsDone(Connection conn, Long jobSeq, String statusMessage) throws DbException {
        return this.jobManagerSql.markJobAsDone(conn, jobSeq, statusMessage);
    }

    private String getAuName(String auId) throws IllegalArgumentException, Exception {
        String DEBUG_HEADER = "getAuName(): ";
        if (log.isDebug2()) {
            log.debug2("getAuName(): auId = " + auId);
        }
        String message = "Cannot find Archival Unit for auId '" + auId + "'";
        try {
            ArchivalUnit au = this.pluginManager.getAuFromId(auId);
            if (log.isDebug3()) {
                log.debug3("getAuName(): au = " + au);
            }
            if (au != null) {
                String auName = au.getName();
                if (log.isDebug2()) {
                    log.debug2("getAuName(): auName = " + auName);
                }
                return auName;
            }
        }
        catch (IllegalArgumentException iae) {
            log.error(message, (Throwable)iae);
            throw iae;
        }
        catch (Exception e) {
            log.error(message, (Throwable)e);
            throw e;
        }
        log.error(message);
        throw new IllegalArgumentException(message);
    }

    long getSleepDelaySeconds() {
        return this.sleepDelaySeconds;
    }

    public long getNotStartedReindexingJobsCount() throws DbException {
        if (this.jobManagerEnabled) {
            return this.jobManagerSql.getNotStartedReindexingJobsCount();
        }
        return 0L;
    }

    public List<Map<String, Object>> getNotStartedReindexingJobs(int maxJobCount) throws DbException {
        if (this.jobManagerEnabled) {
            return this.jobManagerSql.getNotStartedReindexingJobs(maxJobCount);
        }
        return new ArrayList<Map<String, Object>>();
    }

    public Long createJobForTesting(Long jobTypeSeq, String description, String auId, Long jobStatusSeq, String statusMessage) throws DbException {
        if (log.isDebug2()) {
            log.debug("jobTypeSeq = " + jobTypeSeq);
            log.debug("description = " + description);
            log.debug("auId = " + auId);
            log.debug("jobStatusSeq = " + jobStatusSeq);
            log.debug("statusMessage = " + statusMessage);
        }
        Connection conn = null;
        Long jobSeq = null;
        try {
            conn = this.dbManager.getConnection();
            long creationTime = new Date().getTime();
            jobSeq = this.jobManagerSql.addJob(conn, jobTypeSeq, description, auId, creationTime, creationTime + 1L, creationTime + 2L, jobStatusSeq, statusMessage);
            boolean claimed = this.jobManagerSql.claimUnclaimedJob(conn, "Test", jobSeq);
            if (log.isDebug3()) {
                log.debug3("claimed? = " + claimed);
            }
            JobDbManager.commitOrRollback((Connection)conn, (Logger)log);
        }
        catch (Exception e) {
            String message = "Cannot add job for auId = '" + auId + "'";
            log.error(message, (Throwable)e);
            throw e;
        }
        finally {
            JobDbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("jobSeq = " + jobSeq);
        }
        return jobSeq;
    }

    public JobAuStatus getAuJob(Connection conn, String auId) throws DbException {
        return this.jobManagerSql.getAuJob(conn, auId);
    }

    public long getReindexingJobsCount() throws DbException {
        if (this.jobManagerEnabled) {
            return this.jobManagerSql.getReindexingJobsCount();
        }
        return 0L;
    }

    public long getSuccessfulReindexingJobsCount() throws DbException {
        if (this.jobManagerEnabled) {
            return this.jobManagerSql.getSuccessfulReindexingJobsCount();
        }
        return 0L;
    }

    public long getFailedReindexingJobsCount() throws DbException {
        if (this.jobManagerEnabled) {
            return this.jobManagerSql.getFailedReindexingJobsCount();
        }
        return 0L;
    }

    public List<Map<String, Object>> getFinishedReindexingJobsBefore(int maxJobCount, long beforeTime) throws DbException {
        if (this.jobManagerEnabled) {
            return this.jobManagerSql.getFinishedReindexingJobsBefore(maxJobCount, beforeTime);
        }
        return new ArrayList<Map<String, Object>>();
    }

    public List<Map<String, Object>> getFailedReindexingJobsBefore(int maxJobCount, long beforeTime) throws DbException {
        if (this.jobManagerEnabled) {
            return this.jobManagerSql.getFailedReindexingJobsBefore(maxJobCount, beforeTime);
        }
        return new ArrayList<Map<String, Object>>();
    }

    public boolean isFullReindexJob(Long jobTypeSeq) {
        return this.jobManagerSql.getJobTypeSeqByName().get("put_au").equals(jobTypeSeq);
    }
}

