/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.metadata.extractor.job;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.lockss.metadata.extractor.job.JobAuStatus;

@ApiModel(description="An Archival Unit")
public class Au {
    private String id = null;
    private String job = null;
    private String name = null;

    public Au() {
    }

    public Au(JobAuStatus jobAuStatus) {
        this.id = jobAuStatus.getAuId();
        this.job = jobAuStatus.getId();
        this.name = jobAuStatus.getAuName();
    }

    @ApiModelProperty(required=true, value="The identifier of this AU")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(value="The identifier of the job associated with this AU")
    public String getJob() {
        return this.job;
    }

    public void setJob(String job) {
        this.job = job;
    }

    @ApiModelProperty(value="The name of the AU, for display purposes")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Au au = (Au)o;
        return Objects.equals(this.id, au.id) && Objects.equals(this.job, au.job) && Objects.equals(this.name, au.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.job, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Au {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    job: ").append(this.toIndentedString(this.job)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

