/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.metadata.extractor.job;

import java.util.Vector;
import org.lockss.util.Logger;
import org.lockss.util.StringUtil;

public class JobContinuationToken {
    protected static final Logger log = Logger.getLogger();
    private static final String separator = "-";
    private Long queueTruncationTimestamp = null;
    private Long lastJobSeq = null;

    public JobContinuationToken(String webRequestContinuationToken) throws IllegalArgumentException {
        if (log.isDebug2()) {
            log.debug2("webRequestContinuationToken = " + webRequestContinuationToken);
        }
        String message = "Invalid web request continuation token '" + webRequestContinuationToken + "'";
        if (webRequestContinuationToken != null && !webRequestContinuationToken.trim().isEmpty()) {
            Vector tokenItems = null;
            try {
                tokenItems = StringUtil.breakAt((String)webRequestContinuationToken.trim(), (String)separator);
                if (log.isDebug3()) {
                    log.debug3("tokenItems = " + tokenItems);
                }
                this.queueTruncationTimestamp = Long.valueOf(((String)tokenItems.get(0)).trim());
                if (log.isDebug3()) {
                    log.debug3("queueTruncationTimestamp = " + this.queueTruncationTimestamp);
                }
                this.lastJobSeq = Long.valueOf(((String)tokenItems.get(1)).trim());
                if (log.isDebug3()) {
                    log.debug3("lastJobSeq = " + this.lastJobSeq);
                }
            }
            catch (Exception e) {
                log.warning(message, (Throwable)e);
                throw new IllegalArgumentException(message, e);
            }
            if (tokenItems.size() != 2) {
                log.warning(message);
                throw new IllegalArgumentException(message);
            }
            this.validateMembers();
        }
    }

    public JobContinuationToken(Long queueTruncationTimestamp, Long lastJobSeq) {
        this.queueTruncationTimestamp = queueTruncationTimestamp;
        this.lastJobSeq = lastJobSeq;
        this.validateMembers();
    }

    public Long getQueueTruncationTimestamp() {
        return this.queueTruncationTimestamp;
    }

    public Long getLastJobSeq() {
        return this.lastJobSeq;
    }

    public String toWebResponseContinuationToken() {
        if (this.queueTruncationTimestamp != null && this.lastJobSeq != null) {
            return this.queueTruncationTimestamp + separator + this.lastJobSeq;
        }
        return null;
    }

    public String toString() {
        return "[JobContinuationToken queueTruncationTimestamp=" + this.queueTruncationTimestamp + ", lastJobSeq=" + this.lastJobSeq + "]";
    }

    private void validateMembers() {
        if (this.queueTruncationTimestamp == null && this.lastJobSeq != null || this.queueTruncationTimestamp != null && this.lastJobSeq == null) {
            String message = "Invalid member combination: queueTruncationTimestamp = '" + this.queueTruncationTimestamp + "', lastJobSeq = '" + this.lastJobSeq + "'";
            log.warning(message);
            throw new IllegalArgumentException(message);
        }
        if (this.queueTruncationTimestamp != null && this.queueTruncationTimestamp < 0L) {
            String message = "Invalid member: queueTruncationTimestamp = '" + this.queueTruncationTimestamp + "'";
            log.warning(message);
            throw new IllegalArgumentException(message);
        }
        if (this.lastJobSeq != null && this.lastJobSeq < 0L) {
            String message = "Invalid member: lastJobSeq = '" + this.lastJobSeq + "'";
            log.warning(message);
            throw new IllegalArgumentException(message);
        }
    }
}

