/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.metadata.extractor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.lockss.db.DbException;
import org.lockss.db.DbManager;
import org.lockss.db.JdbcContext;
import org.lockss.metadata.extractor.MetadataExtractorManager;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.plugin.PluginManager;
import org.lockss.util.Logger;

public class MetadataExtractorManagerSql {
    private static final Logger log = Logger.getLogger(MetadataExtractorManagerSql.class);
    private static final int UNKNOWN_VERSION = -1;
    private static final String COUNT_ENABLED_PENDING_AUS_QUERY = "select count(*) from pending_au where priority >= 0";
    private static final String COUNT_BIB_ITEM_QUERY = "select count(*) from bib_item";
    private static final String COUNT_PUBLISHER_QUERY = "select count(distinct publisher.publisher_seq) from publisher,publication,md_item where publisher.publisher_seq=publication.publisher_seq and publication.md_item_seq=md_item.md_item_seq";
    private static final String COUNT_PROVIDER_QUERY = "select count(distinct provider.provider_seq) from provider,au_md,md_item where provider.provider_seq=au_md.provider_seq and au_md.au_md_seq=md_item.au_md_seq";
    private static final String FIND_PRIORITIZED_ENABLED_PENDING_AUS_QUERY = "select pending_au.plugin_id,pending_au.au_key,pending_au.priority,(au_md.au_seq is null) as is_new,pending_au.fully_reindex from pending_au   left join plugin     on plugin.plugin_id        = pending_au.plugin_id   left join au     on au.au_key        = pending_au.au_key    and au.plugin_seq        = plugin.plugin_seq   left join au_md     on au_md.au_seq        = au.au_seq where priority >= 0 order by (pending_au.priority > 0),(true = ? and au_md.au_seq is not null),pending_au.priority";
    private static final String DELETE_PENDING_AU_QUERY = "delete from pending_au where plugin_id = ? and au_key = ?";
    private static final String DELETE_AU_MD_ITEM_QUERY = "delete from md_item where au_md_seq = ?";
    private static final String FIND_AU_MD_BY_AU_ID_QUERY = "select m.au_md_seq from au_md m,au a,plugin p where m.au_seq = a.au_seq and a.plugin_seq = p.plugin_seq and p.plugin_id = ? and a.au_key = ?";
    private static final String DELETE_AU_QUERY = "delete from au where au_seq = ?";
    private static final String FIND_AU_BY_AU_ID_QUERY = "select a.au_seq from au a,plugin p where a.plugin_seq = p.plugin_seq and p.plugin_id = ? and a.au_key = ?";
    private static final String UPDATE_AU_MD_EXTRACT_TIME_QUERY = "update au_md set extract_time = ? where au_md_seq = ?";
    private static final String DELETE_DISABLED_PENDING_AU_QUERY = "delete from pending_au where plugin_id = ? and au_key = ? and priority < 0";
    private static final String INSERT_ENABLED_PENDING_AU_QUERY = "insert into pending_au(plugin_id,au_key,priority,fully_reindex) values (?,?,(select coalesce(max(priority), 0) + 1 from pending_au where priority >= 0),?)";
    private static final String INSERT_ENABLED_PENDING_AU_MYSQL_QUERY = "insert into pending_au(plugin_id,au_key,priority,fully_reindex) values (?,?,(select next_priority from (select coalesce(max(priority), 0) + 1 as next_priority from pending_au where priority >= 0) as temp_pau_table),?)";
    private static final String INSERT_HIGHEST_PRIORITY_PENDING_AU_QUERY = "insert into pending_au(plugin_id,au_key,priority,fully_reindex) values (?,?,0,?)";
    private static final String FIND_PENDING_AU_QUERY = "select plugin_id,au_key from pending_au where plugin_id = ? and au_key = ?";
    private static final String FIND_AU_METADATA_VERSION_QUERY = "select m.md_version from au_md m,au a,plugin p where m.au_seq =  a.au_seq and a.plugin_seq =  p.plugin_seq and p.plugin_id = ? and a.au_key = ?";
    private static final String FIND_AU_FULL_REINDEXING_BY_AU_QUERY = "select fully_reindex from pending_au where plugin_id = ? and au_key = ?";
    private static final String UPDATE_AU_FULL_REINDEXING_QUERY = "update pending_au set fully_reindex = ? where plugin_id = ? and au_key = ?";
    private static final String FIND_AU_MD_EXTRACT_TIME_BY_AU_QUERY = "select m.extract_time from au_md m,au a,plugin p where m.au_seq =  a.au_seq and a.plugin_seq =  p.plugin_seq and p.plugin_id = ? and a.au_key = ?";
    private static final String INSERT_PLATFORM_QUERY = "insert into platform(platform_seq,platform_name) values (default,?)";
    private static final String INSERT_DISABLED_PENDING_AU_QUERY = "insert into pending_au(plugin_id,au_key,priority) values (?,?,-10000)";
    private static final String INSERT_FAILED_INDEXING_PENDING_AU_QUERY = "insert into pending_au(plugin_id,au_key,priority) values (?,?,-1000)";
    private static final String FIND_PENDING_AUS_WITH_PRIORITY_QUERY = "select plugin_id,au_key from pending_au where priority = ?";
    private static final String FIND_AU_PUBLISHER_QUERY = "select distinct pr.publisher_seq from publisher pr,publication p,md_item m,au_md am where pr.publisher_seq = p.publisher_seq and p.md_item_seq = m.parent_seq and m.au_md_seq = am.au_md_seq and am.au_seq = ?";
    private static final String FIND_MD_ITEM_AUTHOR_QUERY = "select author_name from author where md_item_seq = ?";
    private static final String FIND_MD_ITEM_KEYWORD_QUERY = "select keyword from keyword where md_item_seq = ?";
    private static final String INSERT_AUTHOR_QUERY = "insert into author(md_item_seq,author_name,author_idx) values (?,?,(select coalesce(max(author_idx), 0) + 1 from author where md_item_seq = ?))";
    private static final String INSERT_AUTHOR_MYSQL_QUERY = "insert into author(md_item_seq,author_name,author_idx) values (?,?,(select next_idx from (select coalesce(max(author_idx), 0) + 1 as next_idx from author where md_item_seq = ?) as temp_author_table))";
    private static final String INSERT_KEYWORD_QUERY = "insert into keyword(md_item_seq,keyword) values (?,?)";
    private static final String DELETE_UNCONFIGURED_AU_QUERY = "delete from unconfigured_au where plugin_id = ? and au_key = ?";
    private static final String DELETE_AU_CHILD_MD_ITEM_QUERY = "delete from md_item where au_md_seq = ? and md_item_seq = ? and parent_seq is not null";
    private DbManager dbManager;
    private MetadataExtractorManager mdxManager;

    MetadataExtractorManagerSql(DbManager dbManager, MetadataExtractorManager mdxManager) throws DbException {
        this.dbManager = dbManager;
        this.mdxManager = mdxManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getEnabledPendingAusCount() throws DbException {
        String DEBUG_HEADER = "getEnabledPendingAusCount(): ";
        if (log.isDebug2()) {
            log.debug2("getEnabledPendingAusCount(): Starting...");
        }
        long rowCount = -1L;
        Connection conn = this.dbManager.getConnection();
        try {
            rowCount = this.getEnabledPendingAusCount(conn);
        }
        finally {
            DbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("getEnabledPendingAusCount(): rowCount = " + rowCount);
        }
        return rowCount;
    }

    long getEnabledPendingAusCount(Connection conn) throws DbException {
        String DEBUG_HEADER = "getEnabledPendingAusCount(): ";
        if (log.isDebug2()) {
            log.debug2("getEnabledPendingAusCount(): Starting...");
        }
        long rowCount = -1L;
        PreparedStatement stmt = this.dbManager.prepareStatement(conn, COUNT_ENABLED_PENDING_AUS_QUERY);
        ResultSet resultSet = null;
        try {
            resultSet = this.dbManager.executeQuery(stmt);
            resultSet.next();
            rowCount = resultSet.getLong(1);
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot get the count of enabled pending AUs";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'select count(*) from pending_au where priority >= 0'.");
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseResultSet(resultSet);
                DbManager.safeCloseStatement((Statement)stmt);
                throw throwable;
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)stmt);
        if (log.isDebug2()) {
            log.debug2("getEnabledPendingAusCount(): rowCount = " + rowCount);
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getArticleCount() throws DbException {
        String DEBUG_HEADER = "getArticleCount(): ";
        if (log.isDebug2()) {
            log.debug2("getArticleCount(): Starting...");
        }
        long rowCount = -1L;
        Connection conn = this.dbManager.getConnection();
        try {
            rowCount = this.getArticleCount(conn);
        }
        finally {
            DbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("getArticleCount(): rowCount = " + rowCount);
        }
        return rowCount;
    }

    long getArticleCount(Connection conn) throws DbException {
        String DEBUG_HEADER = "getArticleCount(): ";
        if (log.isDebug2()) {
            log.debug2("getArticleCount(): Starting...");
        }
        long rowCount = -1L;
        PreparedStatement stmt = this.dbManager.prepareStatement(conn, COUNT_BIB_ITEM_QUERY);
        ResultSet resultSet = null;
        try {
            resultSet = this.dbManager.executeQuery(stmt);
            resultSet.next();
            rowCount = resultSet.getLong(1);
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot get the count of articles";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'select count(*) from bib_item'.");
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseResultSet(resultSet);
                DbManager.safeCloseStatement((Statement)stmt);
                throw throwable;
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)stmt);
        if (log.isDebug2()) {
            log.debug2("getArticleCount(): rowCount = " + rowCount);
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getPublisherCount() throws DbException {
        String DEBUG_HEADER = "getPublisherCount(): ";
        if (log.isDebug2()) {
            log.debug2("getPublisherCount(): Starting...");
        }
        long rowCount = -1L;
        Connection conn = this.dbManager.getConnection();
        try {
            rowCount = this.getPublisherCount(conn);
        }
        finally {
            DbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("getPublisherCount(): rowCount = " + rowCount);
        }
        return rowCount;
    }

    long getPublisherCount(Connection conn) throws DbException {
        String DEBUG_HEADER = "getPublisherCount(): ";
        if (log.isDebug2()) {
            log.debug2("getPublisherCount(): Starting...");
        }
        long rowCount = -1L;
        PreparedStatement stmt = this.dbManager.prepareStatement(conn, COUNT_PUBLISHER_QUERY);
        ResultSet resultSet = null;
        try {
            resultSet = this.dbManager.executeQuery(stmt);
            resultSet.next();
            rowCount = resultSet.getLong(1);
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot get the count of publishers";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'select count(distinct publisher.publisher_seq) from publisher,publication,md_item where publisher.publisher_seq=publication.publisher_seq and publication.md_item_seq=md_item.md_item_seq'.");
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseResultSet(resultSet);
                DbManager.safeCloseStatement((Statement)stmt);
                throw throwable;
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)stmt);
        if (log.isDebug2()) {
            log.debug2("getPublisherCount(): rowCount = " + rowCount);
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getProviderCount() throws DbException {
        String DEBUG_HEADER = "getProviderCount(): ";
        if (log.isDebug2()) {
            log.debug2("getProviderCount(): Starting...");
        }
        long rowCount = -1L;
        Connection conn = this.dbManager.getConnection();
        try {
            rowCount = this.getProviderCount(conn);
        }
        finally {
            DbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("getProviderCount(): rowCount = " + rowCount);
        }
        return rowCount;
    }

    long getProviderCount(Connection conn) throws DbException {
        String DEBUG_HEADER = "getProviderCount(): ";
        if (log.isDebug2()) {
            log.debug2("getProviderCount(): Starting...");
        }
        long rowCount = -1L;
        PreparedStatement stmt = this.dbManager.prepareStatement(conn, COUNT_PROVIDER_QUERY);
        ResultSet resultSet = null;
        try {
            resultSet = this.dbManager.executeQuery(stmt);
            resultSet.next();
            rowCount = resultSet.getLong(1);
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot get the count of providers";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'select count(distinct provider.provider_seq) from provider,au_md,md_item where provider.provider_seq=au_md.provider_seq and au_md.au_md_seq=md_item.au_md_seq'.");
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseResultSet(resultSet);
                DbManager.safeCloseStatement((Statement)stmt);
                throw throwable;
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)stmt);
        if (log.isDebug2()) {
            log.debug2("getProviderCount(): rowCount = " + rowCount);
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    List<MetadataExtractorManager.PrioritizedAuId> getPrioritizedAuIdsToReindex(Connection conn, int maxAuIds, boolean prioritizeIndexingNewAus) {
        String DEBUG_HEADER = "getPrioritizedAuIdsToReindex(): ";
        if (log.isDebug2()) {
            log.debug2("getPrioritizedAuIdsToReindex(): maxAuIds = " + maxAuIds);
            log.debug2("getPrioritizedAuIdsToReindex(): prioritizeIndexingNewAus = " + prioritizeIndexingNewAus);
        }
        ArrayList<MetadataExtractorManager.PrioritizedAuId> auIds = new ArrayList<MetadataExtractorManager.PrioritizedAuId>();
        PreparedStatement selectPendingAus = null;
        ResultSet results = null;
        String sql = FIND_PRIORITIZED_ENABLED_PENDING_AUS_QUERY;
        try {
            selectPendingAus = this.dbManager.prepareStatement(conn, sql);
            selectPendingAus.setBoolean(1, prioritizeIndexingNewAus);
            results = this.dbManager.executeQuery(selectPendingAus);
            while (auIds.size() < maxAuIds && results.next()) {
                String pluginId = results.getString("plugin_id");
                if (log.isDebug3()) {
                    log.debug3("getPrioritizedAuIdsToReindex(): pluginId = " + pluginId);
                }
                String auKey = results.getString("au_key");
                if (log.isDebug3()) {
                    log.debug3("getPrioritizedAuIdsToReindex(): auKey = " + auKey);
                }
                String auId = PluginManager.generateAuId((String)pluginId, (String)auKey);
                if (log.isDebug3()) {
                    log.debug3("getPrioritizedAuIdsToReindex(): auId = " + auId);
                }
                if (!this.mdxManager.isEligibleForReindexing(auId) || this.mdxManager.activeReindexingTasks.containsKey(auId)) continue;
                MetadataExtractorManager.PrioritizedAuId auToReindex = new MetadataExtractorManager.PrioritizedAuId();
                auToReindex.auId = auId;
                long priority = results.getLong("priority");
                if (log.isDebug3()) {
                    log.debug3("getPrioritizedAuIdsToReindex(): priority = " + priority);
                }
                auToReindex.priority = priority;
                boolean isNew = results.getBoolean("is_new");
                if (log.isDebug3()) {
                    log.debug3("getPrioritizedAuIdsToReindex(): isNew = " + isNew);
                }
                auToReindex.isNew = isNew;
                boolean needFullReindex = results.getBoolean("fully_reindex");
                if (log.isDebug3()) {
                    log.debug3("getPrioritizedAuIdsToReindex(): needFullReindex = " + needFullReindex);
                }
                auToReindex.needFullReindex = needFullReindex;
                auIds.add(auToReindex);
                if (!log.isDebug3()) continue;
                log.debug3("getPrioritizedAuIdsToReindex(): Added auId = " + auId + " to reindex list");
            }
        }
        catch (SQLException sqle) {
            String message = "Cannot identify the enabled pending AUs";
            log.error(message, (Throwable)sqle);
            log.error("maxAuIds = " + maxAuIds);
            log.error("SQL = '" + sql + "'.");
            log.error("prioritizeIndexingNewAus = " + prioritizeIndexingNewAus);
            DbManager.safeCloseResultSet((ResultSet)results);
            DbManager.safeCloseStatement((Statement)selectPendingAus);
        }
        catch (DbException dbe) {
            String message = "Cannot identify the enabled pending AUs";
            log.error(message, (Throwable)dbe);
            log.error("SQL = '" + sql + "'.");
            log.error("prioritizeIndexingNewAus = " + prioritizeIndexingNewAus);
            {
                catch (Throwable throwable) {
                    DbManager.safeCloseResultSet(results);
                    DbManager.safeCloseStatement((Statement)selectPendingAus);
                    throw throwable;
                }
            }
            DbManager.safeCloseResultSet((ResultSet)results);
            DbManager.safeCloseStatement((Statement)selectPendingAus);
        }
        DbManager.safeCloseResultSet((ResultSet)results);
        DbManager.safeCloseStatement((Statement)selectPendingAus);
        auIds.trimToSize();
        if (log.isDebug2()) {
            log.debug2("getPrioritizedAuIdsToReindex(): auIds.size() = " + auIds.size());
        }
        return auIds;
    }

    long removeFromPendingAus(Connection conn, String auId) throws DbException {
        String DEBUG_HEADER = "removeFromPendingAus(): ";
        if (log.isDebug2()) {
            log.debug2("removeFromPendingAus(): auId = " + auId);
        }
        String pluginKey = null;
        String auKey = null;
        PreparedStatement deletePendingAu = this.dbManager.prepareStatement(conn, DELETE_PENDING_AU_QUERY);
        try {
            pluginKey = PluginManager.pluginKeyFromAuId((String)auId);
            auKey = PluginManager.auKeyFromAuId((String)auId);
            deletePendingAu.setString(1, pluginKey);
            deletePendingAu.setString(2, auKey);
            int deletedCount = this.dbManager.executeUpdate(deletePendingAu);
            if (log.isDebug3()) {
                log.debug3("removeFromPendingAus(): deletedCount = " + deletedCount);
            }
        }
        catch (SQLException sqle) {
            String message = "Cannot remove AU from pending table";
            log.error(message, (Throwable)sqle);
            log.error("auId = '" + auId + "'.");
            log.error("SQL = 'delete from pending_au where plugin_id = ? and au_key = ?'.");
            log.error("pluginKey = '" + pluginKey + "'.");
            log.error("auKey = '" + auKey + "'.");
            throw new DbException(message, (Throwable)sqle);
        }
        finally {
            DbManager.safeCloseStatement((Statement)deletePendingAu);
        }
        long enabledPendingAusCount = this.getEnabledPendingAusCount(conn);
        if (log.isDebug2()) {
            log.debug2("removeFromPendingAus(): enabledPendingAusCount = " + enabledPendingAusCount);
        }
        return enabledPendingAusCount;
    }

    int removeAuMetadataItems(Connection conn, String auId) throws DbException {
        String DEBUG_HEADER = "removeAuMetadataItems(): ";
        if (log.isDebug2()) {
            log.debug2("removeAuMetadataItems(): auId = " + auId);
        }
        int count = 0;
        Long auMdSeq = this.findAuMdByAuId(conn, auId);
        if (log.isDebug3()) {
            log.debug3("removeAuMetadataItems(): auMdSeq = " + auMdSeq);
        }
        if (auMdSeq != null) {
            PreparedStatement deleteMetadataItems = this.dbManager.prepareStatement(conn, DELETE_AU_MD_ITEM_QUERY);
            try {
                deleteMetadataItems.setLong(1, auMdSeq);
                count = this.dbManager.executeUpdate(deleteMetadataItems);
            }
            catch (SQLException sqle) {
                String message = "Cannot delete AU metadata items";
                log.error(message, (Throwable)sqle);
                log.error("auId = " + auId);
                log.error("SQL = 'delete from md_item where au_md_seq = ?'.");
                log.error("auMdSeq = " + auMdSeq);
                throw new DbException(message, (Throwable)sqle);
            }
            finally {
                DbManager.safeCloseStatement((Statement)deleteMetadataItems);
            }
        }
        if (log.isDebug2()) {
            log.debug2("removeAuMetadataItems(): count = " + count);
        }
        return count;
    }

    Long findAuMdByAuId(Connection conn, String auId) throws DbException {
        ResultSet resultSet;
        PreparedStatement findAuMd;
        Long auMdSeq;
        block9: {
            String DEBUG_HEADER = "findAuMdByAuId(): ";
            if (log.isDebug2()) {
                log.debug2("findAuMdByAuId(): auId = " + auId);
            }
            String pluginKey = null;
            String auKey = null;
            auMdSeq = null;
            findAuMd = this.dbManager.prepareStatement(conn, FIND_AU_MD_BY_AU_ID_QUERY);
            resultSet = null;
            try {
                pluginKey = PluginManager.pluginKeyFromAuId((String)auId);
                if (log.isDebug3()) {
                    log.debug3("findAuMdByAuId(): pluginKey() = " + pluginKey);
                }
                auKey = PluginManager.auKeyFromAuId((String)auId);
                if (log.isDebug3()) {
                    log.debug3("findAuMdByAuId(): auKey = " + auKey);
                }
                findAuMd.setString(1, pluginKey);
                findAuMd.setString(2, auKey);
                resultSet = this.dbManager.executeQuery(findAuMd);
                if (!resultSet.next()) break block9;
                auMdSeq = resultSet.getLong("au_md_seq");
                if (log.isDebug3()) {
                    log.debug3("findAuMdByAuId(): auMdSeq = " + auMdSeq);
                }
            }
            catch (SQLException sqle) {
                try {
                    String message = "Cannot find AU metadata identifier";
                    log.error(message, (Throwable)sqle);
                    log.error("auId = " + auId);
                    log.error("SQL = 'select m.au_md_seq from au_md m,au a,plugin p where m.au_seq = a.au_seq and a.plugin_seq = p.plugin_seq and p.plugin_id = ? and a.au_key = ?'.");
                    log.error("pluginKey = " + pluginKey);
                    log.error("auKey = " + auKey);
                    throw new DbException(message, (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    DbManager.safeCloseResultSet(resultSet);
                    DbManager.safeCloseStatement((Statement)findAuMd);
                    throw throwable;
                }
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)findAuMd);
        if (log.isDebug2()) {
            log.debug2("findAuMdByAuId(): auMdSeq = " + auMdSeq);
        }
        return auMdSeq;
    }

    public int removeAu(Connection conn, String auId) throws DbException {
        String DEBUG_HEADER = "removeAu(): ";
        if (log.isDebug2()) {
            log.debug2("removeAu(): auId = " + auId);
        }
        int count = 0;
        Long auSeq = this.findAuByAuId(conn, auId);
        if (log.isDebug3()) {
            log.debug3("removeAu(): auSeq = " + auSeq);
        }
        if (auSeq != null) {
            PreparedStatement deleteAu = this.dbManager.prepareStatement(conn, DELETE_AU_QUERY);
            try {
                deleteAu.setLong(1, auSeq);
                count = this.dbManager.executeUpdate(deleteAu);
            }
            catch (SQLException sqle) {
                String message = "Cannot delete AU";
                log.error(message, (Throwable)sqle);
                log.error("auId = " + auId);
                log.error("SQL = 'delete from au where au_seq = ?'.");
                log.error("auSeq = " + auSeq);
                throw new DbException(message, (Throwable)sqle);
            }
            finally {
                DbManager.safeCloseStatement((Statement)deleteAu);
            }
        }
        if (log.isDebug2()) {
            log.debug2("removeAu(): count = " + count);
        }
        return count;
    }

    public Long findAuByAuId(Connection conn, String auId) throws DbException {
        ResultSet resultSet;
        PreparedStatement findAu;
        Long auSeq;
        block9: {
            String DEBUG_HEADER = "findAuByAuId(): ";
            if (log.isDebug2()) {
                log.debug2("findAuByAuId(): auId = " + auId);
            }
            String pluginKey = null;
            String auKey = null;
            auSeq = null;
            findAu = this.dbManager.prepareStatement(conn, FIND_AU_BY_AU_ID_QUERY);
            resultSet = null;
            try {
                pluginKey = PluginManager.pluginKeyFromAuId((String)auId);
                if (log.isDebug3()) {
                    log.debug3("findAuByAuId(): pluginKey() = " + pluginKey);
                }
                auKey = PluginManager.auKeyFromAuId((String)auId);
                if (log.isDebug3()) {
                    log.debug3("findAuByAuId(): auKey = " + auKey);
                }
                findAu.setString(1, pluginKey);
                findAu.setString(2, auKey);
                resultSet = this.dbManager.executeQuery(findAu);
                if (!resultSet.next()) break block9;
                auSeq = resultSet.getLong("au_seq");
                if (log.isDebug3()) {
                    log.debug3("findAuByAuId(): auSeq = " + auSeq);
                }
            }
            catch (SQLException sqle) {
                try {
                    String message = "Cannot find AU identifier";
                    log.error(message, (Throwable)sqle);
                    log.error("auId = " + auId);
                    log.error("SQL = 'select a.au_seq from au a,plugin p where a.plugin_seq = p.plugin_seq and p.plugin_id = ? and a.au_key = ?'.");
                    log.error("pluginKey = " + pluginKey);
                    log.error("auKey = " + auKey);
                    throw new DbException(message, (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    DbManager.safeCloseResultSet(resultSet);
                    DbManager.safeCloseStatement((Statement)findAu);
                    throw throwable;
                }
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)findAu);
        if (log.isDebug2()) {
            log.debug2("findAuByAuId(): auSeq = " + auSeq);
        }
        return auSeq;
    }

    void updateAuLastExtractionTime(Connection conn, Long auMdSeq, long now) throws DbException {
        String DEBUG_HEADER = "updateAuLastExtractionTime(): ";
        if (log.isDebug2()) {
            log.debug2("updateAuLastExtractionTime(): auMdSeq = " + auMdSeq);
            log.debug2("updateAuLastExtractionTime(): now = " + now);
        }
        PreparedStatement updateAuLastExtractionTime = this.dbManager.prepareStatement(conn, UPDATE_AU_MD_EXTRACT_TIME_QUERY);
        try {
            updateAuLastExtractionTime.setLong(1, now);
            updateAuLastExtractionTime.setLong(2, auMdSeq);
            this.dbManager.executeUpdate(updateAuLastExtractionTime);
        }
        catch (SQLException sqle) {
            String message = "Cannot update the AU extraction time";
            log.error(message, (Throwable)sqle);
            log.error("SQL = 'update au_md set extract_time = ? where au_md_seq = ?'.");
            log.error("auMdSeq = '" + auMdSeq + "'.");
            log.error("now = " + now + ".");
            throw new DbException(message, (Throwable)sqle);
        }
        finally {
            DbManager.safeCloseStatement((Statement)updateAuLastExtractionTime);
        }
        if (log.isDebug2()) {
            log.debug2("updateAuLastExtractionTime(): Done.");
        }
    }

    void removeDisabledFromPendingAus(Connection conn, String auId) throws DbException {
        String DEBUG_HEADER = "removeDisabledFromPendingAus(): ";
        if (log.isDebug2()) {
            log.debug2("removeDisabledFromPendingAus(): auId = " + auId);
        }
        String pluginKey = null;
        String auKey = null;
        PreparedStatement deletePendingAu = this.dbManager.prepareStatement(conn, DELETE_DISABLED_PENDING_AU_QUERY);
        try {
            pluginKey = PluginManager.pluginKeyFromAuId((String)auId);
            auKey = PluginManager.auKeyFromAuId((String)auId);
            deletePendingAu.setString(1, pluginKey);
            deletePendingAu.setString(2, auKey);
            this.dbManager.executeUpdate(deletePendingAu);
        }
        catch (SQLException sqle) {
            String message = "Cannot remove disabled AU from pending table";
            log.error(message, (Throwable)sqle);
            log.error("auId = '" + auId + "'.");
            log.error("SQL = 'delete from pending_au where plugin_id = ? and au_key = ? and priority < 0'.");
            log.error("pluginKey = '" + pluginKey + "'.");
            log.error("auKey = '" + auKey + "'.");
            throw new DbException(message, (Throwable)sqle);
        }
        finally {
            DbManager.safeCloseStatement((Statement)deletePendingAu);
        }
        if (log.isDebug2()) {
            log.debug2("removeDisabledFromPendingAus(): Done.");
        }
    }

    PreparedStatement getInsertPendingAuBatchStatement(Connection conn) throws DbException {
        String DEBUG_HEADER = "getInsertPendingAuBatchStatement(): ";
        if (this.dbManager.isTypeMysql()) {
            if (log.isDebug3()) {
                log.debug3("getInsertPendingAuBatchStatement(): SQL = insert into pending_au(plugin_id,au_key,priority,fully_reindex) values (?,?,(select next_priority from (select coalesce(max(priority), 0) + 1 as next_priority from pending_au where priority >= 0) as temp_pau_table),?)");
            }
            return this.dbManager.prepareStatement(conn, INSERT_ENABLED_PENDING_AU_MYSQL_QUERY);
        }
        if (log.isDebug3()) {
            log.debug3("getInsertPendingAuBatchStatement(): SQL = insert into pending_au(plugin_id,au_key,priority,fully_reindex) values (?,?,(select coalesce(max(priority), 0) + 1 from pending_au where priority >= 0),?)");
        }
        return this.dbManager.prepareStatement(conn, INSERT_ENABLED_PENDING_AU_QUERY);
    }

    PreparedStatement getPrioritizedInsertPendingAuBatchStatement(Connection conn) throws DbException {
        String DEBUG_HEADER = "getPrioritizedInsertPendingAuBatchStatement(): ";
        if (log.isDebug3()) {
            log.debug3("getPrioritizedInsertPendingAuBatchStatement(): SQL = insert into pending_au(plugin_id,au_key,priority,fully_reindex) values (?,?,0,?)");
        }
        return this.dbManager.prepareStatement(conn, INSERT_HIGHEST_PRIORITY_PENDING_AU_QUERY);
    }

    boolean isAuPending(Connection conn, String pluginKey, String auKey) throws DbException {
        String DEBUG_HEADER = "isAuPending(): ";
        if (log.isDebug2()) {
            log.debug2("isAuPending(): pluginKey = " + pluginKey);
            log.debug2("isAuPending(): auKey = " + auKey);
        }
        boolean result = false;
        PreparedStatement selectPendingAu = null;
        ResultSet results = null;
        try {
            selectPendingAu = this.dbManager.prepareStatement(conn, FIND_PENDING_AU_QUERY);
            selectPendingAu.setString(1, pluginKey);
            selectPendingAu.setString(2, auKey);
            results = this.dbManager.executeQuery(selectPendingAu);
            result = results.next();
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot find pending AU";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'select plugin_id,au_key from pending_au where plugin_id = ? and au_key = ?'.");
                log.error("pluginKey = '" + pluginKey + "'.");
                log.error("auKey = '" + auKey + "'.");
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseResultSet(results);
                DbManager.safeCloseStatement((Statement)selectPendingAu);
                throw throwable;
            }
        }
        DbManager.safeCloseResultSet((ResultSet)results);
        DbManager.safeCloseStatement((Statement)selectPendingAu);
        if (log.isDebug2()) {
            log.debug2("isAuPending(): result = " + result);
        }
        return result;
    }

    void addAuToPendingAusBatch(String pluginKey, String auKey, boolean fullReindex, PreparedStatement insertPendingAuBatchStatement) throws SQLException {
        insertPendingAuBatchStatement.setString(1, pluginKey);
        insertPendingAuBatchStatement.setString(2, auKey);
        insertPendingAuBatchStatement.setBoolean(3, fullReindex);
        insertPendingAuBatchStatement.addBatch();
    }

    void addAuBatchToPendingAus(PreparedStatement insertPendingAuBatchStatement) throws SQLException {
        String DEBUG_HEADER = "addAuBatchToPendingAus(): ";
        if (log.isDebug2()) {
            log.debug2("addAuBatchToPendingAus(): Starting...");
        }
        insertPendingAuBatchStatement.executeBatch();
        if (log.isDebug2()) {
            log.debug2("addAuBatchToPendingAus(): Done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getAuMetadataVersion(ArchivalUnit au) {
        String DEBUG_HEADER = "getAuMetadataVersion(): ";
        if (log.isDebug2()) {
            log.debug2("getAuMetadataVersion(): au = " + au);
        }
        int version = -1;
        Connection conn = null;
        try {
            conn = this.dbManager.getConnection();
            version = this.getAuMetadataVersion(conn, au);
        }
        catch (DbException dbe) {
            log.error("Cannot get AU metadata version - Using " + version + ": " + (Object)((Object)dbe));
            log.error("au = '" + au + "'.");
        }
        finally {
            DbManager.safeRollbackAndClose((Connection)conn);
        }
        if (log.isDebug2()) {
            log.debug2("getAuMetadataVersion(): version = " + version);
        }
        return version;
    }

    int getAuMetadataVersion(Connection conn, ArchivalUnit au) throws DbException {
        ResultSet resultSet;
        PreparedStatement selectMetadataVersion;
        int version;
        block9: {
            String DEBUG_HEADER = "getAuMetadataVersion(): ";
            if (log.isDebug2()) {
                log.debug2("getAuMetadataVersion(): au = " + au);
            }
            String pluginKey = null;
            String auKey = null;
            version = -1;
            selectMetadataVersion = null;
            resultSet = null;
            try {
                String auId = au.getAuId();
                pluginKey = PluginManager.pluginKeyFromAuId((String)auId);
                if (log.isDebug3()) {
                    log.debug3("getAuMetadataVersion(): pluginKey() = " + pluginKey);
                }
                auKey = PluginManager.auKeyFromAuId((String)auId);
                if (log.isDebug3()) {
                    log.debug3("getAuMetadataVersion(): auKey = " + auKey);
                }
                selectMetadataVersion = this.dbManager.prepareStatement(conn, FIND_AU_METADATA_VERSION_QUERY);
                selectMetadataVersion.setString(1, pluginKey);
                selectMetadataVersion.setString(2, auKey);
                resultSet = this.dbManager.executeQuery(selectMetadataVersion);
                if (!resultSet.next()) break block9;
                version = resultSet.getShort("md_version");
                if (log.isDebug3()) {
                    log.debug3("getAuMetadataVersion(): version = " + version);
                }
            }
            catch (SQLException sqle) {
                try {
                    String message = "Cannot get AU metadata version";
                    log.error(message, (Throwable)sqle);
                    log.error("au = '" + au + "'.");
                    log.error("SQL = 'select m.md_version from au_md m,au a,plugin p where m.au_seq =  a.au_seq and a.plugin_seq =  p.plugin_seq and p.plugin_id = ? and a.au_key = ?'.");
                    log.error("pluginKey = '" + pluginKey + "'.");
                    log.error("auKey = '" + auKey + "'.");
                    throw new DbException(message, (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    DbManager.safeCloseResultSet(resultSet);
                    DbManager.safeCloseStatement(selectMetadataVersion);
                    throw throwable;
                }
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)selectMetadataVersion);
        if (log.isDebug2()) {
            log.debug2("getAuMetadataVersion(): version = " + version);
        }
        return version;
    }

    boolean needAuFullReindexing(Connection conn, ArchivalUnit au) throws DbException {
        ResultSet resultSet;
        PreparedStatement selectFullReindexing;
        boolean fullReindexing;
        block9: {
            String DEBUG_HEADER = "needAuFullReindexing(): ";
            if (log.isDebug2()) {
                log.debug2("needAuFullReindexing(): au = " + au);
            }
            String auId = au.getAuId();
            String pluginKey = PluginManager.pluginKeyFromAuId((String)auId);
            if (log.isDebug3()) {
                log.debug3("needAuFullReindexing(): pluginKey() = " + pluginKey);
            }
            String auKey = PluginManager.auKeyFromAuId((String)auId);
            if (log.isDebug3()) {
                log.debug3("needAuFullReindexing(): auKey = " + auKey);
            }
            fullReindexing = false;
            selectFullReindexing = null;
            resultSet = null;
            try {
                selectFullReindexing = this.dbManager.prepareStatement(conn, FIND_AU_FULL_REINDEXING_BY_AU_QUERY);
                selectFullReindexing.setString(1, pluginKey);
                selectFullReindexing.setString(2, auKey);
                resultSet = this.dbManager.executeQuery(selectFullReindexing);
                if (!resultSet.next()) break block9;
                fullReindexing = resultSet.getBoolean("fully_reindex");
                if (log.isDebug3()) {
                    log.debug3("needAuFullReindexing(): full reindexing = " + fullReindexing);
                }
            }
            catch (SQLException sqle) {
                try {
                    String message = "Cannot get AU fully reindexing flag";
                    log.error(message, (Throwable)sqle);
                    log.error("au = '" + au + "'.");
                    log.error("SQL = 'select fully_reindex from pending_au where plugin_id = ? and au_key = ?'.");
                    log.error("pluginKey = '" + pluginKey + "'.");
                    log.error("auKey = '" + auKey + "'.");
                    throw new DbException(message, (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    DbManager.safeCloseResultSet(resultSet);
                    DbManager.safeCloseStatement((Statement)selectFullReindexing);
                    throw throwable;
                }
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)selectFullReindexing);
        if (log.isDebug2()) {
            log.debug2("needAuFullReindexing(): fullReindexing = " + fullReindexing);
        }
        return fullReindexing;
    }

    void updateAuFullReindexing(Connection conn, ArchivalUnit au, boolean fullReindexing) throws DbException {
        String DEBUG_HEADER = "updateAuFullReindexing(): ";
        if (log.isDebug2()) {
            log.debug2("updateAuFullReindexing(): au = " + au);
            log.debug2("updateAuFullReindexing(): fullReindexing = " + fullReindexing);
        }
        PreparedStatement updateFullReindexing = null;
        String auId = au.getAuId();
        if (log.isDebug3()) {
            log.debug3("updateAuFullReindexing(): auId = " + auId);
        }
        String pluginKey = PluginManager.pluginKeyFromAuId((String)auId);
        if (log.isDebug3()) {
            log.debug3("updateAuFullReindexing(): pluginKey() = " + pluginKey);
        }
        String auKey = PluginManager.auKeyFromAuId((String)auId);
        if (log.isDebug3()) {
            log.debug3("updateAuFullReindexing(): auKey = " + auKey);
        }
        try {
            updateFullReindexing = this.dbManager.prepareStatement(conn, UPDATE_AU_FULL_REINDEXING_QUERY);
            updateFullReindexing.setBoolean(1, fullReindexing);
            updateFullReindexing.setString(2, pluginKey);
            updateFullReindexing.setString(3, auKey);
            this.dbManager.executeUpdate(updateFullReindexing);
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot set AU fully reindex flag";
                log.error(message, (Throwable)sqle);
                log.error("au = '" + au + "'.");
                log.error("SQL = 'update pending_au set fully_reindex = ? where plugin_id = ? and au_key = ?'.");
                log.error("fullReindexing = '" + fullReindexing + "'.");
                log.error("pluginKey = '" + pluginKey + "'.");
                log.error("auKey = '" + auKey + "'.");
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseStatement(updateFullReindexing);
                throw throwable;
            }
        }
        DbManager.safeCloseStatement((Statement)updateFullReindexing);
        if (log.isDebug2()) {
            log.debug2("updateAuFullReindexing(): Done.");
        }
    }

    long getAuExtractionTime(Connection conn, ArchivalUnit au) throws DbException {
        ResultSet resultSet;
        PreparedStatement selectLastExtractionTime;
        long timestamp;
        block9: {
            String DEBUG_HEADER = "getAuExtractionTime(): ";
            if (log.isDebug2()) {
                log.debug2("getAuExtractionTime(): au = " + au);
            }
            String pluginKey = null;
            String auKey = null;
            timestamp = 0L;
            selectLastExtractionTime = null;
            resultSet = null;
            try {
                String auId = au.getAuId();
                pluginKey = PluginManager.pluginKeyFromAuId((String)auId);
                if (log.isDebug3()) {
                    log.debug3("getAuExtractionTime(): pluginKey() = " + pluginKey);
                }
                auKey = PluginManager.auKeyFromAuId((String)auId);
                if (log.isDebug3()) {
                    log.debug3("getAuExtractionTime(): auKey = " + auKey);
                }
                selectLastExtractionTime = this.dbManager.prepareStatement(conn, FIND_AU_MD_EXTRACT_TIME_BY_AU_QUERY);
                selectLastExtractionTime.setString(1, pluginKey);
                selectLastExtractionTime.setString(2, auKey);
                resultSet = this.dbManager.executeQuery(selectLastExtractionTime);
                if (!resultSet.next()) break block9;
                timestamp = resultSet.getLong("extract_time");
                if (log.isDebug3()) {
                    log.debug3("getAuExtractionTime(): timestamp = " + timestamp);
                }
            }
            catch (SQLException sqle) {
                try {
                    String message = "Cannot get AU extraction time";
                    log.error(message, (Throwable)sqle);
                    log.error("au = '" + au + "'.");
                    log.error("SQL = 'select m.extract_time from au_md m,au a,plugin p where m.au_seq =  a.au_seq and a.plugin_seq =  p.plugin_seq and p.plugin_id = ? and a.au_key = ?'.");
                    log.error("pluginKey = '" + pluginKey + "'.");
                    log.error("auKey = '" + auKey + "'.");
                    throw new DbException(message, (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    DbManager.safeCloseResultSet(resultSet);
                    DbManager.safeCloseStatement(selectLastExtractionTime);
                    throw throwable;
                }
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)selectLastExtractionTime);
        if (log.isDebug2()) {
            log.debug2("getAuExtractionTime(): timestamp = " + timestamp);
        }
        return timestamp;
    }

    void addDisabledAuToPendingAus(Connection conn, String auId) throws DbException {
        String DEBUG_HEADER = "addDisabledAuToPendingAus(): ";
        if (log.isDebug2()) {
            log.debug2("addDisabledAuToPendingAus(): auId = " + auId);
        }
        String pluginKey = null;
        String auKey = null;
        PreparedStatement addPendingAuStatement = this.dbManager.prepareStatement(conn, INSERT_DISABLED_PENDING_AU_QUERY);
        try {
            pluginKey = PluginManager.pluginKeyFromAuId((String)auId);
            if (log.isDebug3()) {
                log.debug3("addDisabledAuToPendingAus(): pluginKey = " + pluginKey);
            }
            auKey = PluginManager.auKeyFromAuId((String)auId);
            if (log.isDebug3()) {
                log.debug3("addDisabledAuToPendingAus(): auKey = " + auKey);
            }
            addPendingAuStatement.setString(1, pluginKey);
            addPendingAuStatement.setString(2, auKey);
            int count = this.dbManager.executeUpdate(addPendingAuStatement);
            if (log.isDebug3()) {
                log.debug3("addDisabledAuToPendingAus(): count = " + count);
            }
        }
        catch (SQLException sqle) {
            String message = "Cannot add disabled pending AU";
            log.error(message, (Throwable)sqle);
            log.error("auId = '" + auId + "'.");
            log.error("SQL = 'insert into platform(platform_seq,platform_name) values (default,?)'.");
            log.error("pluginKey = '" + pluginKey + "'.");
            log.error("auKey = '" + auKey + "'.");
            throw new DbException(message, (Throwable)sqle);
        }
        finally {
            DbManager.safeCloseStatement((Statement)addPendingAuStatement);
        }
        if (log.isDebug2()) {
            log.debug2("addDisabledAuToPendingAus(): Done.");
        }
    }

    void addFailedIndexingAuToPendingAus(Connection conn, String auId) throws DbException {
        String DEBUG_HEADER = "addFailedIndexingAuToPendingAus(): ";
        if (log.isDebug2()) {
            log.debug2("addFailedIndexingAuToPendingAus(): auId = " + auId);
        }
        String pluginKey = null;
        String auKey = null;
        PreparedStatement addPendingAuStatement = this.dbManager.prepareStatement(conn, INSERT_FAILED_INDEXING_PENDING_AU_QUERY);
        try {
            pluginKey = PluginManager.pluginKeyFromAuId((String)auId);
            if (log.isDebug3()) {
                log.debug3("addFailedIndexingAuToPendingAus(): pluginKey = " + pluginKey);
            }
            auKey = PluginManager.auKeyFromAuId((String)auId);
            if (log.isDebug3()) {
                log.debug3("addFailedIndexingAuToPendingAus(): auKey = " + auKey);
            }
            addPendingAuStatement.setString(1, pluginKey);
            addPendingAuStatement.setString(2, auKey);
            int count = this.dbManager.executeUpdate(addPendingAuStatement);
            if (log.isDebug3()) {
                log.debug3("addFailedIndexingAuToPendingAus(): count = " + count);
            }
        }
        catch (SQLException sqle) {
            String message = "Cannot add failed pending AU";
            log.error(message, (Throwable)sqle);
            log.error("auId = '" + auId + "'.");
            log.error("SQL = 'insert into platform(platform_seq,platform_name) values (default,?)'.");
            log.error("pluginKey = '" + pluginKey + "'.");
            log.error("auKey = '" + auKey + "'.");
            throw new DbException(message, (Throwable)sqle);
        }
        finally {
            DbManager.safeCloseStatement((Statement)addPendingAuStatement);
        }
        if (log.isDebug2()) {
            log.debug2("addFailedIndexingAuToPendingAus(): Done.");
        }
    }

    Collection<String> findPendingAusWithPriority(Connection conn, int priority) throws DbException {
        String DEBUG_HEADER = "findPendingAusWithPriority(): ";
        if (log.isDebug2()) {
            log.debug2("findPendingAusWithPriority(): priority = " + priority);
        }
        ArrayList<String> aus = new ArrayList<String>();
        ResultSet results = null;
        PreparedStatement selectAus = this.dbManager.prepareStatement(conn, FIND_PENDING_AUS_WITH_PRIORITY_QUERY);
        try {
            selectAus.setInt(1, priority);
            results = this.dbManager.executeQuery(selectAus);
            while (results.next()) {
                String pluginId = results.getString("plugin_id");
                if (log.isDebug3()) {
                    log.debug3("findPendingAusWithPriority(): pluginId = " + pluginId);
                }
                String auKey = results.getString("au_key");
                if (log.isDebug3()) {
                    log.debug3("findPendingAusWithPriority(): auKey = " + auKey);
                }
                String auId = PluginManager.generateAuId((String)pluginId, (String)auKey);
                if (log.isDebug3()) {
                    log.debug3("findPendingAusWithPriority(): auId = " + auId);
                }
                aus.add(auId);
            }
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot find pending AUs";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'insert into platform(platform_seq,platform_name) values (default,?)'.");
                log.error("priority = '" + priority + "'.");
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseResultSet(results);
                DbManager.safeCloseStatement((Statement)selectAus);
                throw throwable;
            }
        }
        DbManager.safeCloseResultSet((ResultSet)results);
        DbManager.safeCloseStatement((Statement)selectAus);
        if (log.isDebug2()) {
            log.debug2("findPendingAusWithPriority(): aus.size() = " + aus.size());
        }
        return aus;
    }

    Long findAuPublisher(Connection conn, Long auSeq) throws DbException {
        String DEBUG_HEADER = "findAuPublisher(): ";
        if (log.isDebug2()) {
            log.debug2("findAuPublisher(): auSeq = " + auSeq);
        }
        Long publisherSeq = null;
        ResultSet resultSet = null;
        PreparedStatement findPublisher = this.dbManager.prepareStatement(conn, FIND_AU_PUBLISHER_QUERY);
        try {
            findPublisher.setLong(1, auSeq);
            resultSet = this.dbManager.executeQuery(findPublisher);
            if (resultSet.next()) {
                publisherSeq = resultSet.getLong("publisher_seq");
            }
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot find the publisher of an AU";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'select distinct pr.publisher_seq from publisher pr,publication p,md_item m,au_md am where pr.publisher_seq = p.publisher_seq and p.md_item_seq = m.parent_seq and m.au_md_seq = am.au_md_seq and am.au_seq = ?'.");
                log.error("auSeq = '" + auSeq + "'.");
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseResultSet(resultSet);
                DbManager.safeCloseStatement((Statement)findPublisher);
                throw throwable;
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)findPublisher);
        if (log.isDebug2()) {
            log.debug2("findAuPublisher(): publisherSeq = " + publisherSeq);
        }
        return publisherSeq;
    }

    Collection<String> getMdItemAuthors(Connection conn, Long mdItemSeq) throws DbException {
        String DEBUG_HEADER = "getMdItemAuthors(): ";
        if (log.isDebug2()) {
            log.debug2("getMdItemAuthors(): mdItemSeq = " + mdItemSeq);
        }
        ArrayList<String> authors = new ArrayList<String>();
        PreparedStatement findMdItemAuthor = this.dbManager.prepareStatement(conn, FIND_MD_ITEM_AUTHOR_QUERY);
        ResultSet resultSet = null;
        try {
            findMdItemAuthor.setLong(1, mdItemSeq);
            resultSet = this.dbManager.executeQuery(findMdItemAuthor);
            while (resultSet.next()) {
                authors.add(resultSet.getString("author_name"));
            }
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot get the authors of a metadata item";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'select author_name from author where md_item_seq = ?'.");
                log.error("mdItemSeq = '" + mdItemSeq + "'.");
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseResultSet(resultSet);
                DbManager.safeCloseStatement((Statement)findMdItemAuthor);
                throw throwable;
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)findMdItemAuthor);
        if (log.isDebug2()) {
            log.debug2("getMdItemAuthors(): authors = " + authors);
        }
        return authors;
    }

    Collection<String> getMdItemKeywords(Connection conn, Long mdItemSeq) throws DbException {
        String DEBUG_HEADER = "getMdItemKeywords(): ";
        if (log.isDebug2()) {
            log.debug2("getMdItemKeywords(): mdItemSeq = " + mdItemSeq);
        }
        ArrayList<String> keywords = new ArrayList<String>();
        PreparedStatement findMdItemKeyword = this.dbManager.prepareStatement(conn, FIND_MD_ITEM_KEYWORD_QUERY);
        ResultSet resultSet = null;
        try {
            findMdItemKeyword.setLong(1, mdItemSeq);
            resultSet = this.dbManager.executeQuery(findMdItemKeyword);
            while (resultSet.next()) {
                keywords.add(resultSet.getString("keyword"));
            }
        }
        catch (SQLException sqle) {
            try {
                String message = "Cannot get the keywords of a metadata item";
                log.error(message, (Throwable)sqle);
                log.error("SQL = 'select keyword from keyword where md_item_seq = ?'.");
                log.error("mdItemSeq = '" + mdItemSeq + "'.");
                throw new DbException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbManager.safeCloseResultSet(resultSet);
                DbManager.safeCloseStatement((Statement)findMdItemKeyword);
                throw throwable;
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)findMdItemKeyword);
        if (log.isDebug2()) {
            log.debug2("getMdItemKeywords(): keywords = " + keywords);
        }
        return keywords;
    }

    void addMdItemAuthors(Connection conn, Long mdItemSeq, Collection<String> authors) throws DbException {
        String DEBUG_HEADER = "addMdItemAuthors(): ";
        if (log.isDebug2()) {
            log.debug2("addMdItemAuthors(): mdItemSeq = " + mdItemSeq);
            log.debug2("addMdItemAuthors(): authors = " + authors);
        }
        if (authors == null || authors.size() == 0) {
            return;
        }
        String sql = this.getInsertMdItemAuthorSql();
        PreparedStatement insertMdItemAuthor = this.dbManager.prepareStatement(conn, sql);
        try {
            for (String author : authors) {
                insertMdItemAuthor.setLong(1, mdItemSeq);
                insertMdItemAuthor.setString(2, author);
                insertMdItemAuthor.setLong(3, mdItemSeq);
                int count = this.dbManager.executeUpdate(insertMdItemAuthor);
                if (!log.isDebug3()) continue;
                log.debug3("addMdItemAuthors(): count = " + count);
                log.debug3("addMdItemAuthors(): Added author = " + author);
            }
        }
        catch (SQLException sqle) {
            String message = "Cannot add metadata item authors";
            log.error(message, (Throwable)sqle);
            log.error("SQL = '" + sql + "'.");
            log.error("mdItemSeq = '" + mdItemSeq + "'.");
            log.error("authors = " + authors + ".");
            throw new DbException(message, (Throwable)sqle);
        }
        finally {
            DbManager.safeCloseStatement((Statement)insertMdItemAuthor);
        }
        if (log.isDebug2()) {
            log.debug2("addMdItemAuthors(): Done.");
        }
    }

    private String getInsertMdItemAuthorSql() {
        if (this.dbManager.isTypeMysql()) {
            return INSERT_AUTHOR_MYSQL_QUERY;
        }
        return INSERT_AUTHOR_QUERY;
    }

    void addMdItemKeywords(Connection conn, Long mdItemSeq, Collection<String> keywords) throws DbException {
        String DEBUG_HEADER = "addMdItemKeywords(): ";
        if (log.isDebug2()) {
            log.debug2("addMdItemKeywords(): mdItemSeq = " + mdItemSeq);
            log.debug2("addMdItemKeywords(): keywords = " + keywords);
        }
        if (keywords == null || keywords.size() == 0) {
            return;
        }
        PreparedStatement insertMdItemKeyword = this.dbManager.prepareStatement(conn, INSERT_KEYWORD_QUERY);
        try {
            for (String keyword : keywords) {
                insertMdItemKeyword.setLong(1, mdItemSeq);
                insertMdItemKeyword.setString(2, keyword);
                int count = this.dbManager.executeUpdate(insertMdItemKeyword);
                if (!log.isDebug3()) continue;
                log.debug3("addMdItemKeywords(): count = " + count);
                log.debug3("addMdItemKeywords(): Added keyword = " + keyword);
            }
        }
        catch (SQLException sqle) {
            String message = "Cannot add metadata item keywords";
            log.error(message, (Throwable)sqle);
            log.error("SQL = 'insert into keyword(md_item_seq,keyword) values (?,?)'.");
            log.error("mdItemSeq = '" + mdItemSeq + "'.");
            log.error("keywords = " + keywords + ".");
            throw new DbException(message, (Throwable)sqle);
        }
        finally {
            DbManager.safeCloseStatement((Statement)insertMdItemKeyword);
        }
        if (log.isDebug2()) {
            log.debug2("addMdItemKeywords(): Done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void removeFromUnconfiguredAus(Connection conn, String auId) {
        PreparedStatement deleteUnconfiguredAu;
        block11: {
            String DEBUG_HEADER = "removeFromUnconfiguredAus(): ";
            if (log.isDebug2()) {
                log.debug2("removeFromUnconfiguredAus(): auId = " + auId);
            }
            deleteUnconfiguredAu = null;
            String pluginKey = null;
            String auKey = null;
            try {
                if (!this.mdxManager.getMetadataManager().isAuInUnconfiguredAuTable(conn, auId)) break block11;
                deleteUnconfiguredAu = this.dbManager.prepareStatement(conn, DELETE_UNCONFIGURED_AU_QUERY);
                pluginKey = PluginManager.pluginKeyFromAuId((String)auId);
                if (log.isDebug3()) {
                    log.debug3("removeFromUnconfiguredAus(): pluginKey = " + pluginKey);
                }
                auKey = PluginManager.auKeyFromAuId((String)auId);
                if (log.isDebug3()) {
                    log.debug3("removeFromUnconfiguredAus(): auKey = " + auKey);
                }
                deleteUnconfiguredAu.setString(1, pluginKey);
                deleteUnconfiguredAu.setString(2, auKey);
                int count = this.dbManager.executeUpdate(deleteUnconfiguredAu);
                if (log.isDebug3()) {
                    log.debug3("removeFromUnconfiguredAus(): count = " + count);
                }
                DbManager.commitOrRollback((Connection)conn, (Logger)log);
            }
            catch (SQLException sqle) {
                String message = "Cannot delete archival unit from unconfigured table";
                log.error(message, (Throwable)sqle);
                log.error("auId = " + auId);
                log.error("SQL = 'delete from unconfigured_au where plugin_id = ? and au_key = ?'.");
                log.error("pluginKey = " + pluginKey);
                log.error("auKey = " + auKey);
                DbManager.safeCloseStatement((Statement)deleteUnconfiguredAu);
            }
            catch (DbException dbe) {
                String message = "Cannot delete archival unit from unconfigured table";
                log.error(message, (Throwable)dbe);
                log.error("auId = " + auId);
                log.error("SQL = 'delete from unconfigured_au where plugin_id = ? and au_key = ?'.");
                log.error("pluginKey = " + pluginKey);
                log.error("auKey = " + auKey);
                {
                    catch (Throwable throwable) {
                        DbManager.safeCloseStatement(deleteUnconfiguredAu);
                        throw throwable;
                    }
                }
                DbManager.safeCloseStatement((Statement)deleteUnconfiguredAu);
            }
        }
        DbManager.safeCloseStatement(deleteUnconfiguredAu);
        if (log.isDebug2()) {
            log.debug2("removeFromUnconfiguredAus(): Done.");
        }
    }

    public int removeAuChildMetadataItem(Connection conn, Long auMdSeq, Long mdItemSeq) throws DbException {
        String DEBUG_HEADER = "removeAuChildMetadataItem(): ";
        if (log.isDebug2()) {
            log.debug2("removeAuChildMetadataItem(): auMdSeq = " + auMdSeq);
            log.debug2("removeAuChildMetadataItem(): mdItemSeq = " + mdItemSeq);
        }
        int count = 0;
        if (auMdSeq != null && mdItemSeq != null) {
            PreparedStatement deleteMetadataItem = this.dbManager.prepareStatement(conn, DELETE_AU_CHILD_MD_ITEM_QUERY);
            try {
                deleteMetadataItem.setLong(1, auMdSeq);
                deleteMetadataItem.setLong(2, mdItemSeq);
                count = this.dbManager.executeUpdate(deleteMetadataItem);
            }
            catch (SQLException sqle) {
                String message = "Cannot delete child metadata item";
                log.error(message, (Throwable)sqle);
                log.error("mdItemSeq = " + mdItemSeq);
                log.error("SQL = 'delete from md_item where au_md_seq = ? and md_item_seq = ? and parent_seq is not null'.");
                throw new DbException(message, (Throwable)sqle);
            }
            finally {
                DbManager.safeCloseStatement((Statement)deleteMetadataItem);
            }
        }
        if (log.isDebug2()) {
            log.debug2("removeAuChildMetadataItem(): count = " + count);
        }
        return count;
    }

    int removeAuMetadataItems(JdbcContext jdbcCtxt, String auId) throws DbException {
        String DEBUG_HEADER = "removeAuMetadataItems(): ";
        if (log.isDebug2()) {
            log.debug2("removeAuMetadataItems(): auId = " + auId);
        }
        int count = 0;
        Connection conn = jdbcCtxt.getConnection();
        Long auMdSeq = this.findAuMdByAuId(jdbcCtxt, auId);
        if (log.isDebug3()) {
            log.debug3("removeAuMetadataItems(): auMdSeq = " + auMdSeq);
        }
        if (auMdSeq != null) {
            PreparedStatement deleteMetadataItems = this.dbManager.prepareStatement(conn, DELETE_AU_MD_ITEM_QUERY);
            jdbcCtxt.setStatement((Statement)deleteMetadataItems);
            try {
                deleteMetadataItems.setLong(1, auMdSeq);
                count = this.dbManager.executeUpdate(deleteMetadataItems);
            }
            catch (SQLException sqle) {
                String message = "Cannot delete AU metadata items";
                log.error(message, (Throwable)sqle);
                log.error("auId = " + auId);
                log.error("SQL = 'delete from md_item where au_md_seq = ?'.");
                log.error("auMdSeq = " + auMdSeq);
                throw new DbException(message, (Throwable)sqle);
            }
            finally {
                DbManager.safeCloseStatement((Statement)deleteMetadataItems);
            }
        }
        if (log.isDebug2()) {
            log.debug2("removeAuMetadataItems(): count = " + count);
        }
        return count;
    }

    private Long findAuMdByAuId(JdbcContext jdbcCtxt, String auId) throws DbException {
        ResultSet resultSet;
        PreparedStatement findAuMd;
        Long auMdSeq;
        block9: {
            String DEBUG_HEADER = "findAuMdByAuId(): ";
            if (log.isDebug2()) {
                log.debug2("findAuMdByAuId(): auId = " + auId);
            }
            Connection conn = jdbcCtxt.getConnection();
            String pluginKey = null;
            String auKey = null;
            auMdSeq = null;
            findAuMd = this.dbManager.prepareStatement(conn, FIND_AU_MD_BY_AU_ID_QUERY);
            resultSet = null;
            jdbcCtxt.setStatement((Statement)findAuMd);
            try {
                pluginKey = PluginManager.pluginKeyFromAuId((String)auId);
                if (log.isDebug3()) {
                    log.debug3("findAuMdByAuId(): pluginKey() = " + pluginKey);
                }
                auKey = PluginManager.auKeyFromAuId((String)auId);
                if (log.isDebug3()) {
                    log.debug3("findAuMdByAuId(): auKey = " + auKey);
                }
                findAuMd.setString(1, pluginKey);
                findAuMd.setString(2, auKey);
                resultSet = this.dbManager.executeQuery(findAuMd);
                if (!resultSet.next()) break block9;
                auMdSeq = resultSet.getLong("au_md_seq");
                if (log.isDebug3()) {
                    log.debug3("findAuMdByAuId(): auMdSeq = " + auMdSeq);
                }
            }
            catch (SQLException sqle) {
                try {
                    String message = "Cannot find AU metadata identifier";
                    log.error(message, (Throwable)sqle);
                    log.error("auId = " + auId);
                    log.error("SQL = 'select m.au_md_seq from au_md m,au a,plugin p where m.au_seq = a.au_seq and a.plugin_seq = p.plugin_seq and p.plugin_id = ? and a.au_key = ?'.");
                    log.error("pluginKey = " + pluginKey);
                    log.error("auKey = " + auKey);
                    throw new DbException(message, (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    DbManager.safeCloseResultSet(resultSet);
                    DbManager.safeCloseStatement((Statement)findAuMd);
                    throw throwable;
                }
            }
        }
        DbManager.safeCloseResultSet((ResultSet)resultSet);
        DbManager.safeCloseStatement((Statement)findAuMd);
        if (log.isDebug2()) {
            log.debug2("findAuMdByAuId(): auMdSeq = " + auMdSeq);
        }
        return auMdSeq;
    }
}

