package org.lockss.laaws.poller.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.lockss.laaws.poller.model.LinkDesc;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * A summary of a poll in which we are acting just as a voter.
 */
@ApiModel(description = "A summary of a poll in which we are acting just as a voter.")
@Validated

public class VoterSummary   {
  @JsonProperty("auId")
  private String auId = null;

  @JsonProperty("caller")
  private String caller = null;

  @JsonProperty("start")
  private Long start = null;

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("deadline")
  private Long deadline = null;

  @JsonProperty("pollKey")
  private String pollKey = null;

  @JsonProperty("detailLink")
  private LinkDesc detailLink = null;

  public VoterSummary auId(String auId) {
    this.auId = auId;
    return this;
  }

  /**
   * The id for the au being polled.
   * @return auId
  **/
  @ApiModelProperty(required = true, value = "The id for the au being polled.")
  @NotNull


  public String getAuId() {
    return auId;
  }

  public void setAuId(String auId) {
    this.auId = auId;
  }

  public VoterSummary caller(String caller) {
    this.caller = caller;
    return this;
  }

  /**
   * The id of who called the poll.
   * @return caller
  **/
  @ApiModelProperty(required = true, value = "The id of who called the poll.")
  @NotNull


  public String getCaller() {
    return caller;
  }

  public void setCaller(String caller) {
    this.caller = caller;
  }

  public VoterSummary start(Long start) {
    this.start = start;
    return this;
  }

  /**
   * The timestamp for when the poll started.
   * @return start
  **/
  @ApiModelProperty(required = true, value = "The timestamp for when the poll started.")
  @NotNull


  public Long getStart() {
    return start;
  }

  public void setStart(Long start) {
    this.start = start;
  }

  public VoterSummary status(String status) {
    this.status = status;
    return this;
  }

  /**
   * The current status of the poll.
   * @return status
  **/
  @ApiModelProperty(required = true, value = "The current status of the poll.")
  @NotNull


  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public VoterSummary deadline(Long deadline) {
    this.deadline = deadline;
    return this;
  }

  /**
   * The deadline for voting in this poll.
   * @return deadline
  **/
  @ApiModelProperty(required = true, value = "The deadline for voting in this poll.")
  @NotNull


  public Long getDeadline() {
    return deadline;
  }

  public void setDeadline(Long deadline) {
    this.deadline = deadline;
  }

  public VoterSummary pollKey(String pollKey) {
    this.pollKey = pollKey;
    return this;
  }

  /**
   * Key generated by poll manager when poll was created.
   * @return pollKey
  **/
  @ApiModelProperty(required = true, value = "Key generated by poll manager when poll was created.")
  @NotNull


  public String getPollKey() {
    return pollKey;
  }

  public void setPollKey(String pollKey) {
    this.pollKey = pollKey;
  }

  public VoterSummary detailLink(LinkDesc detailLink) {
    this.detailLink = detailLink;
    return this;
  }

  /**
   * Get detailLink
   * @return detailLink
  **/
  @ApiModelProperty(value = "")

  @Valid

  public LinkDesc getDetailLink() {
    return detailLink;
  }

  public void setDetailLink(LinkDesc detailLink) {
    this.detailLink = detailLink;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VoterSummary voterSummary = (VoterSummary) o;
    return Objects.equals(this.auId, voterSummary.auId) &&
        Objects.equals(this.caller, voterSummary.caller) &&
        Objects.equals(this.start, voterSummary.start) &&
        Objects.equals(this.status, voterSummary.status) &&
        Objects.equals(this.deadline, voterSummary.deadline) &&
        Objects.equals(this.pollKey, voterSummary.pollKey) &&
        Objects.equals(this.detailLink, voterSummary.detailLink);
  }

  @Override
  public int hashCode() {
    return Objects.hash(auId, caller, start, status, deadline, pollKey, detailLink);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VoterSummary {\n");
    
    sb.append("    auId: ").append(toIndentedString(auId)).append("\n");
    sb.append("    caller: ").append(toIndentedString(caller)).append("\n");
    sb.append("    start: ").append(toIndentedString(start)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    deadline: ").append(toIndentedString(deadline)).append("\n");
    sb.append("    pollKey: ").append(toIndentedString(pollKey)).append("\n");
    sb.append("    detailLink: ").append(toIndentedString(detailLink)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

