/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.impl;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.lockss.app.LockssApp;
import org.lockss.app.LockssDaemon;
import org.lockss.laaws.poller.api.PollsApiDelegate;
import org.lockss.laaws.poller.impl.Page;
import org.lockss.laaws.poller.model.CachedUriSetSpec;
import org.lockss.laaws.poller.model.LinkDesc;
import org.lockss.laaws.poller.model.PageDesc;
import org.lockss.laaws.poller.model.PeerData;
import org.lockss.laaws.poller.model.PollDesc;
import org.lockss.laaws.poller.model.PollerDetail;
import org.lockss.laaws.poller.model.PollerPager;
import org.lockss.laaws.poller.model.PollerSummary;
import org.lockss.laaws.poller.model.RepairData;
import org.lockss.laaws.poller.model.RepairPager;
import org.lockss.laaws.poller.model.RepairQueue;
import org.lockss.laaws.poller.model.TallyData;
import org.lockss.laaws.poller.model.UrlPager;
import org.lockss.laaws.poller.model.VoterDetail;
import org.lockss.laaws.poller.model.VoterPager;
import org.lockss.laaws.poller.model.VoterSummary;
import org.lockss.laaws.status.model.ApiStatus;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.plugin.CachedUrlSet;
import org.lockss.plugin.PluginManager;
import org.lockss.poller.Poll;
import org.lockss.poller.PollManager;
import org.lockss.poller.PollSpec;
import org.lockss.poller.v3.ParticipantUserData;
import org.lockss.poller.v3.PollerStateBean;
import org.lockss.poller.v3.V3Poller;
import org.lockss.poller.v3.V3Voter;
import org.lockss.poller.v3.VoterUserData;
import org.lockss.protocol.PeerIdentity;
import org.lockss.protocol.psm.PsmInterp;
import org.lockss.protocol.psm.PsmState;
import org.lockss.spring.status.SpringLockssBaseApiController;
import org.lockss.util.ByteArray;
import org.lockss.util.StringUtil;
import org.lockss.util.UrlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class PollsApiServiceImpl
extends SpringLockssBaseApiController
implements PollsApiDelegate {
    private static Logger logger = LoggerFactory.getLogger(PollsApiServiceImpl.class);
    private PollManager pollManager;
    private PluginManager pluginManager;
    private LockssDaemon theDaemon;
    @Autowired
    private HttpServletRequest request;
    private static final String DETAIL_UNAVAILABLE = "Unable to add details link.";

    public ApiStatus getApiStatus() {
        return new ApiStatus("swagger/swagger.yaml").setReady(Boolean.valueOf(LockssApp.getLockssApp().isAppRunning()));
    }

    public ResponseEntity<String> callPoll(PollDesc body) {
        CachedUriSetSpec cuSetSpec;
        String auId;
        ArchivalUnit au;
        block7: {
            au = null;
            auId = body.getAuId();
            cuSetSpec = body.getCuSetSpec();
            if (logger.isDebugEnabled()) {
                logger.debug("request to start a poll for au: " + auId);
            }
            try {
                if (!StringUtil.isNullString((String)auId)) {
                    au = this.getPluginManager().getAuFromId(auId);
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block7;
                logger.error("No valid au: " + auId);
            }
        }
        if (au != null) {
            PollSpec ps = this.pollSpecFromDesc(au, cuSetSpec);
            PollManager pm = this.getPollManager();
            try {
                pm.requestPoll(ps);
            }
            catch (PollManager.NotEligibleException e) {
                logger.error(e.getMessage());
                return new ResponseEntity((Object)e.getMessage(), HttpStatus.FORBIDDEN);
            }
            return new ResponseEntity((Object)auId, HttpStatus.ACCEPTED);
        }
        return new ResponseEntity((Object)("No valid au: " + auId), HttpStatus.NOT_FOUND);
    }

    public ResponseEntity<Void> cancelPoll(String psId) {
        block4: {
            if (logger.isDebugEnabled()) {
                logger.debug("request to cancel poll for " + psId);
            }
            PollManager pm = this.getPollManager();
            try {
                ArchivalUnit au = this.getPluginManager().getAuFromId(psId);
                Poll poll = pm.stopPoll(au);
                if (poll != null) {
                    return new ResponseEntity(HttpStatus.OK);
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug("unable to locate poll with id " + psId);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    public ResponseEntity<PollerSummary> getPollStatus(String psId) {
        block4: {
            if (logger.isDebugEnabled()) {
                logger.debug("request poll info for " + psId);
            }
            try {
                PollManager pm;
                Poll poll;
                ArchivalUnit au = this.getPluginManager().getAuFromId(psId);
                if (au != null && (poll = (pm = this.getPollManager()).getPoll(au.getAuId())) != null) {
                    PollerSummary summary = this.summarizePollerPoll(poll);
                    return new ResponseEntity((Object)summary, HttpStatus.OK);
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug("unable to locate poll with id " + psId);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    public ResponseEntity<PollerDetail> getPollerPollDetails(String pollKey) {
        PollManager pm;
        Poll poll;
        if (logger.isDebugEnabled()) {
            logger.debug("request poller details for poll with " + pollKey);
        }
        if ((poll = (pm = this.getPollManager()).getPoll(pollKey)) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Details for poll " + pollKey + " not found.");
            }
            return new ResponseEntity((Object)new PollerDetail(), HttpStatus.NOT_FOUND);
        }
        PollerDetail detail = this.detailPoll(poll);
        return new ResponseEntity((Object)detail, HttpStatus.OK);
    }

    public ResponseEntity<VoterDetail> getVoterPollDetails(String pollKey) {
        PollManager pm;
        Poll poll;
        if (logger.isDebugEnabled()) {
            logger.debug("request voter details for poll with " + pollKey);
        }
        if ((poll = (pm = this.getPollManager()).getPoll(pollKey)) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Details for poll " + pollKey + " not found.");
            }
            return new ResponseEntity((Object)new VoterDetail(), HttpStatus.NOT_FOUND);
        }
        VoterDetail detail = this.detailVoterPoll(poll);
        return new ResponseEntity((Object)detail, HttpStatus.OK);
    }

    public ResponseEntity<UrlPager> getPollPeerVoteUrls(String pollKey, String peerId, String urls, Integer page, Integer size) {
        ParticipantUserData.VoteCounts voteCounts;
        List participants;
        ParticipantUserData userData;
        PollManager pm = this.getPollManager();
        Poll poll = pm.getPoll(pollKey);
        String baseLink = this.request.getRequestURI();
        if (poll instanceof V3Poller && (userData = this.userDataForPeer(peerId, participants = ((V3Poller)poll).getParticipants())) != null && (voteCounts = userData.getVoteCounts()).hasPeerUrlLists() && userData.hasVoted()) {
            Collection<Object> counts;
            switch (urls) {
                case "agreed": {
                    counts = voteCounts.getAgreedUrls();
                    break;
                }
                case "disagreed": {
                    counts = voteCounts.getDisagreedUrls();
                    break;
                }
                case "pollerOnly": {
                    counts = voteCounts.getPollerOnlyUrls();
                    break;
                }
                case "voterOnly": {
                    counts = voteCounts.getVoterOnlyUrls();
                    break;
                }
                default: {
                    counts = Collections.emptyList();
                }
            }
            if (counts != null) {
                Page strPage = new Page(counts, page, size, baseLink);
                UrlPager pager = this.getUrlPager(strPage);
                return new ResponseEntity((Object)pager, (MultiValueMap)strPage.getPageHeaders(), HttpStatus.OK);
            }
        }
        return new ResponseEntity((Object)new UrlPager(), HttpStatus.NOT_FOUND);
    }

    private UrlPager getUrlPager(Page<String> urlPage) {
        PageDesc desc = this.getPageDesc(urlPage);
        UrlPager pager = new UrlPager();
        pager.setPageDesc(desc);
        pager.setUrls(urlPage.getPageContent());
        return pager;
    }

    public ResponseEntity<RepairPager> getRepairQueueData(String pollKey, String repair, Integer page, Integer size) {
        PollManager pm = this.getPollManager();
        Poll poll = pm.getPoll(pollKey);
        String baseLink = this.request.getRequestURI();
        if (poll instanceof V3Poller) {
            ArrayList repairList;
            PollerStateBean.RepairQueue repairQueue = ((V3Poller)poll).getPollerStateBean().getRepairQueue();
            switch (repair) {
                case "active": {
                    repairList = repairQueue.getActiveRepairs();
                    break;
                }
                case "pending": {
                    repairList = repairQueue.getPendingRepairs();
                    break;
                }
                case "completed": {
                    repairList = repairQueue.getCompletedRepairs();
                    break;
                }
                default: {
                    repairList = new ArrayList();
                }
            }
            if (repairList != null) {
                Page rpage = new Page(repairList, page, size, baseLink);
                PageDesc desc = this.getPageDesc(rpage);
                RepairPager pager = new RepairPager();
                pager.setPageDesc(desc);
                if (rpage.hasContent()) {
                    List rlist = rpage.getPageContent();
                    for (PollerStateBean.Repair rep : rlist) {
                        RepairData rdata = new RepairData();
                        rdata.setRepairUrl(rep.getUrl());
                        rdata.setRepairFrom(rep.getRepairFrom().getIdString());
                        if ("completed".equals(repair)) {
                            rdata.setResult(RepairData.ResultEnum.fromValue((String)rep.getTallyResult().toString()));
                        }
                        pager.addRepairsItem(rdata);
                    }
                }
                return new ResponseEntity((Object)pager, (MultiValueMap)rpage.getPageHeaders(), HttpStatus.OK);
            }
        }
        return new ResponseEntity((Object)new RepairPager(), HttpStatus.NOT_FOUND);
    }

    public ResponseEntity<UrlPager> getTallyUrls(String pollKey, String tally, Integer page, Integer size) {
        PollManager pm = this.getPollManager();
        Poll poll = pm.getPoll(pollKey);
        String baseLink = this.request.getRequestURI();
        if (poll instanceof V3Poller) {
            Set tallySet;
            PollerStateBean.TallyStatus tallyStatus = ((V3Poller)poll).getPollerStateBean().getTallyStatus();
            switch (tally) {
                case "agree": {
                    tallySet = tallyStatus.getAgreedUrls();
                    break;
                }
                case "disagree": {
                    tallySet = tallyStatus.getDisagreedUrls();
                    break;
                }
                case "error": {
                    tallySet = tallyStatus.getErrorUrls().keySet();
                    break;
                }
                case "noQuorum": {
                    tallySet = tallyStatus.getNoQuorumUrls();
                    break;
                }
                case "tooClose": {
                    tallySet = tallyStatus.getTooCloseUrls();
                    break;
                }
                default: {
                    tallySet = new HashSet();
                }
            }
            if (tallySet != null) {
                Page strPage = new Page(tallySet, page, size, baseLink);
                UrlPager pager = this.getUrlPager(strPage);
                return new ResponseEntity((Object)pager, (MultiValueMap)strPage.getPageHeaders(), HttpStatus.OK);
            }
        }
        return new ResponseEntity((Object)new UrlPager(), HttpStatus.NOT_FOUND);
    }

    public ResponseEntity<PollerPager> getPollsAsPoller(Integer size, Integer page) {
        if (logger.isDebugEnabled()) {
            logger.debug("request for  a page " + page + " of voter polls with page size " + size);
        }
        PollManager pm = this.getPollManager();
        Collection pollers = pm.getV3Pollers();
        String baseLink = this.request.getRequestURI();
        Page pollerPage = new Page(pollers, size, page, baseLink);
        PollerPager pager = new PollerPager();
        PageDesc desc = this.getPageDesc(pollerPage);
        pager.setPageDesc(desc);
        if (pollerPage.hasContent()) {
            List pollerList = pollerPage.getPageContent();
            for (V3Poller poll : pollerList) {
                pager.addPollsItem(this.summarizePollerPoll((Poll)poll));
            }
        }
        return new ResponseEntity((Object)pager, (MultiValueMap)pollerPage.getPageHeaders(), HttpStatus.OK);
    }

    public ResponseEntity<VoterPager> getPollsAsVoter(Integer size, Integer page) {
        if (logger.isDebugEnabled()) {
            logger.debug("request for  a page " + page + " of voter polls with page size " + size);
        }
        PollManager pm = this.getPollManager();
        Collection voters = pm.getV3Voters();
        String baseLink = this.request.getRequestURI();
        Page voterPage = new Page(voters, size, page, baseLink);
        VoterPager pager = new VoterPager();
        PageDesc desc = new PageDesc();
        desc.setTotal(Integer.valueOf(voterPage.getTotal()));
        desc.setSize(Integer.valueOf(voterPage.getPageSize()));
        desc.setPage(Integer.valueOf(voterPage.getPageNum()));
        desc.setNextPage(voterPage.getNextLink());
        desc.setPrevPage(voterPage.getPrevLink());
        pager.setPageDesc(desc);
        if (voterPage.hasContent()) {
            List pollerList = voterPage.getPageContent();
            for (V3Voter poll : pollerList) {
                pager.addPollsItem(this.summarizeVoterPoll((Poll)poll));
            }
        }
        return new ResponseEntity((Object)pager, HttpStatus.OK);
    }

    private PollSpec pollSpecFromDesc(ArchivalUnit au, CachedUriSetSpec spec) {
        if (spec == null) {
            CachedUrlSet cus = au.getAuCachedUrlSet();
            return new PollSpec(cus, 3);
        }
        return new PollSpec(au.getAuId(), spec.getUrlPrefix(), spec.getLowerBound(), spec.getUpperBound(), 3);
    }

    private PollDesc pollDescFromSpec(PollSpec pollSpec) {
        PollDesc pollDesc = new PollDesc();
        pollDesc.setAuId(pollSpec.getAuId());
        CachedUriSetSpec cuss = new CachedUriSetSpec();
        cuss.setUrlPrefix(pollSpec.getUrl());
        cuss.setUpperBound(pollSpec.getUprBound());
        cuss.setLowerBound(pollSpec.getLwrBound());
        pollDesc.setCuSetSpec(cuss);
        pollDesc.setPollType(Integer.valueOf(pollSpec.getPollType()));
        pollDesc.setProtocol(Integer.valueOf(pollSpec.getProtocolVersion()));
        pollDesc.setVariant(PollDesc.VariantEnum.fromValue((String)pollSpec.getPollVariant().shortName()));
        return pollDesc;
    }

    private PollerSummary summarizePollerPoll(Poll inPoll) {
        PollerSummary summary = new PollerSummary();
        if (inPoll instanceof V3Poller) {
            V3Poller v3poller = (V3Poller)inPoll;
            PollerStateBean psb = v3poller.getPollerStateBean();
            summary.setPollKey(v3poller.getKey());
            summary.setAuId(v3poller.getAu().getAuId());
            summary.setStatus(V3Poller.POLLER_STATUS_STRINGS[v3poller.getStatus()]);
            summary.setStart(Long.valueOf(v3poller.getCreateTime()));
            summary.setVariant(v3poller.getPollVariant().shortName());
            summary.setDeadline(Long.valueOf(v3poller.getDuration()));
            summary.setPollEnd(Long.valueOf(psb.getPollEnd()));
            summary.setParticipants(Integer.valueOf(v3poller.getParticipants().size()));
            PollerStateBean.TallyStatus ts = psb.getTallyStatus();
            if (ts != null) {
                summary.setNumTalliedUrls(Integer.valueOf(ts.getTalliedUrlCount()));
                summary.setNumAgreeUrls(Integer.valueOf(ts.getAgreedUrlCount()));
                summary.setNumHashErrors(Integer.valueOf(ts.getErrorUrlCount()));
            }
            summary.setNumCompletedRepairs(Integer.valueOf(v3poller.getCompletedRepairs().size()));
            summary.setDetailLink(this.makeDetailLink("poller/" + psb.getPollKey()));
        }
        return summary;
    }

    private VoterSummary summarizeVoterPoll(Poll inPoll) {
        VoterSummary summary = new VoterSummary();
        if (inPoll instanceof V3Voter) {
            V3Voter v3Voter = (V3Voter)inPoll;
            VoterUserData userData = v3Voter.getVoterUserData();
            summary.setAuId(v3Voter.getAu().getAuId());
            summary.setCaller(v3Voter.getPollerId().getIdString());
            summary.setDeadline(Long.valueOf(v3Voter.getDeadline().getExpirationTime()));
            summary.setPollKey(v3Voter.getKey());
            summary.setStart(Long.valueOf(v3Voter.getCreateTime()));
            summary.setStatus(v3Voter.getStatusString());
            summary.setDetailLink(this.makeDetailLink("voter/" + userData.getPollKey()));
        }
        return summary;
    }

    private PollerDetail detailPoll(Poll poll) {
        PollerDetail detail = new PollerDetail();
        if (poll instanceof V3Poller) {
            V3Poller v3poller = (V3Poller)poll;
            PollerStateBean psb = v3poller.getPollerStateBean();
            PollDesc desc = this.pollDescFromSpec(poll.getPollSpec());
            desc.setModulus(Integer.valueOf(psb.getModulus()));
            detail.setPollDesc(desc);
            detail.setPollerId(psb.getPollerId().getIdString());
            detail.setStatus(V3Poller.POLLER_STATUS_STRINGS[psb.getStatus()]);
            detail.setPollKey(psb.getPollKey());
            detail.setCreateTime(Long.valueOf(psb.getCreateTime()));
            detail.setDuration(Long.valueOf(psb.getDuration()));
            detail.setDeadline(Long.valueOf(psb.getPollDeadline()));
            detail.setOuterCircleTarget(Integer.valueOf(psb.getOuterCircleTarget()));
            detail.setHashAlgorithm(psb.getHashAlgorithm());
            detail.setVoteMargin(Integer.valueOf(psb.getVoteMargin()));
            detail.setVoteDeadline(Long.valueOf(psb.getVoteDeadline()));
            detail.setPollEnd(Long.valueOf(psb.getPollEnd()));
            detail.setQuorum(Integer.valueOf(psb.getQuorum()));
            detail.setErrorDetails(psb.getErrorDetail());
            detail.setVoteDuration(Long.valueOf(psb.getVoteDuration()));
            for (PeerIdentity peerId : psb.getNoAuPeers()) {
                detail.addNoAuPeersItem(peerId.getIdString());
            }
            for (ParticipantUserData participantData : v3poller.getParticipants()) {
                detail.addVotedPeersItem(this.peerDataFromParticipantData(participantData, psb.getPollKey()));
            }
            TallyData tallyData = this.tallyDataFromTallyStatus(psb.getTallyStatus(), psb.getPollKey());
            detail.setTally(tallyData);
            RepairQueue repairQueue = this.repairQueueFromDataRepairQueue(psb.getRepairQueue(), psb.getPollKey());
            detail.setRepairQueue(repairQueue);
        }
        return detail;
    }

    private PageDesc getPageDesc(Page page) {
        PageDesc desc = new PageDesc();
        desc.setTotal(Integer.valueOf(page.getTotal()));
        desc.setSize(Integer.valueOf(page.getPageSize()));
        desc.setPage(Integer.valueOf(page.getPageNum()));
        desc.setNextPage(page.getNextLink());
        desc.setPrevPage(page.getPrevLink());
        return desc;
    }

    private VoterDetail detailVoterPoll(Poll poll) {
        VoterDetail detail = new VoterDetail();
        if (poll instanceof V3Voter) {
            V3Voter v3voter = (V3Voter)poll;
            PollDesc desc = this.pollDescFromSpec(v3voter.getPollSpec());
            VoterUserData vud = v3voter.getVoterUserData();
            desc.setModulus(Integer.valueOf(vud.getModulus()));
            detail.setPollDesc(desc);
            detail.setPollerId(v3voter.getPollerId().getIdString());
            detail.setCallerId(v3voter.getCallerID().getIdString());
            detail.setStatus(vud.getStatusString());
            detail.setPollKey(vud.getPollKey());
            detail.setCreateTime(Long.valueOf(vud.getCreateTime()));
            detail.setDuration(Long.valueOf(vud.getDuration()));
            detail.setDeadline(Long.valueOf(vud.getDeadline()));
            detail.setHashAlgorithm(vud.getHashAlgorithm());
            detail.setVoteDeadline(Long.valueOf(vud.getVoteDeadline()));
            detail.setErrorDetails(vud.getErrorDetail());
            if (v3voter.getStatus() == 5) {
                if (vud.hasReceivedHint()) {
                    detail.setAgreement(Double.valueOf(vud.getAgreementHint()));
                }
                if (vud.hasReceivedWeightedHint()) {
                    detail.setWtAgreement(Double.valueOf(vud.getWeightedAgreementHint()));
                }
                if (vud.hasReceivedSymmetricAgreement()) {
                    detail.setSymmetricAgreement(Double.valueOf(vud.getSymmetricAgreement()));
                }
                if (vud.hasReceivedSymmetricWeightedAgreement()) {
                    detail.setWtSymmetricAgreement(Double.valueOf(vud.getSymmetricAgreement()));
                }
            }
            detail.setPollerNonce(ByteArray.toBase64((byte[])vud.getPollerNonce()));
            detail.setVoterNonce(ByteArray.toBase64((byte[])vud.getVoterNonce()));
            if (vud.isSymmetricPoll()) {
                detail.setVoter2Nonce(ByteArray.toBase64((byte[])vud.getVoterNonce2()));
                if (v3voter.getStatus() == 5) {
                    detail.setNumAgree(Integer.valueOf(vud.getNumAgreeUrl()));
                    detail.setNumDisagree(Integer.valueOf(vud.getNumDisagreeUrl()));
                    detail.setNumPollerOnly(Integer.valueOf(vud.getNumPollerOnlyUrl()));
                    detail.setNumVoterOnly(Integer.valueOf(vud.getNumVoterOnlyUrl()));
                }
            }
        }
        return detail;
    }

    private PeerData peerDataFromParticipantData(ParticipantUserData voter, String pollKey) {
        PsmState state;
        PeerData peerData = new PeerData();
        peerData.setPeerId(voter.getVoterId().getIdString());
        peerData.setStatus(voter.getStatusString());
        peerData.setAgreement(Float.valueOf(voter.getPercentAgreement()));
        ParticipantUserData.VoteCounts voteCounts = voter.getVoteCounts();
        peerData.setNumAgree(Long.valueOf(voteCounts.getAgreedVotes()));
        peerData.setNumDisagree(Long.valueOf(voteCounts.getDisagreedVotes()));
        peerData.setNumPollerOnly(Long.valueOf(voteCounts.getPollerOnlyVotes()));
        peerData.setNumVoterOnly(Long.valueOf(voteCounts.getVoterOnlyVotes()));
        peerData.setBytesHashed(Long.valueOf(voter.getBytesHashed()));
        peerData.setBytesRead(Long.valueOf(voter.getBytesRead()));
        peerData.setWtAgreement(Float.valueOf(voteCounts.getWeightedPercentAgreement()));
        peerData.setWtNumDisagree(Float.valueOf(voteCounts.getWeightedDisagreedVotes()));
        peerData.setWtNumPollerOnly(Float.valueOf(voteCounts.getWeightedPollerOnlyVotes()));
        peerData.setWtNumVoterOnly(Float.valueOf(voteCounts.getWeightedVoterOnlyVotes()));
        PsmInterp interp = voter.getPsmInterp();
        if (interp != null && (state = interp.getCurrentState()) != null) {
            peerData.setState(state.getName());
            long when = interp.getLastStateChange();
            if (when > 0L) {
                peerData.setLastStateChange(Long.valueOf(when));
            }
        }
        String peerId = peerData.getPeerId();
        peerData.setAgreeLink(this.makePeerLink(pollKey, peerId, "agree"));
        peerData.setDisagreeLink(this.makePeerLink(pollKey, peerId, "disagree"));
        peerData.setPollerOnlyLink(this.makePeerLink(pollKey, peerId, "pollerOnly"));
        peerData.setVoterOnlyLink(this.makePeerLink(pollKey, peerId, "voterOnly"));
        return peerData;
    }

    private RepairQueue repairQueueFromDataRepairQueue(PollerStateBean.RepairQueue inQueue, String pollKey) {
        RepairQueue outQueue = new RepairQueue();
        outQueue.setNumActive(Integer.valueOf(inQueue.getActiveRepairs().size()));
        outQueue.setNumPending(Integer.valueOf(inQueue.getPendingRepairs().size()));
        outQueue.setNumCompleted(Integer.valueOf(inQueue.getCompletedRepairs().size()));
        outQueue.setActiveLink(this.makeRepairQLink(pollKey, "active"));
        outQueue.setCompletedLink(this.makeRepairQLink(pollKey, "completed"));
        outQueue.setPendingLink(this.makeRepairQLink(pollKey, "pending"));
        return outQueue;
    }

    private TallyData tallyDataFromTallyStatus(PollerStateBean.TallyStatus tallyStatus, String pollKey) {
        TallyData tallyData = new TallyData();
        tallyData.setNumAgree(Integer.valueOf(tallyStatus.getAgreedUrlCount()));
        tallyData.setNumDisagree(Integer.valueOf(tallyStatus.getDisgreedUrlCount()));
        tallyData.setNumNoQuorum(Integer.valueOf(tallyStatus.getNoQuorumUrlCount()));
        tallyData.setNumTooClose(Integer.valueOf(tallyStatus.getTooCloseUrlCount()));
        tallyData.setNumError(Integer.valueOf(tallyStatus.getErrorUrlCount()));
        tallyData.setWtAgreed(Float.valueOf(tallyStatus.getWeightedAgreedCount()));
        tallyData.setWtDisagreed(Float.valueOf(tallyStatus.getWeightedDisagreedCount()));
        tallyData.setWtNoQuorum(Float.valueOf(tallyStatus.getWeightedNoQuorumCount()));
        tallyData.setWtTooClose(Float.valueOf(tallyStatus.getWeightedTooCloseCount()));
        tallyData.setAgreeLink(this.makeTallyLink(pollKey, "agree"));
        tallyData.setDisagreeLink(this.makeTallyLink(pollKey, "disagree"));
        tallyData.setNoQuorumLink(this.makeTallyLink(pollKey, "noQuorum"));
        tallyData.setTooCloseLink(this.makeTallyLink(pollKey, "tooClose"));
        tallyData.setErrorLink(this.makeTallyLink(pollKey, "error"));
        return tallyData;
    }

    private LinkDesc makeDetailLink(String pollKey) {
        try {
            String prefix = UrlUtil.getUrlPrefix((String)this.request.getRequestURI());
            LinkDesc ldesc = new LinkDesc();
            ldesc.setLink(prefix + "/polls/" + pollKey + "/details");
            return ldesc;
        }
        catch (MalformedURLException e) {
            logger.error(DETAIL_UNAVAILABLE);
            return null;
        }
    }

    private LinkDesc makeTallyLink(String pollKey, String tallyType) {
        try {
            String prefix = UrlUtil.getUrlPrefix((String)this.request.getRequestURI());
            LinkDesc ldesc = new LinkDesc();
            ldesc.setLink(prefix + "/polls/" + pollKey + "/tally?tally=" + tallyType);
            return ldesc;
        }
        catch (MalformedURLException e) {
            logger.error(DETAIL_UNAVAILABLE);
            return null;
        }
    }

    private LinkDesc makeRepairQLink(String pollKey, String repairType) {
        try {
            String prefix = UrlUtil.getUrlPrefix((String)this.request.getRequestURI());
            LinkDesc ldesc = new LinkDesc();
            ldesc.setLink(prefix + "/polls/" + pollKey + "/repairs?repair=" + repairType);
            return ldesc;
        }
        catch (MalformedURLException e) {
            logger.error(DETAIL_UNAVAILABLE);
            return null;
        }
    }

    private LinkDesc makePeerLink(String pollKey, String peerId, String tallyType) {
        try {
            String prefix = UrlUtil.getUrlPrefix((String)this.request.getRequestURI());
            LinkDesc ldesc = new LinkDesc();
            ldesc.setLink(prefix + "/polls/" + pollKey + "/peer/" + peerId + "?tally=" + tallyType);
            return ldesc;
        }
        catch (MalformedURLException e) {
            logger.error(DETAIL_UNAVAILABLE);
            return null;
        }
    }

    private ParticipantUserData userDataForPeer(String peerId, List<ParticipantUserData> participants) {
        if (peerId == null || participants == null || participants.isEmpty()) {
            return null;
        }
        for (ParticipantUserData userData : participants) {
            if (!userData.getVoterId().getIdString().equals(peerId)) continue;
            return userData;
        }
        return null;
    }

    LockssDaemon getLockssDaemon() {
        if (this.theDaemon == null) {
            this.theDaemon = LockssDaemon.getLockssDaemon();
        }
        return this.theDaemon;
    }

    PollManager getPollManager() {
        if (this.pollManager == null) {
            this.pollManager = this.getLockssDaemon().getPollManager();
        }
        return this.pollManager;
    }

    PluginManager getPluginManager() {
        if (this.pluginManager == null) {
            this.pluginManager = this.getLockssDaemon().getPluginManager();
        }
        return this.pluginManager;
    }
}

