/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.lockss.laaws.poller.model.CachedUriSetSpec;
import org.lockss.laaws.poller.model.PollDesc;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="The Poller Services poll spec used to define a poll.")
@Validated
public class PollDesc {
    @JsonProperty(value="auId")
    private String auId = null;
    @JsonProperty(value="cuSetSpec")
    private CachedUriSetSpec cuSetSpec = null;
    @JsonProperty(value="pollType")
    private Integer pollType = null;
    @JsonProperty(value="protocol")
    private Integer protocol = null;
    @JsonProperty(value="pluginPollVersion")
    private String pluginPollVersion = null;
    @JsonProperty(value="variant")
    private VariantEnum variant = null;
    @JsonProperty(value="modulus")
    private Integer modulus = null;

    public PollDesc auId(String auId) {
        this.auId = auId;
        return this;
    }

    @ApiModelProperty(required=true, value="The id which defines the poll")
    @NotNull
    public String getAuId() {
        return this.auId;
    }

    public void setAuId(String auId) {
        this.auId = auId;
    }

    public PollDesc cuSetSpec(CachedUriSetSpec cuSetSpec) {
        this.cuSetSpec = cuSetSpec;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public CachedUriSetSpec getCuSetSpec() {
        return this.cuSetSpec;
    }

    public void setCuSetSpec(CachedUriSetSpec cuSetSpec) {
        this.cuSetSpec = cuSetSpec;
    }

    public PollDesc pollType(Integer pollType) {
        this.pollType = pollType;
        return this;
    }

    @ApiModelProperty(value="The type of poll to run. Only V3 is supported.")
    @Min(value=3L)
    public Integer getPollType() {
        return this.pollType;
    }

    public void setPollType(Integer pollType) {
        this.pollType = pollType;
    }

    public PollDesc protocol(Integer protocol) {
        this.protocol = protocol;
        return this;
    }

    @ApiModelProperty(value="The version of polling protocol.")
    public Integer getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Integer protocol) {
        this.protocol = protocol;
    }

    public PollDesc pluginPollVersion(String pluginPollVersion) {
        this.pluginPollVersion = pluginPollVersion;
        return this;
    }

    @ApiModelProperty(value="The version of the polling features needed by the plugin.")
    public String getPluginPollVersion() {
        return this.pluginPollVersion;
    }

    public void setPluginPollVersion(String pluginPollVersion) {
        this.pluginPollVersion = pluginPollVersion;
    }

    public PollDesc variant(VariantEnum variant) {
        this.variant = variant;
        return this;
    }

    @ApiModelProperty(value="The V3 poll variation.")
    public VariantEnum getVariant() {
        return this.variant;
    }

    public void setVariant(VariantEnum variant) {
        this.variant = variant;
    }

    public PollDesc modulus(Integer modulus) {
        this.modulus = modulus;
        return this;
    }

    @ApiModelProperty(value="Poll on every 'n'th url.")
    public Integer getModulus() {
        return this.modulus;
    }

    public void setModulus(Integer modulus) {
        this.modulus = modulus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PollDesc pollDesc = (PollDesc)o;
        return Objects.equals(this.auId, pollDesc.auId) && Objects.equals(this.cuSetSpec, pollDesc.cuSetSpec) && Objects.equals(this.pollType, pollDesc.pollType) && Objects.equals(this.protocol, pollDesc.protocol) && Objects.equals(this.pluginPollVersion, pollDesc.pluginPollVersion) && Objects.equals(this.variant, pollDesc.variant) && Objects.equals(this.modulus, pollDesc.modulus);
    }

    public int hashCode() {
        return Objects.hash(this.auId, this.cuSetSpec, this.pollType, this.protocol, this.pluginPollVersion, this.variant, this.modulus);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PollDesc {\n");
        sb.append("    auId: ").append(this.toIndentedString((Object)this.auId)).append("\n");
        sb.append("    cuSetSpec: ").append(this.toIndentedString((Object)this.cuSetSpec)).append("\n");
        sb.append("    pollType: ").append(this.toIndentedString((Object)this.pollType)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString((Object)this.protocol)).append("\n");
        sb.append("    pluginPollVersion: ").append(this.toIndentedString((Object)this.pluginPollVersion)).append("\n");
        sb.append("    variant: ").append(this.toIndentedString((Object)this.variant)).append("\n");
        sb.append("    modulus: ").append(this.toIndentedString((Object)this.modulus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

