/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.lockss.laaws.poller.model.LinkDesc;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="The tally for the current poll.")
@Validated
public class TallyData {
    @JsonProperty(value="numAgree")
    private Integer numAgree = null;
    @JsonProperty(value="agreeLink")
    private LinkDesc agreeLink = null;
    @JsonProperty(value="numDisagree")
    private Integer numDisagree = null;
    @JsonProperty(value="disagreeLink")
    private LinkDesc disagreeLink = null;
    @JsonProperty(value="numTooClose")
    private Integer numTooClose = null;
    @JsonProperty(value="tooCloseLink")
    private LinkDesc tooCloseLink = null;
    @JsonProperty(value="numNoQuorum")
    private Integer numNoQuorum = null;
    @JsonProperty(value="noQuorumLink")
    private LinkDesc noQuorumLink = null;
    @JsonProperty(value="numError")
    private Integer numError = null;
    @JsonProperty(value="errorLink")
    private LinkDesc errorLink = null;
    @JsonProperty(value="wtAgreed")
    private Float wtAgreed = Float.valueOf(0.0f);
    @JsonProperty(value="wtDisagreed")
    private Float wtDisagreed = Float.valueOf(0.0f);
    @JsonProperty(value="wtTooClose")
    private Float wtTooClose = Float.valueOf(0.0f);
    @JsonProperty(value="wtNoQuorum")
    private Float wtNoQuorum = Float.valueOf(0.0f);

    public TallyData numAgree(Integer numAgree) {
        this.numAgree = numAgree;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of urls with agreement.")
    @NotNull
    public Integer getNumAgree() {
        return this.numAgree;
    }

    public void setNumAgree(Integer numAgree) {
        this.numAgree = numAgree;
    }

    public TallyData agreeLink(LinkDesc agreeLink) {
        this.agreeLink = agreeLink;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public LinkDesc getAgreeLink() {
        return this.agreeLink;
    }

    public void setAgreeLink(LinkDesc agreeLink) {
        this.agreeLink = agreeLink;
    }

    public TallyData numDisagree(Integer numDisagree) {
        this.numDisagree = numDisagree;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of urls with disagreement.")
    @NotNull
    public Integer getNumDisagree() {
        return this.numDisagree;
    }

    public void setNumDisagree(Integer numDisagree) {
        this.numDisagree = numDisagree;
    }

    public TallyData disagreeLink(LinkDesc disagreeLink) {
        this.disagreeLink = disagreeLink;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public LinkDesc getDisagreeLink() {
        return this.disagreeLink;
    }

    public void setDisagreeLink(LinkDesc disagreeLink) {
        this.disagreeLink = disagreeLink;
    }

    public TallyData numTooClose(Integer numTooClose) {
        this.numTooClose = numTooClose;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of urls too close.")
    @NotNull
    public Integer getNumTooClose() {
        return this.numTooClose;
    }

    public void setNumTooClose(Integer numTooClose) {
        this.numTooClose = numTooClose;
    }

    public TallyData tooCloseLink(LinkDesc tooCloseLink) {
        this.tooCloseLink = tooCloseLink;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public LinkDesc getTooCloseLink() {
        return this.tooCloseLink;
    }

    public void setTooCloseLink(LinkDesc tooCloseLink) {
        this.tooCloseLink = tooCloseLink;
    }

    public TallyData numNoQuorum(Integer numNoQuorum) {
        this.numNoQuorum = numNoQuorum;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of urls without enough voters.")
    @NotNull
    public Integer getNumNoQuorum() {
        return this.numNoQuorum;
    }

    public void setNumNoQuorum(Integer numNoQuorum) {
        this.numNoQuorum = numNoQuorum;
    }

    public TallyData noQuorumLink(LinkDesc noQuorumLink) {
        this.noQuorumLink = noQuorumLink;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public LinkDesc getNoQuorumLink() {
        return this.noQuorumLink;
    }

    public void setNoQuorumLink(LinkDesc noQuorumLink) {
        this.noQuorumLink = noQuorumLink;
    }

    public TallyData numError(Integer numError) {
        this.numError = numError;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of urls without errors.")
    @NotNull
    public Integer getNumError() {
        return this.numError;
    }

    public void setNumError(Integer numError) {
        this.numError = numError;
    }

    public TallyData errorLink(LinkDesc errorLink) {
        this.errorLink = errorLink;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public LinkDesc getErrorLink() {
        return this.errorLink;
    }

    public void setErrorLink(LinkDesc errorLink) {
        this.errorLink = errorLink;
    }

    public TallyData wtAgreed(Float wtAgreed) {
        this.wtAgreed = wtAgreed;
        return this;
    }

    @ApiModelProperty(value="The weighted sum agreed uris.")
    public Float getWtAgreed() {
        return this.wtAgreed;
    }

    public void setWtAgreed(Float wtAgreed) {
        this.wtAgreed = wtAgreed;
    }

    public TallyData wtDisagreed(Float wtDisagreed) {
        this.wtDisagreed = wtDisagreed;
        return this;
    }

    @ApiModelProperty(value="The weighted sum of disagree uris.")
    public Float getWtDisagreed() {
        return this.wtDisagreed;
    }

    public void setWtDisagreed(Float wtDisagreed) {
        this.wtDisagreed = wtDisagreed;
    }

    public TallyData wtTooClose(Float wtTooClose) {
        this.wtTooClose = wtTooClose;
        return this;
    }

    @ApiModelProperty(value="The sum of the tooClose uris.")
    public Float getWtTooClose() {
        return this.wtTooClose;
    }

    public void setWtTooClose(Float wtTooClose) {
        this.wtTooClose = wtTooClose;
    }

    public TallyData wtNoQuorum(Float wtNoQuorum) {
        this.wtNoQuorum = wtNoQuorum;
        return this;
    }

    @ApiModelProperty(value="The weighted sum of NoQuorum uris.")
    public Float getWtNoQuorum() {
        return this.wtNoQuorum;
    }

    public void setWtNoQuorum(Float wtNoQuorum) {
        this.wtNoQuorum = wtNoQuorum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TallyData tallyData = (TallyData)o;
        return Objects.equals(this.numAgree, tallyData.numAgree) && Objects.equals(this.agreeLink, tallyData.agreeLink) && Objects.equals(this.numDisagree, tallyData.numDisagree) && Objects.equals(this.disagreeLink, tallyData.disagreeLink) && Objects.equals(this.numTooClose, tallyData.numTooClose) && Objects.equals(this.tooCloseLink, tallyData.tooCloseLink) && Objects.equals(this.numNoQuorum, tallyData.numNoQuorum) && Objects.equals(this.noQuorumLink, tallyData.noQuorumLink) && Objects.equals(this.numError, tallyData.numError) && Objects.equals(this.errorLink, tallyData.errorLink) && Objects.equals(this.wtAgreed, tallyData.wtAgreed) && Objects.equals(this.wtDisagreed, tallyData.wtDisagreed) && Objects.equals(this.wtTooClose, tallyData.wtTooClose) && Objects.equals(this.wtNoQuorum, tallyData.wtNoQuorum);
    }

    public int hashCode() {
        return Objects.hash(this.numAgree, this.agreeLink, this.numDisagree, this.disagreeLink, this.numTooClose, this.tooCloseLink, this.numNoQuorum, this.noQuorumLink, this.numError, this.errorLink, this.wtAgreed, this.wtDisagreed, this.wtTooClose, this.wtNoQuorum);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TallyData {\n");
        sb.append("    numAgree: ").append(this.toIndentedString((Object)this.numAgree)).append("\n");
        sb.append("    agreeLink: ").append(this.toIndentedString((Object)this.agreeLink)).append("\n");
        sb.append("    numDisagree: ").append(this.toIndentedString((Object)this.numDisagree)).append("\n");
        sb.append("    disagreeLink: ").append(this.toIndentedString((Object)this.disagreeLink)).append("\n");
        sb.append("    numTooClose: ").append(this.toIndentedString((Object)this.numTooClose)).append("\n");
        sb.append("    tooCloseLink: ").append(this.toIndentedString((Object)this.tooCloseLink)).append("\n");
        sb.append("    numNoQuorum: ").append(this.toIndentedString((Object)this.numNoQuorum)).append("\n");
        sb.append("    noQuorumLink: ").append(this.toIndentedString((Object)this.noQuorumLink)).append("\n");
        sb.append("    numError: ").append(this.toIndentedString((Object)this.numError)).append("\n");
        sb.append("    errorLink: ").append(this.toIndentedString((Object)this.errorLink)).append("\n");
        sb.append("    wtAgreed: ").append(this.toIndentedString((Object)this.wtAgreed)).append("\n");
        sb.append("    wtDisagreed: ").append(this.toIndentedString((Object)this.wtDisagreed)).append("\n");
        sb.append("    wtTooClose: ").append(this.toIndentedString((Object)this.wtTooClose)).append("\n");
        sb.append("    wtNoQuorum: ").append(this.toIndentedString((Object)this.wtNoQuorum)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

