/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="A set of urls bounded by  upper and lower restraints.  If lower = \".\" this is a singleContentNode. If lower is null then start at the root url, if upper is null end with the last.")
@Validated
public class CachedUriSetSpec {
    @JsonProperty(value="urlPrefix")
    private String urlPrefix = null;
    @JsonProperty(value="lowerBound")
    private String lowerBound = null;
    @JsonProperty(value="upperBound")
    private String upperBound = null;

    public CachedUriSetSpec urlPrefix(String urlPrefix) {
        this.urlPrefix = urlPrefix;
        return this;
    }

    @ApiModelProperty(required=true, value="The base which roots the lower and upper bound")
    @NotNull
    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public void setUrlPrefix(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }

    public CachedUriSetSpec lowerBound(String lowerBound) {
        this.lowerBound = lowerBound;
        return this;
    }

    @ApiModelProperty(value="lower bound of the prefix range, inclusive.")
    public String getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(String lowerBound) {
        this.lowerBound = lowerBound;
    }

    public CachedUriSetSpec upperBound(String upperBound) {
        this.upperBound = upperBound;
        return this;
    }

    @ApiModelProperty(value="upper bound of prefix range, inclusive.")
    public String getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(String upperBound) {
        this.upperBound = upperBound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachedUriSetSpec cachedUriSetSpec = (CachedUriSetSpec)o;
        return Objects.equals(this.urlPrefix, cachedUriSetSpec.urlPrefix) && Objects.equals(this.lowerBound, cachedUriSetSpec.lowerBound) && Objects.equals(this.upperBound, cachedUriSetSpec.upperBound);
    }

    public int hashCode() {
        return Objects.hash(this.urlPrefix, this.lowerBound, this.upperBound);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CachedUriSetSpec {\n");
        sb.append("    urlPrefix: ").append(this.toIndentedString((Object)this.urlPrefix)).append("\n");
        sb.append("    lowerBound: ").append(this.toIndentedString((Object)this.lowerBound)).append("\n");
        sb.append("    upperBound: ").append(this.toIndentedString((Object)this.upperBound)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

