/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.lockss.laaws.poller.model.PageDesc;
import org.lockss.laaws.poller.model.PollerSummary;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="A page of poller poll summaries.")
@Validated
public class PollerPager {
    @JsonProperty(value="pageDesc")
    private PageDesc pageDesc = null;
    @JsonProperty(value="polls")
    @Valid
    private List<PollerSummary> polls = null;

    public PollerPager pageDesc(PageDesc pageDesc) {
        this.pageDesc = pageDesc;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public PageDesc getPageDesc() {
        return this.pageDesc;
    }

    public void setPageDesc(PageDesc pageDesc) {
        this.pageDesc = pageDesc;
    }

    public PollerPager polls(List<PollerSummary> polls) {
        this.polls = polls;
        return this;
    }

    public PollerPager addPollsItem(PollerSummary pollsItem) {
        if (this.polls == null) {
            this.polls = new ArrayList<PollerSummary>();
        }
        this.polls.add(pollsItem);
        return this;
    }

    @ApiModelProperty(value="The list of polls for the current page or null")
    @Valid
    public List<PollerSummary> getPolls() {
        return this.polls;
    }

    public void setPolls(List<PollerSummary> polls) {
        this.polls = polls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PollerPager pollerPager = (PollerPager)o;
        return Objects.equals(this.pageDesc, pollerPager.pageDesc) && Objects.equals(this.polls, pollerPager.polls);
    }

    public int hashCode() {
        return Objects.hash(this.pageDesc, this.polls);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PollerPager {\n");
        sb.append("    pageDesc: ").append(this.toIndentedString(this.pageDesc)).append("\n");
        sb.append("    polls: ").append(this.toIndentedString(this.polls)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

