/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.lockss.laaws.poller.api.HashesApi;
import org.lockss.ws.entities.HasherWsParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public interface HashesApiDelegate {
    public static final Logger log = LoggerFactory.getLogger(HashesApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    default public ResponseEntity<String> deleteHash(String requestId) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (((String)this.getAcceptHeader().get()).contains("application/json")) {
                try {
                    return new ResponseEntity(((ObjectMapper)this.getObjectMapper().get()).readValue("\"\"", String.class), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default HashesApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<Resource> getAllHashes() {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (((String)this.getAcceptHeader().get()).contains("")) {
                try {
                    return new ResponseEntity(((ObjectMapper)this.getObjectMapper().get()).readValue("", Resource.class), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type ", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default HashesApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<Resource> getHash(String requestId) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (((String)this.getAcceptHeader().get()).contains("")) {
                try {
                    return new ResponseEntity(((ObjectMapper)this.getObjectMapper().get()).readValue("", Resource.class), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type ", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default HashesApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    default public ResponseEntity<Resource> putHash(HasherWsParams hasherWsParams, Boolean isAsynchronous) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (((String)this.getAcceptHeader().get()).contains("")) {
                try {
                    return new ResponseEntity(((ObjectMapper)this.getObjectMapper().get()).readValue("", Resource.class), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type ", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default HashesApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

