/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.lockss.laaws.poller.api.RepositoryspacesApiDelegate;
import org.lockss.ws.entities.RepositorySpaceWsResult;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="repositoryspaces", description="the repositoryspaces API")
public interface RepositoryspacesApi {
    public RepositoryspacesApiDelegate getDelegate();

    @ApiOperation(value="Query the properties of repository spaces", nickname="getRepositorySpaces", notes="Query the system for selected repository space properties", response=RepositorySpaceWsResult.class, responseContainer="List", authorizations={@Authorization(value="basicAuth")}, tags={"repo"})
    @ApiResponses(value={@ApiResponse(code=200, message="Information about the requested TDB AUs", response=RepositorySpaceWsResult.class, responseContainer="List"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    @RequestMapping(value={"/repositoryspaces"}, produces={"application/json"}, method={RequestMethod.GET})
    default public ResponseEntity<List<RepositorySpaceWsResult>> getRepositorySpaces(@NotNull @ApiParam(value="The query that specifies the repository space properties to be returned", required=true) @Valid @RequestParam(value="repositorySpaceQuery", required=true) String repositorySpaceQuery) {
        return this.getDelegate().getRepositorySpaces(repositorySpaceQuery);
    }
}

