/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.impl;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.lockss.config.ConfigManager;
import org.lockss.protocol.PeerIdentityStatus;
import org.lockss.protocol.V3LcapMessage;
import org.lockss.ws.entities.PeerWsResult;

public class PeerWsSource
extends PeerWsResult {
    private PeerIdentityStatus piStatus;
    private boolean peerIdPopulated = false;
    private boolean lastMessagePopulated = false;
    private boolean messageTypePopulated = false;
    private boolean messageCountPopulated = false;
    private boolean lastPollPopulated = false;
    private boolean lastVotePopulated = false;
    private boolean lastInvitationPopulated = false;
    private boolean invitationCountPopulated = false;
    private boolean pollsCalledPopulated = false;
    private boolean votesCastPopulated = false;
    private boolean pollsRejectedPopulated = false;
    private boolean nakReasonPopulated = false;
    private boolean groupsPopulated = false;
    private boolean platformGroupMatchPopulated = false;
    private static List<String> platformGroups = ConfigManager.getPlatformGroupList();

    public PeerWsSource(PeerIdentityStatus piStatus) {
        this.piStatus = piStatus;
    }

    public String getPeerId() {
        if (!this.peerIdPopulated) {
            this.setPeerId(this.piStatus.getPeerIdentity().getIdString());
            this.peerIdPopulated = true;
        }
        return super.getPeerId();
    }

    public Long getLastMessage() {
        if (!this.lastMessagePopulated) {
            this.setLastMessage(Long.valueOf(this.piStatus.getLastMessageTime()));
            this.lastMessagePopulated = true;
        }
        return super.getLastMessage();
    }

    public String getMessageType() {
        if (!this.messageTypePopulated) {
            int messageOpCode = this.piStatus.getLastMessageOpCode();
            if (messageOpCode >= 10 && messageOpCode < V3LcapMessage.POLL_MESSAGES.length + 10) {
                this.setMessageType(V3LcapMessage.POLL_MESSAGES[messageOpCode - 10] + " (" + messageOpCode + ")");
            } else {
                this.setMessageType("n/a");
            }
            this.messageTypePopulated = true;
        }
        return super.getMessageType();
    }

    public Long getMessageCount() {
        if (!this.messageCountPopulated) {
            this.setMessageCount(Long.valueOf(this.piStatus.getTotalMessages()));
            this.messageCountPopulated = true;
        }
        return super.getMessageCount();
    }

    public Long getLastPoll() {
        if (!this.lastPollPopulated) {
            this.setLastPoll(Long.valueOf(this.piStatus.getLastPollerTime()));
            this.lastPollPopulated = true;
        }
        return super.getLastPoll();
    }

    public Long getLastVote() {
        if (!this.lastVotePopulated) {
            this.setLastVote(Long.valueOf(this.piStatus.getLastVoterTime()));
            this.lastVotePopulated = true;
        }
        return super.getLastVote();
    }

    public Long getLastInvitation() {
        if (!this.lastInvitationPopulated) {
            this.setLastInvitation(Long.valueOf(this.piStatus.getLastPollInvitationTime()));
            this.lastInvitationPopulated = true;
        }
        return super.getLastInvitation();
    }

    public Long getInvitationCount() {
        if (!this.invitationCountPopulated) {
            this.setInvitationCount(Long.valueOf(this.piStatus.getTotalPollInvitatioins()));
            this.invitationCountPopulated = true;
        }
        return super.getInvitationCount();
    }

    public Long getPollsCalled() {
        if (!this.pollsCalledPopulated) {
            this.setPollsCalled(Long.valueOf(this.piStatus.getTotalPollerPolls()));
            this.pollsCalledPopulated = true;
        }
        return super.getPollsCalled();
    }

    public Long getVotesCast() {
        if (!this.votesCastPopulated) {
            this.setVotesCast(Long.valueOf(this.piStatus.getTotalVoterPolls()));
            this.votesCastPopulated = true;
        }
        return super.getVotesCast();
    }

    public Long getPollsRejected() {
        if (!this.pollsRejectedPopulated) {
            this.setPollsRejected(Long.valueOf(this.piStatus.getTotalRejectedPolls()));
            this.pollsRejectedPopulated = true;
        }
        return super.getPollsRejected();
    }

    public String getNakReason() {
        if (!this.nakReasonPopulated) {
            V3LcapMessage.PollNak pollNak = this.piStatus.getLastPollNak();
            if (pollNak != null) {
                this.setNakReason(pollNak.toString());
            }
            this.nakReasonPopulated = true;
        }
        return super.getNakReason();
    }

    public List<String> getGroups() {
        if (!this.groupsPopulated) {
            this.setGroups(this.piStatus.getGroups());
            this.groupsPopulated = true;
        }
        return super.getGroups();
    }

    public Boolean getPlatformGroupMatch() {
        if (!this.platformGroupMatchPopulated) {
            List peerGroups = this.getGroups();
            boolean match = peerGroups == null || peerGroups.isEmpty() || CollectionUtils.containsAny((Collection)platformGroups, (Collection)peerGroups);
            this.setPlatformGroupMatch(Boolean.valueOf(match));
            this.platformGroupMatchPopulated = true;
        }
        return super.getPlatformGroupMatch();
    }
}

