/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.lockss.app.LockssDaemon;
import org.lockss.laaws.poller.impl.RepositoryWsSource;
import org.lockss.laaws.rs.core.LockssRepository;
import org.lockss.repository.RepoSpec;
import org.lockss.util.Logger;
import org.lockss.ws.entities.RepositoryWsResult;

public class RepositoryHelper {
    static String SOURCE_FQCN = RepositoryWsSource.class.getCanonicalName();
    static String RESULT_FQCN = RepositoryWsResult.class.getCanonicalName();
    static String REPOSITORY_SPACE_ID = "repositorySpaceId";
    static String DIRECTORY_NAME = "directoryName";
    static String AU_NAME = "auName";
    static String INTERNAL = "internal";
    static String STATUS = "status";
    static String DISK_USAGE = "diskUsage";
    static String PLUGIN_NAME = "pluginName";
    static String PARAMS = "params";
    static final Set<String> PROPERTY_NAMES = new /* Unavailable Anonymous Inner Class!! */;
    private static Logger log = Logger.getLogger();

    List<RepositoryWsSource> createUniverse() {
        String DEBUG_HEADER = "createUniverse(): ";
        ArrayList<RepositoryWsSource> universe = new ArrayList<RepositoryWsSource>();
        RepoSpec repoSpec = LockssDaemon.getLockssDaemon().getRepositoryManager().getV2Repository();
        String repositorySpaceId = repoSpec.getSpec();
        if (log.isDebug3()) {
            log.debug3("createUniverse(): repositorySpaceId = " + repositorySpaceId);
        }
        LockssRepository repo = repoSpec.getRepository();
        try {
            for (String collectionId : repo.getCollectionIds()) {
                if (log.isDebug3()) {
                    log.debug3("createUniverse(): collectionId = " + collectionId);
                }
                try {
                    for (String auId : repo.getAuIds(collectionId)) {
                        if (log.isDebug3()) {
                            log.debug3("createUniverse(): auId = " + auId);
                        }
                        universe.add(new RepositoryWsSource(repositorySpaceId, collectionId, auId));
                    }
                }
                catch (IOException ioe) {
                    log.error("Exception caught for collectionId '" + collectionId + "': Ignoring collection", (Throwable)ioe);
                }
            }
        }
        catch (IOException ioe) {
            log.error("Exception caught getting collections", (Throwable)ioe);
        }
        if (log.isDebug2()) {
            log.debug2("createUniverse(): universe.size() = " + universe.size());
        }
        return universe;
    }

    String nonDefaultToString(Collection<RepositoryWsResult> results) {
        StringBuilder builder = new StringBuilder("[");
        boolean isFirst = true;
        for (RepositoryWsResult result : results) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append(this.nonDefaultToString(result));
        }
        return builder.append("]").toString();
    }

    private String nonDefaultToString(RepositoryWsResult result) {
        StringBuilder builder = new StringBuilder("RepositoryWsResult [");
        boolean isFirst = true;
        if (result.getRepositorySpaceId() != null) {
            builder.append("repositorySpaceId=").append(result.getRepositorySpaceId());
            isFirst = false;
        }
        if (result.getDirectoryName() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("directoryName=").append(result.getDirectoryName());
        }
        if (result.getAuName() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("auName=").append(result.getAuName());
        }
        if (result.getInternal() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("internal=").append(result.getInternal());
        }
        if (result.getStatus() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("status=").append(result.getStatus());
        }
        if (result.getDiskUsage() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("diskUsage=").append(result.getDiskUsage());
        }
        if (result.getPluginName() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("pluginName=").append(result.getPluginName());
        }
        if (result.getParams() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("params=").append(result.getParams());
        }
        return builder.append("]").toString();
    }
}

