/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.lockss.laaws.poller.model.RepairData;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="structure used to define a repair source for url. if the source is null than repair from publisher")
@Validated
public class RepairData {
    @JsonProperty(value="repairUrl")
    private String repairUrl = null;
    @JsonProperty(value="repairFrom")
    private String repairFrom = null;
    @JsonProperty(value="result")
    private ResultEnum result = null;

    public RepairData repairUrl(String repairUrl) {
        this.repairUrl = repairUrl;
        return this;
    }

    @ApiModelProperty(required=true, value="The url to repair")
    @NotNull
    public String getRepairUrl() {
        return this.repairUrl;
    }

    public void setRepairUrl(String repairUrl) {
        this.repairUrl = repairUrl;
    }

    public RepairData repairFrom(String repairFrom) {
        this.repairFrom = repairFrom;
        return this;
    }

    @ApiModelProperty(required=true, value="The peer to repair from")
    @NotNull
    public String getRepairFrom() {
        return this.repairFrom;
    }

    public void setRepairFrom(String repairFrom) {
        this.repairFrom = repairFrom;
    }

    public RepairData result(ResultEnum result) {
        this.result = result;
        return this;
    }

    @ApiModelProperty(value="The status of this repair")
    public ResultEnum getResult() {
        return this.result;
    }

    public void setResult(ResultEnum result) {
        this.result = result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepairData repairData = (RepairData)o;
        return Objects.equals(this.repairUrl, repairData.repairUrl) && Objects.equals(this.repairFrom, repairData.repairFrom) && Objects.equals(this.result, repairData.result);
    }

    public int hashCode() {
        return Objects.hash(this.repairUrl, this.repairFrom, this.result);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RepairData {\n");
        sb.append("    repairUrl: ").append(this.toIndentedString((Object)this.repairUrl)).append("\n");
        sb.append("    repairFrom: ").append(this.toIndentedString((Object)this.repairFrom)).append("\n");
        sb.append("    result: ").append(this.toIndentedString((Object)this.result)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

