/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.error;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.lockss.laaws.error.LockssRestServiceException;

@XmlRootElement(name="errors")
public class RestResponseErrorBody
implements Iterable<RestResponseError> {
    @XmlElement(name="error")
    private final List<RestResponseError> errors = new ArrayList<RestResponseError>();

    protected RestResponseErrorBody() {
    }

    public RestResponseErrorBody(String message, String parsedRequest) {
        this(new RestResponseError(message, parsedRequest));
    }

    public RestResponseErrorBody(String message, String parsedRequest, LocalDateTime utcTimestamp) {
        this(new RestResponseError(message, parsedRequest, utcTimestamp));
    }

    public RestResponseErrorBody(RestResponseError error) {
        if (error != null) {
            this.errors.add(error);
        }
    }

    public RestResponseErrorBody(LockssRestServiceException exception) {
        this(new RestResponseError(exception.getMessage(), exception.getParsedRequest(), exception.getUtcTimestamp()));
    }

    public RestResponseErrorBody add(RestResponseError error) {
        this.errors.add(error);
        return this;
    }

    @JsonValue
    private List<RestResponseError> getErrors() {
        return this.errors;
    }

    @Override
    public Iterator<RestResponseError> iterator() {
        return this.errors.iterator();
    }

    public String toString() {
        return String.format("Errors[%s]", this.errors);
    }

    public int hashCode() {
        return this.errors.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RestResponseErrorBody)) {
            return false;
        }
        RestResponseErrorBody other = (RestResponseErrorBody)obj;
        return this.errors.equals(other.errors);
    }

    @XmlType
    public static class RestResponseError {
        @XmlElement
        @JsonProperty
        private String message = "(null)";
        @XmlElement
        @JsonProperty
        private String parsedRequest = "(null)";
        @XmlElement
        @JsonProperty
        private LocalDateTime utcTimestamp = LocalDateTime.now(Clock.systemUTC());

        protected RestResponseError() {
        }

        public RestResponseError(String message, String parsedRequest) {
            if (message != null) {
                this.message = message;
            }
            if (parsedRequest != null) {
                this.parsedRequest = parsedRequest;
            }
        }

        public RestResponseError(String message, String parsedRequest, LocalDateTime utcTimestamp) {
            if (message != null) {
                this.message = message;
            }
            if (parsedRequest != null) {
                this.parsedRequest = parsedRequest;
            }
            if (utcTimestamp != null) {
                this.utcTimestamp = utcTimestamp;
            }
        }

        public String getMessage() {
            return this.message;
        }

        public String getParsedRequest() {
            return this.parsedRequest;
        }

        public LocalDateTime getUtcTimestamp() {
            return this.utcTimestamp;
        }

        public String toString() {
            return String.format("[Error message: %s, parsedRequest: %s, utcTimestamp: %s]", this.message, this.parsedRequest, this.utcTimestamp);
        }

        public int hashCode() {
            int result = 17;
            result += 31 * this.message.hashCode();
            result += 31 * this.parsedRequest.hashCode();
            return result += 31 * this.utcTimestamp.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RestResponseError)) {
                return false;
            }
            RestResponseError other = (RestResponseError)obj;
            return this.message.equals(other.message) && this.parsedRequest.equals(other.parsedRequest) && this.utcTimestamp.equals(other.utcTimestamp);
        }
    }
}

