/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Future;
import javax.activation.FileDataSource;
import org.apache.logging.log4j.util.Supplier;
import org.lockss.hasher.HasherParams;
import org.lockss.hasher.HasherResult;
import org.lockss.hasher.SimpleHasher;
import org.lockss.laaws.poller.api.HashesApiDelegate;
import org.lockss.laaws.rs.util.NamedInputStreamResource;
import org.lockss.log.L4JLogger;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.util.FileUtil;
import org.lockss.util.StringUtil;
import org.lockss.util.os.PlatformUtil;
import org.lockss.util.time.TimeBase;
import org.lockss.ws.entities.HasherWsParams;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Service
public class HashesApiServiceImpl
extends BaseSpringApiServiceImpl
implements HashesApiDelegate {
    private static L4JLogger log = L4JLogger.getLogger();
    private static final Map<String, SimpleHasher.ParamsAndResult> HASH_REQUESTS = new LinkedHashMap<String, SimpleHasher.ParamsAndResult>();
    private static final String DEFAULT_REQUEST_ID = "noRequestId";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseEntity<String> deleteHash(String requestId) {
        log.debug2("requestId = {}", (Object)requestId);
        String message = null;
        try {
            SimpleHasher.ParamsAndResult paramsAndResult;
            if (StringUtil.isNullString((String)requestId)) {
                message = "Must supply request identifier";
                log.warn(message);
                return new ResponseEntity((Object)message, HttpStatus.BAD_REQUEST);
            }
            Map<String, SimpleHasher.ParamsAndResult> map = HASH_REQUESTS;
            synchronized (map) {
                paramsAndResult = HASH_REQUESTS.get(requestId);
            }
            if (paramsAndResult == null || paramsAndResult.result == null) {
                message = "Cannot find asynchronous h ash request '" + requestId + "'";
                log.warn(message);
                return new ResponseEntity((Object)message, HttpStatus.NOT_FOUND);
            }
            HasherResult result = paramsAndResult.result;
            log.trace("result = {}", (Object)result);
            switch (result.getRunnerStatus()) {
                case NotStarted: 
                case Init: 
                case Starting: 
                case Running: {
                    Future future = result.getFuture();
                    if (future == null) break;
                    future.cancel(true);
                    break;
                }
            }
            FileUtil.safeDeleteFile((File)result.getBlockFile());
            FileUtil.safeDeleteFile((File)result.getRecordFile());
            Map<String, SimpleHasher.ParamsAndResult> map2 = HASH_REQUESTS;
            synchronized (map2) {
                HASH_REQUESTS.remove(requestId);
            }
            message = SimpleHasher.HasherStatus.Done.toString();
            log.debug2("message = {}", (Object)message);
            return new ResponseEntity((Object)message, HttpStatus.OK);
        }
        catch (Exception e) {
            message = "Cannot deleteHash() for requestId = '" + requestId + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity getAllHashes() {
        log.debug2("Invoked.");
        try {
            LinkedMultiValueMap parts = new LinkedMultiValueMap();
            Map<String, SimpleHasher.ParamsAndResult> map = HASH_REQUESTS;
            synchronized (map) {
                for (String requestId : HASH_REQUESTS.keySet()) {
                    HasherResult result = HashesApiServiceImpl.HASH_REQUESTS.get((Object)requestId).result;
                    log.trace("result = {}", (Object)result);
                    this.populateResultParts(requestId, result, (MultiValueMap<String, HttpEntity<?>>)parts);
                }
            }
            log.trace("parts.size() = {}", (Object)parts.size());
            return this.buildResponse((MultiValueMap<String, HttpEntity<?>>)parts);
        }
        catch (Exception e) {
            String message = "Cannot getAllHashes()";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity getHash(String requestId) {
        log.debug2("requestId = {}", (Object)requestId);
        String message = null;
        try {
            SimpleHasher.ParamsAndResult paramsAndResult;
            if (StringUtil.isNullString((String)requestId)) {
                message = "Must supply request identifier";
                log.warn(message);
                return new ResponseEntity((Object)message, HttpStatus.BAD_REQUEST);
            }
            Map<String, SimpleHasher.ParamsAndResult> map = HASH_REQUESTS;
            synchronized (map) {
                paramsAndResult = HASH_REQUESTS.get(requestId);
            }
            if (paramsAndResult == null || paramsAndResult.result == null) {
                message = "Cannot find asynchronous hash request '" + requestId + "'";
                log.warn(message);
                return new ResponseEntity((Object)message, HttpStatus.NOT_FOUND);
            }
            HasherResult result = paramsAndResult.result;
            log.trace("result = {}", (Object)result);
            LinkedMultiValueMap parts = new LinkedMultiValueMap();
            this.populateResultParts(requestId, result, (MultiValueMap<String, HttpEntity<?>>)parts);
            log.trace("parts.size() = {}", (Object)parts.size());
            return this.buildResponse((MultiValueMap<String, HttpEntity<?>>)parts);
        }
        catch (Exception e) {
            message = "Cannot getHash() for requestId = '" + requestId + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity putHash(HasherWsParams hasherWsParams, Boolean isAsynchronous) {
        log.debug2("hasherWsParams = {}", (Object)hasherWsParams);
        log.debug2("isAsynchronous = {}", (Object)isAsynchronous);
        try {
            HasherParams params = new HasherParams(PlatformUtil.getLocalHostname(), isAsynchronous.booleanValue());
            params.setAlgorithm(hasherWsParams.getAlgorithm());
            params.setAuId(hasherWsParams.getAuId());
            params.setChallenge(hasherWsParams.getChallenge());
            Boolean excludeSuspectVersions = hasherWsParams.isExcludeSuspectVersions();
            if (excludeSuspectVersions == null) {
                params.setExcludeSuspectVersions(false);
            } else {
                params.setExcludeSuspectVersions(excludeSuspectVersions.booleanValue());
            }
            Boolean includeWeight = hasherWsParams.isIncludeWeight();
            if (includeWeight == null) {
                params.setIncludeWeight(false);
            } else {
                params.setIncludeWeight(includeWeight.booleanValue());
            }
            params.setHashType(hasherWsParams.getHashType());
            params.setLower(hasherWsParams.getLower());
            Boolean recordFilteredStream = hasherWsParams.isRecordFilteredStream();
            if (recordFilteredStream == null) {
                params.setRecordFilteredStream(false);
            } else {
                params.setRecordFilteredStream(recordFilteredStream.booleanValue());
            }
            params.setResultEncoding(hasherWsParams.getResultEncoding());
            params.setUpper(hasherWsParams.getUpper());
            params.setUrl(hasherWsParams.getUrl());
            params.setVerifier(hasherWsParams.getVerifier());
            log.trace("params = {}", (Object)params);
            HasherResult result = new HasherResult();
            String requestId = DEFAULT_REQUEST_ID;
            if (!isAsynchronous.booleanValue()) {
                new SimpleHasher(null).hash(params, result);
            } else {
                try {
                    long requestTime = TimeBase.nowMs();
                    result.setRequestTime(requestTime);
                    Map<String, SimpleHasher.ParamsAndResult> map = HASH_REQUESTS;
                    synchronized (map) {
                        requestId = SimpleHasher.getReqId((HasherParams)params, (HasherResult)result, HASH_REQUESTS);
                        log.trace("requestId = {}", (Object)requestId);
                    }
                    new SimpleHasher(null).startHashingThread(params, result);
                }
                catch (RuntimeException re) {
                    String errorMessage = "Error starting asynchronous hash thread: " + re.toString();
                    log.warn(errorMessage);
                    log.warn((Object)re);
                    return new ResponseEntity((Object)errorMessage, HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
            log.trace("result = {}", (Object)result);
            LinkedMultiValueMap parts = new LinkedMultiValueMap();
            this.populateResultParts(requestId, result, (MultiValueMap<String, HttpEntity<?>>)parts);
            log.trace("parts.size() = {}", (Object)parts.size());
            return this.buildResponse((MultiValueMap<String, HttpEntity<?>>)parts);
        }
        catch (Exception e) {
            String message = "Cannot putHash() for hasherWsParams = '" + hasherWsParams + "', isAsynchronous = " + isAsynchronous;
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private void populateResultParts(String requestId, HasherResult result, MultiValueMap<String, HttpEntity<?>> parts) throws IOException {
        File blockFile;
        log.debug2("requestId = {}", (Object)requestId);
        log.debug2("result = {}", (Object)result);
        log.debug2("parts = {}", parts);
        this.addResultPropertiesPart(requestId, result, parts);
        File recordFile = result.getRecordFile();
        if (recordFile != null && recordFile.exists() && recordFile.length() > 0L) {
            this.addFilePart(requestId + "-" + "Record", recordFile, parts);
        }
        if ((blockFile = result.getBlockFile()) != null && blockFile.exists() && blockFile.length() > 0L) {
            this.addFilePart(requestId + "-" + "Block", blockFile, parts);
        }
        log.debug2("Done");
    }

    private void addResultPropertiesPart(String partName, HasherResult result, MultiValueMap<String, HttpEntity<?>> parts) {
        File blockFile;
        log.debug2("partName = {}", (Object)partName);
        log.debug2("result = {}", (Object)result);
        log.debug2("parts = {}", parts);
        HashMap<String, Object> resultProperties = new HashMap<String, Object>();
        resultProperties.put("requestId", result.getRequestId());
        resultProperties.put("startTime", result.getStartTime());
        File recordFile = result.getRecordFile();
        if (recordFile != null && recordFile.exists() && recordFile.length() > 0L) {
            resultProperties.put("recordFileName", recordFile.getName());
        }
        if ((blockFile = result.getBlockFile()) != null && blockFile.exists() && blockFile.length() > 0L) {
            resultProperties.put("blockFileName", blockFile.getName());
        }
        resultProperties.put("errorMessage", result.getRunnerError());
        resultProperties.put("status", result.getRunnerStatus().toString());
        if (result.getHashResult() != null) {
            resultProperties.put("hashResult", result.getHashResult());
        }
        resultProperties.put("bytesHashed", result.getBytesHashed());
        resultProperties.put("filesHashed", result.getFilesHashed());
        resultProperties.put("elapsedTime", result.getElapsedTime());
        parts.add((Object)partName, (Object)new HttpEntity(resultProperties, (MultiValueMap)new HttpHeaders()));
    }

    void addFilePart(String partName, File sourceFile, MultiValueMap<String, HttpEntity<?>> parts) throws IOException {
        log.debug2("partName = {}", (Object)partName);
        log.debug2("sourceFile = {}", (Object)sourceFile);
        FileDataSource fileDS = new FileDataSource(sourceFile);
        String name = fileDS.getName();
        log.trace("name = {}", (Object)name);
        long size = fileDS.getFile().length();
        log.trace("size = {}", (Object)size);
        HttpHeaders partHeaders = new HttpHeaders();
        partHeaders.setContentLength(size);
        log.trace("partHeaders = {}", new Supplier[]{() -> partHeaders});
        NamedInputStreamResource resource = new NamedInputStreamResource(name, fileDS.getInputStream());
        parts.add((Object)partName, (Object)new HttpEntity((Object)resource, (MultiValueMap)partHeaders));
    }

    private ResponseEntity<MultiValueMap<String, HttpEntity<?>>> buildResponse(MultiValueMap<String, HttpEntity<?>> parts) {
        log.debug2("parts = {}", parts);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.MULTIPART_FORM_DATA);
        log.trace("responseHeaders = {}", new Supplier[]{() -> responseHeaders});
        HttpStatus status = HttpStatus.OK;
        log.trace("status = {}", new Supplier[]{() -> status});
        return new ResponseEntity(parts, (MultiValueMap)responseHeaders, status);
    }
}

