/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.poller.v3.ParticipantUserData;
import org.lockss.poller.v3.PollerStateBean;
import org.lockss.poller.v3.V3Poller;
import org.lockss.protocol.psm.PsmInterp;
import org.lockss.protocol.psm.PsmState;
import org.lockss.util.time.TimeBase;
import org.lockss.ws.entities.ParticipantWsResult;
import org.lockss.ws.entities.PollWsResult;
import org.lockss.ws.entities.RepairWsResult;

public class PollWsSource
extends PollWsResult {
    private V3Poller poll;
    private boolean auIdPopulated = false;
    private boolean auNamePopulated = false;
    private boolean participantCountPopulated = false;
    private boolean pollStatusPopulated = false;
    private boolean talliedUrlCountPopulated = false;
    private boolean talliedUrlsPopulated = false;
    private boolean hashErrorCountPopulated = false;
    private boolean errorUrlsPopulated = false;
    private boolean completedRepairCountPopulated = false;
    private boolean completedRepairsPopulated = false;
    private boolean percentAgreementPopulated = false;
    private boolean startTimePopulated = false;
    private boolean deadlinePopulated = false;
    private boolean pollKeyPopulated = false;
    private boolean pollVariantPopulated = false;
    private boolean errorDetailPopulated = false;
    private boolean additionalInfoPopulated = false;
    private boolean voteDeadlinePopulated = false;
    private boolean durationPopulated = false;
    private boolean remainingTimePopulated = false;
    private boolean endTimePopulated = false;
    private boolean agreedUrlCountPopulated = false;
    private boolean agreedUrlsPopulated = false;
    private boolean disagreedUrlCountPopulated = false;
    private boolean disagreedUrlsPopulated = false;
    private boolean noQuorumUrlCountPopulated = false;
    private boolean noQuorumUrlsPopulated = false;
    private boolean tooCloseUrlCountPopulated = false;
    private boolean tooCloseUrlsPopulated = false;
    private boolean activeRepairCountPopulated = false;
    private boolean activeRepairsPopulated = false;
    private boolean bytesHashedCountPopulated = false;
    private boolean bytesReadCountPopulated = false;
    private boolean quorumPopulated = false;
    private boolean participantsPopulated = false;
    private boolean isPoll;

    public PollWsSource(ArchivalUnit au) {
        this.setAuId(au.getAuId());
        this.auIdPopulated = true;
        this.setAuName(au.getName());
        this.auNamePopulated = true;
        this.participantCountPopulated = true;
        this.setPollStatus("Pending");
        this.pollStatusPopulated = true;
        this.talliedUrlCountPopulated = true;
        this.talliedUrlsPopulated = true;
        this.hashErrorCountPopulated = true;
        this.errorUrlsPopulated = true;
        this.completedRepairCountPopulated = true;
        this.completedRepairsPopulated = true;
        this.percentAgreementPopulated = true;
        this.startTimePopulated = true;
        this.deadlinePopulated = true;
        this.pollKeyPopulated = true;
        this.pollVariantPopulated = true;
        this.errorDetailPopulated = true;
        this.additionalInfoPopulated = true;
        this.voteDeadlinePopulated = true;
        this.durationPopulated = true;
        this.remainingTimePopulated = true;
        this.endTimePopulated = true;
        this.agreedUrlCountPopulated = true;
        this.agreedUrlsPopulated = true;
        this.disagreedUrlCountPopulated = true;
        this.disagreedUrlsPopulated = true;
        this.noQuorumUrlCountPopulated = true;
        this.noQuorumUrlsPopulated = true;
        this.tooCloseUrlCountPopulated = true;
        this.tooCloseUrlsPopulated = true;
        this.activeRepairCountPopulated = true;
        this.activeRepairsPopulated = true;
        this.bytesHashedCountPopulated = true;
        this.bytesReadCountPopulated = true;
        this.quorumPopulated = true;
        this.participantsPopulated = true;
        this.isPoll = false;
    }

    public PollWsSource(V3Poller poll) {
        this.poll = poll;
        this.isPoll = true;
    }

    public String getAuId() {
        if (!this.auIdPopulated) {
            if (this.isPoll) {
                this.setAuId(this.poll.getAu().getAuId());
            }
            this.auIdPopulated = true;
        }
        return super.getAuId();
    }

    public String getAuName() {
        if (!this.auNamePopulated) {
            if (this.isPoll) {
                this.setAuName(this.poll.getAu().getName());
            }
            this.auNamePopulated = true;
        }
        return super.getAuName();
    }

    public Integer getParticipantCount() {
        if (!this.participantCountPopulated) {
            if (this.isPoll) {
                this.setParticipantCount(this.poll.getPollSize());
            }
            this.participantCountPopulated = true;
        }
        return super.getParticipantCount();
    }

    public String getPollStatus() {
        if (!this.pollStatusPopulated) {
            if (this.isPoll) {
                this.setPollStatus(this.poll.getStatusString());
            }
            this.pollStatusPopulated = true;
        }
        return super.getPollStatus();
    }

    public Integer getTalliedUrlCount() {
        if (!this.talliedUrlCountPopulated) {
            if (this.isPoll) {
                this.setTalliedUrlCount(this.poll.getTalliedUrls().size());
            }
            this.talliedUrlCountPopulated = true;
        }
        return super.getTalliedUrlCount();
    }

    public List<String> getTalliedUrls() {
        if (!this.talliedUrlsPopulated) {
            if (this.isPoll) {
                this.setTalliedUrls(this.poll.getTalliedUrls());
            }
            this.talliedUrlsPopulated = true;
        }
        return super.getTalliedUrls();
    }

    public Integer getHashErrorCount() {
        if (!this.hashErrorCountPopulated) {
            if (this.isPoll) {
                if (this.poll.getErrorUrls() != null) {
                    this.setHashErrorCount(this.poll.getErrorUrls().size());
                } else {
                    this.setHashErrorCount(0);
                }
            }
            this.hashErrorCountPopulated = true;
        }
        return super.getHashErrorCount();
    }

    public Map<String, String> getErrorUrls() {
        if (!this.errorUrlsPopulated) {
            if (this.isPoll) {
                this.setErrorUrls(this.poll.getErrorUrls());
            }
            this.errorUrlsPopulated = true;
        }
        return super.getErrorUrls();
    }

    public Integer getCompletedRepairCount() {
        if (!this.completedRepairCountPopulated) {
            if (this.isPoll) {
                this.setCompletedRepairCount(this.poll.getCompletedRepairs().size());
            }
            this.completedRepairCountPopulated = true;
        }
        return super.getCompletedRepairCount();
    }

    public List<RepairWsResult> getCompletedRepairs() {
        if (!this.completedRepairsPopulated) {
            if (this.isPoll) {
                ArrayList<RepairWsResult> results = new ArrayList<RepairWsResult>(this.poll.getCompletedRepairs().size());
                for (PollerStateBean.Repair repair : this.poll.getCompletedRepairs()) {
                    RepairWsResult result = new RepairWsResult();
                    result.setUrl(repair.getUrl());
                    if (repair.getRepairFrom() != null) {
                        result.setPeerId(repair.getRepairFrom().getIdString());
                    }
                    results.add(result);
                }
                this.setCompletedRepairs(results);
            }
            this.completedRepairsPopulated = true;
        }
        return super.getCompletedRepairs();
    }

    public Float getPercentAgreement() {
        if (!this.percentAgreementPopulated) {
            if (this.isPoll && this.poll.getStatus() == 6) {
                this.setPercentAgreement(Float.valueOf(this.poll.getPercentAgreement()));
            }
            this.percentAgreementPopulated = true;
        }
        return super.getPercentAgreement();
    }

    public Long getStartTime() {
        if (!this.startTimePopulated) {
            if (this.isPoll) {
                this.setStartTime(this.poll.getCreateTime());
            }
            this.startTimePopulated = true;
        }
        return super.getStartTime();
    }

    public Long getDeadline() {
        if (!this.deadlinePopulated) {
            if (this.isPoll) {
                this.setDeadline(this.poll.getDeadline().getExpirationTime());
            }
            this.deadlinePopulated = true;
        }
        return super.getDeadline();
    }

    public String getPollKey() {
        if (!this.pollKeyPopulated) {
            if (this.isPoll) {
                this.setPollKey(this.poll.getKey());
            }
            this.pollKeyPopulated = true;
        }
        return super.getPollKey();
    }

    public String getPollVariant() {
        if (!this.pollVariantPopulated) {
            if (this.isPoll) {
                this.setPollVariant(this.poll.getPollVariant().toString());
            }
            this.pollVariantPopulated = true;
        }
        return super.getPollVariant();
    }

    public String getErrorDetail() {
        if (!this.errorDetailPopulated) {
            if (this.isPoll) {
                this.setErrorDetail(this.poll.getPollerStateBean().getErrorDetail());
            }
            this.errorDetailPopulated = true;
        }
        return super.getErrorDetail();
    }

    public String getAdditionalInfo() {
        if (!this.additionalInfoPopulated) {
            if (this.isPoll) {
                this.setAdditionalInfo(this.poll.getPollerStateBean().getAdditionalInfo());
            }
            this.additionalInfoPopulated = true;
        }
        return super.getAdditionalInfo();
    }

    public Long getVoteDeadline() {
        if (!this.voteDeadlinePopulated) {
            if (this.isPoll && !this.poll.isLocalPoll()) {
                this.setVoteDeadline(this.poll.getVoteDeadline());
            }
            this.voteDeadlinePopulated = true;
        }
        return super.getVoteDeadline();
    }

    public Long getDuration() {
        if (!this.durationPopulated) {
            if (this.isPoll) {
                this.setDuration(this.poll.getDuration());
            }
            this.durationPopulated = true;
        }
        return super.getDuration();
    }

    public Long getRemainingTime() {
        if (!this.remainingTimePopulated) {
            long remain;
            if (this.isPoll && this.poll.isPollActive() && (remain = TimeBase.msUntil((long)this.poll.getDeadline().getExpirationTime())) >= 0L) {
                this.setRemainingTime(remain);
            }
            this.remainingTimePopulated = true;
        }
        return super.getRemainingTime();
    }

    public Long getEndTime() {
        if (!this.endTimePopulated) {
            if (this.isPoll && !this.poll.isPollActive() && !this.poll.getDeadline().equals((Object)this.poll.getEndTime())) {
                this.setEndTime(this.poll.getEndTime());
            }
            this.endTimePopulated = true;
        }
        return super.getEndTime();
    }

    public Integer getAgreedUrlCount() {
        if (!this.agreedUrlCountPopulated) {
            int count;
            if (this.isPoll && (count = this.poll.getAgreedUrls().size()) > 0) {
                this.setAgreedUrlCount(count);
            }
            this.agreedUrlCountPopulated = true;
        }
        return super.getAgreedUrlCount();
    }

    public Set<String> getAgreedUrls() {
        if (!this.agreedUrlsPopulated) {
            if (this.isPoll) {
                this.setAgreedUrls(this.poll.getAgreedUrls());
            }
            this.agreedUrlsPopulated = true;
        }
        return super.getAgreedUrls();
    }

    public Integer getDisagreedUrlCount() {
        if (!this.disagreedUrlCountPopulated) {
            int count;
            if (this.isPoll && (count = this.poll.getDisagreedUrls().size()) > 0) {
                this.setDisagreedUrlCount(count);
            }
            this.disagreedUrlCountPopulated = true;
        }
        return super.getDisagreedUrlCount();
    }

    public Set<String> getDisagreedUrls() {
        if (!this.disagreedUrlsPopulated) {
            if (this.isPoll) {
                this.setDisagreedUrls(this.poll.getDisagreedUrls());
            }
            this.disagreedUrlsPopulated = true;
        }
        return super.getDisagreedUrls();
    }

    public Integer getNoQuorumUrlCount() {
        if (!this.noQuorumUrlCountPopulated) {
            int count;
            if (this.isPoll && (count = this.poll.getNoQuorumUrls().size()) > 0) {
                this.setNoQuorumUrlCount(count);
            }
            this.noQuorumUrlCountPopulated = true;
        }
        return super.getNoQuorumUrlCount();
    }

    public Set<String> getNoQuorumUrls() {
        if (!this.noQuorumUrlsPopulated) {
            if (this.isPoll) {
                this.setNoQuorumUrls(this.poll.getNoQuorumUrls());
            }
            this.noQuorumUrlsPopulated = true;
        }
        return super.getNoQuorumUrls();
    }

    public Integer getTooCloseUrlCount() {
        if (!this.tooCloseUrlCountPopulated) {
            int count;
            if (this.isPoll && (count = this.poll.getTooCloseUrls().size()) > 0) {
                this.setTooCloseUrlCount(count);
            }
            this.tooCloseUrlCountPopulated = true;
        }
        return super.getTooCloseUrlCount();
    }

    public Set<String> getTooCloseUrls() {
        if (!this.tooCloseUrlsPopulated) {
            if (this.isPoll) {
                this.setTooCloseUrls(this.poll.getTooCloseUrls());
            }
            this.tooCloseUrlsPopulated = true;
        }
        return super.getTooCloseUrls();
    }

    public Integer getActiveRepairCount() {
        if (!this.activeRepairCountPopulated) {
            int count;
            if (this.isPoll && (count = this.poll.getActiveRepairs().size()) > 0) {
                this.setActiveRepairCount(count);
            }
            this.activeRepairCountPopulated = true;
        }
        return super.getActiveRepairCount();
    }

    public List<RepairWsResult> getActiveRepairs() {
        if (!this.activeRepairsPopulated) {
            if (this.isPoll) {
                List repairs = this.poll.getActiveRepairs();
                ArrayList<RepairWsResult> results = new ArrayList<RepairWsResult>(repairs.size());
                for (PollerStateBean.Repair repair : repairs) {
                    RepairWsResult result = new RepairWsResult();
                    result.setUrl(repair.getUrl());
                    result.setPeerId(repair.getRepairFrom().getIdString());
                    results.add(result);
                }
                this.setActiveRepairs(results);
            }
            this.activeRepairsPopulated = true;
        }
        return super.getActiveRepairs();
    }

    public Long getBytesHashedCount() {
        if (!this.bytesHashedCountPopulated) {
            if (this.isPoll && this.poll.isEnableHashStats()) {
                this.setBytesHashedCount(this.poll.getBytesHashed());
            }
            this.bytesHashedCountPopulated = true;
        }
        return super.getBytesHashedCount();
    }

    public Long getBytesReadCount() {
        if (!this.bytesReadCountPopulated) {
            if (this.isPoll && this.poll.isEnableHashStats()) {
                this.setBytesReadCount(this.poll.getBytesRead());
            }
            this.bytesReadCountPopulated = true;
        }
        return super.getBytesReadCount();
    }

    public Integer getQuorum() {
        if (!this.quorumPopulated) {
            if (this.isPoll) {
                this.setQuorum(this.poll.getQuorum());
            }
            this.quorumPopulated = true;
        }
        return super.getQuorum();
    }

    public List<ParticipantWsResult> getParticipants() {
        if (!this.participantsPopulated) {
            if (this.isPoll) {
                ArrayList<ParticipantWsResult> results = new ArrayList<ParticipantWsResult>();
                for (ParticipantUserData voter : this.poll.getParticipants()) {
                    results.add(this.createParticipant(voter, false));
                }
                for (ParticipantUserData voter : this.poll.getExParticipants()) {
                    results.add(this.createParticipant(voter, true));
                }
                this.setParticipants(results);
            }
            this.participantsPopulated = true;
        }
        return super.getParticipants();
    }

    private ParticipantWsResult createParticipant(ParticipantUserData voter, boolean isExParticipant) {
        PsmState state;
        PsmInterp interp;
        ParticipantWsResult result = new ParticipantWsResult();
        result.setPeerId(voter.getVoterId().getIdString());
        result.setPeerStatus(voter.getStatusString());
        result.setHasVoted(Boolean.valueOf(voter.hasVoted()));
        if (voter.hasVoted()) {
            ParticipantUserData.VoteCounts voteCounts = voter.getVoteCounts();
            result.setPercentAgreement(Float.valueOf(voteCounts.getPercentAgreement()));
            result.setAgreedVoteCount(Long.valueOf(voteCounts.getAgreedVotes()));
            result.setDisagreedVoteCount(Long.valueOf(voteCounts.getDisagreedVotes()));
            result.setPollerOnlyVoteCount(Long.valueOf(voteCounts.getPollerOnlyVotes()));
            result.setVoterOnlyVotecount(Long.valueOf(voteCounts.getVoterOnlyVotes()));
            result.setBytesHashed(Long.valueOf(voter.getBytesHashed()));
            result.setBytesRead(Long.valueOf(voter.getBytesRead()));
            if (voteCounts.hasPeerUrlLists()) {
                result.setAgreedUrls(voteCounts.getAgreedUrls());
                result.setDisagreedUrls(voteCounts.getDisagreedUrls());
                result.setPollerOnlyUrls(voteCounts.getPollerOnlyUrls());
                result.setVoterOnlyUrls(voteCounts.getVoterOnlyUrls());
                result.setIsPostRepair(Boolean.valueOf(true));
            }
        }
        if ((interp = voter.getPsmInterp()) != null && (state = interp.getCurrentState()) != null) {
            result.setCurrentState(state.getName());
            long when = interp.getLastStateChange();
            if (when > 0L) {
                result.setLastStateChange(Long.valueOf(when));
            }
        }
        result.setIsExParticipant(Boolean.valueOf(isExParticipant));
        return result;
    }
}

