/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.impl;

import java.util.List;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.QueryResults;
import org.lockss.laaws.poller.api.RepositoriesApiDelegate;
import org.lockss.laaws.poller.impl.RepositoryHelper;
import org.lockss.log.L4JLogger;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.util.josql.JosqlUtil;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class RepositoriesApiServiceImpl
extends BaseSpringApiServiceImpl
implements RepositoriesApiDelegate {
    private static L4JLogger log = L4JLogger.getLogger();

    public ResponseEntity getRepositories(String repositoryQuery) {
        log.debug2("repositoryQuery = {}", (Object)repositoryQuery);
        RepositoryHelper repositoryHelper = new RepositoryHelper();
        List results = null;
        try {
            String fullQuery = JosqlUtil.createFullQuery((String)repositoryQuery, (String)RepositoryHelper.SOURCE_FQCN, RepositoryHelper.PROPERTY_NAMES, (String)RepositoryHelper.RESULT_FQCN);
            log.trace("fullQuery = {}", (Object)fullQuery);
            Query q = new Query();
            try {
                q.parse(fullQuery);
                QueryResults qr = q.execute(repositoryHelper.createUniverse());
                results = qr.getResults();
                log.trace("results.size() = {}", (Object)results.size());
                log.trace("results = {}", (Object)repositoryHelper.nonDefaultToString(results));
                return new ResponseEntity((Object)results, HttpStatus.OK);
            }
            catch (QueryExecutionException qee) {
                String message = "Cannot getRepositories() for repositoryQuery = '" + repositoryQuery + "'";
                log.error(message, (Throwable)qee);
                return new ResponseEntity((Object)message, HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        catch (Exception e) {
            String message = "Cannot getRepositories() for repositoryQuery = '" + repositoryQuery + "'";
            log.error(message, (Throwable)e);
            return new ResponseEntity((Object)message, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

