/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.lockss.app.LockssDaemon;
import org.lockss.laaws.poller.impl.RepositorySpaceWsSource;
import org.lockss.repository.RepositoryManager;
import org.lockss.util.Logger;
import org.lockss.util.os.PlatformUtil;
import org.lockss.ws.entities.RepositorySpaceWsResult;

public class RepositorySpaceHelper {
    static String SOURCE_FQCN = RepositorySpaceWsSource.class.getCanonicalName();
    static String RESULT_FQCN = RepositorySpaceWsResult.class.getCanonicalName();
    static String REPOSITORY_SPACE_ID = "repositorySpaceId";
    static String SIZE = "size";
    static String USED = "used";
    static String FREE = "free";
    static String PERCENTAGE_FULL = "percentageFull";
    static String ACTIVE_COUNT = "activeCount";
    static String INACTIVE_COUNT = "inactiveCount";
    static String DELETED_COUNT = "deletedCount";
    static String ORPHANED_COUNT = "orphanedCount";
    static final Set<String> PROPERTY_NAMES = new HashSet<String>(){
        {
            this.add(REPOSITORY_SPACE_ID);
            this.add(SIZE);
            this.add(USED);
            this.add(FREE);
            this.add(PERCENTAGE_FULL);
            this.add(ACTIVE_COUNT);
            this.add(INACTIVE_COUNT);
            this.add(DELETED_COUNT);
            this.add(ORPHANED_COUNT);
        }
    };
    private static Logger log = Logger.getLogger();

    List<RepositorySpaceWsSource> createUniverse() {
        String DEBUG_HEADER = "createUniverse(): ";
        ArrayList<RepositorySpaceWsSource> universe = new ArrayList<RepositorySpaceWsSource>();
        RepositoryManager repoManager = LockssDaemon.getLockssDaemon().getRepositoryManager();
        universe.addAll(repoManager.getRepositoryDFMap().entrySet().stream().map(entry -> new RepositorySpaceWsSource((String)entry.getKey(), (PlatformUtil.DF)entry.getValue())).collect(Collectors.toList()));
        if (log.isDebug2()) {
            log.debug2("createUniverse(): universe.size() = " + universe.size());
        }
        return universe;
    }

    String nonDefaultToString(Collection<RepositorySpaceWsResult> results) {
        StringBuilder builder = new StringBuilder("[");
        boolean isFirst = true;
        for (RepositorySpaceWsResult result : results) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append(this.nonDefaultToString(result));
        }
        return builder.append("]").toString();
    }

    private String nonDefaultToString(RepositorySpaceWsResult result) {
        StringBuilder builder = new StringBuilder("RepositorySpaceWsResult [");
        boolean isFirst = true;
        if (result.getRepositorySpaceId() != null) {
            builder.append("repositorySpaceId=").append(result.getRepositorySpaceId());
            isFirst = false;
        }
        if (result.getSize() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("size=").append(result.getSize());
        }
        if (result.getUsed() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("used=").append(result.getUsed());
        }
        if (result.getFree() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("free=").append(result.getFree());
        }
        if (result.getPercentageFull() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("percentageFull=").append(result.getPercentageFull());
        }
        if (result.getActiveCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("activeCount=").append(result.getActiveCount());
        }
        if (result.getInactiveCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("inactiveCount=").append(result.getInactiveCount());
        }
        if (result.getDeletedCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("deletedCount=").append(result.getDeletedCount());
        }
        if (result.getOrphanedCount() != null) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append("orphanedCount=").append(result.getOrphanedCount());
        }
        return builder.append("]").toString();
    }
}

