/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.lockss.app.LockssDaemon;
import org.lockss.config.ConfigManager;
import org.lockss.config.Configuration;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.plugin.AuUtil;
import org.lockss.plugin.Plugin;
import org.lockss.plugin.PluginManager;
import org.lockss.util.Logger;
import org.lockss.util.PropUtil;
import org.lockss.ws.entities.RepositoryWsResult;

public class RepositoryWsSource
extends RepositoryWsResult {
    private static final String NOT_APPLICABLE = "NOT APPLICABLE";
    private static Logger log = Logger.getLogger();
    private boolean directoryNamePopulated;
    private boolean auNamePopulated;
    private boolean internalPopulated;
    private boolean statusPopulated;
    private boolean diskUsagePopulated;
    private boolean pluginNamePopulated;
    private boolean paramsPopulated;
    private String collectionId;
    private String auId;
    private ArchivalUnit au;
    private boolean auPopulated;
    private Properties auIdProps;
    private boolean auIdPropsPopulated;
    private LockssDaemon theDaemon = null;
    private PluginManager pluginMgr = null;

    public RepositoryWsSource(String repositorySpaceId, String collectionId, String auId) {
        this.setRepositorySpaceId(repositorySpaceId);
        this.collectionId = collectionId;
        this.auId = auId;
    }

    public String getRepositorySpaceId() {
        return super.getRepositorySpaceId();
    }

    public String getDirectoryName() {
        if (!this.directoryNamePopulated) {
            this.setDirectoryName(NOT_APPLICABLE);
            this.directoryNamePopulated = true;
        }
        return super.getDirectoryName();
    }

    public String getAuName() {
        if (!this.auNamePopulated) {
            if (this.auId != null) {
                String name = null;
                if (this.getArchivalUnit() != null) {
                    name = this.au.getName();
                } else {
                    name = "";
                    if (!this.isOrphaned()) {
                        try {
                            Configuration config = this.getPluginManager().getStoredAuConfigurationAsConfiguration(this.auId);
                            if (config != null && !config.isEmpty()) {
                                name = config.get("reserved.displayName");
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                if (name != null) {
                    this.setAuName(name);
                }
            }
            this.auNamePopulated = true;
        }
        return super.getAuName();
    }

    public Boolean getInternal() {
        if (!this.internalPopulated) {
            this.setInternal(Boolean.valueOf(this.getPluginManager().isInternalAu(this.getPluginManager().getAuFromIdIfExists(this.auId))));
            this.internalPopulated = true;
        }
        return super.getInternal();
    }

    public String getStatus() {
        if (!this.statusPopulated) {
            if (this.auId == null) {
                this.setStatus("No AUID");
            } else if (this.getArchivalUnit() != null) {
                this.setStatus("Active");
            } else if (this.isOrphaned()) {
                this.setStatus("Orphaned");
            } else {
                try {
                    Configuration config = this.getPluginManager().getStoredAuConfigurationAsConfiguration(this.auId);
                    if (config == null || config.isEmpty()) {
                        this.setStatus("Deleted");
                    } else if (config.getBoolean("reserved.disabled", false)) {
                        this.setStatus("Inactive");
                    } else {
                        this.setStatus("Deleted");
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.statusPopulated = true;
        }
        return super.getStatus();
    }

    public Long getDiskUsage() {
        if (!this.diskUsagePopulated) {
            this.diskUsagePopulated = true;
        }
        return super.getDiskUsage();
    }

    public String getPluginName() {
        if (!this.pluginNamePopulated) {
            if (this.auId != null) {
                this.setPluginName(PluginManager.pluginNameFromAuId((String)this.auId));
            }
            this.pluginNamePopulated = true;
        }
        return super.getPluginName();
    }

    public Map<String, String> getParams() {
        if (!this.paramsPopulated) {
            if (this.auId != null) {
                if (this.getArchivalUnit() != null) {
                    Configuration config = this.au.getConfiguration();
                    if (config != null && !config.isEmpty()) {
                        this.setParams(this.makeParams(config));
                    }
                } else {
                    if (this.getAuIdProps() != null && !this.auIdProps.isEmpty()) {
                        this.setParams(this.makeParams(this.auIdProps));
                    }
                    if (!this.isOrphaned()) {
                        try {
                            Configuration config = this.getPluginManager().getStoredAuConfigurationAsConfiguration(this.auId);
                            if (config != null && !config.isEmpty()) {
                                this.setParams(this.makeParams(config));
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            this.paramsPopulated = true;
        }
        return super.getParams();
    }

    private Properties getAuIdProps() {
        if (!this.auIdPropsPopulated) {
            String auKey = null;
            try {
                auKey = PluginManager.auKeyFromAuId((String)this.auId);
                this.auIdProps = PropUtil.canonicalEncodedStringToProps((String)auKey);
            }
            catch (Exception e) {
                log.warning("Couldn't decode AUKey: " + auKey, (Throwable)e);
            }
            this.auIdPropsPopulated = true;
        }
        return this.auIdProps;
    }

    private LockssDaemon getTheDaemon() {
        if (this.theDaemon == null) {
            this.theDaemon = LockssDaemon.getLockssDaemon();
        }
        return this.theDaemon;
    }

    private PluginManager getPluginManager() {
        if (this.pluginMgr == null) {
            this.pluginMgr = this.getTheDaemon().getPluginManager();
        }
        return this.pluginMgr;
    }

    private ArchivalUnit getArchivalUnit() {
        if (!this.auPopulated) {
            this.au = this.getPluginManager().getAuFromId(this.auId);
            this.auPopulated = true;
        }
        return this.au;
    }

    private boolean isOrphaned() {
        if (this.getAuIdProps() == null) {
            return true;
        }
        String pluginKey = PluginManager.pluginKeyFromId((String)PluginManager.pluginIdFromAuId((String)this.auId));
        Plugin plugin = this.getPluginManager().getPlugin(pluginKey);
        if (plugin == null) {
            return true;
        }
        Configuration defConfig = ConfigManager.fromProperties((Properties)this.auIdProps);
        return !AuUtil.isConfigCompatibleWithPlugin((Configuration)defConfig, (Plugin)plugin);
    }

    private Map<String, String> makeParams(Configuration config) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : config.keySet()) {
            result.put(key, config.get(key));
        }
        return result;
    }

    private Map<String, String> makeParams(Properties props) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : props.stringPropertyNames()) {
            result.put(key, props.getProperty(key));
        }
        return result;
    }
}

