/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.poller.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.lockss.util.rest.poller.PollDesc;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="The details of a poll being performed or queued as the Voter.")
@Validated
public class VoterDetail {
    @JsonProperty(value="pollDesc")
    private PollDesc pollDesc = null;
    @JsonProperty(value="pollerId")
    private String pollerId = null;
    @JsonProperty(value="callerId")
    private String callerId = null;
    @JsonProperty(value="status")
    private String status = null;
    @JsonProperty(value="pollKey")
    private String pollKey = null;
    @JsonProperty(value="createTime")
    private Long createTime = null;
    @JsonProperty(value="duration")
    private Long duration = null;
    @JsonProperty(value="deadline")
    private Long deadline = null;
    @JsonProperty(value="hashAlgorithm")
    private String hashAlgorithm = null;
    @JsonProperty(value="agreement")
    private Double agreement = null;
    @JsonProperty(value="wtAgreement")
    private Double wtAgreement = null;
    @JsonProperty(value="symmetricAgreement")
    private Double symmetricAgreement = null;
    @JsonProperty(value="wtSymmetricAgreement")
    private Double wtSymmetricAgreement = null;
    @JsonProperty(value="pollerNonce")
    private String pollerNonce = null;
    @JsonProperty(value="voterNonce")
    private String voterNonce = null;
    @JsonProperty(value="voter2Nonce")
    private String voter2Nonce = null;
    @JsonProperty(value="voteDeadline")
    private Long voteDeadline = null;
    @JsonProperty(value="numAgree")
    private Integer numAgree = null;
    @JsonProperty(value="numDisagree")
    private Integer numDisagree = null;
    @JsonProperty(value="numPollerOnly")
    private Integer numPollerOnly = null;
    @JsonProperty(value="numVoterOnly")
    private Integer numVoterOnly = null;
    @JsonProperty(value="errorDetails")
    private String errorDetails = null;

    public VoterDetail pollDesc(PollDesc pollDesc) {
        this.pollDesc = pollDesc;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public PollDesc getPollDesc() {
        return this.pollDesc;
    }

    public void setPollDesc(PollDesc pollDesc) {
        this.pollDesc = pollDesc;
    }

    public VoterDetail pollerId(String pollerId) {
        this.pollerId = pollerId;
        return this;
    }

    @ApiModelProperty(required=true, value="The id of the voter in the poll")
    @NotNull
    public String getPollerId() {
        return this.pollerId;
    }

    public void setPollerId(String pollerId) {
        this.pollerId = pollerId;
    }

    public VoterDetail callerId(String callerId) {
        this.callerId = callerId;
        return this;
    }

    @ApiModelProperty(value="The id of the poller who called the poll")
    public String getCallerId() {
        return this.callerId;
    }

    public void setCallerId(String callerId) {
        this.callerId = callerId;
    }

    public VoterDetail status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The current status of the poll.")
    @NotNull
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public VoterDetail pollKey(String pollKey) {
        this.pollKey = pollKey;
        return this;
    }

    @ApiModelProperty(value="Key generated by poll manager when poll is created.")
    public String getPollKey() {
        return this.pollKey;
    }

    public void setPollKey(String pollKey) {
        this.pollKey = pollKey;
    }

    public VoterDetail createTime(Long createTime) {
        this.createTime = createTime;
        return this;
    }

    @ApiModelProperty(value="The timestamp  at which the poll was created.")
    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public VoterDetail duration(Long duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(value="The estimated duration for the poll.")
    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public VoterDetail deadline(Long deadline) {
        this.deadline = deadline;
        return this;
    }

    @ApiModelProperty(value="The time by which the poll must have completed")
    public Long getDeadline() {
        return this.deadline;
    }

    public void setDeadline(Long deadline) {
        this.deadline = deadline;
    }

    public VoterDetail hashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
        return this;
    }

    @ApiModelProperty(value="The algorithm used by the hasher for this poll.")
    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public VoterDetail agreement(Double agreement) {
        this.agreement = agreement;
        return this;
    }

    @ApiModelProperty(value="The percentage agreement.")
    public Double getAgreement() {
        return this.agreement;
    }

    public void setAgreement(Double agreement) {
        this.agreement = agreement;
    }

    public VoterDetail wtAgreement(Double wtAgreement) {
        this.wtAgreement = wtAgreement;
        return this;
    }

    @ApiModelProperty(value="The weighted percentage agreement.")
    public Double getWtAgreement() {
        return this.wtAgreement;
    }

    public void setWtAgreement(Double wtAgreement) {
        this.wtAgreement = wtAgreement;
    }

    public VoterDetail symmetricAgreement(Double symmetricAgreement) {
        this.symmetricAgreement = symmetricAgreement;
        return this;
    }

    @ApiModelProperty(value="The percentage of symmetric agreement.")
    public Double getSymmetricAgreement() {
        return this.symmetricAgreement;
    }

    public void setSymmetricAgreement(Double symmetricAgreement) {
        this.symmetricAgreement = symmetricAgreement;
    }

    public VoterDetail wtSymmetricAgreement(Double wtSymmetricAgreement) {
        this.wtSymmetricAgreement = wtSymmetricAgreement;
        return this;
    }

    @ApiModelProperty(value="The weighted percentage of symmetric agreement.")
    public Double getWtSymmetricAgreement() {
        return this.wtSymmetricAgreement;
    }

    public void setWtSymmetricAgreement(Double wtSymmetricAgreement) {
        this.wtSymmetricAgreement = wtSymmetricAgreement;
    }

    public VoterDetail pollerNonce(String pollerNonce) {
        this.pollerNonce = pollerNonce;
        return this;
    }

    @ApiModelProperty(value="the poller nonce")
    public String getPollerNonce() {
        return this.pollerNonce;
    }

    public void setPollerNonce(String pollerNonce) {
        this.pollerNonce = pollerNonce;
    }

    public VoterDetail voterNonce(String voterNonce) {
        this.voterNonce = voterNonce;
        return this;
    }

    @ApiModelProperty(value="the voter nonce")
    public String getVoterNonce() {
        return this.voterNonce;
    }

    public void setVoterNonce(String voterNonce) {
        this.voterNonce = voterNonce;
    }

    public VoterDetail voter2Nonce(String voter2Nonce) {
        this.voter2Nonce = voter2Nonce;
        return this;
    }

    @ApiModelProperty(value="the voter2 nonce")
    public String getVoter2Nonce() {
        return this.voter2Nonce;
    }

    public void setVoter2Nonce(String voter2Nonce) {
        this.voter2Nonce = voter2Nonce;
    }

    public VoterDetail voteDeadline(Long voteDeadline) {
        this.voteDeadline = voteDeadline;
        return this;
    }

    @ApiModelProperty(value="The  time by which all voters must have voted.")
    public Long getVoteDeadline() {
        return this.voteDeadline;
    }

    public void setVoteDeadline(Long voteDeadline) {
        this.voteDeadline = voteDeadline;
    }

    public VoterDetail numAgree(Integer numAgree) {
        this.numAgree = numAgree;
        return this;
    }

    @ApiModelProperty(value="The number of urls with agreement.")
    public Integer getNumAgree() {
        return this.numAgree;
    }

    public void setNumAgree(Integer numAgree) {
        this.numAgree = numAgree;
    }

    public VoterDetail numDisagree(Integer numDisagree) {
        this.numDisagree = numDisagree;
        return this;
    }

    @ApiModelProperty(value="The number of urls with disagreement.")
    public Integer getNumDisagree() {
        return this.numDisagree;
    }

    public void setNumDisagree(Integer numDisagree) {
        this.numDisagree = numDisagree;
    }

    public VoterDetail numPollerOnly(Integer numPollerOnly) {
        this.numPollerOnly = numPollerOnly;
        return this;
    }

    @ApiModelProperty(value="The number of urls found by only the poller.")
    public Integer getNumPollerOnly() {
        return this.numPollerOnly;
    }

    public void setNumPollerOnly(Integer numPollerOnly) {
        this.numPollerOnly = numPollerOnly;
    }

    public VoterDetail numVoterOnly(Integer numVoterOnly) {
        this.numVoterOnly = numVoterOnly;
        return this;
    }

    @ApiModelProperty(value="The number of urls found by only a voter.")
    public Integer getNumVoterOnly() {
        return this.numVoterOnly;
    }

    public void setNumVoterOnly(Integer numVoterOnly) {
        this.numVoterOnly = numVoterOnly;
    }

    public VoterDetail errorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    @ApiModelProperty(value="The error which caused the poll to fail.")
    public String getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VoterDetail voterDetail = (VoterDetail)o;
        return Objects.equals(this.pollDesc, voterDetail.pollDesc) && Objects.equals(this.pollerId, voterDetail.pollerId) && Objects.equals(this.callerId, voterDetail.callerId) && Objects.equals(this.status, voterDetail.status) && Objects.equals(this.pollKey, voterDetail.pollKey) && Objects.equals(this.createTime, voterDetail.createTime) && Objects.equals(this.duration, voterDetail.duration) && Objects.equals(this.deadline, voterDetail.deadline) && Objects.equals(this.hashAlgorithm, voterDetail.hashAlgorithm) && Objects.equals(this.agreement, voterDetail.agreement) && Objects.equals(this.wtAgreement, voterDetail.wtAgreement) && Objects.equals(this.symmetricAgreement, voterDetail.symmetricAgreement) && Objects.equals(this.wtSymmetricAgreement, voterDetail.wtSymmetricAgreement) && Objects.equals(this.pollerNonce, voterDetail.pollerNonce) && Objects.equals(this.voterNonce, voterDetail.voterNonce) && Objects.equals(this.voter2Nonce, voterDetail.voter2Nonce) && Objects.equals(this.voteDeadline, voterDetail.voteDeadline) && Objects.equals(this.numAgree, voterDetail.numAgree) && Objects.equals(this.numDisagree, voterDetail.numDisagree) && Objects.equals(this.numPollerOnly, voterDetail.numPollerOnly) && Objects.equals(this.numVoterOnly, voterDetail.numVoterOnly) && Objects.equals(this.errorDetails, voterDetail.errorDetails);
    }

    public int hashCode() {
        return Objects.hash(this.pollDesc, this.pollerId, this.callerId, this.status, this.pollKey, this.createTime, this.duration, this.deadline, this.hashAlgorithm, this.agreement, this.wtAgreement, this.symmetricAgreement, this.wtSymmetricAgreement, this.pollerNonce, this.voterNonce, this.voter2Nonce, this.voteDeadline, this.numAgree, this.numDisagree, this.numPollerOnly, this.numVoterOnly, this.errorDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VoterDetail {\n");
        sb.append("    pollDesc: ").append(this.toIndentedString((Object)this.pollDesc)).append("\n");
        sb.append("    pollerId: ").append(this.toIndentedString((Object)this.pollerId)).append("\n");
        sb.append("    callerId: ").append(this.toIndentedString((Object)this.callerId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    pollKey: ").append(this.toIndentedString((Object)this.pollKey)).append("\n");
        sb.append("    createTime: ").append(this.toIndentedString((Object)this.createTime)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString((Object)this.duration)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString((Object)this.deadline)).append("\n");
        sb.append("    hashAlgorithm: ").append(this.toIndentedString((Object)this.hashAlgorithm)).append("\n");
        sb.append("    agreement: ").append(this.toIndentedString((Object)this.agreement)).append("\n");
        sb.append("    wtAgreement: ").append(this.toIndentedString((Object)this.wtAgreement)).append("\n");
        sb.append("    symmetricAgreement: ").append(this.toIndentedString((Object)this.symmetricAgreement)).append("\n");
        sb.append("    wtSymmetricAgreement: ").append(this.toIndentedString((Object)this.wtSymmetricAgreement)).append("\n");
        sb.append("    pollerNonce: ").append(this.toIndentedString((Object)this.pollerNonce)).append("\n");
        sb.append("    voterNonce: ").append(this.toIndentedString((Object)this.voterNonce)).append("\n");
        sb.append("    voter2Nonce: ").append(this.toIndentedString((Object)this.voter2Nonce)).append("\n");
        sb.append("    voteDeadline: ").append(this.toIndentedString((Object)this.voteDeadline)).append("\n");
        sb.append("    numAgree: ").append(this.toIndentedString((Object)this.numAgree)).append("\n");
        sb.append("    numDisagree: ").append(this.toIndentedString((Object)this.numDisagree)).append("\n");
        sb.append("    numPollerOnly: ").append(this.toIndentedString((Object)this.numPollerOnly)).append("\n");
        sb.append("    numVoterOnly: ").append(this.toIndentedString((Object)this.numVoterOnly)).append("\n");
        sb.append("    errorDetails: ").append(this.toIndentedString((Object)this.errorDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

