/**
 * NOTE: This class is auto generated by the swagger code generator program (2.4.18).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.lockss.laaws.poller.api;

import org.lockss.ws.entities.HasherWsParams;
import org.springframework.core.io.Resource;
import io.swagger.annotations.*;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;

@Api(value = "hashes", description = "the hashes API")
@RequestMapping(value = "")
public interface HashesApi {

    HashesApiDelegate getDelegate();

    @ApiOperation(value = "Remove an asynchronous hashing operation", nickname = "deleteHash", notes = "Remove from the system an asynchronous hashing operation,\\ \\ terminating it if it's still running", response = String.class, authorizations = {
        @Authorization(value = "basicAuth")
    }, tags={ "hash", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Asynchronous hashing operation successfully removed", response = String.class),
        @ApiResponse(code = 400, message = "Bad Request"),
        @ApiResponse(code = 401, message = "Unauthorized"),
        @ApiResponse(code = 404, message = "No asynchronous hashing operation found with that id"),
        @ApiResponse(code = 500, message = "Internal Server Error") })
    @RequestMapping(value = "/hashes/requests/{requestId}",
        produces = { "application/json" }, 
        method = RequestMethod.DELETE)
    default ResponseEntity<String> deleteHash(@ApiParam(value = "Identifier of the asynchronous hashing operation",required=true) @PathVariable("requestId") String requestId) {
        return getDelegate().deleteHash(requestId);
    }


    @ApiOperation(value = "Get the results of all the asynchronous hashing operations", nickname = "getAllHashes", notes = "Get the results of all the asynchronous hashing operations", response = Resource.class, authorizations = {
        @Authorization(value = "basicAuth")
    }, tags={ "hash", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Information about all the asynchronous hashing operations", response = Resource.class),
        @ApiResponse(code = 401, message = "Unauthorized"),
        @ApiResponse(code = 500, message = "Internal Server Error") })
    @RequestMapping(value = "/hashes",
        produces = { "multipart/form-data" }, 
        method = RequestMethod.GET)
    default ResponseEntity<Resource> getAllHashes() {
        return getDelegate().getAllHashes();
    }


    @ApiOperation(value = "Get the result of an asynchronous hashing operation", nickname = "getHash", notes = "Get the result of an asynchronous hashing operation", response = Resource.class, authorizations = {
        @Authorization(value = "basicAuth")
    }, tags={ "hash", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Information about the asynchronous hashing operation", response = Resource.class),
        @ApiResponse(code = 400, message = "Bad Request"),
        @ApiResponse(code = 401, message = "Unauthorized"),
        @ApiResponse(code = 404, message = "No asynchronous hashing operation found with that id"),
        @ApiResponse(code = 500, message = "Internal Server Error") })
    @RequestMapping(value = "/hashes/requests/{requestId}",
        produces = { "multipart/form-data" }, 
        method = RequestMethod.GET)
    default ResponseEntity<Resource> getHash(@ApiParam(value = "Identifier of the asynchronous hashing operation",required=true) @PathVariable("requestId") String requestId) {
        return getDelegate().getHash(requestId);
    }


    @ApiOperation(value = "Perform a hashing operation", nickname = "putHash", notes = "Perform the hashing of an AU or a URL", response = Resource.class, authorizations = {
        @Authorization(value = "basicAuth")
    }, tags={ "hash", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Information about the performed hashing operation", response = Resource.class),
        @ApiResponse(code = 400, message = "Bad Request"),
        @ApiResponse(code = 401, message = "Unauthorized"),
        @ApiResponse(code = 500, message = "Internal Server Error") })
    @RequestMapping(value = "/hashes",
        produces = { "multipart/form-data" }, 
        method = RequestMethod.PUT)
    default ResponseEntity<Resource> putHash(@ApiParam(value = "" ,required=true )  @Valid @RequestBody HasherWsParams hasherWsParams,@ApiParam(value = "Indication of whether the operation should be done synchronously", defaultValue = "true") @Valid @RequestParam(value = "isAsynchronous", required = false, defaultValue="true") Boolean isAsynchronous) {
        return getDelegate().putHash(hasherWsParams, isAsynchronous);
    }

}
